#if !defined(__bookshop_h)              // Sentry, use file only if it's not already included.
#define __bookshop_h

/*  Project bookshop
    
    Copyright ) 1993. All Rights Reserved.

    SUBSYSTEM:    bookshop.exe Application
    FILE:         bookshop.h
    AUTHOR:       


    OVERVIEW
    ========
    Class definition for bookshopApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\statusba.h>
#include <owl\controlb.h>
#include <owl\buttonga.h>
#include <owl\editview.h>
#include <owl\listview.h>
#include <owl\docmanag.h>
#include <owl\filedoc.h>
#include <owl\printer.h>

#include <classlib\bags.h>

#include <owl\edit.h>
#include <owl\listbox.h>

#include "apxprint.h"
#include "apxprev.h"

#include "bookshop.rh"            // Definition of all resources.

// TFileDrop class Maintains information about a dropped file, its name, where it was dropped,
// and whether or not it was in the client area
class TFileDrop {
public:
    operator == (const TFileDrop& other) const {return this == &other;}

    char*   FileName;
    TPoint  Point;
    BOOL    InClientArea;

    HICON   Icon;
    BOOL    DefIcon;

    TFileDrop (char*, TPoint&, BOOL, TModule* module);
    ~TFileDrop ();

    const char* WhoAmI ();
private:
    //
    // hidden to prevent accidental copying or assignment
    //
    TFileDrop (const TFileDrop&);
    TFileDrop & operator = (const TFileDrop&);
};

typedef TIBagAsVector<TFileDrop> TFileList;
typedef TIBagAsVectorIterator<TFileDrop> TFileListIter;


//{{TApplication = bookshopApp}}
class bookshopApp : public TApplication {
private:

private:
    void SetupSpeedBar (TDecoratedFrame *frame);
    void AddFiles (TFileList* files);

public:
    bookshopApp ();
    virtual ~bookshopApp ();


    // Public data members used by the print menu commands and Paint routine in MDIChild.
    TPrinter        *Printer;                           // Printer support.
    BOOL            Printing;                           // Printing in progress.

//{{bookshopAppVIRTUAL_BEGIN}}
public:
    virtual void InitMainWindow();
    virtual void InitInstance();
//{{bookshopAppVIRTUAL_END}}

//{{bookshopAppRSP_TBL_BEGIN}}
protected:
    void EvNewView (TView& view);
    void EvCloseView (TView& view);
    void CmHelpAbout ();
    void CmFilePrint ();
    void CmFilePrintSetup ();
    void CmFilePrintPreview ();
    void CmPrintEnable (TCommandEnabler &tce);
    void EvDropFiles (TDropInfo drop);
    void EvWinIniChange (char far* section);
    void OnViewTitles ();
//{{bookshopAppRSP_TBL_END}}
  DECLARE_RESPONSE_TABLE(bookshopApp);
};    //{{bookshopApp}}


#endif                                      // __bookshop_h sentry.
