/*  Project bookshop
    
    Copyright ) 1993. All Rights Reserved.

    SUBSYSTEM:    bookshop.exe Application
    FILE:         bookshop.cpp
    AUTHOR:       


    OVERVIEW
    ========
    Source file for implementation of bookshopApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\vbxctl.h>

#include <dir.h>

#include "bookshop.h"
#include "bkshpabd.h"                        // Definition of about dialog.
#include "sqcmain.h"
#include "ctitles.h"		//VDB code


// Drag / Drop support:
TFileDrop::TFileDrop (char* fileName, TPoint& p, BOOL inClient, TModule* module)
{
    char    exePath[MAXPATH];
    
    exePath[0] = 0;
    FileName = strcpy(new char[strlen(fileName) + 1], fileName);
    Point = p;
    InClientArea = inClient;
    
    Icon = (WORD)FindExecutable(FileName, ".\\", exePath) <= 32 ? 0 : ::ExtractIcon(*module, exePath, 0);

    // Use a question mark if couldn't get the icon from the executable.
    //
    if ((WORD)Icon <= 1) {  // 0=no icons in exe,  1=not an exe
        Icon = LoadIcon(0, (WORD)Icon == 1 ? IDI_APPLICATION : IDI_QUESTION);
        DefIcon = TRUE;
    } else
        DefIcon = FALSE;
}

TFileDrop::~TFileDrop ()
{
    delete FileName;
    if (!DefIcon)
        FreeResource(Icon);
}

const char *TFileDrop::WhoAmI ()
{
  return FileName;
}


//{{bookshopApp Implementation}}

//VDB --
static CTitles *pTitlesFrm = NULL;		// Titles dialog
//-- VDB
//{{DOC_VIEW}}
DEFINE_DOC_TEMPLATE_CLASS(TFileDocument, TWindowView, DocType1);
//{{DOC_VIEW_END}}

//{{DOC_MANAGER}}
DocType1 __dvt1("All Files (*.*)", "*.*", 0, "TXT", dtAutoDelete | dtUpdateDir);
//{{DOC_MANAGER_END}}

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(bookshopApp, TApplication)
//{{bookshopAppRSP_TBL_BEGIN}}
    EV_OWLVIEW(dnCreate, EvNewView),
    EV_OWLVIEW(dnClose,  EvCloseView),
    EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
    EV_COMMAND(CM_FILEPRINT, CmFilePrint),
    EV_COMMAND(CM_FILEPRINTERSETUP, CmFilePrintSetup),
    EV_COMMAND(CM_FILEPRINTPREVIEW, CmFilePrintPreview),
    EV_COMMAND_ENABLE(CM_FILEPRINT, CmPrintEnable),
    EV_COMMAND_ENABLE(CM_FILEPRINTERSETUP, CmPrintEnable),
    EV_COMMAND_ENABLE(CM_FILEPRINTPREVIEW, CmPrintEnable),
    EV_WM_DROPFILES,
    EV_WM_WININICHANGE,
    EV_COMMAND(CM_VIEWTITLES, OnViewTitles),
//{{bookshopAppRSP_TBL_END}}
END_RESPONSE_TABLE;
//
// FrameWindow must be derived to override Paint for Preview and Print.
//
class SDIDecFrame : public TDecoratedFrame {
public:
    SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, BOOL trackMenuSelection = FALSE, TModule *module = 0) :
            TDecoratedFrame(parent, title, clientWnd, trackMenuSelection, module)
      {  }
    ~SDIDecFrame ()
      { pTitlesFrm = NULL; }

    void Paint (TDC& dc, BOOL erase, TRect& rect);
};


//////////////////////////////////////////////////////////
// bookshopApp
// =====
//
bookshopApp::bookshopApp () : TApplication("Bookshop")
{
	long	lAppHand, lRevision ;	// VDB Code

    Printer = 0;
    Printing = FALSE;

    DocManager = new TDocManager(dmSDI | dmMenu);

	 // INSERT>> Your constructor code here.
	SQcConnect(&lAppHand, &lRevision) ;	// VDB Code

}


bookshopApp::~bookshopApp ()
{
    if (Printer)
        delete Printer;

	 // INSERT>> Your destructor code here.

	 	 // VDB code --
		SQcDisconnect(SQcGetAppHand());

		if (pTitlesFrm)
		{
			delete pTitlesFrm ;
			pTitlesFrm = NULL ;
		}
		// -- VDB code


}


void bookshopApp::SetupSpeedBar (TDecoratedFrame *frame)
{ 
    //
    // Create default toolbar New and associate toolbar buttons with commands.
    //   
    TControlBar* cb = new TControlBar(frame);
    cb->Insert(*new TButtonGadget(CM_FILENEW, CM_FILENEW));
    cb->Insert(*new TButtonGadget(CM_FILEOPEN, CM_FILEOPEN));
    cb->Insert(*new TButtonGadget(CM_FILESAVE, CM_FILESAVE));
    cb->Insert(*new TSeparatorGadget(6));
    cb->Insert(*new TButtonGadget(CM_EDITCUT, CM_EDITCUT));
    cb->Insert(*new TButtonGadget(CM_EDITCOPY, CM_EDITCOPY));
    cb->Insert(*new TButtonGadget(CM_EDITPASTE, CM_EDITPASTE));
    cb->Insert(*new TSeparatorGadget(6));
    cb->Insert(*new TButtonGadget(CM_EDITUNDO, CM_EDITUNDO));
    cb->Insert(*new TSeparatorGadget(6));
    cb->Insert(*new TButtonGadget(CM_EDITFIND, CM_EDITFIND));
    cb->Insert(*new TButtonGadget(CM_EDITFINDNEXT, CM_EDITFINDNEXT));
    cb->Insert(*new TSeparatorGadget(6));
    cb->Insert(*new TButtonGadget(CM_FILEPRINT, CM_FILEPRINT));
    cb->Insert(*new TButtonGadget(CM_FILEPRINTPREVIEW, CM_FILEPRINTPREVIEW));

    // Add fly-over help hints.
    cb->SetHintMode(TGadgetWindow::EnterHints);

    frame->Insert(*cb, TDecoratedFrame::Top);
}


//////////////////////////////////////////////////////////
// bookshopApp
// =====
// Application intialization.
//
void bookshopApp::InitMainWindow ()
{
    TDecoratedFrame *frame = new SDIDecFrame(0, GetName(), 0, TRUE);

    nCmdShow = nCmdShow != SW_SHOWMINIMIZED ? SW_SHOWNORMAL : nCmdShow;

    //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_SDIAPPLICATION);

    //
    // Menu associated with window and accelerator table associated with table.
    //
    frame->AssignMenu(SDI_MENU);
    
    //
    // Associate with the accelerator table.
    //
    frame->Attr.AccelTable = SDI_MENU;

    SetupSpeedBar(frame);

    TStatusBar *sb = new TStatusBar(frame, TGadget::Recessed,
                                    TStatusBar::CapsLock        |
                                    TStatusBar::NumLock         |
                                    TStatusBar::ScrollLock      |
                                    TStatusBar::Overtype);
    frame->Insert(*sb, TDecoratedFrame::Bottom);
  
    MainWindow = frame;

}


//////////////////////////////////////////////////////////
// bookshopApp
// =====
// Response Table handlers:
//
void bookshopApp::EvNewView (TView& view)
{
    MainWindow->SetClientWindow(view.GetWindow());
    if (!view.IsOK())
        MainWindow->SetClientWindow(0);
}


void bookshopApp::EvCloseView (TView&)
{
    MainWindow->SetClientWindow(0);
    MainWindow->SetCaption("Bookshop");
}


//
// Paint routine for Window, Printer, and PrintPreview for an TEdit client.
//
void SDIDecFrame::Paint (TDC& dc, BOOL, TRect& rect)
{
    bookshopApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), bookshopApp);
    if (theApp) {
        // Only paint if we're printing and we have something to paint, otherwise do nothing.
        if (theApp->Printing && theApp->Printer && !rect.IsEmpty()) {
            // Use pageSize to get the size of the window to render into.  For a Window it's the client area,
            // for a printer it's the printer DC dimensions and for print preview it's the layout window.
            TSize   pageSize(rect.right - rect.left, rect.bottom - rect.top);

        }
    }
}


//////////////////////////////////////////////////////////
// bookshopApp
// ==========
// Menu File Print command
void bookshopApp::CmFilePrint ()
{
    //
    // Create Printer object if not already created.
    // 
    if (!Printer)
        Printer = new TPrinter;

    //
    // Create Printout window and set characteristics.
    //
    APXPrintOut printout(Printer, "Title", MainWindow);
    printout.SetBanding(TRUE);

    Printing = TRUE;

    //
    // Bring up the Print dialog and print the document.
    //
    Printer->Print(MainWindow, printout, TRUE);

    Printing = FALSE;
}


//////////////////////////////////////////////////////////
// bookshopApp
// ==========
// Menu File Print Setup command
void bookshopApp::CmFilePrintSetup ()
{
    if (!Printer)
        Printer = new TPrinter;

    //
    // Bring up the Print Setup dialog.
    //
    Printer->Setup(MainWindow);
}


//////////////////////////////////////////////////////////
// bookshopApp
// ==========
// Menu File Print Preview command
void bookshopApp::CmFilePrintPreview ()
{
    SDIDecFrame *sdiFrame = TYPESAFE_DOWNCAST(MainWindow, SDIDecFrame); 
    if (sdiFrame) {
        if (Printer)
            Printer = new TPrinter;

        Printing = TRUE;

        PreviewWindow *prevW = new PreviewWindow(sdiFrame, Printer, sdiFrame, "Print Preview", new TLayoutWindow(0));
        prevW->Create();

        BeginModal(MainWindow);

        Printing = FALSE;

        // Now that printing is off we can invalidate because the edit window to repaint.
        MainWindow->SetRedraw(TRUE);
        MainWindow->Invalidate();

        // We must destroy the preview window explicitly.  Otherwise, the window will not be destroyed until
        // it's parent the MainWindow is destroyed.
        prevW->Destroy();
        delete prevW;
    }
}


//////////////////////////////////////////////////////////
// bookshopApp
// ==========
// Menu enabler used by Print, Print Setup and Print Preview.
void bookshopApp::CmPrintEnable (TCommandEnabler &tce)
{
    // If we have a Printer already created just test if all is okay.
    // Otherwise create a Printer object and make sure the printer
    // really exists and then delete the Printer object.
    if (!Printer) {
        Printer = new TPrinter;
        
        tce.Enable(Printer->GetSetup().Error == 0);
    } else
        tce.Enable(Printer->GetSetup().Error == 0);
}


//////////////////////////////////////////////////////////
// bookshopApp
// ===========
// Menu Help About bookshop.exe command
void bookshopApp::CmHelpAbout ()
{
    //
    // Show the modal dialog.
    //
    bookshopAboutDlg(MainWindow).Execute();
}


void bookshopApp::InitInstance ()
{
    TApplication::InitInstance();

    // Accept files via drag/drop in the frame window.
    MainWindow->DragAcceptFiles(TRUE);
}


void bookshopApp::EvDropFiles (TDropInfo drop)
{
    // Number of files dropped.
    int totalNumberOfFiles = drop.DragQueryFileCount();

    TFileList* files = new TFileList;

    for (int i = 0; i < totalNumberOfFiles; i++) {
        // Tell DragQueryFile the file interested in (i) and the length of your buffer.
        int     fileLength = drop.DragQueryFileNameLen(i) + 1;
        char    *fileName = new char[fileLength];

        drop.DragQueryFile(i, fileName, fileLength);

        // Getting the file dropped. The location is relative to your client coordinates,
        // and will have negative values if dropped in the non client parts of the window.
        //
        // DragQueryPoint copies that point where the file was dropped and returns whether
        // or not the point is in the client area.  Regardless of whether or not the file
        // is dropped in the client or non-client area of the window, you will still receive
        // the file name.
        TPoint  point;
        BOOL    inClientArea = drop.DragQueryPoint(point);
        files->Add(new TFileDrop(fileName, point, inClientArea, this));
    }

    // Open the files that were dropped.
    AddFiles(files);

    // Release the memory allocated for this handle with DragFinish.
    drop.DragFinish();
}


void bookshopApp::AddFiles (TFileList* files)
{
    // Open all files dragged in.
    TFileListIter fileIter(*files);

    while (fileIter) {
        TDocTemplate* tpl = GetDocManager()->MatchTemplate(fileIter.Current()->WhoAmI());
        if (tpl)
            tpl->CreateDoc(fileIter.Current()->WhoAmI());
        fileIter++;
    }
}


void bookshopApp::EvWinIniChange (char far* section)
{
    if (lstrcmp(section, "windows") == 0) {
        // If the device changed in the WIN.INI file then the printer
        // might have changed.  If we have a TPrinter (Printer) then
        // check and make sure it's identical to the current device
        // entry in WIN.INI.
        if (Printer) {
            char printDBuffer[255];
            LPSTR printDevice = printDBuffer;
            LPSTR devName = 0;
            LPSTR driverName = 0;
            LPSTR outputName = 0;
        
            if (::GetProfileString("windows", "device", "", printDevice, sizeof(printDevice))) {
                // The string which should come back is something like:
                //
                //      HP LaserJet III,hppcl5a,LPT1:
                //
                // Where the format is:
                //
                //      devName,driverName,outputName
                //
                devName = printDevice;
                while (*printDevice) {
                    if (*printDevice == ',') {
                        *printDevice++ = 0;
                        if (!driverName)
                            driverName = printDevice;
                        else
                            outputName = printDevice;
                    } else
                        printDevice = AnsiNext(printDevice);
                }

                if ((Printer->GetSetup().Error != 0)                                ||
                    (lstrcmp(devName, Printer->GetSetup().GetDeviceName()) != 0)    ||
                    (lstrcmp(driverName, Printer->GetSetup().GetDriverName()) != 0) ||
                    (lstrcmp(outputName, Printer->GetSetup().GetOutputName()) != 0)) {
                
                    // New printer installed so get the new printer device now.
                    delete Printer;
                    Printer = new TPrinter;
                }
            } else {
                // No printer installed (GetProfileString failed).
                delete Printer;
                Printer = new TPrinter;
            }
        }
    }
}


int OwlMain (int , char* [])
{
    TBIVbxLibrary   vbxSupport;                 // This application has VBX controls.
    bookshopApp     App;
    int             result;

    result = App.Run();

    return result;
}

void bookshopApp::OnViewTitles ()
{
	 // INSERT>> Your code here.
	 	 // VDB code --
	 /* If the class is not allocated, allocate it.  If the window is already
			shown, set it as the active window.  Else create it afresh */

	if ( pTitlesFrm && ! pTitlesFrm->IsWindow() ) 
	{
		delete pTitlesFrm ;
		pTitlesFrm = NULL ;
	}
	 if (!pTitlesFrm) 
	 {
			pTitlesFrm = new CTitles(MainWindow) ;
			 if (!pTitlesFrm)
					return ;	// Error creating the form.
	 }

	 if (pTitlesFrm->IsWindow())
	 {
			pTitlesFrm->SetActiveWindow() ;
	 }
	 else
	 {
		pTitlesFrm->Create() ;
	 }
	 // -- VDB code


}

