//----------------------------------------------------------------------------
// ObjectWindows - (C) Copyright 1993 by Borland International
//----------------------------------------------------------------------------
#include <owl\owlpch.h>
#include <owl\applicat.h>
#include <owl\dialog.h>
#include <owl\framewin.h>
#include <owl\vbxctl.h>
#include "integra2.rc"
#include "..\..\..\INCLUDE\sqcmain.h"
#include "..\..\..\INCLUDE\sqc1.h"

class TDBApp : public TApplication {
  public:
    TDBApp() : TApplication() {}
    long DBHandle;
  protected:
    void InitMainWindow();
    BOOL ProcessAppMsg(MSG& msg);
};

class TPatDialog : public TDialog, public TVbxEventHandler {
  public:
    TPatDialog(TWindow* parent, TResId name) : TDialog(parent, name) {}

  protected:
    void SetupWindow();
    void CleanupWindow();

  DECLARE_RESPONSE_TABLE(TPatDialog);
};

DEFINE_RESPONSE_TABLE2(TPatDialog, TDialog, TVbxEventHandler)
END_RESPONSE_TABLE;

void TPatDialog::SetupWindow()
{
  TDialog::SetupWindow();
}

void TPatDialog::CleanupWindow()
{
  ::PostQuitMessage(0);
}

class TDocDialog : public TDialog, public TVbxEventHandler {
  public:
    TDocDialog(TWindow* parent, TResId name) : TDialog(parent, name) {}

  protected:
    void SetupWindow();
    void CleanupWindow();
    TPatDialog* PatDlg;
  DECLARE_RESPONSE_TABLE(TDocDialog);
};

DEFINE_RESPONSE_TABLE2(TDocDialog, TDialog, TVbxEventHandler)
END_RESPONSE_TABLE;

void TDocDialog::SetupWindow()
{
  TDialog::SetupWindow();
  PatDlg = new TPatDialog(0,TResId(IDD_PATIENTS));
  PatDlg->Create();
  TDBApp* app = (TDBApp*)GetApplication();
  SQcGo(app->DBHandle,0);
}

void TDocDialog::CleanupWindow()
{
  PatDlg->Destroy();
  delete PatDlg;
}

void TDBApp::InitMainWindow() {
  TDocDialog *DocDlg = new TDocDialog(0,TResId(IDD_DOCTORS));
  MainWindow = new TFrameWindow(0, "Integra Example", DocDlg, TRUE);
  MainWindow->Attr.Style &= ~(WS_MAXIMIZEBOX | WS_THICKFRAME);
}

BOOL TDBApp::ProcessAppMsg(MSG& msg)
{
  if (msg.message == WM_KEYDOWN &&
      (msg.wParam == VK_ESCAPE || msg.wParam == VK_RETURN))
    return TRUE;      // ignore OK and CANCEL keys, rather than quit dialog
  return TApplication::ProcessAppMsg(msg);
}

int
OwlMain(int, char**)
{
  TBIVbxLibrary vbxLib;     // constructing this loads & inits the library
  TDBApp app;
  long revision;
  SQcConnect(&app.DBHandle,&revision);
  int result = app.Run();
  SQcDisconnect(app.DBHandle);
  return result;
}
