//---------------------------------------------------------
//     DIBVIEW - TDibView include file
//---------------------------------------------------------
#if !defined(__DIBVIEW_H)
#define      __DIBVIEW_H

#include "dibdoc.h"
#include <owl\docmanag.h>
#include "knife1.h"
#include "dibview.rc"

////////////////////////////////////////////////////////////////
class _DOCVIEWCLASS TDibView : public TView, public TVbxPicBuf
{
  public:
    TDibView(TDIBDocument& doc,
             TWindow* parent = 0,
             const char* name = 0,
             TModule* module = 0);
   ~TDibView();

    static LPCSTR StaticName() {return "TDibView::DibViewName";}
    const char*   GetViewName() {return StaticName();}
    TWindow*      GetWindow() {return this;}
    BOOL          CanClose();

    // View drawing routines
    //
    void FillViewData();
    void UpdateViewData();

  protected:
    void SetupWindow();

    // view event handlers
    //
    BOOL  VnViewOpened(TView*);
    BOOL  VnViewClosed(TView*);
    BOOL  VnDocOpened(int omode);
    BOOL  VnDocClosed(int omode);
    BOOL  VnIsWindow(HWND hWnd);

    // File commands
    //
    void CmFileSave();
    void CmFileSaveAs();

    // View menu commands & enablers
    //
    void CeAutoscale(TCommandEnabler&);
    void CmAutoscale();
    void CeZoomFactor(TCommandEnabler&);
    void CmZoomFactor();

    // Image tool commands
    //
    void CmImkNegate();
    void CmImkMirrorHorizontal();
    void CmImkMirrorVertical();
    void CmImkRotate();
    void CmImkSharpen();
    void CmImkSoften();

    // Document Pointer
    //
    TDIBDocument* DocPtr;

    // VBX event handlers for PicBuf control. Many of these are just stubs for
    // ease of extending this class.
    //
    void PicBuf_EvClick(VBXEVENT FAR*) {
      // no arguments
    }

    void PicBuf_EvChange(VBXEVENT FAR*) {
      // no arguments
    }

    void PicBuf_EvDblClick(VBXEVENT FAR*) {
       // no arguments
    }

    void PicBuf_EvDragDrop(VBXEVENT FAR*);

    void PicBuf_EvDragOver(VBXEVENT FAR*) {
       // Source As Control,X As Integer,Y As Integer,State As Integer
    }

    void PicBuf_EvGotFocus(VBXEVENT FAR*) {
      // no arguments
    }

    void PicBuf_EvKeyDown(VBXEVENT FAR*) {
      // KeyCode As Integer,Shift As Integer
    }

    void PicBuf_EvKeyPress(VBXEVENT FAR*) {
      // KeyAscii As Integer
    }

    void PicBuf_EvKeyUp(VBXEVENT FAR*) {
      // KeyCode As Integer,Shift As Integer
    }

    void PicBuf_EvLostFocus(VBXEVENT FAR*) {
      // no arguments
    }

    void PicBuf_EvMouseDown(VBXEVENT FAR*);
    void PicBuf_EvMouseMove(VBXEVENT FAR*);
    void PicBuf_EvMouseUp(VBXEVENT FAR*);

    void PicBuf_EvPaint(VBXEVENT FAR*) {
      // no arguments
    }

  DECLARE_RESPONSE_TABLE(TDibView);
};

#endif  //   __DIBVIEW_H
