//---------------------------------------------------------
//     DIBDOC - TDIBDocument source module
//---------------------------------------------------------
#include <owl\owlpch.h>
#include "dibdoc.h"

////////////////////////////////////////////////////////////////
BOOL TDIBDocument::Open(int /*mode*/, LPCSTR path)
{
  if (!IsDirty()) {
    hDIB = (HDIB)imkLoad(path ? (char*)path : (char*)GetDocPath(), IMK_EXTENSION, 0);
    if (path)
      SetDocPath(path);
    SetDirty(FALSE);
  }
  return TRUE;
}

////////////////////////////////////////////////////////////////
BOOL TDIBDocument::Close()
{
  if (TDocument::Close())
    return FALSE;

  hDIB = 0;
  return TRUE;
}

////////////////////////////////////////////////////////////////
BOOL TDIBDocument::Commit(BOOL force)
{
  if (!IsDirty() && !force)
    return TRUE;
  imkStore((char*)GetDocPath(), (short)hDIB, IMK_EXTENSION, IMK_UNCOMP);
  SetDirty(FALSE);

  return TRUE;
}

////////////////////////////////////////////////////////////////
BOOL TDIBDocument::Revert(BOOL clear)
{
  if (!TDocument::Revert(clear))
    return FALSE;
  if (!clear)
    Open(0);

  return TRUE;
}

////////////////////////////////////////////////////////////////
BOOL TDIBDocument::IsOpen()
{
  return (BOOL)hDIB;
}

////////////////////////////////////////////////////////////////
BOOL TDIBDocument::SetHDIB(const HDIB& newHDIB)
{
  hDIB = newHDIB;
  SetDirty(TRUE);
  return TRUE;
}
