//----------------------------------------------------------------------------
// ObjectWindows - (C) Copyright 1993 by Borland International
//    Simple VBX Chart example
// Note, when making a new project with TKChart, the identifier length must
// be increased from 32 to 50 or so.
//----------------------------------------------------------------------------
#include <owl\owlpch.h>
#include <owl\applicat.h>
#include <owl\dc.h>
#include <owl\dialog.h>
#include <owl\framewin.h>
#include <owl\vbxctl.h>
#include "tkchart1.h"
#include "chart.rh"

const char AppName[] = "Chart";

// Pretty titles for each graph type
char *CTypes[32] = {
  { "3D Chart (area, seperate, no frame)"},
  { "3D Chart (area, seperate, frame)"},
  { "3D Chart (area, stack, no frame)"},
  { "3D Chart (area, stack, frame)"},
  { "3D Chart (column, seperate)"},
  { "3D Chart (column, stack)"},
  { "3D Chart (column, alternate)"},
  { "3D Chart (line)"},
  { "3D Chart (area, X Userdata)"},
  { "3D Chart (pie)"},
  { "2D Chart (area, stack, no frame)"},
  { "2D Chart (area, stack, frame)"},
  { "2D Chart (bar, stack)"},
  { "2D Chart (bar, alternate)"},
  { "2D Chart (bar, overlap)"},
  { "2D Chart (column, stack)"},
  { "2D Chart (column, alternate)"},
  { "2D Chart (column, overlap)"},
  { "2D Chart (line, dot)"},
  { "2D Chart (line, line)"},
  { "2D Chart (line, dot, line)"},
  { "2D Chart (line, chain)"},
  { "2D Chart (area, X Userdata)"},
  { "2D Chart (area, column)"},
  { "2D Chart (area, line)"},
  { "2D Chart (area, dot, line)"},
  { "2D Chart (column, line)"},
  { "2D Chart (column, dot, line)"},
  { "2D Chart (pie)"},
  { "2D Chart (hiloclose)"},
  { "2D Chart (hiloclose, dot, line)"},
  { "2D Chart (hiloclose, line)"}
};

class TChart : public TDialog {
  public:
   TBrush      Brush;

   TVbxTKChart* Chart;
   TChart();

   void   InitChart();
   void   ChangeChart(UINT);

  protected:
   BOOL       EvInitDialog(HWND hWnd);
   void          EvPaint();
   HBRUSH        EvCtlColor(HDC, HWND hWndChild, UINT ctlType);

  DECLARE_RESPONSE_TABLE(TChart);
};

DEFINE_RESPONSE_TABLE1(TChart, TDialog)
  EV_WM_PAINT,
  EV_WM_CTLCOLOR,
END_RESPONSE_TABLE;

TChart::TChart()
  : TWindow((TWindow*)0),
   TDialog(0, AppName),
   Brush(TColor(0, 0, 0)),
   Chart(new TVbxTKChart(this, IDC_TKCHART1))  // Create new chart object
{
  ;
}

BOOL TChart::EvInitDialog( HWND hWnd )
{
  BOOL rv = TDialog::EvInitDialog( hWnd );

  // Initialize chart in InitDialog, after chart has been created in dialog
  InitChart();
  return rv;
}

//
// Colorize the dialog. Allows background to show through corners of
//  buttons, uses yellow text on black background in the display, and sets
//  the dialog background to blue.
//
HBRUSH
TChart::EvCtlColor(HDC hDC, HWND hWndChild, UINT ctlType)
{
  switch (ctlType) {
   case CTLCOLOR_BTN:
    SetBkMode(hDC, TRANSPARENT);
    return (HBRUSH)GetStockObject(NULL_BRUSH);

   case CTLCOLOR_DLG:
    SetBkMode(hDC, TRANSPARENT);
    return (HBRUSH)Brush;

   default:
    return TDialog::EvCtlColor(hDC, hWndChild, ctlType);
  }
}

//
// Even dialogs can have their backgrounds painted on.  This creates
//  a blue ellipse over the black background.
//
void
TChart::EvPaint()
{
  TBrush    blueBrush(TColor(0, 0, 255));
  TPaintDC  dc(*this);

  dc.SelectObject(blueBrush);
  dc.SelectStockObject(NULL_PEN);

  TRect clientRect = GetClientRect();
  clientRect.bottom = clientRect.right;
  clientRect.Offset(-clientRect.right/4, -clientRect.right/4);
  dc.Ellipse(clientRect);
}

void
TChart::InitChart()
{
  Chart->SetPropAutoAdjOrigin(TRUE);
  Chart->SetPropTrueTypeFont(TRUE);
  Chart->SetPropcElement(4);
  Chart->SetPropChartType(TVbxTKChart::ChartType_2D_column_stacked);
  Chart->SetPropDataType(TVbxTKChart::DataType_Integer);
  Chart->SetPropChartConfig(0);

  // Configure X-axis
  Chart->SetPropAxisIndex(0);
  Chart->SetPropiMinVal(0);
  Chart->SetPropiIncVal(50);
  Chart->SetPropDivision(5);
  Chart->SetPropLabelType(1);

  Chart->SetPropAxisConfig(0);

  // Configure Y-axis
  Chart->SetPropAxisIndex(1);
  Chart->SetPropiMinVal(0);
  Chart->SetPropiIncVal(50);
  Chart->SetPropDivision(5);
  Chart->SetPropLabelType(1);

  Chart->SetPropAxisConfig(0);

  // Configure Z-axis
  Chart->SetPropAxisIndex(2);
  Chart->SetPropiMinVal(0);
  Chart->SetPropiIncVal(50);
  Chart->SetPropDivision(5);
  Chart->SetPropLabelType(2);

  Chart->SetPropAxisConfig(0);

  // legend labels
  Chart->SetPropzLabelArr((string)"A",0);
  Chart->SetPropzLabelArr((string)"B",1);
  Chart->SetPropzLabelArr((string)"C",2);
  Chart->SetPropzLabelArr((string)"D",3);

  // Turn off excessive redraws, paint msg will suffice
  Chart->SetPropRedraw(0);
  Chart->SetPropTitleArr((string)"X-Axis",0);
  Chart->SetPropTitleArr((string)"Y-Axis",1);
  Chart->SetPropTitleArr((string)"Welcome to Borland Visual Solutions!",3);

  //Add data to chart
  Chart->SetPropiDataArr(0,0);
  Chart->SetPropiDataArr(100,1);
  Chart->SetPropiDataArr(70,2);
  Chart->SetPropiDataArr(-20,3);
  Chart->SetPropAddData(0);

  Chart->SetPropiDataArr(10,0);
  Chart->SetPropiDataArr(110,1);
  Chart->SetPropiDataArr(80,2);
  Chart->SetPropiDataArr(-10,3);
  Chart->SetPropAddData(0);

  Chart->SetPropiDataArr(20,0);
  Chart->SetPropiDataArr(130,1);
  Chart->SetPropiDataArr(100,2);
  Chart->SetPropiDataArr(10,3);
  Chart->SetPropAddData(0);
  Chart->SetPropRedraw(1);
}

void
TChart::ChangeChart(UINT id)
{
  // make sure to paint only once
  Chart->SetPropRedraw(0);
  Chart->SetPropTitleArr(string(CTypes[id-1]),3);
  Chart->SetPropChartType(id-1);
}


//----------------------------------------------------------------------------

class TChartApp : public TApplication {
  public:
   TChart* ChartDialog;

   TChartApp(const char far* name) : TApplication(name) {}

  protected:
   void   InitMainWindow();
   void   Cm3D1();
   void   Cm3D2();
   void   Cm3D3();
   void   Cm3D4();
   void   Cm3D5();
   void   Cm3D6();
   void   Cm3D7();
   void   Cm3D8();
   void   Cm3D9();
   void   Cm3D10();
   void   Cm2D1();
   void   Cm2D2();
   void   Cm2D3();
   void   Cm2D4();
   void   Cm2D5();
   void   Cm2D6();
   void   Cm2D7();
   void   Cm2D8();
   void   Cm2D9();
   void   Cm2D10();
   void   Cm2D11();
   void   Cm2D12();
   void   Cm2D13();
   void   Cm2D14();
   void   Cm2D15();
   void   Cm2D16();
   void   Cm2D17();
   void   Cm2D18();
   void   Cm2D19();
   void   Cm2D20();
   void   Cm2D21();
   void   Cm2D22();

   LRESULT       EvCommand(UINT, HWND, UINT);

  DECLARE_RESPONSE_TABLE(TChartApp);
};

DEFINE_RESPONSE_TABLE(TChartApp)
  EV_COMMAND(CM_3D1, Cm3D1),
  EV_COMMAND(CM_3D2, Cm3D2),
  EV_COMMAND(CM_3D3, Cm3D3),
  EV_COMMAND(CM_3D4, Cm3D4),
  EV_COMMAND(CM_3D5, Cm3D5),
  EV_COMMAND(CM_3D6, Cm3D6),
  EV_COMMAND(CM_3D7, Cm3D7),
  EV_COMMAND(CM_3D8, Cm3D8),
  EV_COMMAND(CM_3D9, Cm3D9),
  EV_COMMAND(CM_3D10, Cm3D10),
  EV_COMMAND(CM_2D1, Cm2D1),
  EV_COMMAND(CM_2D2, Cm2D2),
  EV_COMMAND(CM_2D3, Cm2D3),
  EV_COMMAND(CM_2D4, Cm2D4),
  EV_COMMAND(CM_2D5, Cm2D5),
  EV_COMMAND(CM_2D6, Cm2D6),
  EV_COMMAND(CM_2D7, Cm2D7),
  EV_COMMAND(CM_2D8, Cm2D8),
  EV_COMMAND(CM_2D9, Cm2D9),
  EV_COMMAND(CM_2D10, Cm2D10),
  EV_COMMAND(CM_2D11, Cm2D11),
  EV_COMMAND(CM_2D12, Cm2D12),
  EV_COMMAND(CM_2D13, Cm2D13),
  EV_COMMAND(CM_2D14, Cm2D14),
  EV_COMMAND(CM_2D15, Cm2D15),
  EV_COMMAND(CM_2D16, Cm2D16),
  EV_COMMAND(CM_2D17, Cm2D17),
  EV_COMMAND(CM_2D18, Cm2D18),
  EV_COMMAND(CM_2D19, Cm2D19),
  EV_COMMAND(CM_2D20, Cm2D20),
  EV_COMMAND(CM_2D21, Cm2D21),
  EV_COMMAND(CM_2D22, Cm2D22),
END_RESPONSE_TABLE;

//
// Create the chart dialog as the application's main window.
//
void
TChartApp::InitMainWindow()
{
  ChartDialog = new TChart;

  MainWindow = new TFrameWindow(0, Name, ChartDialog, TRUE);
  MainWindow->SetIcon(this, AppName);
  MainWindow->AssignMenu("MAIN_MENU");
  MainWindow->Attr.Style &= ~(WS_MAXIMIZEBOX | WS_THICKFRAME);
}

// Menu graphtype commands
void
TChartApp::Cm3D1()
{
  ChartDialog->ChangeChart(1);
}

void
TChartApp::Cm3D2()
{
  ChartDialog->ChangeChart(2);
}

void
TChartApp::Cm3D3()
{
  ChartDialog->ChangeChart(3);
}

void
TChartApp::Cm3D4()
{
  ChartDialog->ChangeChart(4);
}

void
TChartApp::Cm3D5()
{
  ChartDialog->ChangeChart(5);
}

void
TChartApp::Cm3D6()
{
  ChartDialog->ChangeChart(6);
}

void
TChartApp::Cm3D7()
{
  ChartDialog->ChangeChart(7);
}

void
TChartApp::Cm3D8()
{
  ChartDialog->ChangeChart(8);
}

void
TChartApp::Cm3D9()
{
  ChartDialog->ChangeChart(9);
}

void
TChartApp::Cm3D10()
{
  ChartDialog->ChangeChart(10);
}

void
TChartApp::Cm2D1()
{
  ChartDialog->ChangeChart(11);
}

void
TChartApp::Cm2D2()
{
  ChartDialog->ChangeChart(12);
}

void
TChartApp::Cm2D3()
{
  ChartDialog->ChangeChart(13);
}

void
TChartApp::Cm2D4()
{
  ChartDialog->ChangeChart(14);
}

void
TChartApp::Cm2D5()
{
  ChartDialog->ChangeChart(15);
}

void
TChartApp::Cm2D6()
{
  ChartDialog->ChangeChart(16);
}

void
TChartApp::Cm2D7()
{
  ChartDialog->ChangeChart(17);
}

void
TChartApp::Cm2D8()
{
  ChartDialog->ChangeChart(18);
}

void
TChartApp::Cm2D9()
{
  ChartDialog->ChangeChart(19);
}

void
TChartApp::Cm2D10()
{
  ChartDialog->ChangeChart(20);
}

void
TChartApp::Cm2D11()
{
  ChartDialog->ChangeChart(21);
}

void
TChartApp::Cm2D12()
{
  ChartDialog->ChangeChart(22);
}

void
TChartApp::Cm2D13()
{
  ChartDialog->ChangeChart(23);
}

void
TChartApp::Cm2D14()
{
  ChartDialog->ChangeChart(24);
}

void
TChartApp::Cm2D15()
{
  ChartDialog->ChangeChart(25);
}

void
TChartApp::Cm2D16()
{
  ChartDialog->ChangeChart(26);
}

void
TChartApp::Cm2D17()
{
  ChartDialog->ChangeChart(27);
}

void
TChartApp::Cm2D18()
{
  ChartDialog->ChangeChart(28);
}

void
TChartApp::Cm2D19()
{
  ChartDialog->ChangeChart(29);
}

void
TChartApp::Cm2D20()
{
  ChartDialog->ChangeChart(30);
}

void
TChartApp::Cm2D21()
{
  ChartDialog->ChangeChart(31);
}

void
TChartApp::Cm2D22()
{
  ChartDialog->ChangeChart(32);
}



int
OwlMain(int /*argc*/, char* /*argv*/ [])
{
  TBIVbxLibrary vbxLib;
  return TChartApp(AppName).Run();
}
