
{*******************************************************}
{                                                       }
{       Delphi Runtime Library                          }
{       Windows Messages and Types                      }
{                                                       }
{       Copyright (c) 1991,95 Borland International     }
{                                                       }
{*******************************************************}

unit Messages;

interface


uses WinTypes;


{ Window Messages }

const
  wm_Null             = $0000;
  wm_Create           = $0001;
  wm_Destroy          = $0002;
  wm_Move             = $0003;
  wm_Size             = $0005;
  wm_Activate         = $0006;
  wm_SetFocus         = $0007;
  wm_KillFocus        = $0008;
  wm_Enable           = $000A;
  wm_SetRedraw        = $000B;
  wm_SetText          = $000C;
  wm_GetText          = $000D;
  wm_GetTextLength    = $000E;
  wm_Paint            = $000F;
  wm_Close            = $0010;
  wm_QueryEndSession  = $0011;
  wm_Quit             = $0012;
  wm_QueryOpen        = $0013;
  wm_EraseBkGnd       = $0014;
  wm_SysColorChange   = $0015;
  wm_EndSession       = $0016;
  wm_SystemError      = $0017;
  wm_ShowWindow       = $0018;
  wm_CtlColor         = $0019;
  wm_WinIniChange     = $001A;
  wm_DevModeChange    = $001B;
  wm_ActivateApp      = $001C;
  wm_FontChange       = $001D;
  wm_TimeChange       = $001E;
  wm_CancelMode       = $001F;
  wm_SetCursor        = $0020;
  wm_MouseActivate    = $0021;
  wm_ChildActivate    = $0022;
  wm_QueueSync        = $0023;
  wm_GetMinMaxInfo    = $0024;
  wm_PaintIcon        = $0026;
  wm_IconEraseBkGnd   = $0027;
  wm_NextDlgCtl       = $0028;
  wm_SpoolerStatus    = $002A;
  wm_DrawItem         = $002B;
  wm_MeasureItem      = $002C;
  wm_DeleteItem       = $002D;
  wm_VKeyToItem       = $002E;
  wm_CharToItem       = $002F;
  wm_SetFont          = $0030;
  wm_GetFont          = $0031;
  wm_QueryDragIcon    = $0037;
  wm_CompareItem      = $0039;
  wm_Compacting       = $0041;

  wm_CommNotify        = $0044;

  wm_WindowPosChanging = $0046;
  wm_WindowPosChanged  = $0047;
  wm_Power             = $0048;


  wm_NCCreate         = $0081;
  wm_NCDestroy        = $0082;
  wm_NCCalcSize       = $0083;
  wm_NCHitTest        = $0084;
  wm_NCPaint          = $0085;
  wm_NCActivate       = $0086;
  wm_GetDlgCode       = $0087;
  wm_NCMouseMove      = $00A0;
  wm_NCLButtonDown    = $00A1;
  wm_NCLButtonUp      = $00A2;
  wm_NCLButtonDblClk  = $00A3;
  wm_NCRButtonDown    = $00A4;
  wm_NCRButtonUp      = $00A5;
  wm_NCRButtonDblClk  = $00A6;
  wm_NCMButtonDown    = $00A7;
  wm_NCMButtonUp      = $00A8;
  wm_NCMButtonDblClk  = $00A9;

  wm_KeyFirst         = $0100;
  wm_KeyDown          = $0100;
  wm_KeyUp            = $0101;
  wm_Char             = $0102;
  wm_DeadChar         = $0103;
  wm_SysKeyDown       = $0104;
  wm_SysKeyUp         = $0105;
  wm_SysChar          = $0106;
  wm_SysDeadChar      = $0107;
  wm_KeyLast          = $0108;

  wm_InitDialog       = $0110;
  wm_Command          = $0111;
  wm_SysCommand       = $0112;
  wm_Timer            = $0113;
  wm_HScroll          = $0114;
  wm_VScroll          = $0115;
  wm_InitMenu         = $0116;
  wm_InitMenuPopup    = $0117;
  wm_MenuSelect       = $011F;
  wm_MenuChar         = $0120;
  wm_EnterIdle        = $0121;


  wm_MouseFirst       = $0200;
  wm_MouseMove        = $0200;
  wm_LButtonDown      = $0201;
  wm_LButtonUp        = $0202;
  wm_LButtonDblClk    = $0203;
  wm_RButtonDown      = $0204;
  wm_RButtonUp        = $0205;
  wm_RButtonDblClk    = $0206;
  wm_MButtonDown      = $0207;
  wm_MButtonUp        = $0208;
  wm_MButtonDblClk    = $0209;
  wm_MouseLast        = $0209;

  wm_ParentNotify     = $0210;
  wm_MDICreate        = $0220;
  wm_MDIDestroy       = $0221;
  wm_MDIActivate      = $0222;
  wm_MDIRestore       = $0223;
  wm_MDINext          = $0224;
  wm_MDIMaximize      = $0225;
  wm_MDITile          = $0226;
  wm_MDICascade       = $0227;
  wm_MDIIconArrange   = $0228;
  wm_MDIGetActive     = $0229;
  wm_MDISetMenu       = $0230;

  wm_DropFiles        = $0233;

  wm_Cut              = $0300;
  wm_Copy             = $0301;
  wm_Paste            = $0302;
  wm_Clear            = $0303;
  wm_Undo             = $0304;
  wm_RenderFormat     = $0305;
  wm_RenderAllFormats = $0306;
  wm_DestroyClipboard = $0307;
  wm_DrawClipboard    = $0308;
  wm_PaintClipboard   = $0309;
  wm_VScrollClipboard = $030A;
  wm_SizeClipboard    = $030B;
  wm_AskCBFormatName  = $030C;
  wm_ChangeCBChain    = $030D;
  wm_HScrollClipboard = $030E;
  wm_QueryNewPalette  = $030F;
  wm_PaletteIsChanging = $0310;
  wm_PaletteChanged   = $0311;

  wm_PenWinFirst      = $0380;
  wm_PenWinLast       = $038F;

  wm_Coalesce_First   = $0390;
  wm_Coalesce_Last    = $039F;

{ NOTE: All Message Numbers below 0x0400 are RESERVED }

{ Private Window Messages Start Here }

  wm_User             = $0400;

{ Button Notification Codes }

const
  bn_Clicked       = 0;
  bn_Paint         = 1;
  bn_Hilite        = 2;
  bn_Unhilite      = 3;
  bn_Disable       = 4;
  bn_DoubleClicked = 5;

{ Listbox Notification Codes }

const
  lbn_ErrSpace  = (-2);
  lbn_SelChange = 1;
  lbn_DblClk    = 2;
  lbn_SelCancel = 3;
  lbn_SetFocus  = 4;
  lbn_KillFocus = 5;

{ Listbox messages }


const
  lb_AddString           = (wm_User+1);
  lb_InsertString        = (wm_User+2);
  lb_DeleteString        = (wm_User+3);
  lb_ResetContent        = (wm_User+5);
  lb_SetSel              = (wm_User+6);
  lb_SetCurSel           = (wm_User+7);
  lb_GetSel              = (wm_User+8);
  lb_GetCurSel           = (wm_User+9);
  lb_GetText             = (wm_User+10);
  lb_GetTextLen          = (wm_User+11);
  lb_GetCount            = (wm_User+12);
  lb_SelectString        = (wm_User+13);
  lb_Dir                 = (wm_User+14);
  lb_GetTopIndex         = (wm_User+15);
  lb_FindString          = (wm_User+16);
  lb_GetSelCount         = (wm_User+17);
  lb_GetSelItems         = (wm_User+18);
  lb_SetTabStops         = (wm_User+19);
  lb_GetHorizontalExtent = (wm_User+20);
  lb_SetHorizontalExtent = (wm_User+21);
  lb_SetColumnWidth      = (wm_User+22);
  lb_SetTopIndex         = (wm_User+24);
  lb_GetItemRect         = (wm_User+25);
  lb_GetItemData         = (wm_User+26);
  lb_SetItemData         = (wm_User+27);
  lb_SelItemRange        = (wm_User+28);
  lb_MsgMax              = (wm_User+33);
  lb_GetCaretIndex       = wm_User+32;
  lb_SetCaretIndex       = wm_User+31;
  lb_SetItemHeight       = wm_User+33;
  lb_GetItemHeight       = wm_User+34;
  lb_FindStringExact     = wm_User+35;


{ Combo Box Notification Codes }

const
  cbn_ErrSpace   = (-1);
  cbn_SelChange  = 1;
  cbn_DblClk     = 2;
  cbn_SetFocus   = 3;
  cbn_KillFocus  = 4;
  cbn_EditChange = 5;
  cbn_EditUpdate = 6;
  cbn_DropDown   = 7;
  cbn_Closeup    = 8;
  cbn_SelEndOk   = 9;
  cbn_SelEndCancel = 10;

{ Combo Box messages }


const
  cb_GetEditSel            = (wm_User+0);
  cb_LimitText             = (wm_User+1);
  cb_SetEditSel            = (wm_User+2);
  cb_AddString             = (wm_User+3);
  cb_DeleteString          = (wm_User+4);
  cb_Dir                   = (wm_User+5);
  cb_GetCount              = (wm_User+6);
  cb_GetCurSel             = (wm_User+7);
  cb_GetLBText             = (wm_User+8);
  cb_GetLBTextLen          = (wm_User+9);
  cb_InsertString          = (wm_User+10);
  cb_ResetContent          = (wm_User+11);
  cb_FindString            = (wm_User+12);
  cb_SelectString          = (wm_User+13);
  cb_SetCurSel             = (wm_User+14);
  cb_ShowDropDown          = (wm_User+15);
  cb_GetItemData           = (wm_User+16);
  cb_SetItemData           = (wm_User+17);
  cb_GetDroppedControlRect = (wm_User+18);
  cb_MsgMax                = (wm_User+19);  { Removed in Windows 3.1 }
  cb_SetItemHeight         = wm_User+19;
  cb_GetItemHeight         = wm_User+20;
  cb_SetExtendedUI         = wm_User+21;
  cb_GetExtendedUI         = wm_User+22;
  cb_GetDroppedState       = wm_User+23;
  cb_FindStringExact       = wm_User+24;


{ Edit Control Notification Codes }

const
  en_SetFocus  = $0100;
  en_KillFocus = $0200;
  en_Change    = $0300;
  en_Update    = $0400;
  en_ErrSpace  = $0500;
  en_MaxText   = $0501;
  en_HScroll   = $0601;
  en_VScroll   = $0602;

{ Edit Control Messages }


const
  em_GetSel          = (wm_User+0);
  em_SetSel          = (wm_User+1);
  em_GetRect         = (wm_User+2);
  em_SetRect         = (wm_User+3);
  em_SetRectNP       = (wm_User+4);
  em_Scroll          = (wm_User+5);
  em_LineScroll      = (wm_User+6);
  em_GetModify       = (wm_User+8);
  em_SetModify       = (wm_User+9);
  em_GetLineCount    = (wm_User+10);
  em_LineIndex       = (wm_User+11);
  em_SetHandle       = (wm_User+12);
  em_GetHandle       = (wm_User+13);
  em_GetThumb        = (wm_User+14);
  em_LineLength      = (wm_User+17);
  em_ReplaceSel      = (wm_User+18);
  em_SetFont         = (wm_User+19);
  em_GetLine         = (wm_User+20);
  em_LimitText       = (wm_User+21);
  em_CanUndo         = (wm_User+22);
  em_Undo            = (wm_User+23);
  em_FmtLines        = (wm_User+24);
  em_LineFromChar    = (wm_User+25);
  em_SetWordBreak    = (wm_User+26);
  em_SetTabStops     = (wm_User+27);
  em_SetPasswordChar = (wm_User+28);
  em_EmptyUndoBuffer = (wm_User+29);
  em_MsgMax          = (wm_User+30);  { Removed in Windows 3.1 }
  em_GetFirstVisibleLine = wm_User+30;
  em_SetReadOnly = wm_User+31;
  em_SetWordBreakProc = wm_User+32;
  em_GetWordBreakProc = wm_User+33;
  em_GetPasswordChar = wm_User+34;


const
  stm_SetIcon = wm_User+0;
  stm_GetIcon = wm_User+1;

{ Button Control Messages }


const
  bm_GetCheck = (wm_User+0);
  bm_SetCheck = (wm_User+1);
  bm_GetState = (wm_User+2);
  bm_SetState = (wm_User+3);
  bm_SetStyle = (wm_User+4);


{ Dialog messages }
  dm_GetDefID = (wm_User+0);
  dm_SetDefID = (wm_User+1);

type

{ Generic window message record }

  PMessage = ^TMessage;
  TMessage = record
    Msg: Cardinal;
    case Integer of
      0: (
        WParam: Word;
        LParam: Longint;
        Result: Longint);
      1: (
        WParamLo: Byte;
        WParamHi: Byte;
        LParamLo: Word;
        LParamHi: Word;
        ResultLo: Word;
        ResultHi: Word);
  end;

{ Common message format records }

  TWMNoParams = record
    Msg: Cardinal;
    Unused: array[0..2] of Word;
    Result: Longint;
  end;

  TWMKey = record
    Msg: Cardinal;
    CharCode: Word;
    KeyData: Longint;
    Result: Longint;
  end;

  TWMMouse = record
    Msg: Cardinal;
    Keys: Word;
    case Integer of
      0: (
        XPos: Integer;
        YPos: Integer);
      1: (
        Pos: TPoint;
        Result: Longint);
  end;

  TWMWindowPosMsg = record
    Msg: Cardinal;
    Unused: Integer;
    WindowPos: PWindowPos;
    Result: Longint;
  end;

  TWMScroll = record
    Msg: Cardinal;
    ScrollCode: SmallInt; { SB_xxxx }
    Pos: SmallInt;
    ScrollBar: HWND;
    Result: Longint;
  end;

{ Message records }

  TWMActivate = record
    Msg: Cardinal;
    Active: WORD; { WA_INACTIVE, WA_ACTIVE, WA_CLICKACTIVE }
    ActiveWindow: HWND;
    Minimized: BOOL;
    Result: Longint;
  end;

  TWMActivateApp = record
    Msg: Cardinal;
    Active: BOOL;
    Task: THANDLE;
    Unused: Word;
    Result: Longint;
  end;

  TWMAskCBFormatName = record
    Msg: Cardinal;
    NameLen: Word;
    FormatName: PChar;
    Result: Longint;
  end;

  TWMCancelMode = TWMNoParams;

  TWMChangeCBChain = record
    Msg: Cardinal;
    Remove: HWND;
    Next: HWND;
    Unused: Word;
    Result: Longint;
  end;

  TWMChar = TWMKey;

  TWMCharToItem = record
    Msg: Cardinal;
    Key: Word;
    ListBox: HWND;
    CaretPos: Word;
    Result: Longint;
  end;

  TWMChildActivate = TWMNoParams;

  TWMChooseFont_GetLogFont = record
    Msg: Cardinal;
    Unused: Word;
    LogFont: PLogFont;
    Result: Longint;
  end;

  TWMClear = TWMNoParams;
  TWMClose = TWMNoParams;

  TWMCommand = record
    Msg: Cardinal;
    ItemID: Word;
    Ctl: HWND;
    NotifyCode: Word;
    Result: Longint;
  end;

  TWMCommNotify = record
    Msg: Cardinal;
    Device: Word;
    NotifyStatus: Word;  { CN_EVENT, CN_RECEIVE, CN_TRANSMIT }
    Unused: Word;
    Result: Longint;
  end;

  TWMCompacting = record
    Msg: Cardinal;
    CompactRatio: Word;
    Unused: Longint;
    Result: Longint;
  end;

  TWMCompareItem = record
    Msg: Cardinal;
    Ctl: Word;
    CompareItemStruct: PCompareItemStruct;
    Result: Longint;
  end;

  TWMCopy = TWMNoParams;


  { ?? WM_CLP_LAUNCH, WM_CPL_LAUNCHED }

  TWMCreate = record
    Msg: Cardinal;
    Unused: Integer;
    CreateStruct: PCreateStruct;
    Result: Longint;
  end;


  TWMCtlColor = record
    Msg: Cardinal;
    ChildDC: HDC;
    ChildWnd: HWND;
    CtlType: Integer;  { CTLCOLOR_BTN, CTLCOLOR_DLG, CTLCOLOR_EDIT, CTLCOLOR_LISTBOX,
                         CTLCOLOR_MSGBOX, CTLCOLOR_SCROLLBAR, CTLCOLOR_STAIC}
    Result: Longint;
  end;


  TWMCut = TWMNoParams;

  TWMDDE_Ack = record
    Msg: Cardinal;
    PostingApp: HWND;
    case Word of
      WM_DDE_INITIATE: (
        App: Word;
        Topic: Word;
        Result: Longint);
      WM_DDE_EXECUTE {and all others }: (
        Status: Word;
        case Word of
          WM_DDE_EXECUTE: (
            Commands: THANDLE);
          0 { all others }: (
            Item: Word));
  end;

  TWMDDE_Advise = record
    Msg: Cardinal;
    PostingApp: HWND;
    Options: THANDLE;
    Item: Word;
    Result: Longint;
  end;

  TWMDDE_Data = record
    Msg: Cardinal;
    PostingApp: HWND;
    Data: THANDLE;
    Item: Word;
    Result: Longint;
  end;

  TWMDDE_Execute = record
    Msg: Cardinal;
    PostingApp: HWND;
    Commands: THANDLE;
    Unused: Word;
    Result: Longint;
  end;

  TWMDDE_Initiate = record
    Msg: Cardinal;
    PostingApp: HWND;
    App: Word;
    Topic: Word;
    Result: Longint;
  end;

  TWMDDE_Poke = record
    Msg: Cardinal;
    PostingApp: HWND;
    Data: THANDLE;
    Item: Word;
    Result: Longint;
  end;

  TWMDDE_Request = record
    Msg: Cardinal;
    PostingApp: HWND;
    Format: Word;
    Item: Word;
    Result: Longint;
  end;

  TWMDDE_Terminate = record
    Msg: Cardinal;
    PostingApp: HWND;
    Unused: Longint;
    Result: Longint;
  end;

  TWMDDE_Unadvise = TWMDDE_Advise;
  TWMDeadChar = TWMChar;

  TWMDeleteItem = record
    Msg: Cardinal;
    Ctl: HWND;
    DeleteItemStruct: PDeleteItemStruct;
    Result: Longint;
  end;

  TWMDestroy = TWMNoParams;
  TWMDestroyClipboard = TWMNoParams;

  TWMDevModeChanged = record
    Msg: Cardinal;
    Unused: Integer;
    Device: PChar;
    Result: Longint;
  end;

  TWMDrawClipboard = TWMNoParams;

  TWMDrawItem = record
    Msg: Cardinal;
    Ctl: HWND;
    DrawItemStruct: PDrawItemStruct;
    Result: Longint;
  end;

  TWMDropFiles = record
    Msg: Cardinal;
    Drop: THANDLE;
    Unused: Longint;
    Result: Longint;
  end;

  TWMEnable = record
    Msg: Cardinal;
    Enabled: BOOL;
    Unused: Longint;
    Result: Longint;
  end;

  TWMEndSession = record
    Msg: Cardinal;
    EndSession: BOOL;
    Unused: Longint;
    Result: Longint;
  end;

  TWMEnterIdle = record
    Msg: Cardinal;
    Source: Word; { MSGF_DIALOGBOX, MSGF_MENU }
    IdleWnd: HWND;
    Unused: Word;
    Result: Longint;
  end;


  TWMEraseBkgnd = record
    Msg: Cardinal;
    DC: HDC;
    Unused: Longint;
    Result: Longint;
  end;

  TWMFontChange = TWMNoParams;
  TWMGetDlgCode = TWMNoParams;
  TWMGetFont = TWMNoParams;


  TWMGetMinMaxInfo = record
    Msg: Cardinal;
    Unused: Integer;
    MinMaxInfo: PMinMaxInfo;
    Result: Longint;
  end;

  TWMGetText = record
    Msg: Cardinal;
    TextMax: Integer;
    Text: PChar;
    Result: Longint;
  end;

  TWMGetTextLength = TWMNoParams;


  TWMHScroll = TWMScroll;

  TWMHScrollClipboard = record
    Msg: Cardinal;
    Viewer: HWND;
    ScrollCode: Word; {SB_BOTTOM, SB_ENDSCROLL, SB_LINEDOWN, SB_LINEUP,
                       SB_PAGEDOWN, SB_PAGEUP, SB_THUMBPOSITION,
                       SB_THUMBTRACK, SB_TOP }
    Pos: Word;
    Result: Longint;
  end;

  TWMIconEraseBkgnd = TWMEraseBkgnd;

  TWMInitDialog = record
    Msg: Cardinal;
    Focus: HWND;
    InitParam: Longint;
    Result: Longint;
  end;

  TWMInitMenu = record
    Msg: Cardinal;
    Menu: HMENU;
    Unused: Longint;
    Result: Longint;
  end;

  TWMInitMenuPopup = record
    Msg: Cardinal;
    MenuPopup: HMENU;
    Pos: SmallInt;
    SystemMenu: BOOL;
    Result: Longint;
  end;

  TWMKeyDown = TWMKey;
  TWMKeyUp = TWMKey;

  TWMKillFocus = record
    Msg: Cardinal;
    FocusedWnd: HWND;
    Unused: Longint;
    Result: Longint;
  end;

  TWMLButtonDblClk = TWMMouse;
  TWMLButtonDown   = TWMMouse;
  TWMLButtonUp     = TWMMouse;
  TWMMButtonDblClk = TWMMouse;
  TWMMButtonDown   = TWMMouse;
  TWMMButtonUp     = TWMMouse;

  {!! 32? }
  TWMMDIActivate = record
    Msg: Cardinal;
    Activate: BOOL;
    ActiveWnd: HWND;
    DeactiveWnd: HWND;
    Result: Longint;
  end;

  TWMMDICascade = record
    Msg: Cardinal;
    Cascade: Word;     { 0, MDITILE_SKIPDISABLED }
    Unused: Longint;
    Result: Longint;
  end;

  TWMMDICreate = record
    Msg: Cardinal;
    Unused: Integer;
    MDICreateStruct: PMDICreateStruct;
    Result: Longint;
  end;

  TWMMDIDestroy = record
    Msg: Cardinal;
    Child: HWND;
    Unused: Longint;
    Result: Longint;
  end;

  TWMMDIGetActive = TWMNoParams;
  TWMMDIIconArrange = TWMNoParams;

  TWMMDIMaximize = record
    Msg: Cardinal;
    Maximize: HWND;
    Unused: Longint;
    Result: Longint;
  end;

  TWMMDINext = record
    Msg: Cardinal;
    Child: HWND;
    Next: Longint;
    Result: Longint;
  end;


  TWMMDIRestore = record
    Msg: Cardinal;
    IDChild: HWND;
    Unused: Longint;
    Result: Longint;
  end;

  TWMMDISetMenu = record
    Msg: Cardinal;
    MenuFrame: HMENU;
    MenuWindow: HMENU;
    Result: Longint;
  end;

  TWMMDITile = record
    Msg: Cardinal;
    Tile: Word;       { MDITILE_HORIZONTAL, MDITILE_SKIPDISABLE, MDITILE_VERTICAL }
    Unused: Longint;
    Result: Longint;
  end;

  TWMMeasureItem = record
    Msg: Cardinal;
    IDCtl: Word;
    MeasureItemStruct: PMeasureItemStruct;
    Result: Longint;
  end;

  TWMMenuChar = record
    Msg: Cardinal;
    User: Char;
    Unused: Byte;
    MenuFlag: Word;   { MF_POPUP, MF_SYSMENU }
    Menu: HMENU;
    Result: Longint;
  end;

  TWMMenuSelect = record
    Msg: Cardinal;
    IDItem: Word;
    MenuFlag: Word;  { MF_BITMAP, MF_CHECKED, MF_DISABLED, MF_GRAYED, MF_MOUSESELECT,
                       MF_OWNERDRAW, MF_POPUP, MF_SEPARATOR, MF_SYSMENU }
    Menu: HMENU;
    Result: Longint;
  end;

  TWMMouseActivate = record
    Msg: Cardinal;
    TopLevel: HWND;
    HitTestCode: Word;
    MouseMsg: Word;
    Result: Longint;
  end;

  TWMMouseMove = TWMMouse;

  TWMMove = record
    Msg: Cardinal;
    Unused: Integer;
    case Integer of
      0: (
        XPos: SmallInt; 
        YPos: SmallInt);
      1: (
        Pos: TPoint;
        Result: Longint);
  end;

  TWMNCActivate = record
    Msg: Cardinal;
    Active: BOOL;
    Unused: Longint;
    Result: Longint;
  end;

  TWMNCCalcSize = record
    Msg: Cardinal;
    CalcValidRects: BOOL;
    CalcSize_Params: PNCCalcSize_Params;
    Result: Longint;
  end;

  TWMNCCreate = record
    Msg: Cardinal;
    Unused: Integer;
    CreateStruct: PCreateStruct;
    Result: Longint;
  end;

  TWMNCDestroy = TWMNoParams;

  TWMNCHitTest = record
    Msg: Cardinal;
    Unused: Cardinal;
    case Integer of
      0: (
        XPos: SmallInt;
        YPos: SmallInt);
      1: (
        Pos: TSmallPoint;
        Result: Longint);
  end;

  TWMNCHitMessage = record
    Msg: Cardinal;
    HitTest: Integer; {??}
    XCursor: SmallInt;
    YCursor: SmallInt;
    Result: Longint;
  end;

  TWMNCLButtonDblClk  = TWMNCHitMessage;
  TWMNCLButtonDown    = TWMNCHitMessage;
  TWMNCLButtonUp      = TWMNCHitMessage;
  TWMNCMButtonDblClk  = TWMNCHitMessage;
  TWMNCMButtonDown    = TWMNCHitMessage;
  TWMNCMButtonUp      = TWMNCHitMessage;
  TWMNCMouseMove      = TWMNCHitMessage;

  TWMNCPaint = TWMNoParams;

  TWMNCRButtonDblClk  = TWMNCHitMessage;
  TWMNCRButtonDown    = TWMNCHitMessage;
  TWMNCRButtonUp      = TWMNCHitMessage;

  TWMNextDlgCtl = record
    Msg: Cardinal;
    CtlFocus: Word;
    Handle: BOOL;
    Unused: Word;
    Result: Longint;
  end;

  TWMPaint = record
    Msg: Cardinal;
    DC: HDC;
    Unused: Longint;
    Result: Longint;
  end;

  TWMPaintClipboard = record
    Msg: Cardinal;
    Viewer: HWND;
    PaintStruct: THANDLE;
    Unused: Word;
    Result: Longint;
  end;

  TWMPaintIcon = TWMNoParams;

  TWMPaletteChanged = record
    Msg: Cardinal;
    PalChg: HWND;
    Unused: Longint;
    Result: Longint;
  end;

  TWMPaletteIsChanging = record
    Msg: Cardinal;
    Realize: HWND;
    Unused: Longint;
    Result: Longint;
  end;

  TWMParentNotify = record
    Msg: Cardinal;
    case Event: Word of
      WM_CREATE, WM_DESTROY: (
        ChildWnd: HWND;
        ChildID: Word);
      WM_LBUTTONDOWN, WM_MBUTTONDOWN, WM_RBUTTONDOWN: (
        XPos: Integer;
        YPos: Integer);
      0 { Name is MS DOC }: (
        Value1: Word;
        Value2: Word;
        Result: Longint);
  end;

  TWMPaste = TWMNoParams;

  TWMPower = record  { !! not declared in WinTypes }
    Msg: Cardinal;
    PowerEvt: Word;     { PWR_SUSPENDREQUEST, PWR_SUSPENDRESUME, PWR_CRITICALRESUME }
    Unused: Longint;
    Result: Longint;
  end;

  TWMQueryDragIcon = TWMNoParams;

  TWMQueryEndSession = TWMNoParams;

  TWMQueryNewPalette = TWMNoParams;
  TWMQueryOpen = TWMNoParams;
  TWMQueueSync = TWMNoParams;

  TWMQuit = record
    Msg: Cardinal;
    ExitCode: Word;
    Unused: Longint;
    Result: Longint;
  end;

  TWMRButtonDblClk = TWMMouse;
  TWMRButtonDown = TWMMouse;
  TWMRButtonUp = TWMMouse;

  TWMRenderAllFormats = TWMNoParams;

  TWMRenderFormat = record
    Msg: Cardinal;
    Format: Word;
    Unused: Longint;
    Result: Longint;
  end;

  TWMSetCursor = record
    Msg: Cardinal;
    CursorWnd: HWND;
    HitTest: Word;
    MouseMsg: Word;
    Result: Longint;
  end;

  TWMSetFocus = record
    Msg: Cardinal;
    FocusedWnd: HWND;
    Unused: Longint;
    Result: Longint;
  end;

  TWMSetFont = record
    Msg: Cardinal;
    Font: HFONT;
    Redraw: BOOL;
    Unused: Word;
    Result: Longint;
  end;


  TWMSetRedraw = record
    Msg: Cardinal;
    Redraw: Word;
    Unused: Longint;
    Result: Longint;
  end;

  TWMSetText = record
    Msg: Cardinal;
    Unused: Integer;
    Text: PChar;
    Result: Longint;
  end;

  TWMShowWindow = record
    Msg: Cardinal;
    Show: BOOL;
    Status: Word;
    Unused: Word;
    Result: Longint;
  end;

  TWMSize = record
    Msg: Cardinal;
    SizeType: Word;    { SIZE_MAXIMIZED, SIZE_MINIMIZED, SIZE_RESTORED,
                         SIZE_MAXHIDE, SIZE_MAXSHOW }
    Width: Word;
    Height: Word;
    Result: Longint;
  end;

  TWMSizeClipboard = record
    Msg: Cardinal;
    Viewer: HWND;
    RC: THandle;
    Unused: Word;
    Result: Longint;
  end;

  TWMSpoolerStatus = record
    Msg: Cardinal;
    JobStatus: Word;
    JobsLeft: Word;
    Unused: Word;
    Result: Longint;
  end;

  TWMSysChar = TWMKey;
  TWMSysColorChange = TWMNoParams;

  TWMSysCommand = record
    Msg: Cardinal;
    case CmdType: Word of
      SC_HOTKEY: (
        ActivateWnd: HWND;
        Unused1: Word);
      SC_KEYMENU: (
        Key: Word;
        Unused2: Word);
      SC_CLOSE, SC_HSCROLL, SC_MAXIMIZE, SC_MINIMIZE, SC_MOUSEMENU, SC_MOVE,
      SC_NEXTWINDOW, SC_PREVWINDOW, SC_RESTORE, SC_SCREENSAVE, SC_SIZE,
      SC_TASKLIST, SC_VSCROLL: (
        XPos: SmallInt;
        YPos: SmallInt;
        Result: Longint);
  end;

  TWMSysDeadChar = record
    Msg: Cardinal;
    DeadKey: Char; { !! should this be 16 bits? }
    Unused: Byte;
    RepeatCount: Integer;
    AutoRepeat: Word;
    Result: Longint;
  end;

  TWMSysKeyDown = TWMKey;
  TWMSysKeyUp = TWMKey;

  TWMSystemError = record  { !! not declared in WinTypes or WIN32 API }
    Msg: Cardinal;
    ErrSpec: Word;
    Unused: Longint;
    Result: Longint;
  end;

  TWMTimeChange = TWMNoParams;

  TWMTimer = record
    Msg: Cardinal;
    TimerID: Word;
    TimerProc: TFarProc;
    Result: Longint;
  end;

  TWMUndo = TWMNoParams;

  TWMVKeyToItem = TWMCharToItem;

  TWMVScroll = TWMScroll;

  TWMVScrollClipboard = record
    Msg: Cardinal;
    Viewer: HWND;
    ScollCode: Word;
    ThumbPos: Word;
    Result: Longint;
  end;

  TWMWindowPosChanged = TWMWindowPosMsg;
  TWMWindowPosChanging = TWMWindowPosMsg;

  TWMWinIniChange = record
    Msg: Cardinal;
    Unused: Integer;
    Section: PChar;
    Result: Longint;
  end;

implementation

end.

