
{*******************************************************}
{                                                       }
{       Delphi Runtime Library                          }
{       Windows 3.1 API Interface Unit                  }
{                                                       }
{       Copyright (c) 1992,93 Borland International     }
{                                                       }
{*******************************************************}

unit Dispatch;

interface

uses WinTypes, OLE2;

const

  FADF_AUTO      = $0001;  { array is allocated on the stack }
  FADF_STATIC    = $0002;  { array is staticly allocated }
  FADF_EMBEDDED  = $0004;  { array is embedded in a structure }
  FADF_FIXEDSIZE = $0010;  { array may not be resized or reallocated }
  FADF_BSTR      = $0100;  { an array of BSTRs }
  FADF_UNKNOWN   = $0200;  { an array of IUnknown }
  FADF_DISPATCH  = $0400;  { an array of IDispatch }
  FADF_VARIANT   = $0800;  { an array of VARIANTs }
  FADF_RESERVED  = $F0E8;  { bits reserved for future use }

{ VARENUM usage key,

    [V] - may appear in a VARIANT
    [T] - may appear in a TYPEDESC
    [P] - may appear in an OLE property set
    [S] - may appear in a Safe Array }

  VT_EMPTY           = 0;   { [V]   [P]  nothing                     }
  VT_NULL            = 1;   { [V]        SQL style Null              }
  VT_I2              = 2;   { [V][T][P]  2 byte signed int           }
  VT_I4              = 3;   { [V][T][P]  4 byte signed int           }
  VT_R4              = 4;   { [V][T][P]  4 byte real                 }
  VT_R8              = 5;   { [V][T][P]  8 byte real                 }
  VT_CY              = 6;   { [V][T][P]  currency                    }
  VT_DATE            = 7;   { [V][T][P]  date                        }
  VT_BSTR            = 8;   { [V][T][P]  binary string               }
  VT_DISPATCH        = 9;   { [V][T]     IDispatch FAR*              }
  VT_ERROR           = 10;  { [V][T]     SCODE                       }
  VT_BOOL            = 11;  { [V][T][P]  True=-1, False=0            }
  VT_VARIANT         = 12;  { [V][T][P]  VARIANT FAR*                }
  VT_UNKNOWN         = 13;  { [V][T]     IUnknown FAR*               }

  VT_I1              = 16;  {    [T]     signed char                 }
  VT_UI1             = 17;  {    [T]     unsigned char               }
  VT_UI2             = 18;  {    [T]     unsigned short              }
  VT_UI4             = 19;  {    [T]     unsigned short              }
  VT_I8              = 20;  {    [T][P]  signed 64-bit int           }
  VT_UI8             = 21;  {    [T]     unsigned 64-bit int         }
  VT_INT             = 22;  {    [T]     signed machine int          }
  VT_UINT            = 23;  {    [T]     unsigned machine int        }
  VT_VOID            = 24;  {    [T]     C style void                }
  VT_HRESULT         = 25;  {    [T]                                 }
  VT_PTR             = 26;  {    [T]     pointer type                }
  VT_SAFEARRAY       = 27;  {    [T]     (use VT_ARRAY in VARIANT)   }
  VT_CARRAY          = 28;  {    [T]     C style array               }
  VT_USERDEFINED     = 29;  {    [T]     user defined type          }
  VT_LPSTR           = 30;  {    [T][P]  null terminated string      }
  VT_LPWSTR          = 31;  {    [T][P]  wide null terminated string }

  VT_FILETIME        = 64;  {       [P]  FILETIME                    }
  VT_BLOB            = 65;  {       [P]  Length prefixed bytes       }
  VT_STREAM          = 66;  {       [P]  Name of the stream follows  }
  VT_STORAGE         = 67;  {       [P]  Name of the storage follows }
  VT_STREAMED_OBJECT = 68;  {       [P]  Stream contains an object   }
  VT_STORED_OBJECT   = 69;  {       [P]  Storage contains an object  }
  VT_BLOB_OBJECT     = 70;  {       [P]  Blob contains an object     }
  VT_CF              = 71;  {       [P]  Clipboard format            }
  VT_CLSID           = 72;  {       [P]  A Class ID                  }

  VT_VECTOR          = $1000; {       [P]  simple counted array        }
  VT_ARRAY           = $2000; { [V]        SAFEARRAY*                  }
  VT_BYREF           = $4000; { [V]                                    }
  VT_RESERVED        = $8000;

  STDOLE_MAJORVERNUM = 1;
  STDOLE_MINORVERNUM = 0;
  STDOLE_LCID = 0;

{ OLE Automation error codes }

  DISP_E_UNKNOWNINTERFACE = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (1);
  DISP_E_MEMBERNOTFOUND = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (3);
  DISP_E_PARAMNOTFOUND = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (4);
  DISP_E_TYPEMISMATCH = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (5);
  DISP_E_UNKNOWNNAME = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (6);
  DISP_E_NONAMEDARGS = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (7);
  DISP_E_BADVARTYPE = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (8);
  DISP_E_EXCEPTION = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (9);
  DISP_E_OVERFLOW = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (10);
  DISP_E_BADINDEX = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (11);
  DISP_E_UNKNOWNLCID = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (12);
  DISP_E_ARRAYISLOCKED = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (13);
  DISP_E_BADPARAMCOUNT = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (14);
  DISP_E_PARAMNOTOPTIONAL = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (15);
  DISP_E_BADCALLEE = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (16);
  DISP_E_NOTACOLLECTION = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (17);

  TYPE_E_BUFFERTOOSMALL = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32790);
  TYPE_E_INVDATAREAD = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32792);
  TYPE_E_UNSUPFORMAT = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32793);
  TYPE_E_REGISTRYACCESS = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32796);
  TYPE_E_LIBNOTREGISTERED = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32797);
  TYPE_E_UNDEFINEDTYPE = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32807);
  TYPE_E_QUALIFIEDNAMEDISALLOWED = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32808);
  TYPE_E_INVALIDSTATE = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32809);
  TYPE_E_WRONGTYPEKIND = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32810);
  TYPE_E_ELEMENTNOTFOUND = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32811);
  TYPE_E_AMBIGUOUSNAME = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32812);
  TYPE_E_NAMECONFLICT = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32813);
  TYPE_E_UNKNOWNLCID = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32814);
  TYPE_E_DLLFUNCTIONNOTFOUND = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (32815);
  TYPE_E_BADMODULEKIND = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (35005);
  TYPE_E_SIZETOOBIG = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (35013);
  TYPE_E_DUPLICATEID = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (35014);
  TYPE_E_INVALIDID = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (35023);
  TYPE_E_TYPEMISMATCH = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (36000);
  TYPE_E_OUTOFBOUNDS = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (36001);
  TYPE_E_IOERROR = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (36002);
  TYPE_E_CANTCREATETMPFILE = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (36003);
  TYPE_E_CANTLOADLIBRARY = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (40010);
  TYPE_E_INCONSISTENTPROPFUNCS = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (40067);
  TYPE_E_CIRCULARTYPE = (SEVERITY_ERROR shl 31) or (FACILITY_DISPATCH shl 16) or (40068);

  VARIANT_NOVALUEPROP = 1;
  VAR_TIMEVALUEONLY = 1; { return time value }
  VAR_DATEVALUEONLY = 2; { return date value }

{ DISPID reserved for the standard "value" property }

  DISPID_VALUE = 0;

{ DISPID reserved to indicate an "unknown" name }

  DISPID_UNKNOWN =  -1;

{ The following DISPID is reserved to indicate the param
  that is the right-hand-side (or "put" value) of a PropertyPut }

  DISPID_PROPERTYPUT = -3;

{ DISPID reserved for the standard "NewEnum" method }

  DISPID_NEWENUM  = -4;

{ DISPID reserved for the standard "Evaluate" method }

  DISPID_EVALUATE  = -5;
  DISPID_CONSTRUCTOR = -6;
  DISPID_DESTRUCTOR = -7;

  MEMBERID_NIL = DISPID_UNKNOWN;
  ID_DEFAULTINST = -2;

  IDLFLAG_NONE = 0;
  IDLFLAG_FIN = 1;
  IDLFLAG_FOUT = 2;
  IDLFLAG_FLCID = 4;
  IDLFLAG_FRETVAL = 8;

{ Flags for IDispatch::Invoke }

  DISPATCH_METHOD = 1;
  DISPATCH_PROPERTYGET = 2;
  DISPATCH_PROPERTYPUT = 4;
  DISPATCH_PROPERTYPUTREF = 8;

  TYPEFLAG_FOLEAUTOMATION = $100;
  TYPEFLAG_FNONEXTENSIBLE = $80;
  TYPEFLAG_FDUAL = $40;
  TYPEFLAG_FCONTROL = $20;
  TYPEFLAG_FHIDDEN = $10;
  TYPEFLAG_FPREDECLID = 8;
  TYPEFLAG_FLICENSED = 4;
  TYPEFLAG_FCANCREATE = 2;
  TYPEFLAG_FAPPOBJECT = 1;

  FUNCFLAG_FHIDDEN = $40;
  FUNCFLAG_FDEFAULTBIND = $20;
  FUNCFLAG_FDISPLAYBIND = $10;
  FUNCFLAG_FREQUESTEDIT = 8;
  FUNCFLAG_FBINDABLE = 4;
  FUNCFLAG_FSOURCE = 2;
  FUNCFLAG_FRESTRICTED = 1;

  VARFLAG_FHIDDEN = $40;
  VARFLAG_FDEFAULTBIND = $20;
  VARFLAG_FDISPLAYBIND = $10;
  VARFLAG_FREQUESTEDIT = 8;
  VARFLAG_FBINDABLE = 4;
  VARFLAG_FSOURCE = 2;
  VARFLAG_FREADONLY = 1;

  IMPLTYPEFLAG_FDEFAULT = 1;
  IMPLTYPEFLAG_FSOURCE = 2;
  IMPLTYPEFLAG_FRESTRICTED = 4;

{ flags for RegisterActiveObject }

  ACTIVEOBJECT_STRONG = 0;
  ACTIVEOBJECT_WEAK = 1;

  INVOKE_FUNC = 1;
  INVOKE_PROPERTYGET = 2;
  INVOKE_PROPERTYPUT = 4;
  INVOKE_PROPERTYPUTREF = 8;

  SYS_WIN16 = 0;
  SYS_WIN32 = 1;
  SYS_MAC = 2;

  LIBFLAG_FRESTRICTED = 1;
  LIBFLAG_FCONTROL = 2;
  LIBFLAG_FHIDDEN = 4;

  TKIND_ENUM = 0;
  TKIND_RECORD = 1;
  TKIND_MODULE = 2;
  TKIND_INTERFACE = 3;
  TKIND_DISPATCH = 4;
  TKIND_COCLASS = 5;
  TKIND_ALIAS = 6;
  TKIND_UNION = 7;
  TKIND_MAX = 8;

  CC_CDECL = 1;
  CC_PASCAL = 2;
  CC_MACPASCAL = 3;
  CC_STDCALL = 4;
  CC_RESERVED = 5;
  CC_SYSCALL = 6;
  CC_MPWCDECL = 7;
  CC_MPWPASCAL = 8;
  CC_MAX = 9;

  FUNC_VIRTUAL = 0;
  FUNC_PUREVIRTUAL = 1;
  FUNC_NONVIRTUAL = 2;
  FUNC_STATIC = 3;
  FUNC_DISPATCH = 4;

  VAR_PERINSTANCE = 0;
  VAR_STATIC = 1;
  VAR_CONST = 2;
  VAR_DISPATCH = 3;

  DESCKIND_NONE = 0;
  DESCKIND_FUNCDESC = 1;
  DESCKIND_VARDESC = 2;
  DESCKIND_TYPECOMP = 3;
  DESCKIND_IMPLICITAPPOBJ = 4;
  DESCKIND_MAX = 5;

type

  IDispatch = class;
  ITypeInfo = class;
  ITypeComp = class;

  BSTR = PChar;

  PSAFEARRAYBOUND = ^SAFEARRAYBOUND;
  SAFEARRAYBOUND = record
    cElements: Longint;
    lLbound: Longint;
  end;

  PSAFEARRAY = ^SAFEARRAY;
  SAFEARRAY = record
    cDims: Longint;
    fFeatures: Longint;
    cbElements: Longint;
    cLocks: Longint;
    handle: Longint;
    pvData: Pointer;
    rgsabound: array[0..0] of SAFEARRAYBOUND;
  end;

  VARIANT_BOOL = WordBool;

  DATE = Double;

{ This is a helper record for use in handling currency }

  CY = record
    Lo: Longint;
    Hi: Longint;
  end;

  VARTYPE = Word;

  PVARIANT = ^VARIANT;
  VARIANT = record
    vt: VARTYPE;
    wReserved1: Word;
    wReserved2: Word;
    wReserved3: Word;
    case Integer of
      VT_UI1:                  (bVal: Byte);
      VT_I2:                   (iVal: Smallint);
      VT_I4:                   (lVal: Longint);
      VT_R4:                   (fltVal: Single);
      VT_R8:                   (dblVal: Double);
      VT_BOOL:                 (vbool: BOOL);
      VT_ERROR:                (scode: SCODE);
      VT_CY:                   (cyVal: CY);
      VT_DATE:                 (date: DATE);
      VT_BSTR:                 (bstrVal: BSTR);
      VT_UNKNOWN:              (punkVal: IUnknown);
      VT_DISPATCH:             (pdispVal: IDispatch);
      VT_ARRAY:                (parray: PSAFEARRAY);
      VT_BYREF or VT_UI1:      (pbVal: ^Byte);
      VT_BYREF or VT_I2:       (piVal: ^Smallint);
      VT_BYREF or VT_I4:       (plVal: ^Longint);
      VT_BYREF or VT_R4:       (pfltVal: ^Single);
      VT_BYREF or VT_R8:       (pdblVal: ^Double);
      VT_BYREF or VT_BOOL:     (pbool: ^BOOL);
      VT_BYREF or VT_ERROR:    (pscode: ^SCODE);
      VT_BYREF or VT_CY:       (pcyVal: ^CY);
      VT_BYREF or VT_DATE:     (pdate: ^DATE);
      VT_BYREF or VT_BSTR:     (pbstrVal: ^BSTR);
      VT_BYREF or VT_UNKNOWN:  (ppunkVal: ^IUnknown);
      VT_BYREF or VT_DISPATCH: (ppdispVal: ^IDispatch);
      VT_BYREF or VT_ARRAY:    (pparray: ^PSAFEARRAY);
      VT_BYREF or VT_VARIANT:  (pvarVal: PVARIANT);
      VT_BYREF:                (byRef: Pointer);
  end;

  VARIANTARG = VARIANT;
  PVARIANTARG = PVARIANT;

  LCID = Longint;

{ ITypeLib }

  DISPID = Longint;
  MEMBERID = DISPID;

  PTLIBATTR = ^TLIBATTR;
  TLIBATTR = record
    guid: GUID; { globally unique library id }
    lcid: LCID; { locale of the TypeLibrary }
    syskind: Word;
    wMajorVerNum: Word;
    wMinorVerNum: Word;
    wLibFlags: Word;
  end;

  ITypeLib = class(IUnknown)
    function GetTypeInfoCount: Integer; virtual; cdecl; export; abstract;
    function GetTypeInfo(index: Integer; var pptinfo: ITypeInfo): HResult; virtual; cdecl; export; abstract;
    function GetTypeInfoType(index: Integer; var ptypekind: Word): HResult;
      virtual; cdecl; export; abstract;
    function GetTypeInfoOfGuid(const guid: IID; var pptinfo: ITypeInfo): HResult;
      virtual; cdecl; export; abstract;
    function GetLibAttr(var pptlibattr: PTLIBATTR): HResult; virtual; cdecl; export; abstract;
    function GetTypeComp(var pptcomp: ITypeComp): HResult; virtual; cdecl; export; abstract;
    function GetDocumentation(index: Integer; var pbstrName: BSTR;
      var pbstrDocString: BSTR; var pdwHelpContext: Longint;
      var pbstrHelpFile: BSTR): HResult; virtual; cdecl; export; abstract;
    function IsName(szNameBuf: PChar; lHashVal: Longint; var lpfName: Integer): HResult;
      virtual; cdecl; export; abstract;
    function FindName(szNameBuf: PChar; lHashVal: Longint; var rgptinfo: ITypeInfo;
      var rgmemid: MEMBERID; var pcFound: Word): HResult; virtual; cdecl; export; abstract;
    procedure ReleaseTLibAttr(ptlibattr: PTLIBATTR); virtual; cdecl; export; abstract;
  end;

{ ITypeInfo }

  HREFTYPE = Longint;

  PARRAYDESC = ^ARRAYDESC;

  PTYPEDESC = ^TYPEDESC;
  TYPEDESC = record
    case Integer of
      VT_PTR:         (ptdesc: PTYPEDESC; vt: VARTYPE);
      VT_CARRAY:      (padesc: PARRAYDESC);
      VT_USERDEFINED: (hreftype: HREFTYPE);
  end;

  ARRAYDESC = record
    tdescElem: TYPEDESC;                     { element type }
    cDims: Word;                             { dimension count }
    rgbounds: array[0..0] of SAFEARRAYBOUND; { variable length array of bounds }
  end;

  PIDLDESC = ^IDLDESC;
  IDLDESC = record
    bstrIDLInfo: BSTR; { reserved, but original name retained for compatibilty }
    wIDLFlags: Word;   { IN, OUT, etc }
  end;

  PELEMDESC = ^ELEMDESC;
  ELEMDESC = record
    tdesc: TYPEDESC;  { the type of the element }
    idldesc: IDLDESC; { info for remoting the element }
  end;

  PTYPEATTR = ^TYPEATTR;
  TYPEATTR = record
    guid: GUID;                 { the GUID of the TypeInfo }
    lcid: LCID;                 { locale of member names and doc strings }
    dwReserved: Longint;
    memidConstructor: MEMBERID; { ID of constructor, MEMBERID_NIL if none }
    memidDestructor: MEMBERID;  { ID of destructor, MEMBERID_NIL if none }
    lpstrSchema: PChar;         { reserved for future use }
    cbSizeInstance: Longint;    { the size of an instance of this type }
    typekind: Word;             { the kind of type this typeinfo describes }
    cFuncs: Word;               { number of functions }
    cVars: Word;                { number of variables / data members }
    cImplTypes: Word;           { number of implemented interfaces }
    cbSizeVft: Word;            { the size of this types virtual func table }
    cbAlignment: Word;          { the alignment for an instance of this type }
    wTypeFlags: Word;
    wMajorVerNum: Word;         { major version number }
    wMinorVerNum: Word;         { minor version number }
    tdescAlias: TYPEDESC;       { if typekind == TKIND_ALIAS this specifies
                                  the type for which this type is an alias }
    idldescType: IDLDESC;       { IDL attributes of the described type }
  end;

  PDISPPARAMS = ^DISPPARAMS;
  DISPPARAMS = record
    rgvarg: PVARIANTARG;
    rgdispidNamedArgs: ^DISPID;
    cArgs: Word;
    cNamedArgs: Word;
  end;

  PEXEPINFO = ^EXCEPINFO;

  TFNDeferredFillIn = function(ExInfo: PEXEPINFO): HResult;

  EXCEPINFO = record
    { An error code describing the error. Either (but not both) the
      wCode or scode fields must be set }
    wCode: Word;
    wReserved: Word;
    { A textual, human readable name of the source of the exception.
      It is up to the IDispatch implementor to fill this in.
      Typically this will be an application name. }
    bstrSource: BSTR;
    { A textual, human readable description of the error.
      If no description is available, NULL should be used. }
    bstrDescription: BSTR;
    { Fully qualified drive, path, and file name of a help file with more
      information about the error.  If no help is available, NULL should
      be used. }
    bstrHelpFile: BSTR;
    { help context of topic within the help file. }
    dwHelpContext: Longint;
    pvReserved: Pointer;
    { Use of this field allows an application to defer filling in
      the bstrDescription, bstrHelpFile, and dwHelpContext fields
      until they are needed.  This field might be used, for example,
      if loading the string for the error is a time-consuming
      operation. If deferred fill-in is not desired, this field should
      be set to NULL. }
    pfnDeferredFillIn: TFNDeferredFillIn;
    { An SCODE describing the error. }
    scode: SCODE;
  end;

  PFUNCDESC = ^FUNCDESC;
  FUNCDESC = record
     memid: MEMBERID;
     lprgscode: ^SCODE;
     lprgelemdescParam: PELEMDESC;  { array of parameter types }
     fkind: Word;
     ikind: Word;
     cconv: Word;
     cParams: Smallint;
     cParamsOpt: Smallint;
     oVft: Smallint;
     cScodes: Smallint;
     elemdescFunc: ELEMDESC;
     wFuncFlags: Word;
  end;

  PVARDESC = ^VARDESC;
  VARDESC = record
    memid: MEMBERID;
    lpstrSchema: PChar;
    case Integer of
      VAR_PERINSTANCE: (
        oInst: Longint;
        elemdescVar: ELEMDESC;
        wVarFlags: Word;
        vk: Word);
      VAR_CONST: (
        lpvarValue: PVARIANT);
  end;

  ITypeInfo = class(IUnknown)
    function GetTypeAttr(var pptypeattr: PTYPEATTR): HResult; virtual; cdecl; export; abstract;
    function GetTypeComp(var pptcomp: ITypeComp): HResult; virtual; cdecl; export; abstract;
    function GetFuncDesc(index: Integer; var ppfuncdesc: PFUNCDESC): HResult;
      virtual; cdecl; export; abstract;
    function GetVarDesc(index: Integer; var ppvardesc: PVARDESC): HResult;
      virtual; cdecl; export; abstract;
    function GetNames(memid: MEMBERID; var rgbstrNames: BSTR; cMaxNames: Integer;
      var pcNames: Integer): HResult; virtual; cdecl; export; abstract;
    function GetRefTypeOfImplType(index: Integer; var phreftype: HREFTYPE): HResult;
      virtual; cdecl; export; abstract;
    function GetImplTypeFlags(index: Integer; var pimpltypeflags: Integer): HResult;
      virtual; cdecl; export; abstract;
    function GetIDsOfNames(var rgszNames: PChar; cNames: Integer;
      var rgmemid: MEMBERID): HResult; virtual; cdecl; export; abstract;
    function Invoke(pvInstance: Pointer; memid: MEMBERID; wFlags: Word;
      var pdispparams: DISPPARAMS; var pvarResult: VARIANT;
      var pexcepinfo: EXCEPINFO; var puArgErr: Integer): HResult; virtual; cdecl; export; abstract;
    function GetDocumentation(memid: MEMBERID; var pbstrName: BSTR;
      var pbstrDocString: BSTR; var pdwHelpContext: Longint;
      var pbstrHelpFile: BSTR): HResult; virtual; cdecl; export; abstract;
    function GetDllEntry(memid: MEMBERID; invkind: Word;
      var pbstrDllName: BSTR; var pbstrName: BSTR; var pwOrdinal: Word): HResult;
      virtual; cdecl; export; abstract;
    function GetRefTypeInfo(hreftype: HREFTYPE; var pptinfo: ITypeInfo): HResult;
      virtual; cdecl; export; abstract;
    function AddressOfMember(memid: MEMBERID; invkind: Word;
      var ppv: Pointer): HResult; virtual; cdecl; export; abstract;
    function CreateInstance(punkOuter: IUnknown; const riid: IID;
      var ppvObj: Pointer): HResult; virtual; cdecl; export; abstract;
    function GetMops(memid: MEMBERID; var pbstrMops: BSTR): HResult;
      virtual; cdecl; export; abstract;
    function GetContainingTypeLib(var pptlib: ITypeLib; var pindex: Integer): HResult;
      virtual; cdecl; export; abstract;
    procedure ReleaseTypeAttr(ptypeattr: PTYPEATTR); virtual; cdecl; export; abstract;
    procedure ReleaseFuncDesc(pfuncdesc: PFUNCDESC); virtual; cdecl; export; abstract;
    procedure ReleaseVarDesc(pvardesc: PVARDESC); virtual; cdecl; export; abstract;
  end;

{ ITypeComp }

  BINDPTR = record
    case Integer of
      1: (lpfuncdesc: PFUNCDESC);
      2: (lpvardesc: PVARDESC);
      3: (lptcomp: ITypeComp);
  end;

{ ITypeComp methods }

  ITypeComp = class(IUnknown)
    function Bind(szName: PChar; lHashVal: Longint; wflags: Word;
      var pptinfo: ITypeInfo; var pdesckind: Word;
      var pbindptr: BINDPTR): HResult; virtual; cdecl; export; abstract;
    function BindType(szName: PChar; lHashVal: Longint; var pptinfo: ITypeInfo;
      var pptcomp: ITypeComp): HResult; virtual; cdecl; export; abstract;
  end;

{ ICreateTypeLib }

  ICreateTypeInfo = class;
  ICreateTypeLib = class(IUnknown)
    function CreateTypeInfo(szName: PChar; tkind: Word;
      var lplpictinfo: ICreateTypeInfo): HResult; virtual; cdecl; export; abstract;
    function SetName(szName: PChar): HResult; virtual; cdecl; export; abstract;
    function SetVersion(wMajorVerNum: Word; wMinorVerNum: Word): HResult; virtual; cdecl; export; abstract;
    function SetGuid(const guid: IID): HResult; virtual; cdecl; export; abstract;
    function SetDocString(szDoc: PChar): HResult; virtual; cdecl; export; abstract;
    function SetHelpFileName(szHelpFileName: PChar): HResult; virtual; cdecl; export; abstract;
    function SetHelpContext(dwHelpContext: Longint): HResult; virtual; cdecl; export; abstract;
    function SetLcid(lcid: LCID): HResult; virtual; cdecl; export; abstract;
    function SetLibFlags(uLibFlags: Integer): HResult; virtual; cdecl; export; abstract;
    function SaveAllChanges: HResult; virtual; cdecl; export; abstract;
  end;

{ ICreateTypeInfo }

  ICreateTypeInfo = class(IUnknown)
    function SetGuid(const guid: IID): HResult; virtual; cdecl; export; abstract;
    function SetTypeFlags(uTypeFlags: Integer): HResult; virtual; cdecl; export; abstract;
    function SetDocString(pstrDoc: PChar): HResult; virtual; cdecl; export; abstract;
    function SetHelpContext(dwHelpContext: Longint): HResult; virtual; cdecl; export; abstract;
    function SetVersion(wMajorVerNum: Word; wMinorVerNum: Word): HResult;
      virtual; cdecl; export; abstract;
    function AddRefTypeInfo(ptinfo: ITypeInfo; var phreftype: HREFTYPE): HResult;
      virtual; cdecl; export; abstract;
    function AddFuncDesc(index: Integer; var pfuncdesc: FUNCDESC): HResult;
      virtual; cdecl; export; abstract;
    function AddImplType(index: Integer; hreftype: HREFTYPE): HResult;
      virtual; cdecl; export; abstract;
    function SetImplTypeFlags(index: Integer; impltypeflags: Integer): HResult;
      virtual; cdecl; export; abstract;
    function SetAlignment(cbAlignment: Word): HResult; virtual; cdecl; export; abstract;
    function SetSchema(lpstrSchema: PChar): HResult; virtual; cdecl; export; abstract;
    function AddVarDesc(index: Integer; var pvardesc: VARDESC): HResult;
      virtual; cdecl; export; abstract;
    function SetFuncAndParamNames(index: Integer; var rgszNames: PChar;
      cNames: Integer): HResult; virtual; cdecl; export; abstract;
    function SetVarName(index: Integer; szName: PChar): HResult; virtual; cdecl; export; abstract;
    function SetTypeDescAlias(var ptdescAlias: TYPEDESC): HResult; virtual; cdecl; export; abstract;
    function DefineFuncAsDllEntry(index: Integer; szDllName: PChar;
      szProcName: PChar): HResult; virtual; cdecl; export; abstract;
    function SetFuncDocString(index: Integer; szDocString: PChar): HResult;
      virtual; cdecl; export; abstract;
    function SetVarDocString(index: Integer; szDocString: PChar): HResult;
      virtual; cdecl; export; abstract;
    function SetFuncHelpContext(index: Integer; dwHelpContext: Longint): HResult;
      virtual; cdecl; export; abstract;
    function SetVarHelpContext(index: Integer; dwHelpContext: Longint): HResult;
      virtual; cdecl; export; abstract;
    function SetMops(index: Integer; bstrMops: BSTR): HResult; virtual; cdecl; export; abstract;
    function SetTypeIdldesc(var pidldesc: IDLDESC): HResult; virtual; cdecl; export; abstract;
    function LayOut: HResult; virtual; cdecl; export; abstract;
  end;

{ IEnumVARIANT }

  IEnumVARIANT = class(IUnknown)
    function Next(celt: Longint; var rgvar: VARIANT;
      var pceltFetched: Longint): HResult; virtual; cdecl; export; abstract;
    function Skip(celt: Longint): HResult; virtual; cdecl; export; abstract;
    function Reset: HResult; virtual; cdecl; export; abstract;
    function Clone(var ppenum: IEnumVARIANT): HResult; virtual; cdecl; export; abstract;
  end;

{ IDispatch }

  IDispatch = class(IUnknown)
    function GetTypeInfoCount(var pctinfo: Integer): HResult; virtual; cdecl; export; abstract;
    function GetTypeInfo(itinfo: Integer; lcid: LCID; var pptinfo: ITypeInfo): HResult; virtual; cdecl; export; abstract;
    function GetIDsOfNames(const riid: IID; var rgszNames: PChar;
      cNames: Integer; lcid: LCID; var rgdispid: DISPID): HResult; virtual; cdecl; export; abstract;
    function Invoke(dispidMember: DISPID; const riid: IID; lcid: LCID;
      wFlags: Word; var pdispparams: DISPPARAMS; var pvarResult: VARIANT;
      var pexcepinfo: EXCEPINFO; var puArgErr: Integer): HResult; virtual; cdecl; export; abstract;
  end;

{ IErrorInfo }

  IErrorInfo = class(IUnknown)
    function GetGUID(var pguid: GUID): HResult; virtual; cdecl; export; abstract;
    function GetSource(var pbstrSource: BSTR): HResult; virtual; cdecl; export; abstract;
    function GetDescription(var pbstrDescription: BSTR): HResult; virtual; cdecl; export; abstract;
    function GetHelpFile(var pbstrHelpFile: BSTR): HResult; virtual; cdecl; export; abstract;
    function GetHelpContext(var pdwHelpContext: Longint): HResult; virtual; cdecl; export; abstract;
  end;

{ ICreateErrorInfo methods }

  ICreateErrorInfo = class(IUnknown)
    function SetGUID(const rguid: IID): HResult; virtual; cdecl; export; abstract;
    function SetSource(szSource: PChar): HResult; virtual; cdecl; export; abstract;
    function SetDescription(szDescription: PChar): HResult; virtual; cdecl; export; abstract;
    function SetHelpFile(szHelpFile: PChar): HResult; virtual; cdecl; export; abstract;
    function SetHelpContext(dwHelpContext: Longint): HResult; virtual; cdecl; export; abstract;
  end;

{ ISupportErrorInfo methods }

  ISupportErrorInfo = class(IUnknown)
    function InterfaceSupportsErrorInfo(const riid: IID): HResult; virtual; cdecl; export; abstract;
  end;

{ IDispatch implementation support }

  PPARAMDATA = ^PARAMDATA;
  PARAMDATA = record
    szName: PChar; { parameter name }
    vt: VARTYPE; { parameter type }
  end;

  PMETHODDATA = ^METHODDATA;
  METHODDATA = record
    szName: PChar; { method name }
    ppdata: PPARAMDATA; { pointer to an array of PARAMDATAs }
    dispid: DISPID; { method ID }
    iMeth: Integer; { method index }
    cc: Word; { calling convention }
    cArgs: Integer; { count of arguments }
    wFlags: Word; { same wFlags as on IDispatch::Invoke() }
    vtReturn: VARTYPE;
  end;

  PINTERFACEDATA = ^INTERFACEDATA;
  INTERFACEDATA = record
    pmethdata: PMETHODDATA; { pointer to an array of METHODDATAs }
    cMembers: Integer; { count of members }
  end;

{ IIDs }

function IID_IDispatch: GUID;
function IID_ITypeInfo: GUID;
function PIID_IDispatch: REFGUID;
function PIID_ITypeInfo: REFGUID;

{ BSTR API }

function SysAllocString(const p1: PChar): BSTR;
function SysReAllocString(var p1: BSTR; const p2: PChar): Integer;
function SysAllocStringLen(const p1: PChar; p2: Cardinal): BSTR;
function SysReAllocStringLen(var p1: BSTR; const p2: PChar; p3: Cardinal): Integer;
procedure SysFreeString(bstr: BSTR);
function SysStringLen(p1: BSTR): Cardinal;

{$IFDEF WIN32}
function SysStringByteLen(p1: BSTR): Word;
function SysAllocStringByteLen(psz: PChar; len: Word): BSTR;
{$ENDIF}

{ Time API }

function DosDateTimeToVariantTime(wDosDate, wDosTime: Word; var pvtime: DATE): Integer;
function VariantTimeToDosDateTime(vtime: DATE; var pwDosDate, pwDosTime: Word): Integer;

{ SafeArray API }

function SafeArrayAllocDescriptor(cDims: Cardinal; var ppsaOut: PSAFEARRAY): HResult;
function SafeArrayAllocData(psa: PSAFEARRAY): HResult;
function SafeArrayCreate(vt: VARTYPE; cDims: Cardinal; rgsabound: PSAFEARRAYBOUND): PSAFEARRAY;
function SafeArrayDestroyDescriptor(psa: PSAFEARRAY): HResult;
function SafeArrayDestroyData(psa: PSAFEARRAY): HResult;
function SafeArrayDestroy(psa: PSAFEARRAY): HResult;
function SafeArrayRedim(psa: PSAFEARRAY; psaboundNew: PSAFEARRAYBOUND): HResult;
function SafeArrayGetDim(psa: PSAFEARRAY): Cardinal;
function SafeArrayGetElemsize(psa: PSAFEARRAY): Cardinal;
function SafeArrayGetUBound(psa: PSAFEARRAY; nDim: Cardinal; var plUbound: Longint): HResult;
function SafeArrayGetLBound(psa: PSAFEARRAY; nDim: Cardinal; var plLbound: Longint): HResult;
function SafeArrayLock(psa: PSAFEARRAY): HResult;
function SafeArrayUnlock(psa: PSAFEARRAY): HResult;
function SafeArrayAccessData(psa: PSAFEARRAY; var ppvData: Pointer): HResult;
function SafeArrayUnaccessData(psa: PSAFEARRAY): HResult;
function SafeArrayGetElement(psa: PSAFEARRAY; var rgIndices; var pv): HResult;
function SafeArrayPutElement(psa: PSAFEARRAY; var rgIndices; var pv): HResult;
function SafeArrayCopy(psa: PSAFEARRAY; var ppsaOut: PSAFEARRAY): HResult;
function SafeArrayPtrOfIndex(psa: PSAFEARRAY; var rgIndices; var ppvData: Pointer): HResult;

{ VARIANT API }

procedure VariantInit(var pvarg: VARIANTARG);
function VariantClear(var pvarg: VARIANTARG): HResult;
function VariantCopy(var pvargDest, pvargSrc: VARIANTARG): HResult;
function VariantCopyInd(var pvarDest: VARIANT; var pvargSrc: VARIANTARG): HResult;
function VariantChangeType(var pvargDest: VARIANTARG; var pvarSrc: VARIANTARG;
  wFlags: Word; vt: VARTYPE): HResult;
function VariantChangeTypeEx(var pvargDest, pvarSrc: VARIANTARG; lcid: LCID;
  wFlags: Word; vt: VARTYPE): HResult;

{ VARTYPE Coercion API }

{ Note: The routines that convert from a string are defined
  to take a OLECHAR rather than a BSTR because no allocation is
  required, and this makes the routines a bit more generic.
  They may of course still be passed a BSTR as the strIn param. }

{ Any of the coersion functions that converts either from or to a string
  takes an additional lcid and dwFlags arguments. The lcid argument allows
  locale specific parsing to occur.  The dwFlags allow additional function
  specific condition to occur.  All function that accept the dwFlags argument
  can include either 0 or LOCALE_NOUSEROVERRIDE flag. In addition, the
  VarDateFromStr functions also accepts the VAR_TIMEVALUEONLY and
  VAR_DATEVALUEONLY flags }

function VarUI1FromI2(sIn: Smallint; var pbOut: Byte): HResult;
function VarUI1FromI4(lIn: Longint; var pbOut: Byte): HResult;
function VarUI1FromR4(fltIn: Single; var pbOut: Byte): HResult;
function VarUI1FromR8(dblIn: Double; var pbOut: Byte): HResult;
function VarUI1FromCy(cyIn: CY; var pbOut: Byte): HResult;
function VarUI1FromDate(dateIn: DATE; var pbOut: Byte): HResult;
function VarUI1FromStr(strIn: BSTR; lcid: LCID; dwFlags: Longint; var pbOut: Byte): HResult;
function VarUI1FromDisp(pdispIn: IDispatch; lcid: LCID; var pbOut: Byte): HResult;
function VarUI1FromBool(boolIn: VARIANT_BOOL; var pbOut: Byte): HResult;

function VarI2FromUI1(bIn: Byte; var psOut: Smallint): HResult;
function VarI2FromI4(lIn: Longint; var psOut: Smallint): HResult;
function VarI2FromR4(fltIn: Single; var psOut: Smallint): HResult;
function VarI2FromR8(dblIn: Double; var psOut: Smallint): HResult;
function VarI2FromCy(cyIn: CY; var psOut: Smallint): HResult;
function VarI2FromDate(dateIn: DATE; var psOut: Smallint): HResult;
function VarI2FromStr(strIn: BSTR; lcid: LCID; dwFlags: Longint; var psOut: Smallint): HResult;
function VarI2FromDisp(pdispIn: IDispatch; lcid: LCID; var psOut: Smallint): HResult;
function VarI2FromBool(boolIn: VARIANT_BOOL; var psOut: Smallint): HResult;

function VarI4FromUI1(bIn: Byte; var plOut: Longint): HResult;
function VarI4FromI2(sIn: Smallint; var plOut: Longint): HResult;
function VarI4FromR4(fltIn: Single; var plOut: Longint): HResult;
function VarI4FromR8(dblIn: Double; var plOut: Longint): HResult;
function VarI4FromCy(cyIn: CY; var plOut: Longint): HResult;
function VarI4FromDate(dateIn: DATE; var plOut: Longint): HResult;
function VarI4FromStr(strIn: BSTR; lcid: LCID; dwFlags: Longint; var plOut: Longint): HResult;
function VarI4FromDisp(pdispIn: IDispatch; lcid: LCID; var plOut: Longint): HResult;
function VarI4FromBool(boolIn: VARIANT_BOOL; var plOut: Longint): HResult;

function VarR4FromUI1(bIn: Byte; var pfltOut: Single): HResult;
function VarR4FromI2(sIn: Smallint; var pfltOut: Single): HResult;
function VarR4FromI4(lIn: Longint; var pfltOut: Single): HResult;
function VarR4FromR8(dblIn: Double; var pfltOut: Single): HResult;
function VarR4FromCy(cyIn: CY; var pfltOut: Single): HResult;
function VarR4FromDate(dateIn: DATE; var pfltOut: Single): HResult;
function VarR4FromStr(strIn: BSTR; lcid: LCID; dwFlags: Longint; var pfltOut: Single): HResult;
function VarR4FromDisp(pdispIn: IDispatch; lcid: LCID; var pfltOut: Single): HResult;
function VarR4FromBool(boolIn: VARIANT_BOOL; var pfltOut: Single): HResult;

function VarR8FromUI1(bIn: Byte; var pdblOut: Double): HResult;
function VarR8FromI2(sIn: Smallint; var pdblOut: Double): HResult;
function VarR8FromI4(lIn: Longint; var pdblOut: Double): HResult;
function VarR8FromR4(fltIn: Single; var pdblOut: Double): HResult;
function VarR8FromCy(cyIn: CY; var pdblOut: Double): HResult;
function VarR8FromDate(dateIn: DATE; var pdblOut: Double): HResult;
function VarR8FromStr(strIn: BSTR; lcid: LCID; dwFlags: Longint; var pdblOut: Double): HResult;
function VarR8FromDisp(pdispIn: IDispatch; lcid: LCID; var pdblOut: Double): HResult;
function VarR8FromBool(boolIn: VARIANT_BOOL; var pdblOut: Double): HResult;

function VarDateFromUI1(bIn: Byte; var pdateOut: DATE): HResult;
function VarDateFromI2(sIn: Smallint; var pdateOut: DATE): HResult;
function VarDateFromI4(lIn: Longint; var pdateOut: DATE): HResult;
function VarDateFromR4(fltIn: Single; var pdateOut: DATE): HResult;
function VarDateFromR8(dblIn: Double; var pdateOut: DATE): HResult;
function VarDateFromCy(cyIn: CY; var pdateOut: DATE): HResult;
function VarDateFromStr(strIn: BSTR; lcid: LCID; dwFlags: Longint; var pdateOut: DATE): HResult;
function VarDateFromDisp(pdispIn: IDispatch; lcid: LCID; var pdateOut: DATE): HResult;
function VarDateFromBool(boolIn: VARIANT_BOOL; var pdateOut: DATE): HResult;

function VarCyFromUI1(bIn: Byte; var pcyOut: CY): HResult;
function VarCyFromI2(sIn: Smallint; var pcyOut: CY): HResult;
function VarCyFromI4(lIn: Longint; var pcyOut: CY): HResult;
function VarCyFromR4(fltIn: Single; var pcyOut: CY): HResult;
function VarCyFromR8(dblIn: Double; var pcyOut: CY): HResult;
function VarCyFromDate(dateIn: DATE; var pcyOut: CY): HResult;
function VarCyFromStr(strIn: BSTR; lcid: LCID; dwFlags: Longint; var pcyOut: CY): HResult;
function VarCyFromDisp(pdispIn: IDispatch; lcid: LCID; var pcyOut: CY): HResult;
function VarCyFromBool(boolIn: VARIANT_BOOL; var pcyOut: CY): HResult;

function VarBstrFromUI1(bVal: Byte; lcid: LCID; dwFlags: Longint; var pbstrOut: BSTR): HResult;
function VarBstrFromI2(iVal: Smallint; lcid: LCID; dwFlags: Longint; var pbstrOut: BSTR): HResult;
function VarBstrFromI4(lIn: Longint; lcid: LCID; dwFlags: Longint; var pbstrOut: BSTR): HResult;
function VarBstrFromR4(fltIn: Single; lcid: LCID; dwFlags: Longint; var pbstrOut: BSTR): HResult;
function VarBstrFromR8(dblIn: Double; lcid: LCID; dwFlags: Longint; var pbstrOut: BSTR): HResult;
function VarBstrFromCy(cyIn: CY; lcid: LCID; dwFlags: Longint; var pbstrOut: BSTR): HResult;
function VarBstrFromDate(dateIn: DATE; lcid: LCID; dwFlags: Longint; var pbstrOut: BSTR): HResult;
function VarBstrFromDisp(pdispIn: IDispatch; lcid: LCID; dwFlags: Longint; var pbstrOut: BSTR): HResult;
function VarBstrFromBool(boolIn: VARIANT_BOOL; lcid: LCID; dwFlags: Longint; var pbstrOut: BSTR): HResult;

function VarBoolFromUI1(bIn: Byte; var pboolOut: VARIANT_BOOL): HResult;
function VarBoolFromI2(sIn: Smallint; var pboolOut: VARIANT_BOOL): HResult;
function VarBoolFromI4(lIn: Longint; var pboolOut: VARIANT_BOOL): HResult;
function VarBoolFromR4(fltIn: Single; var pboolOut: VARIANT_BOOL): HResult;
function VarBoolFromR8(dblIn: Double; var pboolOut: VARIANT_BOOL): HResult;
function VarBoolFromDate(dateIn: DATE; var pboolOut: VARIANT_BOOL): HResult;
function VarBoolFromCy(cyIn: CY; var pboolOut: VARIANT_BOOL): HResult;
function VarBoolFromStr(strIn: BSTR; lcid: LCID; dwFlags: Longint; var pboolOut: VARIANT_BOOL): HResult;
function VarBoolFromDisp(pdispIn: IDispatch; lcid: LCID; var pboolOut: VARIANT_BOOL): HResult;

{ TypeInfo APIs }

{ compute a 32bit hash value for the given name  based on the lcid and system kind }
{ Macro to compute a 32bit hash value for the given name based on the LCID }
function LHashValOfName(lcid: LCID; const szName: PChar): Longint;

{ compute a 16bit hash value from 32 bit hash value }
function WHashValOfLHashVal(lhashval: LongInt): Word;

{ Check if the hash values are compatible. }
function IsHashValCompatible(lhashval1: LongInt; lhashval2: LongInt): Boolean;


function LHashValOfNameSys(syskind: Word; lcid: LCID; const szName: PChar): Longint;
function LoadTypeLib(const szFile: PChar; var pptlib: ITypeLib): HResult;
function LoadRegTypeLib(const rguid: IID; wVerMajor: Word; wVerMinor: Word;
  lcid: LCID; var pptlib: ITypeLib): HResult;
function QueryPathOfRegTypeLib(const guid: IID; wMaj: Word; wMin: Word; lcid: LCID;
  var lpbstrPathName: BSTR): HResult;
function RegisterTypeLib(ptlib: ITypeLib; szFullPath, szHelpDir: PChar): HResult;
function CreateTypeLib(syskind: Word; const szFile: PChar; var ppctlib: ICreateTypeLib): HResult;

{ ISupportErrorInfo methods }
function SetErrorInfo(dwReserved: Longint; perrinfo: IErrorInfo): HResult;
function GetErrorInfo(dwReserved: Longint; var pperrinfo: IErrorInfo): HResult;
function CreateErrorInfo(var pperrinfo: ICreateErrorInfo): HResult;

{ IDispatch implementation support }
function DispGetParam(var pdispparams: DISPPARAMS; position: Integer; vtTarg:
  VARTYPE; var pvarResult: VARIANT; var puArgErr: Integer): HResult;
function DispGetIDsOfNames(ptinfo: ITypeInfo; var rgszNames: PChar;
  cNames: Integer; var rgdispid: DISPID): HResult;
function DispInvoke(_this: Pointer; ptinfo: ITypeInfo; dispidMember: DISPID;
  wFlags: Word; var pparams: DISPPARAMS; var pvarResult: VARIANT;
  var pexcepinfo: EXCEPINFO; var puArgErr: Integer): HResult;
function CreateDispTypeInfo(var pidata: INTERFACEDATA; lcid: LCID;
  var pptinfo: ITypeInfo): HResult;
function CreateStdDispatch(var punkOuter: IUnknown; pvThis: Pointer;
  ptinfo: ITypeInfo; var ppunkStdDisp: IUnknown): HResult;

{ Active Object Registration API }

function RegisterActiveObject(punk: IUnknown; const rclsid: IID;
  dwFlags: Longint; var pdwRegister: Longint): HResult;
function RevokeActiveObject(dwRegister: Longint; pvReserved: HResult): HResult;
function GetActiveObject(const rclsid: IID; pvReserved: HResult; var ppunk: IUnknown): HResult;

{ MISC API }

function OaBuildVersion: Longint;

implementation

function SysAllocString; external 'ole2disp';
function SysReAllocString; external 'ole2disp';
function SysAllocStringLen; external 'ole2disp';
function SysReAllocStringLen; external 'ole2disp';
procedure SysFreeString; external 'ole2disp';
function SysStringLen; external 'ole2disp';

function DosDateTimeToVariantTime; external 'ole2disp';
function VariantTimeToDosDateTime; external 'ole2disp';

function SafeArrayAllocDescriptor; external 'ole2disp';
function SafeArrayAllocData; external 'ole2disp';
function SafeArrayCreate; external 'ole2disp';
function SafeArrayDestroyDescriptor; external 'ole2disp';
function SafeArrayDestroyData; external 'ole2disp';
function SafeArrayDestroy; external 'ole2disp';
function SafeArrayRedim; external 'ole2disp';
function SafeArrayGetDim; external 'ole2disp';
function SafeArrayGetElemsize; external 'ole2disp';
function SafeArrayGetUBound; external 'ole2disp';
function SafeArrayGetLBound; external 'ole2disp';
function SafeArrayLock; external 'ole2disp';
function SafeArrayUnlock; external 'ole2disp';
function SafeArrayAccessData; external 'ole2disp';
function SafeArrayUnaccessData; external 'ole2disp';
function SafeArrayGetElement; external 'ole2disp';
function SafeArrayPutElement; external 'ole2disp';
function SafeArrayCopy; external 'ole2disp';
function SafeArrayPtrOfIndex; external 'ole2disp';

procedure VariantInit; external 'ole2disp';
function VariantClear; external 'ole2disp';
function VariantCopy; external 'ole2disp';
function VariantCopyInd; external 'ole2disp';
function VariantChangeType; external 'ole2disp';
function VariantChangeTypeEx; external 'ole2disp';

function VarUI1FromI2; external 'ole2disp';
function VarUI1FromI4; external 'ole2disp';
function VarUI1FromR4; external 'ole2disp';
function VarUI1FromR8; external 'ole2disp';
function VarUI1FromCy; external 'ole2disp';
function VarUI1FromDate; external 'ole2disp';
function VarUI1FromStr; external 'ole2disp';
function VarUI1FromDisp; external 'ole2disp';
function VarUI1FromBool; external 'ole2disp';
function VarI2FromUI1; external 'ole2disp';
function VarI2FromI4; external 'ole2disp';
function VarI2FromR4; external 'ole2disp';
function VarI2FromR8; external 'ole2disp';
function VarI2FromCy; external 'ole2disp';
function VarI2FromDate; external 'ole2disp';
function VarI2FromStr; external 'ole2disp';
function VarI2FromDisp; external 'ole2disp';
function VarI2FromBool; external 'ole2disp';
function VarI4FromUI1; external 'ole2disp';
function VarI4FromI2; external 'ole2disp';
function VarI4FromR4; external 'ole2disp';
function VarI4FromR8; external 'ole2disp';
function VarI4FromCy; external 'ole2disp';
function VarI4FromDate; external 'ole2disp';
function VarI4FromStr; external 'ole2disp';
function VarI4FromDisp; external 'ole2disp';
function VarI4FromBool; external 'ole2disp';
function VarR4FromUI1; external 'ole2disp';
function VarR4FromI2; external 'ole2disp';
function VarR4FromI4; external 'ole2disp';
function VarR4FromR8; external 'ole2disp';
function VarR4FromCy; external 'ole2disp';
function VarR4FromDate; external 'ole2disp';
function VarR4FromStr; external 'ole2disp';
function VarR4FromDisp; external 'ole2disp';
function VarR4FromBool; external 'ole2disp';
function VarR8FromUI1; external 'ole2disp';
function VarR8FromI2; external 'ole2disp';
function VarR8FromI4; external 'ole2disp';
function VarR8FromR4; external 'ole2disp';
function VarR8FromCy; external 'ole2disp';
function VarR8FromDate; external 'ole2disp';
function VarR8FromStr; external 'ole2disp';
function VarR8FromDisp; external 'ole2disp';
function VarR8FromBool; external 'ole2disp';
function VarDateFromUI1; external 'ole2disp';
function VarDateFromI2; external 'ole2disp';
function VarDateFromI4; external 'ole2disp';
function VarDateFromR4; external 'ole2disp';
function VarDateFromR8; external 'ole2disp';
function VarDateFromCy; external 'ole2disp';
function VarDateFromStr; external 'ole2disp';
function VarDateFromDisp; external 'ole2disp';
function VarDateFromBool; external 'ole2disp';
function VarCyFromUI1; external 'ole2disp';
function VarCyFromI2; external 'ole2disp';
function VarCyFromI4; external 'ole2disp';
function VarCyFromR4; external 'ole2disp';
function VarCyFromR8; external 'ole2disp';
function VarCyFromDate; external 'ole2disp';
function VarCyFromStr; external 'ole2disp';
function VarCyFromDisp; external 'ole2disp';
function VarCyFromBool; external 'ole2disp';
function VarBstrFromUI1; external 'ole2disp';
function VarBstrFromI2; external 'ole2disp';
function VarBstrFromI4; external 'ole2disp';
function VarBstrFromR4; external 'ole2disp';
function VarBstrFromR8; external 'ole2disp';
function VarBstrFromCy; external 'ole2disp';
function VarBstrFromDate; external 'ole2disp';
function VarBstrFromDisp; external 'ole2disp';
function VarBstrFromBool; external 'ole2disp';
function VarBoolFromUI1; external 'ole2disp';
function VarBoolFromI2; external 'ole2disp';
function VarBoolFromI4; external 'ole2disp';
function VarBoolFromR4; external 'ole2disp';
function VarBoolFromR8; external 'ole2disp';
function VarBoolFromDate; external 'ole2disp';
function VarBoolFromCy; external 'ole2disp';
function VarBoolFromStr; external 'ole2disp';
function VarBoolFromDisp; external 'ole2disp';

function LHashValOfNameSys; external 'ole2disp';
function LoadTypeLib; external 'ole2disp';
function LoadRegTypeLib; external 'ole2disp';
function QueryPathOfRegTypeLib; external 'ole2disp';
function RegisterTypeLib; external 'ole2disp';
function CreateTypeLib; external 'ole2disp';
function SetErrorInfo; external 'ole2disp';
function GetErrorInfo; external 'ole2disp';
function CreateErrorInfo; external 'ole2disp';
function DispGetParam; external 'ole2disp';
function DispGetIDsOfNames; external 'ole2disp';
function DispInvoke; external 'ole2disp';
function CreateDispTypeInfo; external 'ole2disp';
function CreateStdDispatch; external 'ole2disp';

function RegisterActiveObject; external 'ole2disp';
function RevokeActiveObject; external 'ole2disp';
function GetActiveObject; external 'ole2disp';

function OaBuildVersion; external 'ole2disp';

function LHashValOfName(lcid: LCID; const szName: PChar): Longint;
begin
  Result := LHashValOfNameSys(SYS_WIN32, lcid, szName);
end;

function WHashValOfLHashVal(lhashval: LongInt): Word;
begin
  Result := $ffff and (lhashval);
end;

function IsHashValCompatible(lhashval1: LongInt; lhashval2: LongInt): Boolean;
begin
  Result := ($00ff0000 and (lhashval1)) = ($00ff0000 and (lhashval2));
end;

{ IIDs }

procedure _IID_IDispatch; far; external 'ole2disp';
procedure _IID_ITypeInfo; far; external 'typelib';

function IID_IDispatch: GUID;
begin
  Result := REFGUID(@_IID_IDispatch)^;
end;

function IID_ITypeInfo: GUID;
begin
  Result := REFGUID(@_IID_ITypeInfo)^;
end;

function PIID_IDispatch: REFGUID;
begin
  Result := REFGUID(@_IID_IDispatch);
end;

function PIID_ITypeInfo: REFGUID;
begin
  Result := REFGUID(@_IID_ITypeInfo);
end;

end.
