/*
*
*	Copyright (c) 1992-94, Coromandel Industries, Inc.
*
*	All rights reserved. No part of this program or publication may be 
*	reproduced, transcribed, stored in a retrieval system, or translated
*	into any language or computer language, in any form or by any means, 
*	electronic, mechanical, magnetic, optical, chemical, biological, or
*	otherwise, without the prior written permission of :
*
*		Coromandel Industries, Inc.
*		70-15, Austin Street, 3rd Floor 
*		Forest Hills, NY 11375, USA.
* 
*
* 
*	System       :	INTEGRA VDB SQL Controls  
*	Module       :	VDB Engine
*	Filename     :	sqcmain.h
*	Description  :	Header file for call interface
*
*/

#if	!defined(_SQCMAIN_H)
#define	_SQCMAIN_H

// Version
#define SQC_VERSION	200		// major version 2.00

// object types

#define	SQC_FORM	100		// the object type is form
#define	SQC_CONTROL	101		// the object type is a child control
#define	SQC_DATASTREAM	102		// the object type is a data source
#define	SQC_CONNECTION	103		// the object type is connection
#define	SQC_ENVIRONMENT	104		// the object type is ODBC henv
#define	SQC_DBPROP	105		// the object type is connection
					// capability mask
#define	SQC_BOUNDCTRL	106		// HWND of bound visual control
#define	SQC_APP		107	

// warning codes

#define WREPLACE	10000		// an object has been replaced

// error codes  


#define ERRBASE		-10000
#define ENORES		ERRBASE - 100	// no resources left
#define BADPARAM	ERRBASE - 200	// illegal argument 
#define ESUBSTI		ERRBASE - 300	// substitution failed 
#define EBADHAND	ERRBASE - 600	// bad app handle
#define EBADWND		ERRBASE - 700	// bad window  handle
#define EBADCTRL	ERRBASE - 900	// bad control handle  
#define EDBERR		ERRBASE -1000	// database error
#define EQUERY		ERRBASE -1200	// error with result columncnt
#define EBADFORM	ERRBASE -1500	// bad form  
#define EBADRANGE	ERRBASE -1600	// bad control 
#define EBADCOL		ERRBASE -1800	// bad column syntax  
#define EBADCURS	ERRBASE -1900	// bad cursor syntax  
#define ESYNTAX		ERRBASE -2100	// bad syntax    
#define EBADBIND 	ERRBASE -2200	// bad bind structure    
#define EBADPORT 	ERRBASE -2300	// bad port name    
#define ESEQERR		ERRBASE -2400	// sequence error
#define EIMPEXP		ERRBASE -2500	// import export error
#define ECURSTATE	ERRBASE -2600	// bad cursor state
#define SS_EOF		ERRBASE -2700	// End of cursor
#define ENOTINST	ERRBASE -2800	// Not installed properly
#define EACCESS		ERRBASE -2900	// Access violation 
#define EINTERR		ERRBASE -3100	// Internal error
#define ENOCOL		ERRBASE -3300	// no column is selected
#define ENORESULT	ERRBASE -3400	// no result set
#define ENOOBJ		ERRBASE -3600	// no object exists
#define ECOLSEQ		ERRBASE -3700	// column sequence error
#define ETRUNC		ERRBASE -3800	// data is truncated
#define ETMPFILE	ERRBASE -3900	// error in temp file of cursor
#define EVALERR		ERRBASE -4100	// Error in expression evaluation
#define EBADNAME	ERRBASE -4200	// Name is not a valid object
#define ETRIG		ERRBASE -4400	// Trigger string error
#define EDATEERR	ERRBASE -4500	// Date format conversion error
#define ECANCEL		ERRBASE -4600	// Cancelled by user
#define EFILTER		ERRBASE -4700	// Filter error
#define SS_EOR		ERRBASE -4800	// End of result set
#define ESORTERR	ERRBASE -4900	// sort errors
#define ELASTERROR	ERRBASE -5000	// Last error


// success codes 

#define	SS_SUCCESS		0

// application mode bits

#define SQC_APP_SHOWERR		1	// display all errors
#define SQC_APP_SHOWSQL		2	// display all sql statements 
#define SQC_APP_SHOWTEXT	4	// show sql statements in text box
#define SQC_APP_LOG		8	// log operations 
#define SQC_APP_DESIGN	 	16	// design mode operations allowed
#define SQC_APP_NOCURSORNAME	32	// don't show cursor name for showsql
#define SQC_APP_NO3rdPARTY	64	// No automatic support for 3rd party
					// controls

// connect modes

#define SQC_CONNECT		3	// use connect
#define SQC_DRVCONNECT		4	// use driver connect

// types of cursors

#define SQC_TABLES		1	// list of tables
#define SQC_COLUMNS		2	// list of columns
#define SQC_SELECT		3	// select statement
#define SQC_GENERIC		4	// generic non select stmt
#define SQC_STATISTICS		5	// list of indexes
#define SQC_SPECIALCOLS		6	// list of special columns
#define SQC_IMPORT		7	// import file
#define SQC_EXPORT		8	// export file
#define SQC_TYPEINFO		9	// sql data type info
#define SQC_MEMORY		10	// memory cursor
#define SQC_LOOKUP		11	// lookup cursor
#define SQC_PROCLIST		12	// Procedure list
#define SQC_PROCEDURE		13	// Procedure 
#define SQC_PASSTHROUGH		14	// Pass through 
#define SQC_PROCCOLS		15	// Procedure columns 


// access modes for cursors

#define SQC_ACC_UPD		1	    // allow updates
#define SQC_ACC_INS		2	    // allow inserts
#define SQC_ACC_DEL		4	    // allow deletes
#define SQC_ACC_MODIFY  	7	    // or of upd,del and ins
#define SQC_ACC_BROWSE		8	    // allow browsing(next and prev)
#define SQC_ACC_QUERY		16	    // allow query from form
#define SQC_ACC_SNAPSHOT 	32	    // set snapshot mode 
#define SQC_ACC_RESERVED 	64	    // must be zero 
#define SQC_ACC_PRIMKEY 	128	    // first col is prim key part 1
#define SQC_ACC_PRIMKEY2 	256	    // second col is prim key part 2
#define SQC_ACC_ENCELLATTRIB	512	    // enable cell level attributes
#define SQC_ACC_KEYSET 		1024	    // only keys are saved in curs
#define SQC_ACC_ENBUTTON	2048	    // enable button enable disable
#define SQC_ACC_AUTO		4096	    // set best accessmode 
#define SQC_ACC_NORUN		(1L << 13)  // no run cursor for modify
#define SQC_ACC_ENSUB		(1L << 14)  // enable substitution
#define SQC_ACC_FETCHALL 	(1L << 16)  // fetch event for all fetches
#define SQC_ACC_INSEVENT 	(1L << 17)  // enable events for insert
#define SQC_ACC_UPDEVENT 	(1L << 18)  // enable events for update
#define SQC_ACC_DELEVENT 	(1L << 19)  // enable events for delete
#define SQC_ACC_FETCHEVENT 	(1L << 20)  // enable events for fetch
#define SQC_ACC_FIELDEVENT 	(1L << 21)  // enable events for field
#define SQC_ACC_ROWSEL 		(1L << 22)  // enable events for row sel
#define SQC_ACC_STATEEVENT	(1L << 23)  // enable events for state
#define	SQC_ACC_CONFUPD		(1L << 28)  // confirm all updates
#define	SQC_ACC_CONFDEL		(1L << 29)  // confirm all deletes
#define	SQC_ACC_CONFINS		(1L << 30)  // confirm all inserts
#define SQC_ACC_MODIFYEVENT 	SQC_ACC_INSEVENT \
				+ SQC_ACC_UPDEVENT \
				+ SQC_ACC_DELEVENT \
				+ SQC_ACC_ROWSEL


// data source and visual control types as indexes

#define SQC_DSI_ODBC		0	//
#define SQC_DSI_CURSORVIEW	1	//

#define SQC_CTI_ThTXB		16 	// thunder text box
#define SQC_CTI_MGRID		17	// thunder grid
#define SQC_CTI_CGRID		18	// CI grid
#define SQC_CTI_CBUTTON		19	//  Button controls 
#define SQC_CTI_LB		20	//  List Box control
#define SQC_CTI_CMB		21	//  Combo Box control
#define SQC_CTI_CHKBOX		22	//  CheckBox control
#define SQC_CTI_RB		23	//  Radio Button Control
#define SQC_CTI_FRAME		24	//  Frame control
#define SQC_CTI_3rdPARTY	25	//  3rd party control


// fetch browse modes	

#define  SQC_CURS_NEXT		0
#define  SQC_CURS_FIRST		1
#define  SQC_CURS_LAST		2
#define  SQC_CURS_PREV		3
#define  SQC_CURS_ABS		4
#define  SQC_CURS_REL		5
#define  SQC_CURS_ALL		6
#define  SQC_CURS_CURR		7

#define  SQC_QRY_AND	 	0	//
#define  SQC_QRY_OR	 	1	//
#define  SQC_QRY_LIKEPOST	2	//
#define  SQC_QRY_LIKEPRE 	4	//
#define  SQC_QRY_EXTERN 	128	// query fields are external

#define SQC_QRY_MASK		135

// mask edit property definitions

#define SQC_MASK_DISABLEMASK    10
#define SQC_MASK_DISPLAYONLY    11

// date formats

#define SQC_DATE_FRDISP		100	// from display format to ISO
#define SQC_DATE_FRDRV		101	// from driver format to ISO
#define SQC_DATE_TODISP		102	// from ISO format to display
#define SQC_DATE_TODRV		103	// from ISO format to driver

//  build data source modes and action codes  	

// flag bits for bind column host flag variable

#define SQC_COL_NULLBIT		1	// if set null value
#define SQC_COL_INSERT		2	// if set insert op
#define SQC_COL_UPDATE		4	// if set update op
#define SQC_COL_DELETE		8	// if set delete op
#define SQC_COL_DATATRUNC	16	// if set data truncated
#define SQC_COL_MARKED		32	// if set row/col is marked
#define SQC_COL_NOMODIFY	64	// if set row can't be modified/deleted


// mode bits for SQcNewRecord Call

#define SQC_NEW_NOINSERT	1	// NewRecord will not automaticall
					// insert the new record


// return values for events

#define	SQC_EVENT_CONTINUE	0	// continue the operation
#define SQC_EVENT_ABORT		9	// abort the operation
#define SQC_EVENT_NEWDATA	2	// continue after accepting new data
#define SQC_EVENT_PRELOAD	3	// cause PREFETCH event before
					// showing the data

// Cursor Event State codes returned for Cursor states

#define SQC_EVENT_OPEN		100	// event occurs before first record
#define SQC_EVENT_CLOSE		101	// event occurs after close
#define SQC_EVENT_LASTREC	102	// event occurs after last record
					// is read from database
#define SQC_EVENT_EXEC		103	// event occurs before execution of
					// preparable statement
#define SQC_EVENT_DESTROY	104	// event occurs before destroy
#define SQC_EVENT_POSTACTION	105	// event occurs before destroy

// Event PREFETCH event flags

#define SQC_FETCH_FIRST		200	// fetching first time from database
#define SQC_FETCH_REFETCH	201	// refetching from database
#define SQC_FETCH_BROWSE	202	// fetching from cursor while browsing

// event constants-- the order must be same as defined in custom control

#define SQC_CURS_ERROR		0
#define SQC_CURS_PREDELETE	1
#define SQC_CURS_PREFETCH	2
#define SQC_CURS_PREFIELD	3
#define SQC_CURS_PREINSERT	4
#define SQC_CURS_PREUPDATE	5
#define SQC_CURS_ROWSEL		6
#define SQC_CURS_STATE		7
#define SQC_APP_CURSORCREATE	0

// trigger types

#define SQC_TRG_ROWSEL 	100	// row selected ( from list box or ctrl obj)
#define SQC_TRG_FETCH 	101	// fetch trigger (cursor object)
#define SQC_TRG_INSERT 	102	// insert trigger (cursor object)
#define SQC_TRG_UPDATE 	103	// update trigger (cursor object)

// Connection options including transaction isolation options
// These options are mask bits in DBmode property in CIDS and
// lparam of SQcSetDBmode() function
// ENISO would set the isolation level through SetConnectOption()
// if ENISO bit is not set, the isolation level is as per default 
// ENAUTOC bit would set autocommit on or off depending on AUTOCOMMIT bit
// if ENAUTO bit is not set autocommit is as per default
// ENSCOPE would choose the fscope option for SpecialColumns() call
// if ENSCOPE is not set previous values are used and the default is
// CURROW. 
// if ENROWID is set, T1AST and ROWID bits are transfered. For
// Integra database, these two bits T1AST and ROWID must be set

#define SQC_DBM_ISO0    1L		// Isolation level READ_UNCOMMITTED
#define SQC_DBM_ISO1    (1L << 1)	// Isolation level READ_COMMITTED
#define SQC_DBM_ISO2    (1L << 2)	// Isolation level REPEATABLE_READ
#define SQC_DBM_ISO3    (1L << 3)	// Isolation level SERIALIZABLE
#define SQC_DBM_ISO4    (1L << 4)	// Isolation level VERSIONING
#define SQC_DBM_ENISO   (1L << 5)	// Set Isolation Level
#define SQC_DBM_AUTOCOMMIT  (1L << 6)	// auto commit 
#define SQC_DBM_ENAUTOC  (1L << 7)	// set auto commit 
#define SQC_DBM_TRANS	(1L << 8)	// special  cols in TRANSACTION scope
#define SQC_DBM_SESS	(1L << 9)	// special  cols in SESSION scope
#define SQC_DBM_CURROW	(1L << 10)	// special  cols in CURROW scope
#define SQC_DBM_ENSCOPE	(1L << 11)	// set scope option for special cols
#define SQC_DBM_T1AST	(1L << 16)	// for select * qualify with table name
#define SQC_DBM_ROWID	(1L << 17)	// database has special ROWID 
#define SQC_DBM_ENROWID	(1L << 18)	// set database rowid  & T1AST  
#define SQC_DBM_1STMT	(1L << 19)	// Only one statement can be active
#define SQC_DBM_NOAST	(1L << 20)	// * cannot be qualified by tablename
#define SQC_DBM_OUTERJ	(1L << 22)	// Outer joins supported
#define SQC_DBM_OUTERFJ	(1L << 23)	// Full outer joins supported
#define SQC_DBM_INSPARAM (1L << 24)	// Inserts through params
#define SQC_DBM_DELIMIT	(1L << 25)	// Delimit the column names
#define SQC_DBM_NOCOLATTR (1L << 26)	// ignore column attribute errors
#define SQC_DBM_ENGEN	(1L << 31)	// enable general flags

#define SQC_DBM_ENABLES	 SQC_DBM_ENISO \
				+ SQC_DBM_ENAUTOC \
				+ SQC_DBM_ENSCOPE \
				+ SQC_DBM_ENROWID \
				+ SQC_DBM_ENGEN 


// Operation codes to be used in ButtonControl call

#define OP_NONE			0	// No operation
#define OP_CLEARFORM		1	// clear the form in actionstr
#define OP_CLEARQUERY		2	// clear text fields bound to cursor
#define OP_CLOSECURSOR		3	// close the cursor  
#define OP_DELETE		4	// delete the current record
#define OP_CURR			5	// refetch the current record
#define OP_FIRST		6	// fetch the first record
#define OP_LAST			7	// fetch the last record
#define OP_NEXT			8	// fetch the next record
#define OP_PREV			9	// fetch the previous record
#define OP_INSERT		10	// insert record
#define OP_OPEN			11	// oper the cursor
#define OP_QBF			12	// query by form
#define OP_UPDATE		13	// update the current record
#define OP_EXECUTECHAIN		14	// execute the chain of cursors
#define OP_NEWRECORD		15	// insert a new record using defaults
#define OP_LASTCOMMAND		16	// Place holder 


// sql data types to be used while binding host address 


#define SQC_CHAR      		1
#define SQC_NUMERIC   		2
#define SQC_DECIMAL   		3
#define SQC_INTEGER   		4
#define SQC_SMALLINT  		5
#define SQC_FLOAT     		6
#define SQC_REAL      		7
#define SQC_DOUBLE    		8
#define SQC_DATE            	9
#define SQC_TIME           	10
#define SQC_TIMESTAMP      	11
#define SQC_VARCHAR  		12
#define SQC_LONGVARCHAR    	-1
#define SQC_BINARY         	-2
#define SQC_VARBINARY      	-3
#define SQC_LONGVARBINARY  	-4
#define SQC_BIGINT         	-5
#define SQC_TINYINT        	-6
#define SQC_BIT            	-7
#define SQC_INTEGRA_CURRENCY	14


// Grid constants used while setting grid run time properties

#define SQC_GRID_ALLROWS		0  // the property applies to all rows
#define SQC_GRID_ALLCOLS		0  // the property applies to all cols
#define SQC_GRID_1STATEPB		1  // i state push button object
#define SQC_GRID_2STATEPB		2  // 2 state push button object
#define SQC_GRID_CHECKBOX		3  // check box
#define SQC_GRID_COMBODROPDOWN		4  // drop down combo box
#define SQC_GRID_COMBODROPDOWNLIST	5  // drop down list combo box

// Grid constants for combobox flags

#define SQC_GRID_COMBO_NOCOLHEADERS	1  // no column headers
#define SQC_GRID_COMBO_ROWHEADERS	2  // show row headers
#define SQC_GRID_COMBO_NOHORIZLINES	4  // no horizontal grid lines
#define SQC_GRID_COMBO_NOVERTLINES	8  // no verticle grid lines
#define SQC_GRID_COMBO_COLAESECOLS	16  // concantanate columns

// structure definitions
// query event structure. C++ 8.0 event handler has the last parameter
// LPVOID pointing to the following structure. 

typedef struct tagCIGenEvent
{
	long  FAR *paction;	// set to CONTINUE 
	long  FAR *plparam;	// event dependent long parameter
	long  FAR *prownum;	// row number for the event ( 1 based)
				// or operation
	long  FAR *pdstrhand;	// data stream handle
} CIGENEVENT;

// to transfer large amounts of data from LONGVARBINARY or LONGVARCHAR
// address of the following structure may be bound as user buffer with
// buffersize set to 0 in SQcBindColumn() call. Data is transfered to and
// from the opened file. Count field may be given as 0 for complete transfer

typedef struct tagSQcBindDef
{
 	long	offset;		//while reading from database offset into
				// database field
				// while writing to database field,offset
				// into the source file
	long 	count;		// maximum no of bytes to be transfered
	HFILE	filehand;	// filehandle of opened file. The file
				// must exist
} SQCBINDDEF;

typedef struct tagSQcErrInfo
{			
	char   	SqlState[8];	// these three members are same
	long   	NativeError;	// as the values returned by
	char   	ErrorMsg[514];	// odbc SQLError call
	void   	FAR *hdbc;	// HDBC handle
	void	FAR *hstmt;	// HSTMT handle
	long	majorstate;	// internal state
	long	minorstate;	// internal state
	long	errorcnt;	// cumulative error count
	long	revision;	// revision number
	int	retcode;	// return code from call
	short   errortype;	// +ve info and -ve error
	long 	param[4];	// 4 longs reserved 
} SQCERRINFO;


typedef struct tagSQCCOLINFO
{
	long	s_flags;		// flag bits
	long	s_prec;			// precision of the column
	long	s_dispwidth;		// display size in bytes
	short	s_icol;			// 1 based column number
	short	s_sqltype;		// SQL data type 
	short	s_scale;		// scale of the column
	short	s_nullable;		// flag for Nullability
	short	s_Ctype;		// C data type for conversion
	short	s_boundcol;		// column number of visual
					// object if bound (1 based)
					// 0 means unbound
	char	s_name[32];		// name of the column
} SQCCOLINFO;

typedef struct tagSQCCURSINFO
{
	long	s_flags;		// flag bits
	short	s_ncols;		// number columns
	long	s_rows;			// number of rows. -1 if not known
	long	s_curpos;		// current cursor position ( 1 based)
	long	s_startrow;		// selection range
	long	s_endrow;		// as 1 based  
	short	s_startcol;		// rows and
	short	s_endcol;		// columns
	char    s_name[32];		// cursor name
	char    s_statement[512];	// full table name
	long	s_accessmode; 		// accessmode bits
	short	s_cursortype;		// type of cursor
	char    s_dbmsname[32];		// data base name
} SQCCURSINFO;

//	The selection range is valid of s_startrow is > 0 and rows are 1 based
// 	the column numbers are 1 based and refer to the visual object columns

//  all prototypes for exported functions  


typedef  void	(CALLBACK *CIEVENTPROC)(int eventnum,void FAR *vparam,\
			long lparam,CIGENEVENT FAR *event); 

#if defined __cplusplus
extern "C" {
#endif

int FAR PASCAL _export SQcActOnDataStream(long DsrcHand,
				short operation,
				char FAR *szStr,
				long FAR *pRetval,
				long lparam,
				short wparam);
int FAR PASCAL _export	SQcAttachControl(long AppHand,
				char FAR *szFormname,
				char FAR *szCtrlname, 
				short controltype,
				HANDLE CtrlWnd);
int FAR PASCAL _export SQcAttachDataBase(long AppHand,
				char FAR *szDBName,
				char FAR *szConnectStr, 
				char FAR *szUID, 
				char FAR *szPWD, 
				short connecttype,
				char FAR *szConnectStrOut,
				short strsize,
				void  FAR * FAR *phdbc,
				HANDLE formwnd);
int FAR PASCAL _export SQcAttachForm (long AppHand, 
				char FAR *szFormname, 
				HANDLE FormWnd);
int FAR PASCAL  _export SQcBatchEdit(long DsrcHand,
				char FAR *szIUDstr,
				short mode);	
int FAR PASCAL _export SQcBindColumn(long DsrcHand,
				short col,  // 1 based
				short sqldatatype,
				void FAR *buf,
				long  bufsize,
				short FAR *flag);
int FAR PASCAL _export	SQcBindCursor(long DsrcHand,
				char FAR *szControlNameList);
int FAR PASCAL _export SQcBindExp(long AppHand,
				char FAR *szObject,
				char FAR *szexpstmt);
int FAR PASCAL _export SQcBindInOut(long AppHand,
				char FAR *szObjectList,
				char FAR *szDataSource);
int FAR PASCAL _export SQcBindTrigger(long DsrcHand,
				char  FAR *szTriggerstr,
				char  FAR *modifier,
				short  mode);
int FAR PASCAL _export SQcBuild(long DsrcHand,
				char FAR *szDsrcStmt, 
				short curstype,
				char FAR *szDBname,
				long accessmode 
				);
int FAR PASCAL _export	SQcBuildBindExec(long DsrcHand,
				char FAR *szControlNameList,
				char FAR *szDsrcStmt,
				short curstype,
				long accessmode,
				char FAR *szDBname);
int FAR PASCAL _export SQcButtonControl(long DsrcHand,
				short operation,HWND hwnd);
int FAR PASCAL _export SQcCheckVersion(short version);
int FAR PASCAL _export SQcClear(long DsrcHand);
int FAR PASCAL _export SQcClearForm(long AppHand, char FAR *szFormName);
int FAR PASCAL _export SQcClose(long DsrcHand);
int FAR PASCAL _export SQcCloseAndUnbind(long DsrcHand);
int FAR PASCAL _export SQcCommitWork(long AppHand, char FAR *DBname);
int FAR PASCAL _export SQcConnect (long FAR *pAppHand, long FAR *revision);
int FAR PASCAL _export SQcConvertToMemCursor(long DsrcHand,
				long FAR *reccount);
int FAR PASCAL _export SQcCreateDataStream(long AppHand,
				char FAR *szDsrcName,
				short DataSrcType,
				long FAR *pdsrcHand 
				);
int FAR PASCAL _export SQcDelete(long DsrcHand);
int FAR PASCAL _export SQcDeleteDataStream(long DsrcHand);
int FAR PASCAL _export SQcDeleteRecord(long DsrcHand,long recnum);
int FAR PASCAL _export SQcDeleteJoinTbl(long DsrcHand,
				char FAR *tablename,
				long recnum,
				short mode);
int FAR PASCAL _export	SQcDetachControl(long AppHand,
				char FAR *szFormname,
				char FAR *szCtrlname);
int FAR PASCAL _export SQcDetachDataBase(long AppHand, char FAR *szDBname);
int FAR PASCAL _export SQcDetachForm (long AppHand, char FAR *szFormname);
int FAR PASCAL _export SQcDisconnect (long AppHand);
int FAR PASCAL _export	SQcExecute(long AppHand,
				char FAR *szdsrcname,
				long FAR *pDsrcHand);
int FAR PASCAL _export SQcFetch(long DsrcHand,long FAR *rowid,
				long  lparam,
				short fetchcode);
int FAR PASCAL _export SQcFormatDate(short format,
				char FAR *inbuf,
				char FAR *outbuf,
				short outbufsize,
				char FAR *dispdtf, 
				char FAR *drvdtf);
long FAR PASCAL _export SQcGetAppHand (void);
int FAR PASCAL _export SQcGetColInfo(long DsrcHand,
				SQCCOLINFO FAR *colinfo,short col);
int FAR PASCAL _export SQcGetColNum(long DsrcHand,char FAR *colname);
int FAR PASCAL _export SQcGetCursorInfo(long DsrcHand,
				SQCCURSINFO FAR *tblinfo);
int  FAR PASCAL _export SQcGetError(long AppHand, SQCERRINFO FAR *err);
int  FAR PASCAL _export SQcGetErrorMsg(int errorval,
				char FAR *errbuf,short bufsize);
int FAR PASCAL _export	SQcGetHandle(long AppHand,
				char FAR *szname,
				long FAR *pHand,
				short SqcObjType);
int FAR PASCAL _export SQcGetLrecord(long DsrcHand, 
				long FAR *plrecord,long precord);
int FAR PASCAL _export	SQcGetName(long AppHand,
				char FAR *szname,
				short namelength,
				short SqcObjType,
				long	Key);
int FAR PASCAL _export SQcGetPrecord(long DsrcHand, 
				long FAR *pprecord,long lrecord);
int FAR PASCAL _export SQcGo(long AppHand,short priority);
int FAR PASCAL _export SQcInsert(long DsrcHand);
int FAR PASCAL _export SQcInsertRecord(long DsrcHand, long FAR *precnum);
int FAR PASCAL _export SQcInsertJoinTbl(long DsrcHand,
				char FAR *tablename,
				short mode);
int FAR PASCAL _export SQcLog (long AppHand, char FAR *filename);
int FAR PASCAL _export SQcLogRecord(long DsrcHand, long filehandle);
int FAR PASCAL _export SQcNewRecord(long DsrcHand, long FAR *prow, 
				long lparam,short mode);
int FAR PASCAL _export SQcOpen(long DsrcHand,char FAR *actionstr);
int FAR PASCAL _export SQcQBF(long DsrcHand,char FAR *actionstr,
					short modifier);
int FAR PASCAL _export SQcReadPhysicalRecord(long DsrcHand,
				long recnum,long FAR *recflags);
int FAR PASCAL _export SQcReadRecord(long DsrcHand,long recnum);
int FAR PASCAL _export SQcReadColumn(long DsrcHand,
				long rownum, // 1 based
				short col,  // 1 based
				short sqldatatype,
				void FAR *buf,
				long  bufsize,
				short FAR *flag);
int FAR PASCAL _export SQcRollbackWork(long AppHand, char FAR *DBname);
int FAR PASCAL _export SQcSetAppMode (long pAppHand, 
				char FAR *szlog,
				short mode);
int FAR PASCAL _export SQcSetDBmode(long pAppHand,
				char FAR *szDBname,
				long lmode,
				void FAR *pparam);
int FAR PASCAL _export SQcSetColAttr(long DsrcHand,
				short startcol,		// 1 based
				char  FAR *colattrstr);
int FAR PASCAL _export SQcSetColInfo(long DsrcHand,
				SQCCOLINFO FAR *colinfo,short col);
int FAR PASCAL _export SQcSetConnectOption(long AppHand,
				char FAR *szDBname,
				short option,
				long lParam,
				void FAR *vParam);
int FAR PASCAL _export SQcSetCurrentForm(long AppHand, char FAR *szFormName);
int FAR PASCAL _export SQcSetCursorInfo(long DsrcHand,
				SQCCURSINFO FAR *tblinfo);
int FAR PASCAL _export SQcSetDateFormat(long AppHand,
				char FAR *szDBname,
				char FAR *szDisplayFormat,
				char FAR *szDriverFormat);
int FAR PASCAL _export SQcSetEventHandler(long DsrcHand,
				CIEVENTPROC eventhandler,
				void FAR *vparam,
				long lparam);

int FAR PASCAL _export SQcSetMaskEditMode(long DsrcHand,
				short property,
				short mode);
int FAR PASCAL _export SQcSetTopRow(long DsrcHand,long recnum);
int FAR PASCAL _export SQcSetTraceLevel(long AppHand,
				long DsrcHand,
				char FAR *filter,
				short level);
int FAR PASCAL _export SQcTrigger(long AppHand,
				char FAR *szObjname,
				long	lparam,
				short triggertype);
int FAR PASCAL _export SQcUnbindColumns(long DsrcHand);
int FAR PASCAL _export SQcUpdate(long DsrcHand);
int FAR PASCAL _export SQcUpdateRecord(long DsrcHand,long recnum);
int FAR PASCAL _export SQcUpdateJoinTbl(long DsrcHand,
				char FAR *tablename,
				long recnum,
				short mode);
int FAR PASCAL _export SQcVerifyHandle(long DsrcHand);

#if defined __cplusplus
 }
#endif

#endif	/* _SQCMAIN_H */

