unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, Tx4vb, VBXCtrl;

const
  CLIP_CUT   = 1;
  CLIP_COPY  = 2;
  CLIP_PASTE = 3;
  CLIP_CLEAR = 4;

  ft_RTF = 1;
  ft_TX = 2;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Edit1: TMenuItem;
    Search1: TMenuItem;
    Format1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    N1: TMenuItem;
    Print1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Delete1: TMenuItem;
    SelectAll1: TMenuItem;
    Find1: TMenuItem;
    Replace1: TMenuItem;
    Character1: TMenuItem;
    Paragraph1: TMenuItem;
    TXButtonBar1: TTXButtonBar;
    TXRuler1: TTXRuler;
    TextControl1: TTextControl;
    TXStatusBar1: TTXStatusBar;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    PrintDialog1: TPrintDialog;
    FontDialog1: TFontDialog;
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
  private
    FHandle: integer;  { File Handle }
    FileType: integer;
    { Private declarations }
  public
    { Public declarations }
    procedure CreateTheFile(FileName: string);
    procedure SaveTX(FileName: string);
    procedure SaveRTF(FileName: string);
    procedure LoadTX(FileName: string);
    procedure LoadRTF(FileName: string);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormResize(Sender: TObject);
begin
  TXButtonBar1.Width := ClientWidth;

  TXRuler1.Top := TXButtonBar1.Height;
  TXRuler1.Width := ClientWidth;

  TextControl1.Top := (TXButtonBar1.Height + TXRuler1.Height);
  TextControl1.Width := ClientWidth;

  TextControl1.Height := ClientHeight -(TXButtonBar1.Height + TXRuler1.Height +
                      TXStatusBar1.Height);
  TXStatusBar1.Top := CLientHeight - TXStatusBar1.Height;
  TXSTatusBar1.Width := ClientWidth;

end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  TextControl1.PageHeight := 15840;
  TextControl1.PageWidth := 12240;
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.CreateTheFile(FileName: string);
{ This method creates the empty file specified by FileName }
var
  F: File;
begin
  AssignFile(f, FileName);
  Rewrite(f);
  CloseFile(f);
end;


procedure TMainForm.SaveTX(FileName: string);
{ This method saves the contents of TextControl1 into a TX formatted file }
var
  FName: array[0..80] of Char;
begin

  if not FileExists(FileName) then
    CreateTheFile(FileName);

  strpcopy(FName, FileName);
  FHandle := _lopen(FName, of_write);
  TextControl1.Save := FHandle;
  _lclose(FHandle);
end;

procedure TMainForm.SaveRTF(FileName: string);
{ This method saves the contents of TextControl1 into an RTF
  formatted file }
begin
  TextControl1.RTFExport := FileName;
end;

procedure TMainForm.LoadTX(FileName: string);
{ This method loads a TX Formatted File into TextControl1 }
var
  FName: array[0..80] of Char;
begin
  strpcopy(FName, FileName);
  FHandle := _lopen(FName, of_read);
  with TextControl1 do
  begin
    SelStart := 0;
    SelLength := -1;
    Clip := CLIP_CLEAR;
    Load := FHandle;
  end;
  _lclose(FHandle);
end;

 procedure TMainForm.LoadRTF(FileName: string);
{ This method Loads an RTF Formatted File into TextControl1 }
begin
  with TextControl1 do
  begin
    SelStart := 0;
    SelLength := -1;
    Clip := CLIP_CLEAR;
    RTFImport := FileName;
  end;
end;

procedure TMainForm.Open1Click(Sender: TObject);
var
  FExt: string;
begin
  if OpenDialog1.Execute then
    FExt := ExtractFileExt(OpenDialog1.FileName);
    if FExt = '.TX' then
    begin
      LoadTX(OpenDialog1.FileName);
      FileType := ft_TX;
    end
    else if FExt = '.RTF' then
    begin
      LoadRTF(OpenDialog1.FileName);
      FileType := ft_RTF;
    end;
    Caption := OpenDialog1.FileName;
end;

procedure TMainForm.Save1Click(Sender: TObject);
begin
  if Caption = '' then
    SaveAs1Click(Sender)
  else
    case FileType of
      ft_TX:  SaveTX(Caption);
      ft_RTF: SaveRTF(Caption);
    end; {case}
end;

procedure TMainForm.SaveAs1Click(Sender: TObject);
var
  FExt: string;
begin
  if SaveDialog1.Execute then
    FExt := ExtractFileExt(SaveDialog1.FileName);
    if FExt = '.TX' then
    begin
      SaveTX(SaveDialog1.FileName);
      FileType := ft_TX;
    end
    else if FExt = '.RTF' then
    begin
      SaveRTF(SaveDialog1.FileName);
      FileType := ft_RTF;
    end;
  Caption := SaveDialog1.FileName;
end;
end.
