DECLARE FUNCTION UpLoad% ()
DECLARE FUNCTION HangUp% ()
DECLARE FUNCTION DownLoad% ()
DECLARE FUNCTION DoDial% ()
DECLARE FUNCTION Help% ()
DECLARE FUNCTION HexToInt% (strng$)
'****************************************************************
'*               ----- bc7exm2.bas -----                        *
'*                                                              *
'*      Willies' Computer Software Company                      *
'*      Copyright (C) Egberto Willies, 1988-1992                *
'*      All rights reserved.                                    *
'*                                                              *
'*Author-                                                       *
'*      12-DEC-1989 by Egberto Willies                          *
'*                                                              *
'*Description-                                                  *
'*      Example showing how to use QuickBasic with libraries.   *
'*      This is a dumb terminal emulator.                       *
'*                                                              *
'****************************************************************

'************************************************
'* Include QUICKBASIC COMMDRV Include file.     *
'************************************************
'$INCLUDE: 'bc7comm.bas'

'************************************************
'* Make all letters a-z integers by default     *
'************************************************
DEFINT A-Z

'************************************************
'* This defines a user type that contains all   *
'* the serial port characteristics.             *
'************************************************
DIM pcb AS portparam

'************************************************
'* Define the communications buffer.            *
'* We are defining 256 bytes for input and      *
'* 256 bytes for output.                        *
'************************************************
DIM buf AS STRING * 514

DIM ch AS STRING * 1

'************************************************
'* Enter port number, UART address, and IRQ.    *
'************************************************
CLS : LOCATE 1, 1
INPUT "Enter the port number           ==>"; pnum
INPUT "Enter the UART address(HEX)     ==>"; tmp$
INPUT "Enter the IRQ number            ==>"; irqnum
puart = HexToInt%(tmp$)
stat = Help%

'************************************************
'* Leaves available memory for COMM-DRV         *
'* library allocations to use. If any COMM-DRV  *
'* function fails due to memory allocation      *
'* make this value more negative.               *
'************************************************
dummy = SETMEM(-10240)

'************************************************
'* Initialize the port                          *
'************************************************
Port = pnum
subport = 0
BaseAdr = puart
irq = irqnum
cardtype = CARDNORMAL
cardseg = 0
inbuflen = 2048
outbuflen = 1024
flag = 0
stat = InitializePort%(Port, subport, BaseAdr, irq, cardtype, cardseg, inbuflen, outbuflen, flag)
IF stat <> RS232ERRNONE THEN
	PRINT "Error "; stat; "initializing serial port"
	SYSTEM
	END IF

DO
	'************************************************
	'* Make string the exact size of the read.      *
	'************************************************
	ch = " "

	'********************************************************
	'* Attempt to get a byte from the serial port.          *
	'* If character read from serial port, output it.       *
	'********************************************************
	stat = GetByte(Port)
	IF stat <> -1 THEN
		IF stat <> 10 THEN
			PRINT CHR$(stat);
			END IF
		END IF

	'************************************************
	'* Attempt to get byte from the keyboard.       *
	'* If control Z is hit then we exit.            *
	'************************************************
	a$ = INKEY$
	IF a$ <> "" THEN
		IF a$ = CHR$(26) THEN
			EXIT DO

		ELSEIF a$ = CHR$(22) THEN
			stat = Help%

		ELSEIF a$ = CHR$(2) THEN
			stat = DoDial%

		ELSEIF a$ = CHR$(4) THEN
			stat = DownLoad%

		ELSEIF a$ = CHR$(21) THEN
			stat = UpLoad%

		ELSEIF a$ = CHR$(18) THEN
			stat = HangUp%

		ELSE
			ch = a$

			'************************************************
			'* Attempt to output byte over serial port.     *
			'************************************************
			stat = PutByte(Port, ASC(ch))
			IF stat = -1 THEN
				PRINT "Error writing to serial port"
				END IF
			END IF
		END IF
	LOOP WHILE ch = ch

'************************************************
'* Attempt to cleanup vectors and so forth.     *
'************************************************
stat = UnInitializePort(Port)
IF stat = -1 THEN
	PRINT "Error cleaning serial port"
	END IF
SYSTEM
'********************************************************
'********************************************************
'********************************************************
'********************************************************
'********************************************************
'********************************************************
'********************************************************
'********************************************************
'********************************************************

'********************************************************
'********************************************************
FUNCTION DoDial%
CLS
LINE INPUT "Enter Number To Dial ==>"; telno$
telno$ = telno$ + CHR$(0)
IF Dial%(Port, 1, SSEGADD(telno$)) <> 0 THEN
	PRINT "Error Dialing Telephone"
	EXIT FUNCTION
	END IF
stat = ModemConnect(Port)
IF (stat = -1) OR (stat = -2) THEN
	PRINT "***Error Connecting***"
ELSEIF stat = -3 THEN
	PRINT "***No Dial Tone***"
ELSEIF stat = -4 THEN
	PRINT "***Telephone Busy***"
ELSE
	PRINT "Connected Successfully"
	PRINT "Carrier Speed=>"; ModemGetCarrierSpeed(Port)
	PRINT "Connect Speed=>"; ModemGetConnectSpeed(Port)
	END IF
END FUNCTION

'********************************************************
' Download Files
'********************************************************
FUNCTION DownLoad%
CLS

'File transfer type selection
PRINT "Select Protocol"
PRINT "0 - XMODEM"
PRINT "1 - XMODEM 1K"
PRINT "2 - YMODEM"
PRINT "3 - YMODEM Batch"
PRINT "4 - YMODEM G"
PRINT "5 - YMODEM G Batch"
PRINT "6 - ZMODEM"
INPUT "Enter Protocol       ==>"; Prot
LINE INPUT "Enter File Spec ==>"; FilNam$
FilNam$ = FilNam$ + CHR$(0)

'Allow Automatic Dialog Box
stat = FileTransferDialog%(Port, 1)
stat = cdrvxfer.files%(Port, 1, Prot, SSEGADD(FilNam$), 0)
IF stat <> CDRVXFERERROK THEN
	PRINT "File Transfer Error #"; stat
ELSE
	PRINT "Successful File Transfer"
	END IF
END FUNCTION

'********************************************************
' HangUp the phone
'********************************************************
FUNCTION HangUp%
stat = ModemHangup%(Port)
IF stat <> 0 THEN
	PRINT "Error hanging up modem"
	END IF
END FUNCTION

'********************************************************
' Help Menu
'********************************************************
FUNCTION Help%
CLS
PRINT "<CTL V> Help"
PRINT "<CTL B> Dial"
PRINT "<CTL R> HangUp"
PRINT "<CTL D> Download File(s)"
PRINT "<CTL U> Upload File(s)"
END FUNCTION

'********************************************************
' Hex to integer conversion
'********************************************************
FUNCTION HexToInt% (strng$)
hexval% = 0
strlen% = LEN(strng$)

FOR i% = 1 TO strlen%
	strchar$ = MID$(strng$, i%, 1)
	IF strchar$ <= "9" AND strchar$ >= "0" THEN
		strch% = ASC(strchar$) - ASC("0")
	ELSEIF strchar$ <= "F" AND strchar$ >= "A" THEN
		strch% = ASC(strchar$) - ASC("A") + 10
	ELSEIF strchar$ <= "f" AND strchar$ >= "a" THEN
		strch% = ASC(strchar$) - ASC("a") + 10
	END IF

	hexval% = 16 * hexval% + strch%
NEXT i%
HexToInt% = hexval%
END FUNCTION

'********************************************************
' Upload Files
'********************************************************
FUNCTION UpLoad%
CLS

'File transfer type selection
PRINT "Select Protocol"
PRINT "0 - XMODEM"
PRINT "1 - XMODEM 1K"
PRINT "2 - YMODEM"
PRINT "3 - YMODEM Batch"
PRINT "4 - YMODEM G"
PRINT "5 - YMODEM G Batch"
PRINT "6 - ZMODEM"
INPUT "Enter Protocol       ==>"; Prot
LINE INPUT "Enter File Spec ==>"; FilNam$
FilNam$ = FilNam$ + CHR$(0)

'Allow Automatic Dialog Box
stat = FileTransferDialog%(Port, 1)
stat = cdrvxfer.files%(Port, 0, Prot, SSEGADD(FilNam$), 0)
IF stat <> CDRVXFERERROK THEN
	PRINT "File Transfer Error #"; stat
ELSE
	PRINT "Successful File Transfer"
	END IF
END FUNCTION

