'****************************************************************
'*Description-                                                  *
'*      Provides the basic link between the COMM-DRV            *
'*      library and BASIC functions.                            *
'****************************************************************

'****************************************************************
'*=====BAUDS                                                    *
'****************************************************************
CONST BAUD110 = 0               '110 baud
CONST BAUD150 = 1               '150 baud
CONST BAUD300 = 2               '300 baud
CONST BAUD600 = 3               '600 baud
CONST BAUD1200 = 4              '1200   baud
CONST BAUD2400 = 5              '2400   baud
CONST BAUD4800 = 6              '4800   baud
CONST BAUD9600 = 7              '9600   baud
CONST BAUD19200 = 8             '19200 baud
CONST BAUD38400 = 9             '38400 baud
CONST BAUD57600 = 10            '57600 baud
CONST BAUD115200 = 11           '115.2 kbaud
CONST BAUDUSER00 = 12           'User baud rate
CONST BAUDUSER01 = 13           'User baud rate
CONST BAUDUSER02 = 14           'User baud rate
CONST BAUDUSER03 = 15           'User baud rate
CONST BAUDUSER04 = 16           'User baud rate
CONST BAUDUSER05 = 17           'User baud rate
CONST BAUDUSER06 = 18           'User baud rate
CONST BAUDUSER07 = 19           'User baud rate
CONST BAUDUSER08 = 20           'User baud rate
CONST BAUDUSER09 = 21           'User baud rate
'****************************************************************
'*=====Parities                                                 *
'****************************************************************
CONST PARITYNONE = 0            'No parity
CONST PARITYODD = 1             'ODD parity
CONST PARITYEVEN = 2            'Even   parity
CONST PARITYSODD = 3            'Sticky ODD parity
CONST PARITYSEVEN = 4           'Sticky Even parity

'****************************************************************
'*=====Lengths                                                  *
'****************************************************************
CONST LENGTH5 = 0               '5 bits
CONST LENGTH6 = 1               '6 bits
CONST LENGTH7 = 2               '7 bits
CONST LENGTH8 = 3               '8 bits

'****************************************************************
'*=====Stobits                                                  *
'****************************************************************
CONST STOPBIT1 = 0              '1 Stop bit
CONST STOPBIT2 = 1              '2 Stop bit

'****************************************************************
'*=====Break                                                    *
'****************************************************************
CONST BREAKOFF = 0              'Break off
CONST BREAKON = 1               'Break on

'****************************************************************
'*=====PROTOCOL                                                 *
'****************************************************************
CONST PROTRTSRTS = 0            'Local  CTS/RTS-Remote CTS/RTS
CONST PROTRTSXON = 1            'Local  CTS/RTS-Remote XON/XOFF
CONST PROTRTSDTR = 2            'Local  CTS/RTS-Remote DSR/DTR
CONST PROTRTSNON = 3            'Local  CTS/RTS-Remote no prot
CONST PROTNONNON = 4            'Local  no prot-Remote no prot
CONST PROTNONXON = 5            'Local  no  protocol-Remote XOFF/XON
CONST PROTXONNON = 6            'Local  XOFF/XON-Remote no prot
CONST PROTXONXON = 7            'Local  XON/XOFF-Remote XON/XOFF
CONST PROTDTRNON = 8            'Local   DSR/DTR-Remote no protocol
CONST PROTDTRRTS = 9            'Local   DSR/DTR-Remote CTS/RTS
CONST PROTDTRDTR = 10           'Local   DSR/DTR-Remote DSR/DTR
CONST PROTDTRXON = 11           'Local   DSR/DTR-Remote DSR/DTR
CONST PROTNONRTS = 12           'Local  no  prot-Remote CTS/RTS prot
CONST PROTNONDTR = 13           'Local  no  prot-Remote DSR/DTR prot
CONST PROTXONRTS = 14           'Local  XOFF/XON- Remote CTS/RTS
CONST PROTXONDTR = 15           'Local  XOFF/XON-Remote DSR/DTR

'****************************************************************
'=====CARDTYPE                                                  *
'****************************************************************
CONST CARDNORMAL = 0            'Normal cards
CONST CARDINTELH = 1            'Intel HUB card
CONST CARDDIGCXI = 2            'Digiboard COMXI
CONST CARDARNETSPLUS = 3        'Arnet Smartplus
CONST CARDAST4PORT = 4          'AST 4 Port
CONST CARDDIGPCX = 5            'Digiboard PCX
CONST CARDGTEK = 6              'GTEK Board
CONST CARDINT14 = 7             'INT14 device
CONST CARDWCSCVXD = 8           'WCSC VxD device

'****************************************************************
'*=====Return error codes                                       *
'****************************************************************
CONST RS232ERRNONE = 0                  'RS232  no error
CONST RS232ERRBUFFER = 1                'RS232  buffer not set or buff changed
CONST RS232ERRACTIVE = 2                'RS232  port not active
CONST RS232ERRXMTBUF = 3                'RS232  xmit buffer full
CONST RS232ERRRCVBUF = 4                'RS232  recv buffer empty
CONST RS232ERRSYNTAX = 5                'RS232  port syntax  error
CONST RS232ERRBUFSIZ = 6                'RS232  invalid buffer size
CONST RS232ERRPORT = 7                  'RS232  invalid port
CONST RS232ERRHANDLR = 8                'RS232  handler changed
CONST RS232ERRBAUD = 9                  'RS232  invalid baud rate
CONST RS232ERRPARITY = 10               'RS232  invalid parity
CONST RS232ERRLNGTH = 11                'RS232  invalid data length
CONST RS232ERRSTOPBIT = 12              'RS232  invalid # stopbits
CONST RS232ERRPROTOCOL = 13             'RS232  invalid protocol
CONST RS232ERRIRQCHANGED = 14           'RS232  IRQ changed
CONST RS232ERRPORTCHANGED = 15          'RS232  port changed
CONST RS232ERRTHRESHOLD = 16            'RS232  invalid threshold
CONST RS232ERRINVIRQ = 17               'RS232  invalid IRQ
CONST RS232ERRINTOFF = 18               'RS232  interrupts not enabled
CONST RS232ERRBREAK = 19                'RS232  invalid break syntax
CONST RS232ERRFATAL = 20                'RS232  fatal error
CONST RS232ERRDSR = 21                  'RS232  CTS error
CONST RS232ERRINVADR = 22               'RS232  Invalid RS232 address
CONST RS232ERRENVIRON = 23              'Environment variable not set
CONST RS232ERRIOCTL = 24                'Error  issuing IOCTL call
CONST RS232ERRATEXIT = 25               'Error  issuing atexit cleanup
CONST RS232ERRDEVINIT = 26              'Error  mapping device for dir calls
CONST RS232ERRDOSOPEN = 27              'Error  opening Device
CONST RS232ERRMALLOC = 28               'Error  allocating memory
CONST RS232ERREXTMICRO = 29             'Error  on external micro
CONST RS232ERRCARDCHANGED = 30          'Card changed error
CONST RS232ERRCARDTYPE = 31             'Card type error
CONST RS232ERRNOSUPPORT = 32            'Not supported
CONST RS232ERRCMDBUFFULL = 33           'Card command buffer full
CONST RS232ERRPPORT = 34                'Invalid parent PCB
CONST RS232ERRNODEVICE = 35             'No device for  this port
CONST RS232ERRUNKNOWN = 36              'Unknow error
CONST RS232ERRBUSY = 37                 'Busy
CONST RS232ERRNOTIMER = 38             'No more timers available
CONST RS232ERRINT14VEC = 39            'INT 14H vector changed
CONST RS232ERRINT1CVEC = 40            'Timer vector changed
CONST RS232ERRDPMI = 41                'DPMI error
CONST RS232ERRWINBUF = 42              'No windows buffer or too small
CONST RS232ERRNOASYNCRES = 43          'No asynchronous resources left
CONST RS232ERRNOTIMERRES = 44          'No timer resources left
CONST RS232ERRNOOTHERES = 45           'Out of other resources
CONST RS232ERRFILEIO = 46              'File I/O error
CONST RS232ERRHMEMG64 = 47             'Hardware memory exceeded 64K
CONST RS232MAPVXD = 48                 'VxD not loaded


'****************************************************************
'Miscellaneous Constants                                        *
'****************************************************************
CONST Len.Fspec = 63                    'Filespec length
CONST LenFspec = Len.Fspec + 1          'Filespec length wil null

'****************************************************************
'File Transfer Constants                                        *
'****************************************************************
'Initial send state
CONST CDRVXFERRSTATEINIT = 0       'Initial receive file transfer state
CONST CDRVXFERSSTATEINIT = 40      'Initial send file transfer state

'Error codes
CONST CDRVXFERERROK = 0            'Complete without errors
CONST CDRVXFERERRNONE = 0          'Complete without errors
CONST CDRVXFERERRSERIAL = 1        'Some serial I/O error
CONST CDRVXFERERROS = 2            'MSDOS Error
CONST CDRVXFERERRPROTOCOL = 3      'Protocol Error
CONST CDRVXFERERRBUSY = 4          'Protocol engine still busy
CONST CDRVXFERERRCANCEL = 5        'Cancel terminated
CONST CDRVXFERERRINVPORT = 6       'Invalid Port
CONST CDRVXFERERRNOPCB = 7         'No more PCBs
CONST CDRVXFERERRMTASK = 8         'MTASK error
CONST CDRVXFERERRACTIVE = 9        'XFER on port still active
CONST CDRVXFERERRFNAME = 10        'Invalid filename
CONST CDRVXFERERRKILLED = 11       'Transfer killed
CONST CDRVXFERERRMEMORY = 12       'Memory allocation error

'Flag values
CONST CDRVXFERFLAGRECOVER = 2097152             '
CONST CDRVXFERFLAGOVERWRITE = 4194304           '
CONST CDRVXFERFLAGRENAME = 8388608              '
CONST CDRVXFERFLAGFILEDONE = -2147483648#       '

'****************************************************************
'Dos Find Structure                                             *
'****************************************************************
TYPE dosfindstruct
dosreserved AS STRING * 21            'Reserved by DOS
dosattrib AS STRING * 1               'File attribute
doswrtime AS INTEGER                  'Last write time
doswrdate AS INTEGER                  'Last write date
dossize AS LONG                       'File size
dosname AS STRING * 13                'DOS filename
dosdummy AS STRING * 1                'Place holder
dospathidx AS INTEGER                 'Index to place name
dosfspec AS STRING * 127              'path plus name
END TYPE

'****************************************************************
'* File find structure                                          *
'****************************************************************
TYPE cdrvxferfileinfo
time AS INTEGER
date AS INTEGER
size AS LONG
fspec AS LONG
fbuf AS dosfindstruct
END TYPE

'****************************************************************
'COMMDRV Port Control Block                                     *
'****************************************************************
TYPE portparam
serrs232base  AS INTEGER              'Base address of port
irq             AS INTEGER              'Interrupt number
baud            AS INTEGER              'baud rate index
parity          AS INTEGER              'parity index
lngth           AS INTEGER              'length index
stopbit         AS INTEGER              'stopbit index
brk             AS INTEGER              'Break
protocol        AS INTEGER              'protocol index
block           AS STRING * 2           'Lowbyte=inblock Highbyte=outblock
inbuflow        AS INTEGER              'Low threshold  of recv buffer
inbufhigh       AS INTEGER              'High threshold of xmit buffer
bufferseg       AS INTEGER              'Segment to start of buffer
bufferoff       AS INTEGER              'Offset to start of buffer
inbuflen        AS INTEGER              'Input  buffer length
outbuflen       AS INTEGER              'Output buffer  length
auxaddr1        AS INTEGER              'Low byte=Aux Address High byte unsuse
cardseg         AS INTEGER              'Memory card segment
cardtype        AS INTEGER              'Card Type
intfunc         AS LONG                 'Interupt function
serror          AS INTEGER              'Error flag
flag            AS INTEGER              'General purpose flag
inbufcount      AS INTEGER              '# bytes in input buf
outbufcount     AS INTEGER              '# of   bytes in ouput
lostichar       AS LONG                 'Lost   inputted bytes
lostochar       AS LONG                 'Lost   outputted bytes
totalichar      AS LONG                 'Total attempted bytes in
totalochar      AS LONG                 'Total attempted bytes out
devfuncs        AS LONG                 'Ptr to table of ptrs to dev funcs
lsrmsr          AS INTEGER              'Low Byte=MSR<==>High Byte=LSR
ddata           AS INTEGER              'Data that sub-device driver may use
inbufstart      AS INTEGER              'Input  buffer control block
outbufstart     AS INTEGER              'Output buffer control block
irqp            AS LONG                 'Pointer to irq parameter block
port            AS INTEGER              'Port   number
flag2           AS INTEGER              'Secondary flag
obufoff         AS INTEGER              'Output buf off if DIFFXBUF set
obufseg         AS INTEGER              'Output buf seg if DIFFXBUF set
pport           AS INTEGER              'Parent port
ppcb            AS INTEGER              'Parent pcb
timeriblk       AS INTEGER              'Timer block
timeroblk       AS INTEGER              'Timer block
hblock          AS STRING * 2           'Hi bytes of input/output timeouts
charxon         AS STRING * 1           'XON char(Receive)
charxoff        AS STRING * 1           'XOFF char(Receive)
charxxon        AS STRING * 1           'XON char(xmit)
charxxoff       AS STRING * 1           'XOFF char(xmit)
auxpcb          AS LONG                 'Pointer to auxiliary PCB
protlocal       AS INTEGER              'Local protocol
protremote      AS INTEGER              'Remote protocol
opcb            AS LONG                 'Pointer to this PCB
dflag           AS INTEGER              'Subdevice specific flag
obaudreg        AS STRING * 2           'Old baud rate
olcrreg         AS STRING * 1           'Old LCR
omcrreg         AS STRING * 1           'Old MCR
oierreg         AS STRING * 1           'Old IER
tuart           AS STRING * 1           'UART type
nextpcb         AS INTEGER              'Pointer to next
END TYPE

TYPE cdrvxferftpcb
'User Provided Information
fspec           AS STRING * LenFspec
port            AS INTEGER
state           AS INTEGER
buf             AS LONG
bufsiz          AS INTEGER
retrycnt        AS INTEGER
rcvtimeout      AS INTEGER
xmttimeout      AS INTEGER

'Xfer Progress Info
curblk          AS INTEGER
blksiz          AS INTEGER
numbytes        AS LONG
offsetbytes     AS LONG
error           AS INTEGER
exterror        AS INTEGER
totalerr        AS INTEGER
currenterr      AS INTEGER

'System Usage
fhandle         AS INTEGER
saveerror       AS INTEGER
deltaerr        AS INTEGER
substate        AS INTEGER
blkidx          AS INTEGER
retry           AS INTEGER
crcretry        AS INTEGER
gretry          AS INTEGER
bretry          AS INTEGER
flag            AS LONG
itimerbuf       AS STRING * 12
otimerbuf       AS STRING * 12
ftimerbuf       AS STRING * 12
elapsed         AS LONG
blockn          AS STRING * 2
crc             AS STRING * 2
ccrc            AS INTEGER
flag2           AS INTEGER
zconv           AS INTEGER
zmanag          AS INTEGER
ztrans          AS INTEGER
zfe             AS STRING * 1
tzfe            AS STRING * 1
ocrc32          AS LONG
xmtcnt          AS INTEGER
xmtidx          AS INTEGER
xmtdat          AS LONG
xmtopkt         AS STRING * 2
xmtocnt         AS INTEGER
xmtoidx         AS INTEGER
xmtpkt          AS STRING * 20
xmtpcnt         AS INTEGER
xmtpidx         AS INTEGER
xmtpdat         AS LONG
xmtncnt         AS INTEGER
xmtnidx         AS INTEGER
xmtndat         AS LONG
txmtcnt         AS INTEGER
txmtidx         AS INTEGER
txmtpkt         AS STRING * 20
icrc32          AS LONG
crcstat         AS INTEGER
lasthdr         AS INTEGER
rcvstate        AS INTEGER
rcvsubstate     AS INTEGER
rcvcancel       AS INTEGER
rcvhtype        AS INTEGER
rcvcnt          AS INTEGER
rcvdat          AS LONG
rcvidx          AS INTEGER
rcvpkt          AS STRING * 20
trcvidx         AS INTEGER
xbufcnt         AS INTEGER
xbufidx         AS INTEGER
xbuf            AS STRING * 50
rbufcnt         AS INTEGER
rbufidx         AS INTEGER
rbuf            AS STRING * 50
f               AS cdrvxferfileinfo
pcb             AS portparam
END TYPE

'****************************************************************
'Low Level Function Declarations                                *
'****************************************************************
DECLARE FUNCTION ser.rs232.block% CDECL ALIAS "_ser_rs232_block" (BYVAL port%, BYVAL inblk%, BYVAL outblk%)
DECLARE FUNCTION ser.rs232.cleanup% CDECL ALIAS "_ser_rs232_cleanup" (BYVAL port%)
DECLARE FUNCTION ser.rs232.dtr.off% CDECL ALIAS "_ser_rs232_dtr_off" (BYVAL port%)
DECLARE FUNCTION ser.rs232.dtr.on% CDECL ALIAS "_ser_rs232_dtr_on" (BYVAL port%)
DECLARE FUNCTION ser.rs232.flush% CDECL ALIAS "_ser_rs232_flush" (BYVAL port%, BYVAL arg%)
DECLARE FUNCTION ser.rs232.getbyte% CDECL ALIAS "_ser_rs232_getbyte" (BYVAL port%, BYVAL ch&)
DECLARE FUNCTION ser.rs232.getpacket% CDECL ALIAS "_ser_rs232_getpacket" (BYVAL port%, BYVAL count%, BYVAL ch&)
DECLARE FUNCTION ser.rs232.getport% CDECL ALIAS "_ser_rs232_getport" (BYVAL port%, SEG pcb AS portparam)
DECLARE FUNCTION ser.rs232.getregister% CDECL ALIAS "_ser_rs232_getregister" (BYVAL port%, SEG regs%)
DECLARE FUNCTION ser.rs232.getstatus% CDECL ALIAS "_ser_rs232_getstatus" (BYVAL port%, SEG stat%)
DECLARE FUNCTION ser.rs232.maxport% CDECL ALIAS "_ser_rs232_maxport" ()
DECLARE FUNCTION ser.rs232.misc.func% CDECL ALIAS "_ser_rs232_misc_func" (BYVAL port%, BYVAL cmd%, BYVAL arg&)
DECLARE FUNCTION ser.rs232.putbyte% CDECL ALIAS "_ser_rs232_putbyte" (BYVAL port%, BYVAL ch&)
DECLARE FUNCTION ser.rs232.putpacket% CDECL ALIAS "_ser_rs232_putpacket" (BYVAL port%, BYVAL count%, BYVAL ch&)
DECLARE FUNCTION ser.rs232.putregister% CDECL ALIAS "_ser_rs232_putregister" (BYVAL port%, BYVAL reg1%, SEG reg2%)
DECLARE FUNCTION ser.rs232.rts.off% CDECL ALIAS "_ser_rs232_rts_off" (BYVAL port%)
DECLARE FUNCTION ser.rs232.rts.on% CDECL ALIAS "_ser_rs232_rts_on" (BYVAL port%)
DECLARE FUNCTION ser.rs232.set.intfunc% CDECL ALIAS "_ser_rs232_set_intfunc" (BYVAL port%, BYVAL a&, BYVAL imask%)
DECLARE FUNCTION ser.rs232.setbauddiv% CDECL ALIAS "_ser_rs232_setbauddiv" (BYVAL cdtyp%, BYVAL bidx%, BYVAL bdiv%)
DECLARE FUNCTION ser.rs232.setup% CDECL ALIAS "_ser_rs232_setup" (BYVAL port%, SEG pcb AS portparam)
DECLARE FUNCTION ser.rs232.viewpacket% CDECL ALIAS "_ser_rs232_viewpacket" (BYVAL port%, BYVAL count%, BYVAL ch&)

'****************************************************************
'Declarations for high level functions in CDRV.DLL              *
'****************************************************************
DECLARE FUNCTION BytesInReceiveBuffer% CDECL ALIAS "_BytesInReceiveBuffer" (BYVAL port%)
DECLARE FUNCTION BytesInTransmitBuffer% CDECL ALIAS "_BytesInTransmitBuffer" (BYVAL port%)
DECLARE FUNCTION CdrvCheckTime% CDECL ALIAS "_CdrvCheckTime" (BYVAL timblk&)
DECLARE FUNCTION CdrvCrc16% CDECL ALIAS "_CdrvCrc16" (BYVAL cnt%, BYVAL buf&)
DECLARE FUNCTION CdrvCrc32& CDECL ALIAS "_CdrvCrc32" (BYVAL cnt%, BYVAL buf&)
DECLARE FUNCTION CdrvDelay% CDECL ALIAS "_CdrvDelay" (BYVAL port%, BYVAL timout%)
DECLARE FUNCTION CdrvGetPcb& CDECL ALIAS "_CdrvGetPcb" (BYVAL port%)
DECLARE FUNCTION CdrvSetTime% CDECL ALIAS "_CdrvSetTime" (BYVAL port%, BYVAL Timeout%, BYVAL timblk&)
DECLARE FUNCTION CdrvSetTimeoutFunction% CDECL ALIAS "_CdrvSetTimeoutFunction" (BYVAL port%, BYVAL func&)
DECLARE FUNCTION CdrvSetTimerResolution% CDECL ALIAS "_CdrvSetTimerResolution" (BYVAL port%, BYVAL Resolution%)
DECLARE FUNCTION cdrvxfer.files% CDECL ALIAS "_cdrvxfer_files" (BYVAL port%, BYVAL dire%, BYVAL prt%, BYVAL fln&, BYVAL dfnc&)
DECLARE FUNCTION cdrvxfer.gclose% CDECL ALIAS "_cdrvxfer_gclose" (SEG ftpcb AS cdrvxferftpcb)
DECLARE FUNCTION cdrvxfer.getfiles% CDECL ALIAS "_cdrvxfer_getfiles" (BYVAL mode%, SEG ftpcb AS cdrvxferftpcb)
DECLARE FUNCTION cdrvxfer.sendfiles% CDECL ALIAS "_cdrvxfer_sendfiles" (BYVAL mode%, SEG ftpcb AS cdrvxferftpcb)
DECLARE FUNCTION cdrvxfer.sfiles% CDECL ALIAS "_cdrvxfer_sfiles" (BYVAL port%, BYVAL dire%, BYVAL prt%, BYVAL fln&, BYVAL dfnc&)
DECLARE FUNCTION Dial% CDECL ALIAS "_Dial" (BYVAL port%, BYVAL mode%, BYVAL tel&)
DECLARE FUNCTION DtrOff% CDECL ALIAS "_DtrOff" (BYVAL port%)
DECLARE FUNCTION DtrOn% CDECL ALIAS "_DtrOn" (BYVAL port%)
DECLARE FUNCTION FileTransferDialog% CDECL ALIAS "_FileTransferDialog" (BYVAL port%, BYVAL mode%)
DECLARE FUNCTION FlushReceiveBuffer% CDECL ALIAS "_FlushReceiveBuffer" (BYVAL port%)
DECLARE FUNCTION FlushTransmitBuffer% CDECL ALIAS "_FlushTransmitBuffer" (BYVAL port%)
DECLARE FUNCTION GetByte% CDECL ALIAS "_GetByte" (BYVAL port%)
DECLARE FUNCTION GetPaceTime% CDECL ALIAS "_GetPaceTime" (BYVAL port%)
DECLARE FUNCTION GetPacket% CDECL ALIAS "_GetPacket" (BYVAL port%, BYVAL lngth%, BYVAL pkt&)
DECLARE FUNCTION GetString% CDECL ALIAS "_GetString" (BYVAL port%, BYVAL lngth%, BYVAL pkt&)
DECLARE FUNCTION GetTimeout% CDECL ALIAS "_GetTimeout" (BYVAL port%)
DECLARE FUNCTION InitializePort% CDECL ALIAS "_InitializePort" (BYVAL port%, BYVAL subport%, BYVAL addr%, BYVAL irq%, BYVAL cardtype%, BYVAL cardseg%, BYVAL inbuflen%, BYVAL outbuflen%, BYVAL flag%)
DECLARE FUNCTION IsBreak% CDECL ALIAS "_IsBreak" (BYVAL port%)
DECLARE FUNCTION IsCarrierDetect% CDECL ALIAS "_IsCarrierDetect" (BYVAL port%)
DECLARE FUNCTION IsCts% CDECL ALIAS "_IsCts" (BYVAL port%)
DECLARE FUNCTION IsDsr% CDECL ALIAS "_IsDsr" (BYVAL port%)
DECLARE FUNCTION IsFramingError% CDECL ALIAS "_IsFramingError" (BYVAL port%)
DECLARE FUNCTION IsInputOverrun% CDECL ALIAS "_IsInputOverrun" (BYVAL port%)
DECLARE FUNCTION IsOverrunError% CDECL ALIAS "_IsOverrunError" (BYVAL port%)
DECLARE FUNCTION IsParityError% CDECL ALIAS "_IsParityError" (BYVAL port%)
DECLARE FUNCTION IsPortAvailable% CDECL ALIAS "_IsPortAvailable" (BYVAL port%)
DECLARE FUNCTION IsReceiveBufferEmpty% CDECL ALIAS "_IsReceiveBufferEmpty" (BYVAL port%)
DECLARE FUNCTION IsRing% CDECL ALIAS "_IsRing" (BYVAL port%)
DECLARE FUNCTION IsTransmitBufferEmpty% CDECL ALIAS "_IsTransmitBufferEmpty" (BYVAL port%)
DECLARE FUNCTION ModemAttention% CDECL ALIAS "_ModemAttention" (BYVAL port%)
DECLARE FUNCTION ModemAnswerMode% CDECL ALIAS "_ModemAnswerMode" (BYVAL port%, BYVAL count%)
DECLARE FUNCTION ModemConnect% CDECL ALIAS "_ModemConnect" (BYVAL port%)
DECLARE FUNCTION ModemGetCarrierSpeed& CDECL ALIAS "_ModemGetCarrierSpeed" (BYVAL port%)
DECLARE FUNCTION ModemGetConnectSpeed& CDECL ALIAS "_ModemGetConnectSpeed" (BYVAL port%)
DECLARE FUNCTION ModemHangup% CDECL ALIAS "_ModemHangup" (BYVAL port%)
DECLARE FUNCTION ModemInit% CDECL ALIAS "_ModemInit" (BYVAL port%)
DECLARE FUNCTION ModemModifyString% CDECL ALIAS "_ModemModifyString" (BYVAL port%, BYVAL code%, BYVAL strng&)
DECLARE FUNCTION ModemModifyValue% CDECL ALIAS "_ModemModifyValue" (BYVAL port%, BYVAL code%, BYVAL value&)
DECLARE FUNCTION PeekChar% CDECL ALIAS "_PeekChar" (BYVAL port%)
DECLARE FUNCTION PutByte% CDECL ALIAS "_PutByte" (BYVAL port%, BYVAL ch%)
DECLARE FUNCTION PutPacket% CDECL ALIAS "_PutPacket" (BYVAL port%, BYVAL count%, BYVAL pkt&)
DECLARE FUNCTION PutString% CDECL ALIAS "_PutString" (BYVAL port%, BYVAL pkt&)
DECLARE FUNCTION ReceiveBufferSize% CDECL ALIAS "_ReceiveBufferSize" (BYVAL port%)
DECLARE FUNCTION RtsOff% CDECL ALIAS "_RtsOff" (BYVAL port%)
DECLARE FUNCTION RtsOn% CDECL ALIAS "_RtsOn" (BYVAL port%)
DECLARE FUNCTION SetBaud% CDECL ALIAS "_SetBaud" (BYVAL port%, BYVAL baud%)
DECLARE FUNCTION SendBreak% CDECL ALIAS "_SendBreak" (BYVAL port%, BYVAL timeval%)
DECLARE FUNCTION SetFlowControlCharacters% CDECL ALIAS "_SetFlowControlCharacters" (BYVAL port%, BYVAL xoff%, BYVAL xon%, BYVAL xxon%, BYVAL xxoff%)
DECLARE FUNCTION SetFlowControlThreshold% CDECL ALIAS "_SetFlowControlThreshold" (BYVAL port%, BYVAL inbuf.low%, BYVAL inbuf.high%)
DECLARE FUNCTION SetPaceTime% CDECL ALIAS "_SetPaceTime" (BYVAL port%, BYVAL timeval%)
DECLARE FUNCTION SetPortCharacteristics% CDECL ALIAS "_SetPortCharacteristics" (BYVAL port%, BYVAL newbaud%, BYVAL newparity%, BYVAL lngth%, BYVAL newstopbit%, BYVAL newprotocol%)
DECLARE FUNCTION SetTimeout% CDECL ALIAS "_SetTimeout" (BYVAL port%, BYVAL timeval%)
DECLARE FUNCTION SetXferParameters% CDECL ALIAS "_SetXferParameters" (BYVAL port%, BYVAL value&)
DECLARE FUNCTION SpaceInReceiveBuffer% CDECL ALIAS "_SpaceInReceiveBuffer" (BYVAL port%)
DECLARE FUNCTION SpaceInTransmitBuffer% CDECL ALIAS "_SpaceInTransmitBuffer" (BYVAL port%)
DECLARE FUNCTION TransferFiles% CDECL ALIAS "_TransferFiles" (BYVAL cmd%, BYVAL port%, BYVAL direction%, BYVAL prt%, BYVAL fspec&, SEG ftpcb AS cdrvxferftpcb)
DECLARE FUNCTION TransmitBufferSize% CDECL ALIAS "_TransmitBufferSize" (BYVAL port%)
DECLARE FUNCTION UnInitializePort% CDECL ALIAS "_UnInitializePort" (BYVAL port%)
DECLARE FUNCTION WaitFor% CDECL ALIAS "_WaitFor" (BYVAL port%, BYVAL tmout%, BYVAL ot&, BYVAL in&)
DECLARE FUNCTION WaitForPeek% CDECL ALIAS "_WaitForPeek" (BYVAL port%, BYVAL tmout%, BYVAL ot&, BYVAL in&)
DECLARE FUNCTION WaitForPeekTable% CDECL ALIAS "_WaitForPeekTable" (BYVAL port%, BYVAL tmout%, BYVAL ot&, BYVAL in&)
DECLARE FUNCTION WaitForTable% CDECL ALIAS "_WaitForTable" (BYVAL port%, BYVAL tmout%, BYVAL ot&, BYVAL in&)

