#! /bin/sh
# RE_SID: @(%)/usr/re/builds/pcnfs/unix/pkg/SCCS/s.addpkg.sh 1.2 93/09/17 15:20:34 SMI
#
# Copyright (c) 1992 by Sun Microsystems, Inc.
# All Rights Reserved.
#
#  Sun considers its source code as an unpublished, proprietary
#  trade secret, and it is available only under strict license
#  provisions.  This copyright notice is placed here only to protect
#  Sun in the event the source is deemed a published work.  Dissassembly,
#  decompilation, or other means of reducing the object code to human
#  readable form is prohibited by the license agreement under which
#  this code is provided to the user or company in possession of this
#  copy.
#
#  RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
#  Government is subject to restrictions as set forth in subparagraph
#  (c)(1)(ii) of the Rights in Technical Data and Computer Software
#  clause at DFARS 52.227-7013 and in similar clauses in the FAR and
#  NASA FAR Supplement.
#

DEST=/var/spool/pkg

fatalerror ( )
{
	echo " " ; echo "*** FATAL ERROR: $@" 1>&2 ; exit 1
}

#########
# Put up startup information
#########
echo 
echo "       --------------------------------------"
echo 
echo "This script will uncompress and untar the pkg file containing the"
echo "SUNWpcnfs package ready for the SVR4 pkgadd utility to install"
echo 
echo "You must be root to run this script."
echo 
echo "Are you ready to proceed (y or n [y]): \c"
read YORN
if [ "$YORN" = "n" ]
then
	echo "Exiting from install script."
	exit 0
fi

echo 
if [ -f /usr/ucb/whoami ]
then 
	if [ `/usr/ucb/whoami` != root ]
	then
		echo "You must be root to run this script."
		echo "Exiting from install script."
		exit 1
	fi
fi


#########
# Check for pkg.taz
#########
if [ ! -f pkg.taz ]
then
	fatalerror "The compressed tar file pkg.taz is missing."
fi

#########
# Copy the pkg.taz file and unpack it
#########

echo "Copying pkg.taz to $DEST/pkg.tar.Z"
cp pkg.taz $DEST/pkg.tar.Z

CURDIR=`pwd`

cd $DEST

echo " "
echo "Uncompressing the $DEST/pkg.tar.Z file."
uncompress -v pkg.tar.Z
if [ $? != 0 ] ; then
	fatalerror "Uncompressing pkg.tar failed."
fi

echo " "
echo "Unpacking the pkg.tar file."
tar -xvf pkg.tar
if [ $? != 0 ] ; then
	fatalerror "Unpacking files from pkg.tar failed."
fi

rm pkg.tar
cd $CURDIR

#########
# Done
#########
echo 
echo "The SUNWpcnfs package is ready to install with the SVR4 utility pkgadd"
echo 
