#! /bin/sh
# RE_SID: @(%)/usr/re/builds/pcnfs/unix/license/SCCS/s.addplum.sh 1.8 94/01/11 17:13:38 SMI
# Copyright (c) 1992 by Sun Microsystems, Inc.
# All Rights Reserved.
#
#  Sun considers its source code as an unpublished, proprietary
#  trade secret, and it is available only under strict license
#  provisions.  This copyright notice is placed here only to protect
#  Sun in the event the source is deemed a published work.  Dissassembly,
#  decompilation, or other means of reducing the object code to human
#  readable form is prohibited by the license agreement under which
#  this code is provided to the user or company in possession of this
#  copy.
#
#  RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
#  Government is subject to restrictions as set forth in subparagraph
#  (c)(1)(ii) of the Rights in Technical Data and Computer Software
#  clause at DFARS 52.227-7013 and in similar clauses in the FAR and
#  NASA FAR Supplement.
#

LICENSE=license
SERVER=rpc.plumd
DB_FILE=pcnfsldb
DEFAULT_DEST=/usr/plum
WHOAMI=/usr/ucb/whoami

fatalerror ( )
{
	echo " " ; echo "*** FATAL ERROR: $@" 1>&2 ; exit 1
}

#########
# Put up startup information
#########
echo 
echo "       --------------------------------------"
echo 
echo "This will install the PC-NFS license server and administrative tool"
echo "on your system."
echo 
echo "Are you ready to proceed (y or n [y]): "
read YORN
if [ "$YORN" = "n" ]
then
	echo "Exiting from install script."
	exit 0
fi

echo 
if [ -f $WHOAMI ] 
	then
	if [ `$WHOAMI` != root ]
	then
		echo "You must be root to run this script."
		echo "Exiting from install script."
		exit 1
	fi
else
	if [ `whoami` != root ]
	then
		echo "You must be root to run this script."
		echo "Exiting from install script."
		exit 1
	fi
fi
	


#########
# Check for $LICENSE.taz
#########
if [ ! -f $LICENSE.taz ]
then
	fatalerror "The compressed tar file $LICENSE.taz is missing."
fi

#########
# Ask for destination directory and create it.
#########
echo  "Install licensing software in: [$DEFAULT_DEST]: "
read DEST
if [ ! -f ${DEST:=$DEFAULT_DEST} ]
then
	echo "Creating $DEST"
	mkdir $DEST
fi

#########
# Copy the $LICENSE.taz file and unpack it
#########

echo "Installing licensing software in $DEST"
cp $LICENSE.taz $DEST

CURDIR=`pwd`

cd $DEST

echo " "
echo "Uncompressing the $LICENSE.taz file."
mv -f $LICENSE.taz $LICENSE.tar.Z
uncompress -v $LICENSE.tar.Z
if [ $? != 0 ] ; then
	fatalerror "Uncompressing $LICENSE.taz failed."
fi

echo " "
echo "Unpacking the $LICENSE.tar file."
tar -xvf $LICENSE.tar
if [ $? != 0 ] ; then
	fatalerror "Unpacking files from $LICENSE.tar failed."
fi

rm $LICENSE.tar
cd $CURDIR

#########
# Add to RC file?
#
# If the installer says yes, add the appropriate line to /etc/rc.local.
# If the installer has set the destination to be something other than
# the default, /usr/plum, then we must also add a -f option so plumd can
# locate the database (default is /usr/plum/pcnfsldb)
#########
echo 
echo "Do you wish to have the license server $SERVER started automatically"
echo  "when this system boots (y or n [y]): "
read YORN
if [ "$YORN" != "n" ]
then
	echo "Adding $SERVER to /etc/rc.local"
	if [ $DEST != $DEFAULT_DEST ]
	then
# Edit rc.local and add rpc.plumd with -f option
		ed - /etc/rc.local << EOFSTRING  > /dev/null
a
#
# Start the PC-NFS License Server
#
if [ -f $DEST/$SERVER ]; then
	$DEST/$SERVER -f $DEST/$DB_FILE &	echo "PC-NFS License Server"
fi
.
w
q
EOFSTRING
	else
# Edit rc.local and add rpc.plumd with -f option
		ed - /etc/rc.local << EOFSTRING  > /dev/null
a
#
# Start the PC-NFS License Server
#
if [ -f $DEST/$SERVER ]; then
	$DEST/$SERVER &		echo "PC-NFS License Server"
fi
.
w
q
EOFSTRING
	fi
fi
echo

#########
# Installation done
#########
echo 
echo "Installation complete."
echo 
echo "For each user who will use the administrative tool, plum, you must"
echo "add $DEST to the PATH and HELPPATH environment variables."
echo 
