/*
** olemisc.h
** This include file is a combination of parts of avexpt.h and pdexpt.h.
** It contains enumerated data types and constants necessary for some of
** the OLE method parameters. Some will not be useful for automation, e.g.,
** the SetPageMode parameter: PDFullScreen. 
** (c) Copyright 1994, Adobe Systems, Inc.  All Rights Reserved.
*/
/* 
** AV Application Preferences data type
*/
typedef enum _t_APrefsType {
	avpPrefsVersion,			/* Int32 */
	avpOpenDialogAtStartup,		/* boolean */
	avpShowSplashAtStartup,		/* boolean */
	avpShowToolBar,				/* boolean */
	avpRememberDialogs,			/* boolean */
	avpShortMenus,				/* boolean */				
	avpDefaultOverviewType,		/* Int32  */
	avpDefaultZoomScale,		/* Fixed */
	avpDefaultZoomType,			/* Int32 */
	avpShowLargeImages,			/* boolean */
	avpGreekText,				/* boolean */
	avpGreekLevel,				/* Int32 */
	avpSubstituteFontType,		/* Int32 */
   avpDoCalibratedColor,		/* boolean */
   avpSkipWarnings,			/* boolean */
	avpPSLevel,					/* Int32 */
	avpShrinkToFit,				/* boolean */
	avpCaseSensitive,			/* boolean */
	avpWholeWords,				/* boolean */
	avpNoteColor,				/* PDColorValue */
	avpNoteLabel,				/* char* */
	avpMaxThreadZoom,			/* Fixed */
	avpEnablePageCache,			/* boolean */
	avpFullScreenColor,			/* PDColorValue */
	avpUnused1,					/* obsolete */
	avpMaxPageCacheZoom,		/* Fixed: pages whose zoom > this will not be cached */
	avpMinPageCacheTicks,		/* Int32: pages which take < this to render will not be cached */
	avpMaxPageCacheBytes,		/* Int32: overall constraint on storage used by cache */
	avpUnused2,					/* obsolete */
	avpFullScreenChangeTimeDelay, /* Int32 */
	avpFullScreenLoop,			  /* boolean */
	avpThumbViewScale,			/* Fixed */
	avpUnused3,					/* obsolete */
	avpDestFitType,				/* char * */
	avpDestZoomInherit,			/* boolean */
	avpHighlightMode,			/* Int32 */
	avpDefaultSplitterPos,		/* Int32 */
	avpUnused4					/* obsolete */
} AVPrefsType;
/* 
** AVZoomType -- used with AVPageViewGetZoomType()/AVPageViewSetZoomType()
** Variable zoom "verbs", corresponding to View menu items
*/
typedef enum _t_AVZoomType {
	AVZoomNoVary,					/* no variable zoom */
	AVZoomFitPage,					/* fit page to window */
	AVZoomFitWidth,					/* fit page width to window */
	AVZoomFitHeight,				/* fit page height to window */
	AVZoomFitVisibleWidth			/* fit visible width to window */
} AVZoomType;

/* PD Things */
/*
** PDPageMode -- used by PDDocGetPageMode()/PDDocSetPageMode().
*/
typedef enum {PDDontCare, 
			  PDUseNone, 
			  PDUseThumbs, 
			  PDUseBookmarks,
			  PDFullScreen
} PDPageMode;

/*
** PDDocFlags -- used by PDDocGetFlags()/SetFlags().
** These flags indicate the state of the document and whether it needs
** to be saved or deleted on close, etc.
** The flags are used as a bit field. More than one value may be set.
** Some flags may be set or get only. Most can be either set or get.
*/
typedef enum {
	PDDocNeedsSave			= 0x0001,	/* document has been modified and needs saving (get/set) */
	PDDocRequiresFullSave	= 0x0002,	/* document cannot be saved incrementally; must
											   be written with PDSaveFull. (get/set)
										*/
	PDDocIsModified			= 0x0004,	/* document has been modified internally, such as 
										   opening/closing bookmarks and annotations, but
										   not in such a way as to warrant saving.
										   (get only)
										*/
	PDDocDeleteOnClose		= 0x0008,	/* document is based on a temporary file which must
										   be deleted when the document is closed or saved.
										   (get/set)
										*/
	PDDocWasRepaired		= 0x0010,	/* document was repaired when opened (get only) */
	PDDocNewMajorVersion	= 0x0020,	/* document major version newer than current (get only) */
	PDDocNewMinorVersion	= 0x0040,	/* document minor version newer than current (get only) */
	PDDocOldVersion			= 0x0080,	/* document version older than current (get only) */
	PDDocSuppressErrors		= 0x0100	/* don't display errors (get/set) */
} PDDocFlags;

/* PDInsertFlags -- used by PDDocInsertPages */
typedef enum {
	PDInsertBookmarks		= 0x0001,	/* insert bookmarks as well as pages */
	PDInsertAll				= 0x1000	/* insert all Catalog and Info dict values as well as pages */
} PDInsertFlags;

/* 
** Page specification defines -- use where a page number or range or count
** is required.
*/
#define PDBeforeFirstPage	((Int32) -1)
#define PDLastPage			((Int32) -2)
#define PDAllPages			((Int32) -3)

/*
** PDSaveType -- replaced by PDSaveFlags 
*/
typedef enum {PDSaveIncremental_A5, 
			  PDSaveFull_A5, 
			  PDSaveCopy_A5,
			  PDSaveLinearized_A5, 
			  PDSaveWithPSHeader_A5
} PDSaveType_A5;

/* Enum for routines that set/get the value of a page's Rotate key. */
typedef enum {
	pdRotate0 = 0,
	pdRotate90 = 90,
	pdRotate180 = 180,
	pdRotate270 = 270
} PDRotate;
