// cviewdoc.h : interface of the CCviewerDoc class
//
/////////////////////////////////////////////////////////////////////////////

#ifndef	_CVIEWDOC_H
#define _CVIEWDOC_H

class CAcroApp;
class CAcroPDDoc;
class CAcroPDPage;

class CCviewerDoc : public CDocument
{
protected: // create from serialization only
	CCviewerDoc();
	DECLARE_DYNCREATE(CCviewerDoc)

// Attributes
public:
protected:
	unsigned long 	NumPages;		// stores # of pages in this document
	unsigned long 	CurPage;        // keeps track of current page #
	int				ViewMode;		// keeps track of view sizing mode 			
	short			nScale;			// current scale percentage for doc
	int				OldWidth; 		// keeps last width of window
	int 			OldHeight;		// keeps last height of window

// Operations
public:
	unsigned long GetCurPage() { return(CurPage); }
	CAcroApp* 		m_pAcroApp;
	CAcroPDPage* 	m_pAcroPDPage;
	CAcroPDDoc* 	m_pAcroPDDoc;
	void Draw(CDC *pDC, HWND m_hWnd, CPoint Origin);
	void GotoPage(unsigned long NewPage);
	void SetScale(int NewScale);
	void SetToolbarStatusBoxes();	
	CSize GetScaledDocSize(int width, int height);
    void CalculateScale(int width, int height);
    
// Implementation
public:
	virtual ~CCviewerDoc();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	virtual BOOL OnOpenDocument(const char* pszPathName);
	virtual BOOL OnSaveDocument(const char* pszPathName);   	

// Generated message map functions
protected:
	//{{AFX_MSG(CCviewerDoc)
	afx_msg void OnUpdateViewFirstpage(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewLastpage(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewNextpage(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewPrevpage(CCmdUI* pCmdUI);
	afx_msg void OnViewFirstpage();
	afx_msg void OnViewLastpage();
	afx_msg void OnViewNextpage();
	afx_msg void OnViewPrevpage();
	afx_msg void OnViewActualsize();
	afx_msg void OnViewFitpage();
	afx_msg void OnViewFitwidth();
	afx_msg void OnUpdateViewActualsize(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewFitpage(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewFitwidth(CCmdUI* pCmdUI);
	afx_msg void OnZoomButton();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CCviewerDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()
};

 

#endif
/////////////////////////////////////////////////////////////////////////////
