/////////////////////////////////////////////////////////////////////////
// autofunc.cpp

#include "stdafx.h"
#include "acroauto.h"
#include "acrobat.h"

#define MAX_STR 255
static char g_szTemp[MAX_STR+1];

HACROAPP _export AcroAppNew()
{
	CAcroApp* pAcroApp = new CAcroApp;
	
	COleException e;
	if (!pAcroApp->CreateDispatch("AcroExch.App",&e)) {
		return NULL;
	}

	return pAcroApp;
}

void _export AcroAppDelete(HACROAPP hAcroApp)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	delete pAcroApp;
}

BOOL _export AcroAppExit(HACROAPP hAcroApp)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->Exit();
}

BOOL _export AcroAppHide(HACROAPP hAcroApp)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->Hide();
}

BOOL _export AcroAppShow(HACROAPP hAcroApp)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->Show();
}
	
BOOL _export AcroAppCloseAllDocs(HACROAPP hAcroApp)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->CloseAllDocs();
}
BOOL _export AcroAppMenuItemExecute(HACROAPP hAcroApp, LPCSTR szMenuItemName)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->MenuItemExecute(szMenuItemName);
}
LPCSTR _export AcroAppGetActiveTool(HACROAPP hAcroApp)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	CString str = pAcroApp->GetActiveTool();
	strncpy(g_szTemp, str, MAX_STR);
	return g_szTemp;
}
BOOL _export AcroAppSetActiveTool(HACROAPP hAcroApp,LPCSTR szButtonName, BOOL bPersistent)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->SetActiveTool(szButtonName, bPersistent);
}
BOOL _export AcroAppToolButtonRemove(HACROAPP hAcroApp,LPCSTR szButtonName)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->ToolButtonRemove(szButtonName);
}
BOOL _export AcroAppToolButtonIsEnabled(HACROAPP hAcroApp, LPCSTR szButtonName)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->ToolButtonIsEnabled(szButtonName);
}
BOOL _export AcroAppMenuItemRemove(HACROAPP hAcroApp, LPCSTR szMenuItemName)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->MenuItemRemove(szMenuItemName);
}
BOOL _export AcroAppMenuItemIsEnabled(HACROAPP hAcroApp, LPCSTR szMenuItemName)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->MenuItemIsEnabled(szMenuItemName);
}
BOOL _export AcroAppMenuItemIsMarked(HACROAPP hAcroApp, LPCSTR szMenuItemName)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->MenuItemIsMarked(szMenuItemName);
}
long _export AcroAppGetNumAVDocs(HACROAPP hAcroApp)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->GetNumAVDocs();
}
HACROAVDOC _export AcroAppGetAVDoc(HACROAPP hAcroApp, long nIndex)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	LPDISPATCH lpDispatch = pAcroApp->GetAVDoc(nIndex);
	if (!lpDispatch) {
		return NULL;
	}
	CAcroAVDoc* pAcroAVDoc = new CAcroAVDoc();
	pAcroAVDoc->AttachDispatch(lpDispatch);
	return (HACROAVDOC)pAcroAVDoc;
}
HACROAVDOC _export AcroAppGetActiveDoc(HACROAPP hAcroApp)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	LPDISPATCH lpDispatch = pAcroApp->GetActiveDoc();
	if (!lpDispatch) {
		return NULL;
	}
	CAcroAVDoc* pAcroAVDoc = new CAcroAVDoc();
	pAcroAVDoc->AttachDispatch(lpDispatch);
	return (HACROAVDOC)pAcroAVDoc;
}
LPCSTR _export AcroAppGetLanguage(HACROAPP hAcroApp)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	CString str = pAcroApp->GetLanguage();
	strncpy(g_szTemp, str, MAX_STR);
	return g_szTemp;
}
BOOL _export AcroAppLock(HACROAPP hAcroApp, LPCSTR szLockedBy)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->Lock(szLockedBy);
}
BOOL _export AcroAppUnlock(HACROAPP hAcroApp)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->Unlock();
}
BOOL _export AcroAppSetPreference(HACROAPP hAcroApp, short nType, long nValue)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->SetPreference(nType, nValue);
}
long _export AcroAppGetPreference(HACROAPP hAcroApp, short nType)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->GetPreference(nType);
}
BOOL _export AcroAppMaximize(HACROAPP hAcroApp)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	return pAcroApp->Maximize();
}
BOOL _export AcroAppSetFrame(HACROAPP hAcroApp, HACRORECT hAcroRect)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	return pAcroApp->SetFrame(pAcroRect->m_lpDispatch);
}
HACRORECT _export AcroAppGetFrame(HACROAPP hAcroApp)
{
	CAcroApp* pAcroApp = (CAcroApp*) hAcroApp;
	LPDISPATCH lpDispatch = pAcroApp->GetFrame();
	if (!lpDispatch) {
		return NULL;
	}
	CAcroRect* pAcroRect = new CAcroRect();
	pAcroRect->AttachDispatch(lpDispatch);
	return (HACRORECT)pAcroRect;
}

///////////////////////////////////////////////////////////////////////
// AcroPDDoc

HACROPDDOC _export AcroPDDocNew()
{
	CAcroPDDoc* pAcroPDDoc = new CAcroPDDoc;
	
	COleException e;
	if (!pAcroPDDoc->CreateDispatch("AcroExch.PDDoc",&e)) {
		return NULL;
	}

	return (HACROPDDOC)pAcroPDDoc;
}

void _export AcroPDDocDelete(HACROPDDOC hAcroPDDoc)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	delete pAcroPDDoc;
}

BOOL _export AcroPDDocOpen(HACROPDDOC hAcroPDDoc, const char* szFullPath)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->Open(szFullPath);
}

BOOL _export AcroPDDocClose(HACROPDDOC hAcroPDDoc)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->Close();
}

BOOL _export AcroPDDocInsertPages(HACROPDDOC hAcroPDDoc, long nInsertPageAfter, HACROPDDOC hAcroPDDocSource, 
			long nStartPage, long nNumPages, BOOL bBookmarks)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	CAcroPDDoc* pAcroPDDocSource = (CAcroPDDoc*) hAcroPDDocSource;
	return pAcroPDDoc->InsertPages(nInsertPageAfter, pAcroPDDocSource->m_lpDispatch,
		nStartPage, nNumPages, bBookmarks);
}

BOOL _export AcroPDDocReplacePages(HACROPDDOC hAcroPDDoc, long nStartPage, HACROPDDOC hAcroPDDocSource, 
			long nStartSourcePage, long nNumPages, BOOL bMergeTextAnnotations)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	CAcroPDDoc* pAcroPDDocSource = (CAcroPDDoc*) hAcroPDDocSource;
	return pAcroPDDoc->ReplacePages(nStartPage, pAcroPDDocSource->m_lpDispatch,
		nStartSourcePage, nNumPages, bMergeTextAnnotations);
}

BOOL _export AcroPDDocDeletePages(HACROPDDOC hAcroPDDoc, long nStartPage, 
			long nEndPage)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->DeletePages(nStartPage, nEndPage);
}
long _export AcroPDDocGetNumPages(HACROPDDOC hAcroPDDoc)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->GetNumPages();
}
BOOL _export AcroPDDocCreate(HACROPDDOC hAcroPDDoc)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->Create();
}

LPCSTR _export AcroPDDocGetInfo(HACROPDDOC hAcroPDDoc, const char* szInfoKey)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	CString str = pAcroPDDoc->GetInfo(szInfoKey);
	strncpy(g_szTemp, str, MAX_STR);
	return g_szTemp;
}

BOOL _export AcroPDDocSetInfo(HACROPDDOC hAcroPDDoc, const char* szInfoKey, 
			const char* szBuffer)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->SetInfo(szInfoKey, szBuffer);
}

BOOL _export AcroPDDocDeleteThumbs(HACROPDDOC hAcroPDDoc, long nStartPage, 
			long nEndPage)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->DeleteThumbs(nStartPage, nEndPage);
}

BOOL _export AcroPDDocMovePage(HACROPDDOC hAcroPDDoc, long nMoveAfterThisPage, 
			long nPageToMove)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->MovePage(nMoveAfterThisPage, nPageToMove);
}

LPCSTR _export AcroPDDocGetFileName(HACROPDDOC hAcroPDDoc)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	CString str = pAcroPDDoc->GetFileName();
	strncpy(g_szTemp, str, MAX_STR);
	return g_szTemp;
}

long _export AcroPDDocGetPageMode(HACROPDDOC hAcroPDDoc)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->GetPageMode();
}

BOOL _export AcroPDDocSetPageMode(HACROPDDOC hAcroPDDoc, long nPageMode)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->SetPageMode(nPageMode);
}

BOOL _export AcroPDDocCreateThumbs(HACROPDDOC hAcroPDDoc, long nFirstPage, 
			long nLastPage)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->CreateThumbs(nFirstPage, nLastPage);
}

HACROPDTEXTSELECT _export AcroPDDocCreateTextSelect(HACROPDDOC hAcroPDDoc, 
			long nPage, HACRORECT hAcroRect)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	LPDISPATCH lpDispatch = pAcroPDDoc->CreateTextSelect(nPage, pAcroRect->m_lpDispatch);
	if (!lpDispatch) return NULL;
	CAcroPDTextSelect* pAcroPDTextSelect = new CAcroPDTextSelect();
	pAcroPDTextSelect->AttachDispatch(lpDispatch);
	return (HACROPDTEXTSELECT)pAcroPDTextSelect;
}

HACROPDPAGE _export AcroPDDocAcquirePage(HACROPDDOC hAcroPDDoc, long nPage)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	LPDISPATCH lpDispatch = pAcroPDDoc->AcquirePage(nPage);
	if (!lpDispatch) return NULL;
	CAcroPDPage* pAcroPDPage = new CAcroPDPage();
	pAcroPDPage->AttachDispatch(lpDispatch);
	return (HACROPDPAGE)pAcroPDPage;
}

LPCSTR _export AcroPDDocGetInstanceID(HACROPDDOC hAcroPDDoc)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	CString str = pAcroPDDoc->GetInstanceID();
	strncpy(g_szTemp, str, MAX_STR);
	return g_szTemp;
}

LPCSTR _export AcroPDDocGetPermanentID(HACROPDDOC hAcroPDDoc)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	CString str = pAcroPDDoc->GetPermanentID();
	strncpy(g_szTemp, str, MAX_STR);
	return g_szTemp;
}

long _export AcroPDDocGetFlags(HACROPDDOC hAcroPDDoc)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->GetFlags();
}

BOOL _export AcroPDDocSetFlags(HACROPDDOC hAcroPDDoc, long nFlags)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->SetFlags(nFlags);
}

HACROAVDOC _export AcroPDDocOpenAVDoc(HACROPDDOC hAcroPDDoc, const char* szTitle)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	LPDISPATCH lpDispatch = pAcroPDDoc->OpenAVDoc(szTitle);
	if (!lpDispatch) return NULL;
	CAcroAVDoc* pAcroAVDoc = new CAcroAVDoc();
	pAcroAVDoc->AttachDispatch(lpDispatch);
	return (HACROAVDOC)pAcroAVDoc;
}

BOOL _export AcroPDDocSave(HACROPDDOC hAcroPDDoc, short nType, const char* szFullPath)
{
	CAcroPDDoc* pAcroPDDoc = (CAcroPDDoc*) hAcroPDDoc;
	return pAcroPDDoc->Save(nType, szFullPath);
}

//////////////////////////////////////////////////////////////////////////////////
// AcroAVDoc

HACROAVDOC _export AcroAVDocNew()
{
	CAcroAVDoc* pAcroAVDoc = new CAcroAVDoc;
	
	COleException e;
	if (!pAcroAVDoc->CreateDispatch("AcroExch.AVDoc",&e)) {
		return NULL;
	}

	return (HACROAVDOC)pAcroAVDoc;
}

void _export AcroAVDocDelete(HACROAVDOC hAcroAVDoc)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	delete pAcroAVDoc;
}

BOOL _export AcroAVDocOpen(HACROAVDOC hAcroAVDoc, const char* szFullPath, const char* szTempTitle)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroAVDoc->Open(szFullPath, szTempTitle);
}
HACROPDDOC _export AcroAVDocGetPDDoc(HACROAVDOC hAcroAVDoc)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	LPDISPATCH lpDispatch = pAcroAVDoc->GetPDDoc();
	if (!lpDispatch) {
		return NULL;
	}
	CAcroPDDoc* pAcroPDDoc = new CAcroPDDoc();
	pAcroPDDoc->AttachDispatch(lpDispatch);
	return (HACROPDDOC)pAcroPDDoc;
}

HACROAVDOC _export AcroAVDocGetAVPageView(HACROAVDOC hAcroAVDoc)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	LPDISPATCH lpDispatch = pAcroAVDoc->GetAVPageView();
	if (!lpDispatch) {
		return NULL;
	}
	CAcroAVPageView* pAcroAVPageView = new CAcroAVPageView();
	pAcroAVPageView->AttachDispatch(lpDispatch);
	return (HACROAVPAGEVIEW)pAcroAVPageView;
}

BOOL _export AcroAVDocSetViewMode(HACROAVDOC hAcroAVDoc, long nType)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroAVDoc->SetViewMode(nType);
}

BOOL _export AcroAVDocFindText(HACROAVDOC hAcroAVDoc, const char* szText, BOOL bCaseSensitive, BOOL bWholeWordsOnly, BOOL bReset)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroAVDoc->FindText(szText, bCaseSensitive, bWholeWordsOnly, bReset);
}

BOOL _export AcroAVDocClose(HACROAVDOC hAcroAVDoc, BOOL bNoSave)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroAVDoc->Close(bNoSave);
}

long _export AcroAVDocGetViewMode(HACROAVDOC hAcroAVDoc)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroAVDoc->GetViewMode();
}

BOOL _export AcroAVDocPrintPages(HACROAVDOC hAcroAVDoc, long nFirstPage, long nLastPage, long nPSLevel, BOOL bBinaryOk, BOOL bShrinkToFit)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroAVDoc->PrintPages(nFirstPage, nLastPage, nPSLevel, bBinaryOk, bShrinkToFit);
}

BOOL _export AcroAVDocClearSelection(HACROAVDOC hAcroAVDoc)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroAVDoc->ClearSelection();
}

BOOL _export AcroAVDocBringToFront(HACROAVDOC hAcroAVDoc)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroAVDoc->BringToFront();
}

LPCSTR _export AcroAVDocGetTitle(HACROAVDOC hAcroAVDoc)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	CString str = pAcroAVDoc->GetTitle();
	strncpy(g_szTemp, str, MAX_STR);
	return g_szTemp;
}

BOOL _export AcroAVDocMaximize(HACROAVDOC hAcroAVDoc, BOOL bMaxSize)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroAVDoc->Maximize(bMaxSize);
}

BOOL _export AcroAVDocSetTitle(HACROAVDOC hAcroAVDoc, const char* szTitle)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroAVDoc->SetTitle(szTitle);
}

BOOL _export AcroAVDocOpenInWindow(HACROAVDOC hAcroAVDoc, const char* szFullPath, short hWnd)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroAVDoc->OpenInWindow(szFullPath, hWnd);
}

BOOL _export AcroAVDocSetTextSelection(HACROAVDOC hAcroAVDoc, HACROPDTEXTSELECT hAcroPDTextSelect)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	CAcroPDTextSelect* pAcroPDTextSelect = (CAcroPDTextSelect*) hAcroPDTextSelect;
	return pAcroAVDoc->SetTextSelection(pAcroPDTextSelect->m_lpDispatch);
}

BOOL _export AcroAVDocShowTextSelect(HACROAVDOC hAcroAVDoc)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroAVDoc->ShowTextSelect();
}

BOOL _export AcroAVDocSetFrame(HACROAVDOC hAcroAVDoc, HACRORECT hAcroRect)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	return pAcroAVDoc->SetFrame(pAcroRect->m_lpDispatch);
}

HACRORECT _export AcroAVDocGetFrame(HACROAVDOC hAcroAVDoc)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	LPDISPATCH lpDispatch = pAcroAVDoc->GetFrame();
	if (!lpDispatch) {
		return NULL;
	}
	CAcroRect* pAcroRect = new CAcroRect();
	pAcroRect->AttachDispatch(lpDispatch);
	return (HACRORECT)pAcroRect;
}

BOOL _export AcroAVDocIsValid(HACROAVDOC hAcroAVDoc)
{
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroAVDoc->IsValid();
}


//////////////////////////////////////////////////////////////////////////////////
// AcroAVPageView
//
//	There is no way to create this object directly so we don't need a New.
//	We do, however need the delete.
// 

void _export AcroAVPageViewDelete(HACROAVPAGEVIEW hAcroAVPageView)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	delete pAcroAVPageView;
}

BOOL AcroAVPageViewGoTo(HACROAVPAGEVIEW hAcroAVPageView, long nPage)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	return pAcroAVPageView->GoTo(nPage);
}
BOOL AcroAVPageViewZoomTo(HACROAVPAGEVIEW hAcroAVPageView, short nType, short nScale)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	return pAcroAVPageView->ZoomTo(nType, nScale);
}

BOOL AcroAVPageViewScrollTo(HACROAVPAGEVIEW hAcroAVPageView, short nX, short nY)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	return pAcroAVPageView->ScrollTo(nX, nY);
}

BOOL AcroAVPageViewReadPageUp(HACROAVPAGEVIEW hAcroAVPageView)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	return pAcroAVPageView->ReadPageUp();
}

BOOL AcroAVPageViewReadPageDown(HACROAVPAGEVIEW hAcroAVPageView)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	return pAcroAVPageView->ReadPageDown();
}

BOOL AcroAVPageViewDoGoBack(HACROAVPAGEVIEW hAcroAVPageView)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	return pAcroAVPageView->DoGoBack();
}

BOOL AcroAVPageViewDoGoForward(HACROAVPAGEVIEW hAcroAVPageView)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	return pAcroAVPageView->DoGoForward();
}

HACROAVDOC AcroAVPageViewGetAVDoc(HACROAVPAGEVIEW hAcroAVPageView)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	LPDISPATCH lpDispatch = pAcroAVPageView->GetAVDoc();
	if (!lpDispatch) {
		return NULL;
	}
	CAcroAVDoc* pAcroAVDoc = new CAcroAVDoc();
	pAcroAVDoc->AttachDispatch(lpDispatch);
	return (HACROAVDOC)pAcroAVDoc;
}

HACROPDPAGE AcroAVPageViewGetPage(HACROAVPAGEVIEW hAcroAVPageView)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	LPDISPATCH lpDispatch = pAcroAVPageView->GetPage();
	if (!lpDispatch) {
		return NULL;
	}
	CAcroPDPage* pAcroPDPage = new CAcroPDPage();
	pAcroPDPage->AttachDispatch(lpDispatch);
	return (HACROPDPAGE)pAcroPDPage;
}

HACROPDDOC AcroAVPageViewGetDoc(HACROAVPAGEVIEW hAcroAVPageView)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	LPDISPATCH lpDispatch = pAcroAVPageView->GetDoc();
	if (!lpDispatch) {
		return NULL;
	}
	CAcroPDDoc* pAcroPDDoc = new CAcroPDDoc();
	pAcroPDDoc->AttachDispatch(lpDispatch);
	return (HACROAVDOC)pAcroPDDoc;
}

long AcroAVPageViewGetZoom(HACROAVPAGEVIEW hAcroAVPageView)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	return pAcroAVPageView->GetZoom();
}

short AcroAVPageViewGetZoomType(HACROAVPAGEVIEW hAcroAVPageView)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	return pAcroAVPageView->GetZoomType();
}

long AcroAVPageViewGetPageNum(HACROAVPAGEVIEW hAcroAVPageView)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	return pAcroAVPageView->GetPageNum();
}

HACROPOINT AcroAVPageViewPointToDevice(HACROAVPAGEVIEW hAcroAVPageView, HACROPOINT hAcroPoint)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	CAcroPoint* pAcroPoint = (CAcroPoint*) hAcroPoint;
	LPDISPATCH lpDispatch = pAcroAVPageView->PointToDevice(pAcroPoint->m_lpDispatch);
	if (!lpDispatch) {
		return NULL;
	}
	CAcroPoint* pAcroPoint1 = new CAcroPoint();
	pAcroPoint1->AttachDispatch(lpDispatch);
	return (HACROAVDOC)pAcroPoint1;
}

HACROPOINT AcroAVPageViewDevicePointToPage(HACROAVPAGEVIEW hAcroAVPageView, HACROPOINT hAcroPoint)
{
	CAcroAVPageView* pAcroAVPageView = (CAcroAVPageView*) hAcroAVPageView;
	CAcroPoint* pAcroPoint = (CAcroPoint*) hAcroPoint;
	LPDISPATCH lpDispatch = pAcroAVPageView->DevicePointToPage(pAcroPoint->m_lpDispatch);
	if (!lpDispatch) {
		return NULL;
	}
	CAcroPoint* pAcroPoint1 = new CAcroPoint();
	pAcroPoint1->AttachDispatch(lpDispatch);
	return (HACROAVDOC)pAcroPoint1;
}

//////////////////////////////////////////////////////////////////////////////////
// AcroPDPage

//	There is no way to create this object directly so we don't need a New.
//	We do, however need the delete.
// 

void _export AcroPDPageDelete(HACROPDPAGE hAcroPDPage)
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	delete pAcroPDPage;
}

HACROPOINT _export AcroPDPageGetSize(HACROPDPAGE hAcroPDPage)
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	LPDISPATCH lpDispatch = pAcroPDPage->GetSize();
	if (!lpDispatch) {
		return NULL;
	}
	CAcroPoint* pAcroPoint = new CAcroPoint();
	pAcroPoint->AttachDispatch(lpDispatch);
	return (HACROPOINT)pAcroPoint;
}

HACROPDANNOT _export AcroPDPageGetAnnot(HACROPDPAGE hAcroPDPage, long nIndex)
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	LPDISPATCH lpDispatch = pAcroPDPage->GetAnnot(nIndex);
	if (!lpDispatch) {
		return NULL;
	}
	CAcroPDAnnot* pAcroPDAnnot = new CAcroPDAnnot();
	pAcroPDAnnot->AttachDispatch(lpDispatch);
	return (HACROPDANNOT)pAcroPDAnnot;
}

HACROPDANNOT _export AcroPDPageAddNewAnnot(HACROPDPAGE hAcroPDPage, long nIndexAddAfter, 
				const char* szSubType, HACRORECT hAcroRect)
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	LPDISPATCH lpDispatch = pAcroPDPage->AddNewAnnot(nIndexAddAfter, szSubType,
				pAcroRect->m_lpDispatch);
	if (!lpDispatch) {
		return NULL;
	}
	CAcroPDAnnot* pAcroPDAnnot = new CAcroPDAnnot();
	pAcroPDAnnot->AttachDispatch(lpDispatch);
	return (HACROPDANNOT)pAcroPDAnnot;
}

BOOL _export AcroPDPageAddAnnot(HACROPDPAGE hAcroPDPage, long nIndexAddAfter, HACROPDANNOT hAcroPDAnnot)		
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	return pAcroPDPage->AddAnnot(nIndexAddAfter, pAcroPDAnnot->m_lpDispatch);
}

BOOL _export AcroPDPageRemoveAnnot(HACROPDPAGE hAcroPDPage, long nIndex)
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	return pAcroPDPage->RemoveAnnot(nIndex);
}

long _export AcroPDPageGetAnnotIndex(HACROPDPAGE hAcroPDPage, HACROPDANNOT hAcroPDAnnot)
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	return pAcroPDPage->GetAnnotIndex(pAcroPDAnnot->m_lpDispatch);
}

long _export AcroPDPageGetNumAnnots(HACROPDPAGE hAcroPDPage)
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	return pAcroPDPage->GetNumAnnots();
}

HACROPDTEXTSELECT _export AcroPDPageCreatePageHilite(HACROPDPAGE hAcroPDPage, HACROHILITELIST hAcroHiliteList)
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	CAcroHiliteList* pAcroHiliteList = (CAcroHiliteList*) hAcroHiliteList;
	LPDISPATCH lpDispatch = pAcroPDPage->CreatePageHilite(pAcroHiliteList->m_lpDispatch);
	if (!lpDispatch) {
		return NULL;
	}
	CAcroPDTextSelect* pAcroPDTextSelect = new CAcroPDTextSelect();
	pAcroPDTextSelect->AttachDispatch(lpDispatch);
	return (HACROPDTEXTSELECT)pAcroPDTextSelect;
}

HACROPDTEXTSELECT _export AcroPDPageCreateWordHilite(HACROPDPAGE hAcroPDPage, HACROHILITELIST hAcroHiliteList)
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	CAcroHiliteList* pAcroHiliteList = (CAcroHiliteList*) hAcroHiliteList;
	LPDISPATCH lpDispatch = pAcroPDPage->CreateWordHilite(pAcroHiliteList->m_lpDispatch);
	if (!lpDispatch) {
		return NULL;
	}
	CAcroPDTextSelect* pAcroPDTextSelect = new CAcroPDTextSelect();
	pAcroPDTextSelect->AttachDispatch(lpDispatch);
	return (HACROPDTEXTSELECT)pAcroPDTextSelect;
}

HACROPDDOC _export AcroPDPageGetDoc(HACROPDPAGE hAcroPDPage)
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	LPDISPATCH lpDispatch = pAcroPDPage->GetDoc();
	if (!lpDispatch) {
		return NULL;
	}
	CAcroPDDoc* pAcroPDDoc = new CAcroPDDoc();
	pAcroPDDoc->AttachDispatch(lpDispatch);
	return (HACROPDDOC)pAcroPDDoc;
}

long _export AcroPDPageGetNumber(HACROPDPAGE hAcroPDPage)
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	return pAcroPDPage->GetNumber();
}

BOOL _export AcroPDPageDraw(HACROPDPAGE hAcroPDPage, short nHWND, short nHDC, short nXOrigin, short nYOrigin, short nZoom)
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	return pAcroPDPage->Draw(nHWND, nHDC, nXOrigin, nYOrigin, nZoom);
}

BOOL _export AcroPDPageSetRotate(HACROPDPAGE hAcroPDPage, short nRotate)
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	return pAcroPDPage->SetRotate(nRotate);
}

short _export AcroPDPageGetRotate(HACROPDPAGE hAcroPDPage) 
{
	CAcroPDPage* pAcroPDPage = (CAcroPDPage*) hAcroPDPage;
	return pAcroPDPage->GetRotate();
}

////////////////////////////////////////////////////////////////////////////
// AcroPDAnnot

//	There is no way to create this object directly so we don't need a New.
//	We do, however need the delete.
// 

void _export AcroPDAnnotDelete(HACROPDANNOT hAcroPDAnnot)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	delete pAcroPDAnnot;
}

BOOL _export AcroPDAnnotIsValid(HACROPDANNOT hAcroPDAnnot)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	return pAcroPDAnnot->IsValid();
}

LPCSTR _export AcroPDAnnotGetSubtype(HACROPDANNOT hAcroPDAnnot)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	CString str = pAcroPDAnnot->GetSubtype();
	strncpy(g_szTemp, str, MAX_STR);
	return g_szTemp;
}

BOOL _export AcroPDAnnotIsEqual(HACROPDANNOT hAcroPDAnnot, HACROPDANNOT hAcroPDAnnot1)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	CAcroPDAnnot* pAcroPDAnnot1 = (CAcroPDAnnot*) hAcroPDAnnot1;
	return pAcroPDAnnot->IsEqual(pAcroPDAnnot1->m_lpDispatch);
}

long _export AcroPDAnnotGetColor(HACROPDANNOT hAcroPDAnnot)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	return pAcroPDAnnot->GetColor();
}

BOOL _export AcroPDAnnotSetColor(HACROPDANNOT hAcroPDAnnot, long nRGBColor)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	return pAcroPDAnnot->SetColor(nRGBColor);
}

LPCSTR _export AcroPDAnnotGetTitle(HACROPDANNOT hAcroPDAnnot)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	CString str = pAcroPDAnnot->GetTitle();
	strncpy(g_szTemp, str, MAX_STR);
	return g_szTemp;
}

BOOL _export AcroPDAnnotSetTitle(HACROPDANNOT hAcroPDAnnot, const char* szTitle)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	return pAcroPDAnnot->SetTitle(szTitle);
}

LPCSTR _export AcroPDAnnotGetContents(HACROPDANNOT hAcroPDAnnot)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	CString str = pAcroPDAnnot->GetContents();
	strncpy(g_szTemp, str, MAX_STR);
	return g_szTemp;
}

BOOL _export AcroPDAnnotSetContents(HACROPDANNOT hAcroPDAnnot, const char* szContents)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	return pAcroPDAnnot->SetContents(szContents);
}

BOOL _export AcroPDAnnotIsOpen(HACROPDANNOT hAcroPDAnnot)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	return pAcroPDAnnot->IsOpen();
}

BOOL _export AcroPDAnnotSetOpen(HACROPDANNOT hAcroPDAnnot, BOOL bIsOpen)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	return pAcroPDAnnot->SetOpen(bIsOpen);
}

HACRORECT _export AcroPDAnnotGetRect(HACROPDANNOT hAcroPDAnnot)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	LPDISPATCH lpDispatch = pAcroPDAnnot->GetRect();
	if (!lpDispatch) {
		return NULL;
	}
	CAcroRect* pAcroRect = new CAcroRect();
	pAcroRect->AttachDispatch(lpDispatch);
	return (HACRORECT)pAcroRect;
}

BOOL _export AcroPDAnnotSetRect(HACROPDANNOT hAcroPDAnnot, HACRORECT hAcroRect)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	return pAcroPDAnnot->SetRect(pAcroRect->m_lpDispatch);
}

HACROTIME _export AcroPDAnnotGetDate(HACROPDANNOT hAcroPDAnnot)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	LPDISPATCH lpDispatch = pAcroPDAnnot->GetDate();
	if (!lpDispatch) {
		return NULL;
	}
	CAcroTime* pAcroTime = new CAcroTime();
	pAcroTime->AttachDispatch(lpDispatch);
	return (HACRORECT)pAcroTime;
}

BOOL _export AcroPDAnnotSetDate(HACROPDANNOT hAcroPDAnnot, HACROTIME hAcroTime)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	return pAcroPDAnnot->SetDate(pAcroTime->m_lpDispatch);
}

BOOL _export AcroPDAnnotPerform(HACROPDANNOT hAcroPDAnnot, HACROAVDOC hAcroAVDoc)
{
	CAcroPDAnnot* pAcroPDAnnot = (CAcroPDAnnot*) hAcroPDAnnot;
	CAcroAVDoc* pAcroAVDoc = (CAcroAVDoc*) hAcroAVDoc;
	return pAcroPDAnnot->Perform(pAcroAVDoc->m_lpDispatch);
}

///////////////////////////////////////////////////////////////////////
// AcroPoint

HACROPOINT _export AcroPointNew()
{
	CAcroPoint* pAcroPoint = new CAcroPoint;
	
	COleException e;
	if (!pAcroPoint->CreateDispatch("AcroExch.Point",&e)) {
		return NULL;
	}

	return pAcroPoint;
}

void _export AcroPointDelete(HACROPOINT hAcroPoint)
{
	CAcroPoint* pAcroPoint = (CAcroPoint*) hAcroPoint;
	delete pAcroPoint;
}

short _export AcroPointGetX(HACROPOINT hAcroPoint)
{
	CAcroPoint* pAcroPoint = (CAcroPoint*) hAcroPoint;
	return pAcroPoint->GetX();
}

void _export AcroPointSetX(HACROPOINT hAcroPoint, short nX)
{
	CAcroPoint* pAcroPoint = (CAcroPoint*) hAcroPoint;
	pAcroPoint->SetX(nX);
}

short _export AcroPointGetY(HACROPOINT hAcroPoint)
{
	CAcroPoint* pAcroPoint = (CAcroPoint*) hAcroPoint;
	return pAcroPoint->GetY();
}

void _export AcroPointSetY(HACROPOINT hAcroPoint, short nY)
{
	CAcroPoint* pAcroPoint = (CAcroPoint*) hAcroPoint;
	pAcroPoint->SetY(nY);
}


/////////////////////////////////////////////////////////////////////////////
// AcroRect


HACRORECT _export AcroRectNew()
{
	CAcroRect* pAcroRect = new CAcroRect;
	
	COleException e;
	if (!pAcroRect->CreateDispatch("AcroExch.Rect",&e)) {
		return NULL;
	}

	return pAcroRect;
}

void _export AcroRectDelete(HACRORECT hAcroRect)
{
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	delete pAcroRect;
}

short _export AcroRectGetLeft(HACRORECT hAcroRect)
{
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	return pAcroRect->GetLeft();
}

void _export AcroRectSetLeft(HACRORECT hAcroRect, short nLeft)
{
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	pAcroRect->SetLeft(nLeft);
}
short _export AcroRectGetTop(HACRORECT hAcroRect)
{
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	return pAcroRect->GetTop();
}
void _export AcroRectSetTop(HACRORECT hAcroRect, short nTop)
{
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	pAcroRect->SetTop(nTop);
}
short _export AcroRectGetRight(HACRORECT hAcroRect)
{
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	return pAcroRect->GetRight();
}
void _export AcroRectSetRight(HACRORECT hAcroRect, short nRight)
{
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	pAcroRect->SetRight(nRight);
}
short _export AcroRectGetBottom(HACRORECT hAcroRect)
{
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	return pAcroRect->GetBottom();
}
void _export AcroRectSetBottom(HACRORECT hAcroRect, short nBottom)
{
	CAcroRect* pAcroRect = (CAcroRect*) hAcroRect;
	pAcroRect->SetBottom(nBottom);
}

/////////////////////////////////////////////////////////////////////////////
// AcroTime 


HACROTIME _export AcroTimeNew()
{
	CAcroTime* pAcroTime = new CAcroTime;
	
	COleException e;
	if (!pAcroTime->CreateDispatch("AcroExch.Time",&e)) {
		return NULL;
	}

	return pAcroTime;
}

void _export AcroTimeDelete(HACROTIME hAcroTime)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	delete pAcroTime;
}

short _export AcroTimeGetYear(HACROTIME hAcroTime)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	return pAcroTime->GetYear();
}
void _export AcroTimeSetYear(HACROTIME hAcroTime, short nYear)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	pAcroTime->SetYear(nYear);
}
short _export AcroTimeGetMonth(HACROTIME hAcroTime)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	return pAcroTime->GetMonth();
}
void _export AcroTimeSetMonth(HACROTIME hAcroTime, short nMonth)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	pAcroTime->SetMonth(nMonth);
}
short _export AcroTimeGetDate(HACROTIME hAcroTime)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	return pAcroTime->GetDate();
}
void _export AcroTimeSetDate(HACROTIME hAcroTime, short nDate)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	pAcroTime->SetDate(nDate);
}
short _export AcroTimeGetHour(HACROTIME hAcroTime)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	return pAcroTime->GetHour();
}
void _export AcroTimeSetHour(HACROTIME hAcroTime, short nHour)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	pAcroTime->SetHour(nHour);
}
short _export AcroTimeGetMinute(HACROTIME hAcroTime)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	return pAcroTime->GetMinute();
}
void _export AcroTimeSetMinute(HACROTIME hAcroTime, short nMinute)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	pAcroTime->SetMinute(nMinute);
}
short _export AcroTimeGetSecond(HACROTIME hAcroTime)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	return pAcroTime->GetSecond();
}
void _export AcroTimeSetSecond(HACROTIME hAcroTime, short nSecond)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	pAcroTime->SetSecond(nSecond);
}
short _export AcroTimeGetMillisecond(HACROTIME hAcroTime)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	return pAcroTime->GetMillisecond();
}
void _export AcroTimeSetMillisecond(HACROTIME hAcroTime, short nMillisecond)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	pAcroTime->SetMillisecond(nMillisecond);
}
short _export AcroTimeGetDay(HACROTIME hAcroTime)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	return pAcroTime->GetDay();
}
void _export AcroTimeSetDay(HACROTIME hAcroTime, short nDay)
{
	CAcroTime* pAcroTime = (CAcroTime*) hAcroTime;
	pAcroTime->SetDay(nDay);
}

/////////////////////////////////////////////////////////////////////////////
// AcroPDTextSelect
//
//	There is no way to create this object directly so we don't need a New.
//	We do, however need the delete.
// 

void _export AcroPDTextSelectDelete(HACROPDTEXTSELECT hAcroPDTextSelect)
{
	CAcroPDTextSelect* pAcroPDTextSelect = (CAcroPDTextSelect*) hAcroPDTextSelect;
	delete pAcroPDTextSelect;
}

BOOL _export AcroPDTextSelectDestroy(HACROPDTEXTSELECT hAcroPDTextSelect)
{
	CAcroPDTextSelect* pAcroPDTextSelect = (CAcroPDTextSelect*) hAcroPDTextSelect;
	return pAcroPDTextSelect->Destroy();
}

long _export AcroPDTextSelectGetNumText(HACROPDTEXTSELECT hAcroPDTextSelect)
{
	CAcroPDTextSelect* pAcroPDTextSelect = (CAcroPDTextSelect*) hAcroPDTextSelect;
	return pAcroPDTextSelect->GetNumText();
}

HACRORECT _export AcroPDTextSelectGetBoundingRect(HACROPDTEXTSELECT hAcroPDTextSelect)
{
	CAcroPDTextSelect* pAcroPDTextSelect = (CAcroPDTextSelect*) hAcroPDTextSelect;
	LPDISPATCH lpDispatch = pAcroPDTextSelect->GetBoundingRect();
	if (!lpDispatch) {
		return NULL;
	}
	CAcroRect* pAcroRect = new CAcroRect();
	pAcroRect->AttachDispatch(lpDispatch);
	return (HACRORECT)pAcroRect;
}

long _export AcroPDTextSelectGetPage(HACROPDTEXTSELECT hAcroPDTextSelect)
{
	CAcroPDTextSelect* pAcroPDTextSelect = (CAcroPDTextSelect*) hAcroPDTextSelect;
	return pAcroPDTextSelect->GetPage();
}

LPCSTR _export AcroPDTextSelectGetText(HACROPDTEXTSELECT hAcroPDTextSelect, long nTextIndex)
{
	CAcroPDTextSelect* pAcroPDTextSelect = (CAcroPDTextSelect*) hAcroPDTextSelect;
	CString str = pAcroPDTextSelect->GetText(nTextIndex);
	strncpy(g_szTemp, str, MAX_STR);
	return g_szTemp;
}

/////////////////////////////////////////////////////////////////////////////
// AcroHiliteList 

HACROHILITELIST _export AcroHiliteListNew()
{
	CAcroHiliteList* pAcroHiliteList = new CAcroHiliteList;
	
	COleException e;
	if (!pAcroHiliteList->CreateDispatch("AcroExch.HiliteList",&e)) {
		return NULL;
	}

	return pAcroHiliteList;
}

void _export AcroHiliteListDelete(HACROHILITELIST hAcroHiliteList)
{
	CAcroHiliteList* pAcroHiliteList = (CAcroHiliteList*) hAcroHiliteList;
	delete pAcroHiliteList;
}

BOOL _export AcroHiliteListAdd(HACROHILITELIST hAcroHiliteList, short nOffset, short nLength)
{
	CAcroHiliteList* pAcroHiliteList = (CAcroHiliteList*) hAcroHiliteList;
	return pAcroHiliteList->Add(nOffset, nLength);
}


