/****************************************************************************/
/*																																					*/
/* UW.H																																			*/
/*																																					*/
/* This is the main header for uWin, containing all the defines and					*/
/* typedefs for the program.																								*/
/*																													Kevin Huck			*/
/*																													Boyd Gafford		*/
/*																																					*/
/****************************************************************************/
#ifndef __UW_H
#define __UW_H

#include <dos.h>							/* for the REGS definition used for mouse int	*/
#include <stdlib.h>
#include <time.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>

#ifndef __ZTC__
#ifdef M_I86								/* Microsofts are malloc.h and memory.h        */
	#include <malloc.h>
	#include <memory.h>
	#include <sys\types.h>
	#pragma pack(1)
#else												/* Borlands are alloc.h and mem.h              */
	#include <alloc.h>
	#include <mem.h>
#endif
#endif

#ifdef M_I86
#include <stddef.h>
#define setmem(p,c,v)				memset((p),(v),(c))
#define movmem(s,d,c)				memmove((d),(s),(c))
#define random(x)       		(rand() % (x))
#define bioskey(c)					_bios_keybrd(c)
#define biosprint(s, d, p)	_bios_printer(s, p, d)
#define getvect(i)          _dos_getvect(i)
#define setvect(i,hdlr)     _dos_setvect(i,hdlr)
#define enable              _enable
#define disable             _disable
#define setcolor            _setcolor
#define moveto              _moveto
#define lineto              _lineto
#define outbyte outp
#define inbyte  inp
#define outword outpw
#define inword  inpw
struct  REGPACK {
    unsigned    r_ax, r_bx, r_cx, r_dx;
    unsigned    r_bp, r_si, r_di, r_ds, r_es, r_flags;
};
enum COLORS {
	BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN,
	LIGHTGRAY, DARKGRAY, LIGHTBLUE, LIGHTGREEN,
	LIGHTCYAN, LIGHTRED, LIGHTMAGENTA, YELLOW, WHITE
};
#define C80  3
#define BW80 2
#define MONO 7
#else
#define outbyte outportb
#define inbyte  inportb
#define outword outport
#define inword  inport
#endif

#ifdef __POWERC
	#define C80 	3
	#define BW80  2
	#define MONO	7
enum COLORS {
	BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN,
	LIGHTGRAY, DARKGRAY, LIGHTBLUE, LIGHTGREEN,
	LIGHTCYAN, LIGHTRED, LIGHTMAGENTA, YELLOW, WHITE
};
#endif

#ifdef __ZTC__
#include <int.h>
#define interrupt
#define O_TRUNC 0
#define O_BINARY 0
#define enable  int_on
#define disable int_off
#endif

/*-------------------------------- debug defines ---------------------------*/
#ifdef ENQ_DEBUG 
#define DBG_POP()  dbg_pop()
#define ENQ_ERROR( p1, p2, s1, s2, p ) enq_error( p1, p2, s1, s2, p )
#define WNP_VLD( s, m, wnp )           wnp_vld( s, m, wnp )
#define PRTP_VLD( s, m, prtp )         prtp_vld( s, m, prtp )
#define P_VLD( s, gp )                 p_vld( s, gp )
#define MENUP_VLD( s, m, menup )       menup_vld( s, m, menup )
#define DBG_LOG( fname )               dbg__log( fname )
#else
#define DBG_POP()
#define ENQ_ERROR( p1, p2, s1, s2, p )
#define WNP_VLD( s, m, wnp )
#define PRTP_VLD( s, m, prtp )
#define P_VLD( s, gp )
#define MENUP_VLD( s, m, menup )
#define DBG_LOG( fname )
#endif


/*------------------------ rectangle operation defines ---------------------*/
#define 	NO_OVERLAP			0
#define		OVERLAP					1
#define		FIRST_ENCLOSED	2
#define		SECOND_ENCLOSED	3

/*---------------------------- general defines -----------------------------*/
#define   ON        1
#define   OFF       0
#define   UP        0
#define   DOWN      1
#define   LEFT      2
#define   RIGHT     3

/*------------------------------ menuing defines ---------------------------*/
#define 	M_HORIZONTAL			0
#define 	M_VERTICAL				1
#define 	M_MAX_ENTRIES			20
#define		M_GET_EVENT				0
#define		M_PROC_EVENT			1
#define		M_EXIT_ON_ESC 		1


/*---------------------------- mouse defines -------------------------------*/
#define		TDELAY (clock_t) 4	/* clock ticks to check for multiple clicks		*/
#define		LB				0					/* m_event->flag is 4 for left button 				*/
#define		MB				2					/* m_event->flag is 64 for middle button			*/
#define		RB				1					/* m_event->flag is 16 for right button				*/

/*---------------------------- window defines ------------------------------*/
#define   NO_BDR    0
#define   SGL_BDR   1
#define   DBL_BDR   2
#define   SLD_BDR   3
#define		DUAL_BDR	4

#define   CENTERED   -1
#define   LEFT_JUST  -2
#define   RIGHT_JUST -3

#define 	ALPHA  		 'A'
#define 	DIGITS  	 'D'
#define 	C_LINE			0
#define 	C_SBLOCK    1
#define 	C_FBLOCK    2

#define   IN   		  0
#define   OUT  			1
#define   BUFF 			0
#define   SAVE			1

#define		WN_POPUP	1
#define		WN_NORMAL	0

#define   DELETE    1
#define   INSERT    0

#define   STRIP_ON  1
#define   STRIP_OFF 0

/*----------------------- printer support defines --------------------------*/
#define PRT_BLOCK 2048
#define MAX_PRINTERS 4

#define BLOCK_SIZE 512

#define READ  0
#define WRITE 1

/*------------------------- flags for wn_gets_ll ---------------------------*/
#define G_STRIP          0x0001
#define G_STRIP_END      0x0002
#define G_UP_FST_CHAR    0x0004
#define G_ARROW          0x0008
#define G_VALIDATE       0x0010
#define G_RIGHT_TO_LEFT  0x0020
#define G_EXIT_ON_FILL   0x0040
#define G_CLEAR_ON_FIRST 0x0080
#define G_UP_FST_CHAR2   0x0100
#define G_MOVE_TO_END    0x0200
#define G_INSERT         0x0400


#define H_ENTRY          0
#define H_PROCESS        1
#define H_EXIT           2

/*-------------------------- base level typedefs ---------------------------*/
typedef unsigned char uchar;
typedef unsigned int  uint;
typedef unsigned long ulong;

/*---------------------------- mouse structures ----------------------------*/
typedef struct reset_struct
{
	int exists;
	int n_buttons;
} M_RESET;

typedef struct loc_struct
{
	int button_status;
	int count;
	int col;
	int row;
} M_LOC;

typedef struct move_struct
{
	int h_count;
	int v_count;
} M_MOVE;

typedef struct event_struct
{
	int		  is_mouse;
	int			key;
	int			mod;
	int			m_x, m_y;
	int  		m_count, m_button;
} EVENT;

/*---------------------------- rectangle structure -------------------------*/
typedef struct rect_struct
{
	int x_min, x_max, y_min, y_max;					/* rectangle coordinates 					*/
} RECT;


/*--------------------------- window structure -----------------------------*/
typedef struct w_struct
{
	struct w_struct	*next;									/* next window in linked list			*/
	struct w_struct	*previous;							/* previous window in list				*/
	RECT						pane;                   /* the window rectangle           */
	RECT						old_pane;               /* for full size toggle           */
	int							rows;										/* save buffer rows and columns		*/
	int							cols;
	int 						csr_x;                  /* the "soft" cursor location     */
	int 						csr_y;
	uchar						att;                    /* the window's attribute         */
	uchar						bdr_att;                /* the window's border attribute  */
	int 						bdr_style;              /* the border style               */
	int 						name_loc;								/* CENTERED, LEFTJUST, RIGHTJUST	*/
	char						*name;                  /* pointer to window name         */
	uchar						*save;									/* pointer to save buffer area		*/
	uchar						*buff;									/* pointer to write buffer area		*/
	uchar						*mask;									/* pointer to window buffer mask	*/

	uchar           *tabs;									/* tab stops                      */
	int							reg_s, reg_e;						/* scroll region start and end		*/

	unsigned				hidden			: 1;        /* 1 if window hidden             */
	unsigned				overlapped	: 1;        /* 1 if window overlapped         */
	unsigned				csr_adv			: 1;				/* 1 if cursor auto advanced      */
	unsigned 				inside      : 1;				/* 1 if bordered and inside  			*/
	unsigned 				mask_on     : 1;				/* 1 if window mask is active			*/
	unsigned				popup				:	1;				/* 1 if window is popup						*/
	unsigned 				scroll      : 1;				/* 1 if window auto-scrolls				*/
	unsigned				bs_clear		: 1;				/* 1 if backspace is destructive	*/

	unsigned				eol_wrap		: 1;				/* 1 if cursor wraps at end of ln */
	unsigned 				mgr_flag    : 1;				/* 1 if win in manager's list	  	*/
	unsigned 				set_flag    : 1;				/* 1 if window is set on screen  	*/
	unsigned 				cr_flag     : 1;				/* 1 if cr processed            	*/
	unsigned 				lf_flag     : 1;				/* 1 if lf processed            	*/
	unsigned 				cr_lf_flag  : 1;				/* 1 if cr or lf act as cr/lf pair*/
	unsigned 				bk_flag     : 1;				/* 1 if backspace processed       */
	unsigned 				tab_flag    : 1;				/* 1 if tab processed            	*/

	unsigned 				bell_flag   : 1;				/* 1 if bell char processed       */
	unsigned				w_wrap			: 1;				/* 1 if word wrap on  						*/
	unsigned				unused			: 14;

	void            *usr_ptr;     	        /* user expansion pointer         */
	uchar           usr_exp[4];							/* user expansion space						*/
                                          /* DO NOT USE BELOW VARIABLES     */
	void            *sys_ptr;               /* system expansion pointer       */
	uchar           sys_exp[4];						  /* system expansion space					*/
} WINDOW;

/*---------------------------- menu structure ------------------------------*/
typedef struct menu_struct
{
	WINDOW		*wnp;															/* the window for output			*/
	int				direction;							  				/* menu direction, vt or hz   */
	int 			num_entries;											/* number of entries in menu	*/
	uchar			csr_att;													/* the cursor attribute				*/
	uchar			first_att;												/* the first letter attribute	*/
	int				csr_pos;													/* current cursor position		*/
	uchar			first_pos[M_MAX_ENTRIES];					/* first letter position      */
	int 			id[M_MAX_ENTRIES];								/* id value for each entry		*/
	uchar			x[M_MAX_ENTRIES];									/* x location for each entry	*/
	char			*entry[M_MAX_ENTRIES];						/* array of char pointers			*/
} MENU;

typedef struct printer
{
	int   active;											/* set to 1 if printer init'd/active    */
	int   halt;                       /* set to 1 to temporarily stop printer */
	int   prt_dev;                    /* file handle for printer device				*/
	char  device[81];                 /* name of printer device               */
	int   prt_buff[2];								/* file handles for printer buffer			*/
	char  buffer[81];                 /* name of printer buffer               */
	int   cr_cnt;                     /* number of carriage returns to send   */
	int   lf_cnt;     		            /* number of line feeds to send         */
	int   block_mode;									/* allows faster output on block devices*/

	long  max_que_size;								/* maximum size of print que	  				*/
	long  init_que_size;							/* initial size of print que						*/
	long  curr_que_size;							/* current size of print que						*/
	long  read;												/* print que read  index                */
	long  write;                      /* print que write index                */
	long  cnt;                       	/* print que cnt (number of bytes in q) */

	uchar *que;			                  /* pointer to print que data            */
	uchar *xlat;                      /* pointer to translation table					*/
	int   xlat_flag;                  /* translation flag											*/
} PRINT;

/*----------------------------- generic macros -----------------------------*/
#define UW_FP_SEG(fp)     ((uint)((ulong)((void far *)(fp)) >> 16))
#define UW_FP_OFF(fp)	    ((uint)((void far *)(fp)))
#define UW_MK_FP(seg,off) ((void far *)(((ulong)(seg)<<16) | (uint)(off)))

#define lower(x, y)	  	(((x) < (y)) ? (x) : (y))
#define upper(x, y) 	 	(((x) > (y)) ? (x) : (y))
#define lobyte(c)			  (uchar) ((c) & 0x00ff)
#define hibyte(c)			  (uchar) ((c) >> 8)
#define range(l,b,h)    ((((b) >= (l)) && ((b) <= (h))))
#define swap(a,b,c)	  	( (c) = (a), (a) = (b), (b) = (c) )

#ifndef min
#define min(x, y) 		 	(((x) < (y)) ? (x) : (y))
#define max(x, y)  			(((x) > (y)) ? (x) : (y))
#endif

/*------------------------- compatibility macros ---------------------------*/
#define refresh_rect(rect)					redisplay_rect(&(rect))
#define rect_equal(rect1,rect2)			is_rect_equal(&(rect1), &(rect2))
#define cr_inrect(c,r,rect)					col_row_inrect(c, r, &(rect))
#define add_window(wnp)							link_window(wnp)
#define remove_window(wnp)					remove_window_ll(1, wnp)

/*----------------------------- window macros ------------------------------*/
#ifndef ENQ_DEBUG
#ifndef SOURCE_TRACE
#define wn_att(a,wnp) 	    	( (wnp)->att = (a) )
#define wn_color(f,b,wnp)	  	( (wnp)->att = ((b) << 4) | (f) )
#define wn_bdratt(a,wnp)	  	( (wnp)->bdr_att = (a) )
#define wn_bdr_color(f,b,wnp)	( (wnp)->bdr_att = ((b) << 4) | (f) )
#define mv_cs(c,r,wnp)				( (wnp)->csr_x = (c), (wnp)->csr_y = (r) )
#define wn_rqty(wnp)					( (wnp)->inside ? ((wnp)->rows - 2) : (wnp)->rows )
#define wn_sqty(wnp)					( (wnp)->reg_e - (wnp)->reg_s )
#define wn_cqty(wnp)					( (wnp)->inside ? ((wnp)->cols - 2) : (wnp)->cols )
#define wn_name(n, wnp)				( (wnp)->name = (n) )
#define wn_name_loc(l, wnp)		( (wnp)->name_loc = (l) )
#define wn_save( wnp )				( wn_io( IN, SAVE, (wnp)) )
#define wn_restore( wnp )			( wn_io(OUT, SAVE, (wnp)) )
#define wn_rfsh( wnp )				( wn_io(OUT, BUFF, (wnp)) )
#define wn_read( wnp )				( wn_io( IN, BUFF, (wnp)) )

#define wn_get_csr_x(wnp)           ((wnp)->csr_x)
#define wn_get_csr_y(wnp)           ((wnp)->csr_y)
#define wn_get_att(wnp) 	        	((wnp)->att)
#define wn_get_bdratt(wnp) 	        ((wnp)->bdr_att)
#define wn_get_rows(wnp) 	        	((wnp)->rows)
#define wn_get_cols(wnp) 	          ((wnp)->cols)
#define wn_get_bdr_style(wnp) 	    ((wnp)->bdr_style)
#define wn_get_name_loc(wnp) 	      ((wnp)->name_loc)

#define wn_is_hidden(wnp)	          ((wnp)->hidden)     
#define wn_is_overlapped(wnp)       ((wnp)->overlapped) 
#define wn_is_csr_adv(wnp)          ((wnp)->csr_adv)    
#define wn_is_inside(wnp)           ((wnp)->inside)     
#define wn_is_mask_on(wnp)          ((wnp)->mask_on)    
#define wn_is_popup(wnp)	          ((wnp)->popup)      
#define wn_is_scroll(wnp)           ((wnp)->scroll)     
#define wn_is_bs_clear(wnp)         ((wnp)->bs_clear)   
#define wn_is_eol_wrap(wnp)         ((wnp)->eol_wrap)   
#define wn_is_mgr_flag(wnp)         ((wnp)->mgr_flag)   
#define wn_is_set_flag(wnp)         ((wnp)->set_flag)   
#define wn_is_cr_flag(wnp)          ((wnp)->cr_flag)    
#define wn_is_lf_flag(wnp)          ((wnp)->lf_flag)    
#define wn_is_cr_lf_flag(wnp)       ((wnp)->cr_lf_flag) 
#define wn_is_bk_flag(wnp)          ((wnp)->bk_flag)    
#define wn_is_tab_flag(wnp)         ((wnp)->tab_flag)   
#define wn_is_bell_flag(wnp)        ((wnp)->bell_flag)  
#define wn_is_w_wrap(wnp)           ((wnp)->w_wrap)     

#define wn_set_csr_x(x,wnp)            ((wnp)->csr_x = x)
#define wn_set_csr_y(y,wnp)            ((wnp)->csr_y = y)
#define wn_set_bdr_style(state,wnp) 	 ((wnp)->bdr_style = state)
#define wn_set_name_loc(state,wnp) 	   ((wnp)->name_loc = state)
#define wn_set_hidden(state,wnp)	     ((wnp)->hidden = state)
#define wn_set_overlapped(state,wnp)   ((wnp)->overlapped = state)
#define wn_set_csr_adv(state,wnp)      ((wnp)->csr_adv = state)
#define wn_set_inside(state,wnp)       ((wnp)->inside = state)
#define wn_set_mask_on(state,wnp)      ((wnp)->mask_on = state)
#define wn_set_popup(state,wnp)	       ((wnp)->popup = state)
#define wn_set_scroll(state,wnp)       ((wnp)->scroll = state)
#define wn_set_bs_clear(state,wnp)     ((wnp)->bs_clear = state)
#define wn_set_eol_wrap(state,wnp)     ((wnp)->eol_wrap = state)
#define wn_set_mgr_flag(state,wnp)     ((wnp)->mgr_flag = state)
#define wn_set_set_flag(state,wnp)     ((wnp)->set_flag = state)
#define wn_set_cr_flag(state,wnp)      ((wnp)->cr_flag = state)
#define wn_set_lf_flag(state,wnp)      ((wnp)->lf_flag = state)
#define wn_set_cr_lf_flag(state,wnp)   ((wnp)->cr_lf_flag = state)
#define wn_set_bk_flag(state,wnp)      ((wnp)->bk_flag = state)
#define wn_set_tab_flag(state,wnp)     ((wnp)->tab_flag = state)
#define wn_set_bell_flag(state,wnp)    ((wnp)->bell_flag = state)
#define wn_set_w_wrap(state,wnp)       ((wnp)->w_wrap = state)
#endif
#endif

#define cls()									( setmem(Screen, V_cols * V_rows * 2, 0) )
#define push(x)  							( Stack[Stack_ptr++] = (x) )
#define pop(x)   							( (x) = Stack[--Stack_ptr] )

#ifdef UW_GLOB_INC
#include "uw_glob.h"
#else
#include "uw_globx.h"
#endif
#include "uw_keys.h"
#include "uw_proto.h"
#include "uw_dbg.h"

#endif     /* __UW_H */

/**** END OF FILE ****/
