/*******************************************************************************
*          SCL1.H - definitions/declarations for SCL1 Library version 3.1      *
*                                                                              *
*     Copyright (C) 1989-1991 by Jos Rodrguez Alvira & Jos R. Lebrn        *
*******************************************************************************/

/* STRUCTURES */

/* Menu structures */

struct MenuOpt{
    int Row,Col;
    char *String;
    int Letter;
    };

struct PopMenuData{
    int L1,C1,L2,C2;
    int NumberOption;
    char *WinBuffer;
    struct MenuOpt *Menust;
    };

/* Mouse Button */

struct MouseButton{
    int Top,Left,Bottom,Right;
    int Row,Col;
    char String[20];
    };

/* ItemList structure */

struct ItemList{
    int Row,Col;
    char *String;
    };

/* Input Fields structure */

struct InputFields{
    int PromptLine;
    int PromptCol;
    char *Prompt;

    int FieldLine;
    int FieldCol;
    char *FieldBuffer;

    int MaxChar;
    unsigned int CharType;
    int (* cdecl Helpf)(struct InputFields *);
    int (* cdecl Checkf)(struct InputFields *);
    };

/* Error Box */

struct ErrorMess{
    int ErrorNum;
    char *Message;
    };

/* Tag List structure */

struct TagList{
    char TagFl;
    char *String;
    };

/* Date structure */

struct DateData{
    int WeekDay;
    int MonthDay;
    int Month;
    int Year;
    };

/* VideoData structure */

struct VideoData{
    int Monitor;
    int Mode;
    int Page;
    int Lines;
    int Cols;
    unsigned int Segment;
    int Retrace;
    };

struct FILETIME{
    unsigned int seconds:5;
    unsigned int minutes:6;
    unsigned int hours:5;
    };

struct FILEDATE{
    unsigned int day:5;
    unsigned int month:4;
    unsigned int year:7;
    };

struct FileData{
    char reserved[21];
    char attrib;
    struct FILETIME time;
    struct FILEDATE date;
    long size;
    char name[13];
    };

/*  Dialog functions - structures and messages

    LineEditor
    messages received by LineEditor */

#define LE_INIT            0
#define LE_DRAW            1
#define LE_UPDATE_FIELD    2
#define LE_ACTIVE          3
#define LE_KEY             4
#define LE_DATA            5
#define LE_POSITION_BEGIN  6
#define LE_POSITION_END    7
#define LE_POSITION_UP     8
#define LE_POSITION_DOWN   9
#define LE_SET_POSITION    10
#define LE_CHARS_UP        11
#define LE_CHARS_DOWN      12
#define LE_CLEAR           14
#define LE_CHECK_MOUSE     15
#define LE_RESET           100

/* messages returned by LineEditor */

#define LE_OK               0
#define LE_EXIT_KEY         1
#define LE_MOUSE_EVENT      2
#define LE_BUFFER_END       3
#define LE_BUFFER_BEGIN     4
#define LE_ILLEGAL_KEY      5
#define LE_BUFFER_FULL      6
#define LE_ILLEGAL_POSITION 7
#define LE_NEW_POSITION     8
#define LE_MY_MOUSE         15
#define LE_DEL_NULL         18

/* LineEditor structure */

typedef struct{
    int PColor;             /* Prompt's color */
    int PRow;               /* Prompt's position */
    int PCol;
    char *Prompt;
    int FColor;             /* Field color */
    int FRow;               /* Field position and screen lenght */
    int FCol;
    unsigned int FLength;   /* length in columns */
    unsigned int FSize;     /* Maximum number of chars */
    int CType;              /* type of characters accepted */
    int MaskFn;             /* 0 accept chars in mask, 1 discard chars in mask */
    char *MaskArray;        /* array of mask chars */
    char *Buffer;           /* destination buffer */
    char *FormatC;          /* chars used in format string */
    unsigned int *ExitKeys; /* array of exit keys scan/ascii code */
    int InsFlag;            /* 1 = Insert ON ,0 =typeover */
    int InsertCur;          /* Insert Mode cursor 0 = none, 1 normal, 2 big */
    int TypeOverCur;        /* typeover mode cursor */
    int CPaint;             /* Conditional paint color */
    unsigned int StartPos;  /* Start and end pos for conditional paint */
    unsigned int EndPos;
    unsigned int EventInfo; /* return information */
    unsigned int Position;  /* current position into buffer (offset) */
    unsigned int Scroll;    /* horizontal scroll counter 0=none */
    int Edited;             /* =1 if line was edited */
    }LEData;

/*  TextWindow
    messages received by TextWindow */

#define TW_INIT         0
#define TW_DRAW         1
#define TW_WRITE        2
#define TW_CLS          3
#define TW_LINE_DOWN    4
#define TW_DRAW_BORDER  5
#define TW_WAIT_ON      30
#define TW_WAIT_OFF     31
#define TW_RESET        100

/* messages returned by TextWindow */

#define TW_OK           0
#define TW_WINDOW_FULL  1

/* TextWindow structure */

typedef struct{
    int Color;
    int UpperRow;
    int LeftCol;
    int LowerRow;
    int RightCol;
    int FrameType;
    int WrapFlag;
    int Position;
    }TWData;

/*  ScrollWindow
    Messages received by ScrollWindow */

#define SW_INIT             0
#define SW_DRAW             1
#define SW_WRITE            2
#define SW_ACTIVE           3
#define SW_DRAW_BORDER      5
#define SW_POSITION_BEGIN   6
#define SW_POSITION_END     7
#define SW_POSITION_UP      8
#define SW_POSITION_DOWN    9
#define SW_SET_POSITION     10
#define SW_CLS              11
#define SW_CHECK_MOUSE      15
#define SW_UWRITE           16
#define SW_RESET            100
#define SW_PAGE_UP          101
#define SW_PAGE_DOWN        102
#define SW_MBAR_CHARS       104

/* Messages returned by ScrollWindow */

#define SW_NULL_ARRAY       -2
#define SW_OK                0
#define SW_EXIT_KEY          1
#define SW_MOUSE_EVENT       2
#define SW_BUFFER_END        3
#define SW_BUFFER_BEGIN      4
#define SW_ILLEGAL_KEY       5
#define SW_ILLEGAL_POSITION  7
#define SW_NEW_POSITION      8
#define SW_MOUSE_SELECT      9
#define SW_MY_MOUSE         15
#define SW_NEW_MOUSEPOS     16
#define SW_BLOCK_MARK       17

#define SW_MBAR_DEF         176
#define SW_THUMB_DEF        219

/* ScrollWindow structure */

typedef struct{
    int NColor;
    int RColor;
    int UpperRow;
    int LeftCol;
    int LowerRow;
    int RightCol;
    int FrameType;
    int ScrollBar;
    int BarColor;
    char **Array;
    char *TagArray;
    int TagColor;
    char *Title;
    int TitleColor;
    unsigned int *ExitKeys;
    unsigned int Lines;
    unsigned int Length;
    unsigned int TopLine;
    unsigned int Position;
    unsigned int FirstCol;
    int OldVBlock;
    int OldHBlock;
    int WindowLines;
    int WindowCols;
    int VScroll;
    int HScroll;
    unsigned int EventInfo;
    }SWData;

/*  MouseButton
    Message received by MouseButton */

#define MB_INIT             0
#define MB_DRAW             1
#define MB_ACTIVE           3
#define MB_CHECK_MOUSE      15
#define MB_RESET            100

/* Message returned by MouseButton */

#define MB_OK               0
#define MB_EXIT_KEY         1
#define MB_MOUSE_EVENT      2
#define MB_ILLEGAL_KEY      5
#define MB_MOUSE_SELECT     9
#define MB_MY_MOUSE         15


/* MouseButton structure */

typedef struct{
    int NColor;
    int RColor;
    int UpperRow;
    int LeftCol;
    int LowerRow;
    int RightCol;
    int PRow;
    int PCol;
    char *Prompt;
    int BoxFlag;
    int ActiveFlag;
    unsigned int *ExitKeys;
    unsigned int EventInfo;
    }MBData;

/*  TagItem
    messages received by TagItem */

#define TI_INIT            0
#define TI_DRAW            1
#define TI_ACTIVE          3
#define TI_CHECK_MOUSE     15
#define TI_RESET           100

/* messages returned by TagItem */

#define TI_OK               0
#define TI_EXIT_KEY         1
#define TI_MOUSE_EVENT      2
#define TI_ILLEGAL_KEY      5
#define TI_NEW_POSITION     8
#define TI_MY_MOUSE         15

/* TagItem structure */

typedef struct{
    int Color;
    int Row;
    int Col;
    int TagFl;
    char *String;
    unsigned int *ExitKeys;
    unsigned int EventInfo;
    }TIData;

/*  Select
    messages received by Select */

#define S_INIT            0
#define S_DRAW            1
#define S_ACTIVE          3
#define S_CHECK_MOUSE     15
#define S_RESET           100

/* messages returned by Select */

#define S_NULL_ARRAY      -2
#define S_OK               0
#define S_EXIT_KEY         1
#define S_MOUSE_EVENT      2
#define S_ILLEGAL_KEY      5
#define S_NEW_POSITION     8
#define S_MY_MOUSE         15

/* Select structures */

typedef struct{
    int Row;
    int Col;
    char *String;
    }SData1;

typedef struct{
    int Color;
    int PRow;
    int PCol;
    char *Prompt;
    unsigned int *ExitKeys;
    int Options;
    int Position;
    unsigned int EventInfo;
    }SData2;

/* Fields2 */

typedef struct{
    int FieldType;
    void *Structure1;
    void *Structure2;
    int (* cdecl CheckF)();
    }FData1;

typedef struct{
    int Message;
    unsigned int EventInfo;
    FData1 *Structure;
    int ActiveField;
    int FieldsNumber;
    }FData2;

typedef struct{
    int EventInfo;
    int (* cdecl UserField)();
    }FData3;


/* Field types */

#define LINE_EDITOR     1
#define SCROLL_WINDOW   2
#define MOUSE_BUTTON    3
#define TAG_ITEM        4
#define SELECT          5
#define LIST_WINDOW     6
#define CALENDAR        7
#define USER_DEFINED    100

/* messages received */

#define F_INIT            0
#define F_DRAW            1
#define F_ACTIVE          3
#define F_MOUSE_EVENT     2
#define F_POSITION_STAY   5
#define F_POSITION_UP     8
#define F_POSITION_DOWN   9
#define F_SET_POSITION    10
#define F_EXIT            13
#define F_SET_POS_EXIT    16
#define F_DRAW_NR         19
#define F_CHECK_ALL       20
#define F_COLORS          21
#define F_RESET           100
#define F_ALLOC           101
#define F_FREE            102

/* FieldCheck messages */

#define F_OK                0
#define F_START           103
#define F_FIELDSTART      104
#define F_NOMEM           106

/*  TagList2
    TagList2 messages received */

#define TL_INIT             0
#define TL_DRAW             1
#define TL_ACTIVE           2
#define TL_RESET            100

/* TagList2 messages returned */

#define TL_OK               0
#define TL_CANCEL           -1

/* TagList2 structure */

typedef struct{
    int NColor;
    int RColor;
    int TColor;
    int UpperRow;
    int LeftCol;
    int LowerRow;
    int RightCol;
    char **Array;
    char *TagArray;
    }TLData;

/*  FileBox2
    FileBox2 messages received */

#define FB_INIT             0
#define FB_DRAW             1
#define FB_ACTIVE           2
#define FB_RESET            100

/* FileBox2 messages returned */

#define FB_OK                0
#define FB_CANCEL           -1

/* FileBox2 structure */

typedef struct{
    int NColor;
    int RColor;
    int UpperRow;
    int LeftCol;
    int LowerRow;
    int RightCol;
    char *Filename;
    int Attrib;
    }FBData;

/* FileBox3 structure */

typedef struct{
    int NColor;
    int RColor;
    int UpperRow;
    int LeftCol;
    int LowerRow;
    int RightCol;
    char *Filename;
    int Attrib;
    unsigned int Display;
    unsigned int SortType;
    int FileNumber;
    int DirNumber;
    }FB3Data;

    /* FileBox3 constants */

#define FB_NAME          1
#define FB_EXT           2
#define FB_SIZE          4
#define FB_DATE          8
#define FB_TIME         16
#define FB_ATTRIB       32
#define FB_REVERSE      64
#define FB_DIR_FIRST   128
#define FB_DMY         256
#define FB_YMD         512

#define FB_ILLEGAL_OP   -2
#define FB_NO_MEM       -3

    /* Dissolve constants */

#define DS_BOX          0
#define DS_SIDES        1
#define DS_SIX_PARTS    2
#define DS_FOUR_BOXES   3

    /* Macro messages */

#define MACRO_START         0
#define MACRO_STOP          1
#define MACRO_REPORT        2
#define MACRO_NO_MACRO      3

    /* Macro struct */

typedef struct{
    unsigned int key;
    unsigned int size;
    unsigned int *buffer;
    }MACROData;

    /* PercentBar messages */

#define PB_INIT     0
#define PB_DRAW     1
#define PB_UPDATE   2

    /* PercentBar struct */

typedef struct{
    int Color;
    int Row;
    int Col;
    int Size;
    unsigned int Total;
    int ForeChar;
    int BackChar;
    }PBData;


/*  MenuSystem
    MenuSystem messages received */

#define MS_INIT               0
#define MS_DRAW               1
#define MS_CHECK              3
#define MS_KEY                4
#define MS_SHADOW_ON         20
#define MS_SHADOW_OFF        21
#define MS_LINE_ON           22
#define MS_LINE_OFF          23
#define MS_SET_FRAME_TYPE    24
#define MS_SET_BAR_ROW       25
#define MS_SET_BAR_START     26
#define MS_SET_BAR_END       27
#define MS_ALT_ON            29
#define MS_ALT_OFF           30
#define MS_SET_FRAME_COLOR   31
#define MS_RESET_FRAME_COLOR 32
#define MS_RESET             100
#define MS_SHOW_MENU         200
#define MS_HIDE_MENU         201


/* MenuSystem messages returned */

#define MS_NO_SELECT    0
#define MS_OK           0
#define MS_SELECT       1
#define MS_CANCEL      -1

/* MenuSystem structures */

typedef struct{
    int Row;
    int Col;
    char *String;
    int Letter;
    }MSOptions;

typedef struct{
    int UpperRow;
    int LeftCol;
    int LowerRow;
    int RightCol;
    int Number;
    char *WinBuffer;
    MSOptions *mso;
    }MSWindow;

typedef struct{
    int StartCol;
    int EndCol;
    unsigned int Key;
    char *String;
    }MSBar;

typedef struct{
    int BarNColor;
    int BarRColor;
    int MenuNColor;
    int MenuRColor;
    int MenuHColor;
    MSBar *msb;
    MSWindow *msw;
    int Number;
    int Menu;
    int Option;
    unsigned int EventInfo;
    }MSData;

/* MenuSystem2 struct */

typedef struct{
    int Row;
    int Col;
    char *String;
    int Letter;
    int Active;
    char *Text;
    }MSOptions2;

typedef struct{
    int UpperRow;
    int LeftCol;
    int LowerRow;
    int RightCol;
    int Number;
    char *WinBuffer;
    MSOptions2 *mso;
    }MSWindow2;

#define MSBar2 MSBar

typedef struct{
    int BarNColor;
    int BarRColor;
    int MenuNColor;
    int MenuRColor;
    int MenuHColor;
    int MenuGNColor;
    int MenuGRColor;
    MSBar2 *msb;
    MSWindow2 *msw;
    int Number;
    int Menu;
    int Option;
    unsigned int EventInfo;
    int TextColor;
    int TextRow;
    int TextCol;
    int TextLenght;
    }MSData2;


/*  ListWindow
    Messages received by ListWindow */

#define LW_INIT             0
#define LW_DRAW             1
#define LW_WRITE            2
#define LW_ACTIVE           3
#define LW_DRAW_BORDER      5
#define LW_POSITION_BEGIN   6
#define LW_POSITION_END     7
#define LW_POSITION_UP      8
#define LW_POSITION_DOWN    9
#define LW_SET_POSITION     10
#define LW_CLS              11
#define LW_CHECK_MOUSE      15
#define LW_RESET            100
#define LW_MBAR_CHARS       104

/*  Messages returned by ListWindow */

#define LW_NULL_ARRAY       -2
#define LW_OK                0
#define LW_EXIT_KEY          1
#define LW_MOUSE_EVENT       2
#define LW_BUFFER_END        3
#define LW_BUFFER_BEGIN      4
#define LW_ILLEGAL_KEY       5
#define LW_ILLEGAL_POSITION  7
#define LW_NEW_POSITION      8
#define LW_MOUSE_SELECT      9
#define LW_MY_MOUSE         15
#define LW_NEW_MOUSEPOS     16
#define LW_BLOCK_MARK       17

#define LW_MBAR_DEF         176
#define LW_THUMB_DEF        219

/* ListWindow structure */

typedef struct{
    int NColor;
    int RColor;
    int UpperRow;
    int LeftCol;
    int LowerRow;
    int RightCol;
    int FrameType;
    int ScrollBar;
    int BarColor;
    char **Array;
    char *TagArray;
    int TagColor;
    char *Title;
    int TitleColor;
    unsigned int *ExitKeys;
    int StaticWidth;
    unsigned int Items;
    unsigned int ColumnWidth;
    unsigned int FirstItem;
    unsigned int Position;
    int WindowLines;
    int WindowCols;
    int TotalCols;
    int TotalWindowItems;
    int OldHBlock;
    unsigned int EventInfo;
    }LWData;

/*  Calendar
    Calendar structure */

typedef struct{
    int NColor;
    int RColor;
    int Row;
    int Col;
    int FrameType;
    unsigned int *ExitKeys;
    int Lang;
    int Month;
    int Day;
    int Year;
    unsigned int EventInfo;
    }CData;

/* Messages received */

#define C_INIT            0
#define C_DRAW            1
#define C_ACTIVE          3
#define C_CHECK_MOUSE    15
#define C_SHADOW_ON      20
#define C_SHADOW_OFF     21
#define C_RESET         100

/* Messagges returned */

#define C_OK            0
#define C_EXIT_KEY      1
#define C_MOUSE_EVENT   2
#define C_ILLEGAL_KEY   5
#define C_NEW_POSITION  8
#define C_MY_MOUSE     15

/* LinkedList messages */

#define LL_INIT               1
#define LL_ADD                2
#define LL_NEXT               3
#define LL_PREVIOUS           4
#define LL_FIRST              5
#define LL_LAST               6
#define LL_DELETE             7
#define LL_DELETE_ALL         8
#define LL_INSERT             9
#define LL_SET_POSITION      10
#define LL_REPLACE           11
#define LL_SAVE_POSITION     12
#define LL_RESTORE_POSITION  13

#define LL_MEM_ERROR          -1
#define LL_OK                  0
#define LL_LAST_NODE           1
#define LL_FIRST_NODE          2
#define LL_EMPTY_LIST          3
#define LL_ILLEGAL_POSITION    4

struct LLNODEtag{
    struct LLNODEtag *Next;
    struct LLNODEtag *Prev;
    unsigned int DataSize;
    char *Data;
    };

typedef struct LLNODEtag LLNODE;

typedef struct{
    unsigned int DataSize;
    char *Data;
    unsigned int Nodes;
    unsigned int ActiveNode;
    LLNODE *Head;
    LLNODE *Tail;
    LLNODE *Position;
    }LLData;

/* RecordFile messages */

#define RF_OPEN         1
#define RF_CREATE       2
#define RF_FIRST        3
#define RF_LAST         4
#define RF_NEXT         5
#define RF_PREVIOUS     6
#define RF_CLOSE        7
#define RF_ADD          8
#define RF_OPENCREATE   9
#define RF_WRITE        10
#define RF_SETPOS       11
#define RF_READ         12

#define RF_OK           0
#define RF_FILENOTFOUND 1
#define RF_EOF          2
#define RF_BOF          3
#define RF_READERR      4
#define RF_WRITEERR     5
#define RF_ILLEGALOP    6

typedef struct{
    char *FName;
    char *Buffer;
    unsigned int DataSize;
    long FPos;
    long FSize;
    long Entries;
    int FHandle;
    int Error;
    }RFData;

/* Create - Destroy window */

typedef struct{
    int Color;
    int Style;
    int FrameType;
    int UpperRow;
    int LeftCol;
    int LowerRow;
    int RightCol;
    int TitleColor;
    char *Title;
    int HorSize;
    int VerSize;
    int HorCenter;
    int VerCenter;
    char *Buffer;
    }WData;

#define W_SAVE    1
#define W_CLEAR   2
#define W_FRAME   4
#define W_GROW    8
#define W_SHRINK  16
#define W_SHADOW  32

#define W_LEFT      0
#define W_RIGHT     1
#define W_CENTER    2

#define W_NOMEM   -1
#define W_OK       0

/* Functions prototypes */

void cdecl BackgroundOn(int (*FAddress)());
char * cdecl AddExtension(char *Filename,char *Extension);
void cdecl BackgroundOff(void);
void cdecl Beep(void);
void cdecl BigCursor(void);
char * cdecl Bin2Ascii(long Number,char *Buffer);
void cdecl Box(int Color,int FrameType,int UpperRow,int LeftCol,int LowerRow,int RightCol);
int cdecl Buf2Disk(char *Filename,char *Buffer,unsigned int Bytes);
int cdecl Calendar(int Message,CData *cd);
int cdecl Center(char *String);
void cdecl ChangeDumpColor(int OldColor,int NewColor,char *p);
char * cdecl ChangeExtension(char *Filename,char *Extension);
unsigned int cdecl CheckChar(unsigned int Character,unsigned int ControlCode);
int cdecl CheckEnhancedKeyb(void);
int cdecl CheckItemList(int Number,int ItemLength,struct ItemList *il);
int cdecl CheckMouseButton(int Number,struct MouseButton *mb);
int cdecl CheckMouse(void);
void cdecl ClearKeyBuf(void);
void cdecl ClearWindow(WData *wd);
void cdecl ClockTick(void);
int cdecl CloseFile(int Handle);
void cdecl Cls(int Color,int UpperRow,int LeftCol,int LowerRow,int RightCol);
int cdecl CreateFile(char *Filename,int *Handle,int Attrib);
int cdecl CreateWindow(WData *wd);
void cdecl C_SetUserLang(CData *cd,char **data);
void cdecl CursorOff(void);
void cdecl CursorOn(void);
unsigned int cdecl Date2Num(int Month, int Day, int Year);
int cdecl DaysPerMonth(int year,int month);
int cdecl DeleteFile(char *Filename);
void cdecl DestroyWindow(WData *wd);
int cdecl DialogBox(int BoxColor,char *Prompt,int InputColor,int MaxChar,unsigned int CharType,char *Buffer);
void cdecl DisableMouse(void);
void cdecl Dissolve(int Color,int Type,int Speed);
void cdecl DrawBoxLine(int Color,int FrameType,int Row1,int Col1,int Row2,int Col2);
void cdecl DrawItemList(int NColor,int RColor,int Number,int Selection,struct ItemList *il);
void cdecl DrawMouseButton(int NColor,int RColor,int Number,int Selection,struct MouseButton *mb);
void cdecl DrawLine(int Color,int Row,int Col,int Count,int Direction,int Character);
void cdecl EB_SetUserLang(char *prompt1,char *prompt2);
void cdecl ErrorBox(int ErrNum);
void cdecl ErrorShadowOff(void);
void cdecl ErrorShadowOn(void);
void cdecl FB_SetUserLang(char **prompt,int offset1,int offset2);
void cdecl FB3_SetUserLang(char **prompt,int offset1,int offset2);
int cdecl FieldCheck(FData2 *p);
int cdecl Fields(int NColor,int RColor,int NFields,struct InputFields *ifld,unsigned int ExitKey,unsigned int HelpKey);
FData2 * cdecl Fields2(int Message,FData1 *fd1,FData2 *fd2,...);
int cdecl FileBox(int NColor,int RColor,char *Filename);
int cdecl FileBox2(int Message, FBData *p);
int cdecl FileBox3(int Message, FB3Data *fb3);
int cdecl File2Buf(char* Filename,char* Buffer,unsigned int* MaxSize);
void cdecl FillBlock(int Color,int UpperRow,int LeftCol,int LowerRow,int RightCol,int Character);
int cdecl FindFirst(char *SearchString,struct FileData *Buffer,int SearchAtr);
int cdecl FindNext(void);
void cdecl GetCharSet(int StartCode,int TotalChars,char *Buffer);
int cdecl GetCurLine(void);
int cdecl GetCurCol(void);
int cdecl GetCurrentDir(char *PathBuffer);
int cdecl GetCurSize(void);
int cdecl GetFiles(char *SearchString,int SearchAtr);
struct DateData * cdecl GetDate(void);
char far * cdecl GetCharSetAddress(int table);
int cdecl GetDefaultDrive(void);
long cdecl GetDiskFreeSpace(int Drive);
unsigned int cdecl GetExtendedAscii(unsigned int Character);
int cdecl GetFileMode(char *Filename,unsigned int *FMode);
long cdecl GetFilePt(int Handle);
long cdecl GetFileSize(int Handle);
long cdecl GetFreeMem(void);
unsigned int cdecl GetKey(void);
int cdecl GetString(int PColor,int PRow,int PCol,char* Prompt,int FColor,int FRow,int FCol,int MaxChar,unsigned int CharType,char *Buffer);
void cdecl GSSBox(int Color,int FrameType,int UpperRow,int LeftCol,int LowerRow,int RightCol,int GrowFl,int SoundFl,int ShadowFl);
char * cdecl GetTime(void);
void cdecl HideMouse(void);
int cdecl InitDrive(int Drive);
void cdecl InitUserError(struct ErrorMess* p);
int cdecl InitMouse(int Cursor);
void cdecl InitVideo(void);
void cdecl InitWData(WData *wd,int Color,int Style,int UpperRow,int LeftCol,int LowerRow,int RightCol,int FrameType,int TitleColor,char *Title);
void cdecl Int24ShadowOff(void);
void cdecl Int24ShadowOn(void);
void cdecl I24_SetUserLang(char *prompt1,int offset1,unsigned int key1,char *prompt2,int offset2,unsigned int key2,struct ErrorMess *em);
unsigned int cdecl KeyReady(void);
unsigned int cdecl KeyStatus(void);
int cdecl LeapYear(int year);
int cdecl LineEditor(int Message,LEData *p,...);
int cdecl LinkedList(int Mess,LLData *ld,...);
int cdecl ListManager(int NColor,int RColor,int Number,int Length,int Selection,int Lines,int Cols,struct ItemList *il);
int cdecl ListWindow(int Message,LWData *p,...);
int cdecl LW_MoveTo(LWData *lwd);
int cdecl MakeDir(char *Path);
int cdecl MCR_CloseFile(void);
void cdecl MCR_Init(unsigned int Key,int (* userf)(int flag,MACROData *md));
void cdecl MCR_MacroDisable(void);
void cdecl MCR_MacroEnable(void);
int cdecl MCR_MacroExist(unsigned int Key);
void cdecl MCR_Play(unsigned int *macro);
int cdecl MCR_ReadFile(char *FileName);
void cdecl MCR_Record(void);
void cdecl MCR_RecordKey(unsigned int Key);
void cdecl MCR_RegisterBackF(void ( *userf)(void));
int cdecl MCR_RegisterMacro(unsigned int Key,unsigned int size,unsigned int *Buffer);
int cdecl MCR_RegisterTrapKey(unsigned int Key,void (* userf)());
void cdecl MCR_Report(void);
int cdecl MCR_SaveMacro(char *FileName,MACROData *md);
void cdecl MCR_UnRegisterBackF(void);
unsigned int * cdecl MCR_UnRegisterMacro(unsigned int Key);
void cdecl MCR_UnRegisterTrapKey(unsigned int Key);
void cdecl MESS_SetPosition(int UpperRow,int LeftCol);
int cdecl Menu(int NColor, int RColor, int HColor,int NumOpt,struct MenuOpt *mo);
int cdecl MenuSystem(int Message,MSData *msd,...);
int cdecl MenuSystem2(int Message,MSData2 *msd,...);
void cdecl MessageOn(int Color,char *String);
void cdecl MessageOff(void);
void cdecl MessageShadowOff(void);
void cdecl MessageShadowOn(void);
void cdecl ModifyCharSet(int Points,int StartCode,int TotalChars,char *Bits);
void cdecl ModifyPalette(char *Colors);
void cdecl ModifyPaletteColor(int Palette,int NewValue);
int cdecl MouseButton(int Message,MBData *p);
int cdecl MouseMenu(int NColor,int RColor,int HColor,int NumOpt,struct MenuOpt *mo,int XMin,int XMax,int YMin,int YMax);
int cdecl MouseMenu2(int NColor,int RColor,int HColor,int NumOpt,struct MenuOpt *mo,int XMin,int XMax,int YMin,int YMax,int StartSel);
int cdecl MoveFilePt(int Handle,unsigned long Bytes);
int cdecl MoveFilePt2Offset(int Handle,unsigned long Bytes);
void cdecl Num2Date(unsigned int count,int *Month, int *Day, int *Year, int *Weekday);
int cdecl OpenFile(char *Filename, int *Handle, int OMode);
void cdecl PercentBar(int Mess,PBData *pbd,...);
int cdecl PushCursor(void);
int cdecl PopCursor(void);
int cdecl PopMenu(int NColor,int RColor,int HColor,struct PopMenuData *pmd);
int cdecl ReadFile(int Handle,char *Buffer,unsigned int Bytes);
int cdecl ReadPalette(char *Colors);
int cdecl RecordFile(int Mess,RFData *rfd);
int cdecl RemoveDir(char *Path);
char * cdecl RemoveExtension(char *Filename);
int cdecl RenameFile(char *OldName,char *NewName);
void cdecl ResetMouse(void);
void cdecl ResetMouseCur(void);
void cdecl ScrollDown(int Color,int UpperRow,int LeftCol,int LowerRow,int RightCol,int Scroll);
void cdecl ScreenDump(int Row,int Column,char *StringAdr);
int cdecl ScrollList(int NColor,int RColor,int Row,int Col,int Lines,char **p);
void cdecl ScrollUp(int Color,int UpperRow,int LeftCol,int LowerRow,int RightCol,int Scroll);
int cdecl ScrollWindow(int Message,SWData *p,...);
void cdecl SetInt24Colors(int NColor,int RColor);
void cdecl SetCurPos(int Row,int Col);
void cdecl SetCurSize(int CursorSize);
void cdecl SetErrorBoxColor(int UColor);
int cdecl SetFileMode(char *Filename, unsigned int NewMode);
void cdecl SetHorLimit(int Minimum,int Maximum);
int cdecl Select(int Message,SData1 *sd1,SData2 *sd2);
void cdecl SetBin2AsciiDel(int Character);
void cdecl SetDialogColor(int NColor,int RColor,int HColor);
void cdecl SetMouseCur(int Character);
void cdecl SetMouseIsr(void);
void cdecl SetMousePos(int X,int Y);
void cdecl SetShadowColor(int Color);
void cdecl SetUserBox(int UpperLeft,int UpperRight,int LowerLeft,int LowerRight,int UpperSide,int BottomSide,int LeftSide,int RightSide);
void cdecl SetUserBoxLine(int HLeft,int HRight,int VUpper,int VLower);
void cdecl SetVerLimit(int Minimum,int Maximum);
void cdecl SetVideoMode(int NewMode);
void cdecl SetVideoPage(int NewPage);
void cdecl SetVideo25(void);
void cdecl SetVideo28(void);
void cdecl SetVideo4350(void);
void cdecl Shadow(int Color,int UpperRow,int LeftCol,int LowerRow,int RightCol);
int cdecl ShellSort(void *base,unsigned int num,unsigned int width,int (*compare)(void *elem1,void *elem2));
void cdecl ShowMouse(void);
void cdecl SortPointers(char *p[]);
void cdecl Sound(int Freq);
void cdecl SoundOff(void);
void cdecl SoundOn(void);
long cdecl StopWatch(int Function);
int cdecl SW_MoveTo(SWData *sw);
int cdecl TagItem(int Message,TIData *tg);
int cdecl TagList(int NColor,int RColor,struct TagList *tl);
int cdecl TagList2(int Message,TLData *p);
int cdecl TagMenu(int NColor,int RColor,int HColor,int NumOpt,struct MenuOpt *mo,int XMin,int XMax,int YMin,int YMax);
int cdecl TextWindow(int Message,TWData *p,...);
void cdecl TL_SetUserLang(char **prompt,int offset1,int offset2);
int cdecl TrapBIOSScreenWrite(void);
void cdecl TrapInt10(void);
void cdecl RestoreInt10(void);
void cdecl TrapInt23(void);
void cdecl TrapInt24(void);
void cdecl TSound(int Frequency,unsigned int Duration);
unsigned int cdecl Video(void);
struct VideoData * cdecl VideoConfig(void);
unsigned int cdecl WaitKeyMouse(void);
void cdecl WaitTime(unsigned int HSec);
void cdecl WF_SetUserLang(char **prompt,int offset1,int offset2);
void cdecl Window(int Color,int UpperRow,int LeftCol,int LowerRow,int RightCol,char* Flag,char* Buffer);
void cdecl WriteOffLen(int Color,int Offset,int Count,char * String);
void cdecl WriteOffset(int Color,int Offset,int Character);
void cdecl WriteScreen(int Atributte,int Row,int Column,char* StringAdr);
void cdecl WriteScreenLen(int Color,int Row,int Col,int Count,char *String);
void cdecl WriteScreenC(int Color,int Row,int Col,char *String);
void cdecl WriteScreenCLen(int Color,int Row,int Col,int Count,char *String);
void cdecl WriteScreenR(int Color,int Row,int Col,char *String);
void cdecl WriteScreenRLen(int Color,int Row,int Col,int Count,char *String);
void cdecl WriteChar(int Color,int Row,int Col,int Count,int Character);
int cdecl WriteFile(int Handle,char *Buffer,unsigned int Bytes);
void cdecl WriteWindow(WData *wd,int Row,int Col,int Count,int Justification,char *String);
int cdecl WFileBox(int Message, FBData *p);
void WF_SetUserLang(char **p,int b1,int b2);
int cdecl YesNo(int NColor,int RColor,int Selection,char *p);
void YN_SetFrame(int FrameType);
void cdecl YesNoShadowOff(void);
void cdecl YesNoShadowOn(void);
void cdecl YN_SetPosition(int UpperRow,int LeftCol);
void cdecl YN_SetUserLang(char *prompt1,int offset1,unsigned int key1,char *prompt2,int offset2,unsigned int key2);
void cdecl ZWindow(int Color,int UpperRow,int LeftCol,int LowerRow,int RightCol,int Frame, char* Buffer);

/* Global Variables */

/* TrapInt24 */

extern int I24_CrtErrFl;

/* GetCurSize */

extern int GCS_CursorSize;

/* GetExtendedAscii */

extern char GE_CharTable;

/* Mouse related */

extern int MSE_LPress,MSE_LRel,MSE_RPress,MSE_RRel;
extern int MSE_Move,MSE_MoveX,MSE_MoveY,MSE_LpX;
extern int MSE_LpY,MSE_LrX,MSE_LrY,MSE_RpX,MSE_RpY;
extern int MSE_RrX,MSE_RrY,MSE_MouseFl,MSE_DoubleClick;

/* GetFiles */

extern char *GF_PointerBuf[];
extern int GF_FileNumber;

/* GetString */

extern char GS_Insert;
extern char GS_Edit;
extern char GS_Beep;

/* Fields */

extern char F_Insert;
extern char F_Beep;

/* VideoConfig */

extern int VC_Monitor,VC_Mode,VC_Page;
extern int VC_Lines,VC_Cols,VC_Retrace;
extern unsigned int VC_Segment;

/* GetTime variables */

extern int GT_Hours;
extern int GT_Minutes;
extern int GT_Seconds;
extern int GT_Hundreths;

/* TrapInt23h */

extern char I23_CtrlBreakFl;

/* SetDialogColors */

extern int D_NColor,D_RColor,D_HColor;

/* Arguments and constants */

/* CheckChar */

#define CC_ANY         1
#define CC_LETTER      2
#define CC_DIGIT       4
#define CC_CAPITALIZE  8
#define CC_REAL        0x14
#define CC_FILESPEC    0x20
#define CC_ESPANOL     0x42
#define CC_PUNCTUATION 0x80
#define CC_PATH        0x0100
#define CC_SEARCH      0x0200
#define CC_EXPONENTIAL 0x0404

/* Video */

#define COLOR   0xb800
#define MONO    0xb000

/* Monitors types */

#define VC_MDA    1
#define VC_CGA    2
#define VC_EGA    4
#define VC_EGAM   5
#define VC_PGC    6
#define VC_VGAM   7
#define VC_VGA    8
#define VC_MCGADC 10
#define VC_MCGAAM 11
#define VC_MCGAAC 12


/* StopWatch */

#define SW_START 0
#define SW_STOP  1

/* File Attributtes */

#define F_READ_ONLY   1
#define F_HIDDEN      2
#define F_SYSTEM      4
#define F_VOLUME      8
#define F_DIRECTORY   16
#define F_ARCHIVE     32

/* DOS 2.0 File Open Mode */

#define DOS2_READ       0           /* Access Rights */
#define DOS2_WRITE      1
#define DOS2_RW         2

/* DOS 3.0 File Open Mode */

#define DOS3_INHERIT    0           /* Inheritance Flag */
#define DOS3_PRIVATE    0x80

#define DOS3_COMP       0           /* Sharing Mode */
#define DOS3_DENY_RW    0x10
#define DOS3_DENY_W     0x20
#define DOS3_DENY_R     0x30
#define DOS3_DENY_NONE  0x40

#define DOS3_READ       0           /* Access Rights */
#define DOS3_WRITE      1
#define DOS3_RW         2

/* DrawLine */

#define DL_HORIZONTAL 0
#define DL_VERTICAL   1

/* InitMouse */

#define IM_NO_SHOW 0
#define IM_SHOW    1

/* Window macros */

#define W_BUF_SIZE(ur,lc,lr,rc) (((((rc) - (lc)) + 1) * 2) * (((lr) - (ur)) + 1))
#define W_SAVECLEAR   0
#define W_SAVEONLY    -2


/* FileBox buffer size */

#define FB_BUF_SIZE 160


/* Cls */

#define CLS_ALL 0,0,24,79


/* YesNo */

#define YN_YES         1
#define YN_NO          0
#define YN_YESDEFAULT  1
#define YN_NODEFAULT   2

/* GetCharSetAddress */

#define GCA_8X8A       3
#define GCA_8X8B       4
#define GCA_8X14       2
#define GCA_8X16       6

