#include <dos.h>
#include <string.h>
#include <graphics.h>

#define TRUE 1
#define FALSE 0
#define IN 0
#define OUT 1
#define THICK 0
#define THIN 1
#define TEXT 0
#define IMAGE 1

#define ALTA 30
#define ALTB 48
#define ALTC 46
#define ALTD 32
#define ALTE 18
#define ALTF 33
#define ALTG 34
#define ALTH 35
#define ALTI 23
#define ALTJ 36
#define ALTK 37
#define ALTL 38
#define ALTM 50
#define ALTN 49
#define ALTO 24
#define ALTP 25
#define ALTQ 16
#define ALTR 19
#define ALTS 31
#define ALTT 20
#define ALTU 22
#define ALTV 47
#define ALTW 17
#define ALTX 45
#define ALTY 21
#define ALTZ 44

#define ALT1 120
#define ALT2 121
#define ALT3 122
#define ALT4 123
#define ALT5 124
#define ALT6 125
#define ALT7 126
#define ALT8 127
#define ALT9 128
#define ALT0 129

#define ALTMINUS  130
#define ALTPLUS   131

//LIB
void dlay(int ticks);
long getticks();
int altkey();
int ctrlkey();
int lshiftkey();
int rshiftkey();
void flushkeys();
unsigned char getvidmode();

//MOUSECLASS
class Mcursor {
	  int shown;
	  int current;
	  int xpos;
	  int ypos;
	  void mouse_interrupt();
	  int m1;
	  int m2;
	  int m3;
	  int m4;
	  int button;
	  int count;
	  long tickcount;
	  int disabled;
	public:
	  int  init();
	  void changeto(int);
	  void get_status();
	  void show();
	  void hide();
	  void set_hor_bounds(int,int);
	  void set_ver_bounds(int,int);
	  void Mcursor::conditional_off(int x1,int y1,int x2,int y2);
	  void Mcursor::position(int,int);
	  int  LBP();
	  int  RBP();
	  int  getcurrent();
	  int  mousex();
	  int  mousey();
	  int  mx();
	  int  my();
	  void unarm();
	  void arm();
	  int  LBDCLK();
	  };

#define UPARROW 1
#define DOT 2
#define PENCIL 3
#define CROSSHAIR 4
#define ARROW 5
#define FINGER 6
#define POINT 7
#define CLOCK 8
#define DISK 9
#define IBAR 10
#define PAINTCAN 11
#define HAND 12
#define ERASOR 13
#define GUNSIGHT 14
#define SCISSORS 15
#define JAWS 16

//INPUT
void beep();
char *strdel(char *,int);
char *strins(char *,int,char);

class Gstring {
	protected:
		int x;
		int y;
		int xpos;
		int length;
		int ucase;
		char laststring[81];
		int shown;
		int escape;
		int retrn;
		int tab;
		int uparrow;
		int dnarrow;
		int infgd;
		int inbgd;
		int firstchar;
		int curpos;
		int curson;
		void showcurs();
		void hidecurs();
	public:
		Gstring();
        ~Gstring();
		void init(int,int,int,int);
		void show();
		void input();
		void get_input();
		void get_form_input();
		void get_form_mouse_input();
		char *getstring();
		void reset();
		void preset(char *);
		int isshown();
		void check_for_blink();
		int returnhit();
		int escapehit();
		int uparrowhit();
		int dnarrowhit();
		int tabhit();
		void setincolors(int,int);
		int hit();
		};

//GROBJECT
class Point
{
	protected:
		int x,y,color;
		viewporttype vref;
	public:
		Point();
		void move(int ptx,int pty);
		virtual void draw();
		void create(int ptx,int pty,int c);
		void restoreviewport();
		void Setcolor(int c);
		virtual void setloc(int ptx,int pty);
		virtual void erase();
		int Getcolor();
		int Getx();
		int Gety();
		};

//************************************************************************

class Colorbutton:public Point
{
	protected:
		int color;
		int width;
		int height;
	public:
		void init(int,int,int,int,int);
		void show(int);
		int  clicked();
		int	 hit();
		int getcolor();
		};

//************************************************************************

class Closebutton:public Colorbutton
{
	public:
		void  show();
		};

//************************************************************************

class Icon:public Point
{
	protected:
		int state;
	public:
		void far *picture;
		Icon();
		~Icon();
		void init(int,int,char*);
		void show();
		void choose();
		int hit();
		int clicked();
		int ispressed();
		};

//************************************************************************

class Gcheckbox:public Point
{
	protected:
		int checked;
		char *desc;
		int length;
	public:
		Gcheckbox();
		~Gcheckbox();
		void init(int,int,char *);
		void show();
		void check();
		void uncheck();
		int is_checked();
        int hit();
		};

//************************************************************************

class Gradio:public Gcheckbox
{
	public:
		void show();
		void check();
		void uncheck();
		};

//************************************************************************

class Acticon:public Icon
{
	protected:
		void *picture[32];
		int state;
		int numpix;
	public:
		Acticon();
		~Acticon();
		void init(int,int,char*);
		void show(int);
		void choose();
		int ispressed();
		void animate(int);
		void backforth(int);
		};

//************************************************************************

class Button:public Point
{
	protected:
		int state,sizex,sizey;
		char btntxt[40];
		int  file_text;
		void far *picture;
		void getpic(char*);
	public:
		Button();
		~Button();
		virtual void show();
		virtual void press();
		void init(int ptx,int pty,char* text,int);
		int hit();
        int pressed();
		};

//************************************************************************

class Bitmap:public Point
{
	protected:
		int sizex,sizey;
		int size;
		void far *picture;
		int shown;
		int clickcount;
        long last_tick;
	public:
		Bitmap();
		~Bitmap();
		void init(int,int);
		void load(char *);
		void save(char *);
		void show_XOR();
		void show_COPY();
		void show_AND();
		void show_OR();
		void show_NOT();
		int is_shown();
		void hide();
		void moveto(int,int);
		int capture(int,int,int,int);
		int hit();
		int clicked();
		int LBDCLK();
		int LBSCLK();
		int xsize();
		int ysize();
		int bitmapx();
		int bitmapy();
		void changexy(int,int);
		};

//************************************************************************

class Panel:public Point
{
	protected:
		int w;
		int h;
		int in_or_out;
		int thick_or_thin;
	public:
		Panel();
		~Panel();
		virtual void show();
		void init(int,int,int,int,int,int);
		};

//************************************************************************

class Bevel:public Point
{
	private:
		int w;
		int h;
		int thick_or_thin;
		Panel outerbevel;
		Panel innerbevel;
	public:
		void init(int,int,int,int,int);
		virtual void show();
		};

//************************************************************************

class OKbox:public Point
{
	protected:
		Button OKbutton;
		Button ESCbutton;
		Panel panel;
		char text[90];
		void *screen;
		int OKorNOT;
	public:
		OKbox();
		~OKbox();
		void init(int,int,char*);
		int show();
		};

//************************************************************************

class Gwindow:public Point
{
	protected:
		Closebutton closebox;
		int			w,h;
		int			fgd,bgd;
		int			tfgd,tbgd;
		int			active;
		char		title[48];
		void		*beneath;
	public:
		Gwindow();
		~Gwindow();
		void init(int,int,int,int,int,int,int,int,char *);
		void show();
		void redraw();
		void hide();
		int	 closeboxhit();
		int  sizecornerhit();
		int  titlebarhit();
		void resize();
		void move();
		int write_to_disk();
		int read_from_disk();
		int totalGwindows();
		};

//GMENU
typedef char gitemarray[80][10];


class Gmenu {
	protected:
		int on;
		int x,y,w,h;
		int num;
		gitemarray gitems;
		int menuchoice;
		int oldbarx,oldbary;
		void *ptr;
		void *menubar;
	public:
		Gmenu();
		~Gmenu();
		void init(int xloc,int yloc,int numentries,gitemarray gitem);
		int show();
		void hide();
		int isshown();
		};

//**************************************************************************

class Gmenubutton {
	protected:
		int on;
		int x,y;
		int offfgd,offbgd;
		int onfgd,onbgd;
		char id[20];
	public:
		Gmenubutton();
		~Gmenubutton();
		void init(int xloc,int yloc,int ffgd,int fbgd,
		int nfgd,int nbgd,char txt[20]);
		void show();
		void press();
		int hit();
		};

//GPRINT
void gprintf(int xloc,int yloc,char *fmt,...);
void gprintc(int xloc, int yloc, char *fmt,...);
void gprintxy(int xloc,int yloc,char *fmt,...);

//SOUNDQ
#define TimerTick 0x8
#define noisemax 8192
#define ON 1
#define OFF 0

#define C 523
#define CS 554
#define D 587
#define DS 622
#define E 659
#define F 698
#define FS 740
#define G 784
#define GS 831
#define A 880
#define AS 932
#define B 988
#define C1 1046

#define SN 32
#define EN 63
#define QN 125
#define HN 250
#define WN 500

#define ENT 20
#define QNT 41
#define HNT 83

#define BN 30000,5
#define SR 30000,32
#define ER 30000,63
#define QR 30000,125
#define HR 30000,250
#define WR 30000,500
#define NM 30000,1

class SoundQ{
	protected:
    	float speed_factor;
	public:
		SoundQ();
		~SoundQ();
		void play(int,int);
		void adjust_speed(float);
		};

typedef struct
{
  int duration;
  int freq;
} noise;

void empty_sound_queue();
void init_sound(void);
void restore_sound(void);
int submit_sound(int freq,int delay);
void interrupt soundsystem(...);

//SCREEN
extern "C" void 	_Cdecl vga256_driver();

class Screen {
	protected:
		static int huge alwayszero();
	public:
		Screen();
		~Screen();
		int VGA_480_16();
		int VGA_350_16();
		int VGA_200_16();
		int VGA_200_256();
		void fill(int);
		};
