//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// Main Header File for window related classes, variables, and functions
//
// If you include this file, without including FLI.H first -- this file
// will automatically include it for you
//

// ==========================================================================
// Consult the reference manual for complete function reference of all
// functions within this header file.  All variables are documented
// inside this header file, for ease of use when modifying the supplied
// source code.  For additional class information, please consult the
// Software Dimensions BBS.  Telephone numbers are included in the
// READ.ME file and in the documentation.
// ==========================================================================

#ifndef __FusionWindows__
#define __FusionWindows__

#ifndef __Fusion__
#include "fli.h"
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//
//                                                                           //
// ShiftManager - Controls the ctrl/alt/normal prompt line                   //
//                                                                           //
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

class WindowElement;

class ShiftManager : virtual public FusionHelp
{
private:

  int NumKeyTies;                   // Number of keys that are linked

  struct _HotKeys                   // Structure containing defined hot keys
  {
    int Tie;                          // The key code for the hot key
    int Event;                        // The event that cooresponds to the key
  } *Keys;

  struct _PromptLine                // Structure containing the prompt line
  {
    char *Key;                        // The text for the key
    char *Info;                       // The text for the key description
    int Event;                        // The event linked to this key
  } *Alt, *Ctrl, *Normal;

  int NumAltKeys;                   // Number of defined ALT keys
  int NumCtrlKeys;                  // Number of defined CTRL keys
  int NumNormKeys;                  // Number of defined unshifted keys

  int InAWindow;                    // Are we in a window?

  int Item;                         // Current highlighted item (by mouse)
  int XOffset;                      // X coordinate of highlighted item
  int PromptWidth;                  // Width of highlighted item
  int OnLastShift;                  // Item last shifted/highlighted

  char *SnapShot;                   // Snap shot of bottom display line

protected:
                                    // These members are static because
                                    // of the possibilities of multiple
                                    // prompt lines accross windows and
                                    // the problems they can pose if each
                                    // shift manager doesn't know what
                                    // happened with the shift states

  static int LastShift;             // Last state of the shifted keys
  static int KeyLast;               // Last key pressed

  int RefreshPromptLine();
  int CheckEvent(int);

public:

  ShiftManager();
  ~ShiftManager();

  void DefineAltKey(char *,char *,int=0,int=0);
  void DefineCtrlKey(char *,char *,int=0,int=0);
  void DefineNormKey(char *,char *,int=0,int=0);
  void DefineKey(int,int);

  int CheckPromptLine();

  virtual int EventHandler(int) = 0;

  friend class WindowElement;
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//
//                                                                           //
// MenuManager - The main menu control class [uses _Options and MenuItems]   //
// _Options - Contains the menu options, which is used inside MenuItems      //
// MenuItems - Contains information about each menu on the menu bar and      //
//    self-contains the _Options structure which stores each menu item on    //
//    the menu
//                                                                           //
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

class WindowElement;
class FusionWindow;
class MenuAlteration;
class MenuItems;

struct _Options                     // structure containing menu options
{
  char *Help;                       // The help line for this option
  char *Option;                     // The name of this option
  char *HotKeyOption;               // The text for the hot key
                                    // linked to this option

  int Event;                        // The event linked to this option
  int HotKey;                       // The hot key linked to this option
  int QuickKey;                     // The one-key quick-key for this option
  int SelectCount;                  // Number of available selectables
  int WidestSelectable;             // What is the width of the widest?
  int *Available;                   // Pointer to integer signifying if
                                    // this option is available (1)
  int *Checked;                     // Can this option be checked?
  int *Selectable;                  // Current selectable option

  char **Selectables;               // List of selectable options

  MenuItems *SubMenu;               // Pointer to a sub menu, if available

  int PreviousState;                // Stores the previous state of the
                                    // menu option -- the available state
};

class MenuItems                     // Class containing menu items
{
private:

  _Options *Option;                 // Contains menu items

  char *Title;                      // Title of the menu on the menu bar
  char *MenuHelp;                   // Global help for the menu

  int X;                            // X location of menu
  int Y;                            // Y location of menu
  int XEnd;                         // End of title on menu bar (for mouse)
  int Width;                        // Width of the menu
  int Height;                       // Height of the menu
  int XStart;                       // Start of title on menu bar (for mouse)
  int HotKeys;                      // Are hot keys available (1) or not (0)
  int SubMenus;                     // Are sub menus available (1) or not (0)
  int Checkables;                   // Are there any checkables (1) or not (0)
  int MenuHotKey;                   // Hot key to activate this menu
  int Selectables;                  // Are there any selectable options (1)?
  int CurrentOption;                // Currently selected option on menu
  int NumberOfOptions;              // Number of menu options available

  int MenuEvent;                    // Event for this menu

  char *SavedRegion;                // Storage for screen under the menu

  int ScanMenu(int);
  int PlaceOption(int);
  int PlaceMenu(int,int,MenuItems &,int=0);

  void RemoveMenu();
  void RemoveOption();
  void ReCheckOption();
  void ReSelectOption();

  void _HotKey(char *,int);
  void _Option(char *,char *,int=0,char *HotKey=0,int=0);

public:

  MenuItems();
  ~MenuItems();

  friend class MenuManager;
  friend class FusionWindow;
  friend class MenuAlteration;
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//
//                                                                           //
// MenuManager - The main menu control class                                 //
//                                                                           //
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

class MenuManager : virtual public FusionHelp
{
public:

  MenuItems **Menus, **SubMenuTrack; // Defines menus and sub menus

  static int IsPullDown;            // Are menus pulldown (1) or popdown (0)
  static int Beneath;               // Sub menus are displayed beneath (1)
                                    // or to right of (0) menu options
  static int IdentifyCheck;         // Should the underscore be shown?

  int SetX;                         // X location of menu bar
  int SetY;                         // Y location of menu bar
  int StowedWidth;                  // Current Width of Bar (for menu altering)
  int CurrentLevel;                 // Current menu level (0=no menus active)
  int NumberOfMenus;                // Number of menus available
  int MouseInControl;               // Is mouse in control of menu (1) or
                                    // not (0).  If not, callback will bring
                                    // mouse control back.

  void SubMenu();
  void CallMenu();
  void FindNext();
  void FindLast();
  void BlankLine();
  void EndSubMenu();
  void RemoveMenu();
  void RemoveOption();
  void RefreshMenus();
  void RemoveAllMenus();
  void Available(int &);
  void CheckMark(int &);
  void PlaceOption(int);
  void HotKey(char *,int);
  void Selectable(int & ...);
  void PlaceMenu(MenuItems &);
  void NewMenu(char *,char *,int,int=0);
  void Option(char *,char *,int=0,char *HotKey=0,int=0);

  int SetMenuBar(int,int,int,void far *Memory=0);

  static void MenuPopDown();
  static void MenuPullDown();
  static void SubMenuRight();
  static void SubMenuBeneath();

  int Manager(int,int,int,WindowElement &,FusionWindow &);

  MenuManager();
  ~MenuManager();
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//
//                                                                           //
// MenuAlteration - Menu alteration class                                    //
//                                                                           //
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

class MenuAlteration : public MenuManager
{
private:

  MenuItems *GrabThis(int,MenuItems *);

protected:

  void SetMenus();

  void DeleteLastMenu();
  void DeleteAllMenus();
  void DeleteMenu(int);
  void DeleteOption(int);
  void ChangeOption(int,char *,char *,int,char *,int);
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//
//                                                                           //
// FusionWindow - The main window and pulldown menu control class            //
//                                                                           //
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

class FusionWindow : public Event, public ShiftManager, public MenuAlteration
{
private:

  BlazeClass Blaze;                 // BlazeClass definition for windows

  WindowElement **Windows;          // Pointers to all available windows in
                                    // the order in the reverse of which they
                                    // are visible on the screen.  In other
                                    // words, if there are two windows on
                                    // the screen -- the window on top is
                                    // the last window in this buffer.

  int MaxWindows;                   // Maximum open windows.  0 means keep
                                    // opening until memory runs out, any
                                    // other number specifies maximum windows

  int VirtualizeInterval;           // Time between virtual events

  int DefaultHelp;                  // This is the default help screen

  int CheckMoveOrSize();
  void CallWindow(int);

protected:

  int CheckEcho();
  int CheckVirtuals();
  int CheckForEcho(int);

  void MoveWindow();
  void SizeWindow();
  void NextWindow();
  void LastWindow();
  void ZoomWindow();
  void TileWindows();
  void CloseWindow();
  void CloseEcho(int);
  void FreshEcho(int);
  void StackWindows();
  void ListAndSelect();
  void CascadeWindows();
  void RefreshWindows();
  void PyramidWindows();
  void VirtualizeFresh();
  void IndexCardWindows();
  void WaterFallWindows();
  void RefreshWorkSpace();

  WindowElement *TopWindow();

public:

  int NumberOfWindows;              // Number of available windows

  FusionWindow();
  virtual ~FusionWindow();

  int EngageFusion();
  int NewWindow(WindowElement *,char *,int=0);
  void GlobalHelp(int HelpSys) { DefaultHelp=HelpSys; }
  void MaximumWindows(int Windows) { MaxWindows=Windows; }
  void VirtualInterval(int);

  virtual int EventHandler(int) = 0;

  friend class WindowElement;
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//
//                                                                           //
// WindowColors - The colors for the defined window                          //
// WindowElement - The window definition class                               //
//                                                                           //
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

class WindowColors
{
public:

  int WinBorder;                    // Window colors
  int WinIcons;                     // See documentation for details
  int WinTitle;
  int WinScrollBar;
  int WinSizeCorner;
  int WinInterior;
  int WinBoldInterior;
  int WinAltInterior;
  int WinDead;

  WindowColors();
};

class WindowElement : public ShiftManager, public MenuManager,
  public WindowColors
{
protected:

  // Global Window Related Stuff ---------------------------------------------

  char *Title;                // What is the title of the window?

  int MinimumWidth;           // What is the minimum width of the window?
  int MinimumHeight;          // What is the minimum height of the window?

  int X;                      // X Coordinate -- Where is the window?
  int Y;                      // Y Coordinate -- Where is the window?

  int Width;                  // How wide is the window?
  int Height;                 // How high is the window?

  int WindowNumber;           // Can be numbered from 1 - 10, for ALT key
                              // access, otherwise must be selected by
                              // jumping

  int Active;                 // Is window currently active?

  int VirtualUpdate;          // Is window virtually updated?

  BlazeClass Blaze;

  // Scroll Bar Related Stuff ------------------------------------------------

  int ExistXScrollBar;        // Is there a horizontal scroll bar?
  int ExistYScrollBar;        // Is there a vertical scroll bar?

  int XMaximum;               // What is the hi-end of the X bar?
  int XCurrent;               // Where is the thumb tab on the X bar?

  int YMaximum;               // What is the hi-end of the Y bar?
  int YCurrent;               // Where is the thumb tab on the Y bar?

  // Icon Related Stuff ------------------------------------------------------

  int ZoomIcon;               // Does window have a zoom icon?
  int CloseIcon;              // Does window have a close icon?
  int SizeIcon;               // Does window have a size icon?
  int Moveable;               // Is the window movable?

  int WindowZoomed;           // Has the window been zoomed?

  int OldX;                   // The "OLD" variables are set with
  int OldY;                   // numbers to represent the state
  int OldWidth;               // of the window before the last
  int OldHeight;              // zoom operation;

  // Connects this class to the Fusion Windows system ------------------------

  FusionWindow *MainHandler;  // Makes connection to FusionWindow so
                              // the window has control over the global
                              // menus

  // Window/Menu Validation and Checking Functions ---------------------------

  int CheckScrollBar();
  void DisplayScrollBar();
  void RemoveTheMenus();

public:

  WindowElement();
  virtual ~WindowElement();

  virtual int Echo();
  virtual void Cursor();
  virtual void ReAlign();
  virtual void ShowWindow();

  virtual void ShowInterior() = 0;
  virtual int EventHandler(int) = 0;

  friend class FusionWindow;
};

#endif

