#
# The Fusion Library Interface for DOS
# Version 1.06c
# Copyright (C) 1990, 1991, 1992
# Software Dimensions
#
# Make File
#
# Required Directory Structure:
#                                       +-- S (mall/tiny)
#                                       |-- M (edium)
#                               FLI ----+-- C (ompact)
#                                       |-- L (arge)
#                                       +-- H (uge)

# Change the COMPILER variable to the name of the compiler that you are
# using:
#   TCC for Turbo C++ 1.01+
#   BCC for Borland C++ 2.0x and Borland C++ 3.00
#   BCCX for Borland C++ 2.0x (Protected Mode)

COMPILER = BCC

# Change the INCLUDES variable so it will point to the location of your
# TC++/BC++ include directory.  Also change the LIBRARIES variable so it
# will point to the location of your TC++/BC++ libraries directory.

INCLUDES = \BC3\INCLUDE;.
LIBRARIES = \BC3\LIB;.

# If you are using Borland C++ 3.0, you may want to specify specific
# optimization options.  The line below permits you to do so.  We are
# using -O1 which enables full size optimization.  You may choose to
# use -O2 for full speed or may choose to use some of the many other
# optimizations:
#
#   -O -Oa -Ob -Oc -Od -Oe -Og -Oi -Ol -Om -Op -Os -Ot
#   -Ov -Ox -Z -G
#
# You might even alter this line if you are using TC++ or BC++ 2.0 and
# want to enable optimizations.

OPTIMIZE = -O1

# Blank out the PRECOMP variable if you are using Turbo C++.  You must do
# this since Turbo C++ DOES NOT support pre-compiled headers

PRECOMP = -H -H=FLI.SYM

# If using a large code model (m/l/h), activate VROOMM

!if $(SMALL)
COMPILE=-ms -ns
MODEL=s
.PATH.obj=s
!elif $(COMPACT)
COMPILE=-mc -nc
MODEL=c
.PATH.obj=c
!elif $(MEDIUM)
COMPILE=-mm -nm -Y
MODEL=m
.PATH.obj=m
!elif $(LARGE)
COMPILE=-ml -nl -Y
MODEL=l
.PATH.obj=l
!elif $(HUGE)
COMPILE=-mh -nh -Y
MODEL=h
.PATH.obj=h
!else
!error Must define SMALL, COMPACT, MEDIUM, LARGE, or HUGE.
!endif

CC = $(COMPILER) +FLI.CFG $(OPTIMIZE) $(COMPILE)
FLIOBJ =  blbox.obj \
          blboxatt.obj \
          blboxfil.obj \
          blbvrvs.obj \
          blbvsvr.obj \
          blccons.obj \
          blchange.obj \
          blchdown.obj \
          blchfill.obj \
          blchrep.obj \
          blcls.obj \
          blcomp.obj \
          blcons.obj \
          blcopy.obj \
          blcursor.obj \
          bldchar.obj \
          blerase.obj \
          blextend.obj \
          blfresh.obj \
          blfromto.obj \
          blfunc.obj \
          blgetkey.obj \
          blgetxy.obj \
          blgotoxy.obj \
          blhline.obj \
          blisbw.obj \
          bllineat.obj \
          blone.obj \
          blpal.obj \
          blputget.obj \
          blquick.obj \
          blscroll.obj \
          blseekey.obj \
          blshadow.obj \
          bltext.obj \
          bluser.obj \
          blvrvr.obj \
          blvrvs.obj \
          blvsvr.obj \
          blwin.obj \
          diabcd.obj \
          diachar.obj \
          diacheck.obj \
          diacombo.obj \
          diadoubl.obj \
          diaelem.obj \
          diafloat.obj \
          diagen.obj \
          diahrad.obj \
          diaint.obj \
          dialong.obj \
          diamulti.obj \
          dianum.obj \
          diapick.obj \
          diapush.obj \
          diaspick.obj \
          diavrad.obj \
          dlgact.obj \
          dlgadd.obj \
          dlgcons.obj \
          dlgelem.obj \
          dlggroup.obj \
          dlghot.obj \
          dlgjump.obj \
          dlgone.obj \
          dlgshow.obj \
          dlguse.obj \
          flicolor.obj \
          flievent.obj \
          flihelp.obj \
          flimouse.obj \
          fliprot.obj \
          infobox.obj \
          maskbcd.obj \
          maskch.obj \
          maskchar.obj \
          maskdbl.obj \
          maskflt.obj \
          maskint.obj \
          masklong.obj \
          masknum.obj \
          popup.obj \
          winalter.obj \
          winavail.obj \
          wincall.obj \
          wincas.obj \
          wincheck.obj \
          winclose.obj \
          wincons.obj \
          windef.obj \
          winecho.obj \
          winfall.obj \
          winfind.obj \
          winfresh.obj \
          winhot.obj \
          winindex.obj \
          winitems.obj \
          winlast.obj \
          winlist.obj \
          winman.obj \
          winmark.obj \
          winmcall.obj \
          winmove.obj \
          winmenu.obj \
          winnew.obj \
          winnext.obj \
          winopt.obj \
          winpyra.obj \
          winsel.obj \
          winset.obj \
          winsize.obj \
          winstate.obj \
          winsub.obj \
          wintile.obj \
          winuse.obj \
          winvir.obj \
          winwksp.obj \
          winzoom.obj

FLILIB =  -+blbox.obj \
          -+blboxatt.obj \
          -+blboxfil.obj \
          -+blbvrvs.obj \
          -+blbvsvr.obj \
          -+blccons.obj \
          -+blchange.obj \
          -+blchdown.obj \
          -+blchfill.obj \
          -+blchrep.obj \
          -+blcls.obj \
          -+blcomp.obj \
          -+blcons.obj \
          -+blcopy.obj \
          -+blcursor.obj \
          -+bldchar.obj \
          -+blerase.obj \
          -+blextend.obj \
          -+blfresh.obj \
          -+blfromto.obj \
          -+blfunc.obj \
          -+blgetkey.obj \
          -+blgetxy.obj \
          -+blgotoxy.obj \
          -+blhline.obj \
          -+blisbw.obj \
          -+bllineat.obj \
          -+blone.obj \
          -+blpal.obj \
          -+blputget.obj \
          -+blquick.obj \
          -+blscroll.obj \
          -+blseekey.obj \
          -+blshadow.obj \
          -+bltext.obj \
          -+bluser.obj \
          -+blvrvr.obj \
          -+blvrvs.obj \
          -+blvsvr.obj \
          -+blwin.obj \
          -+diabcd.obj \
          -+diachar.obj \
          -+diacheck.obj \
          -+diacombo.obj \
          -+diadoubl.obj \
          -+diaelem.obj \
          -+diafloat.obj \
          -+diagen.obj \
          -+diahrad.obj \
          -+diaint.obj \
          -+dialong.obj \
          -+diamulti.obj \
          -+dianum.obj \
          -+diapick.obj \
          -+diapush.obj \
          -+diaspick.obj \
          -+diavrad.obj \
          -+dlgact.obj \
          -+dlgadd.obj \
          -+dlgcons.obj \
          -+dlgelem.obj \
          -+dlggroup.obj \
          -+dlghot.obj \
          -+dlgjump.obj \
          -+dlgone.obj \
          -+dlgshow.obj \
          -+dlguse.obj \
          -+flicolor.obj \
          -+flievent.obj \
          -+flihelp.obj \
          -+flimouse.obj \
          -+fliprot.obj \
          -+infobox.obj \
          -+maskbcd.obj \
          -+maskch.obj \
          -+maskchar.obj \
          -+maskdbl.obj \
          -+maskflt.obj \
          -+maskint.obj \
          -+masklong.obj \
          -+masknum.obj \
          -+popup.obj \
          -+winalter.obj \
          -+winavail.obj \
          -+wincall.obj \
          -+wincas.obj \
          -+wincheck.obj \
          -+winclose.obj \
          -+wincons.obj \
          -+windef.obj \
          -+winecho.obj \
          -+winfall.obj \
          -+winfind.obj \
          -+winfresh.obj \
          -+winhot.obj \
          -+winindex.obj \
          -+winitems.obj \
          -+winlast.obj \
          -+winlist.obj \
          -+winman.obj \
          -+winmark.obj \
          -+winmcall.obj \
          -+winmove.obj \
          -+winmenu.obj \
          -+winnew.obj \
          -+winnext.obj \
          -+winopt.obj \
          -+winpyra.obj \
          -+winsel.obj \
          -+winset.obj \
          -+winsize.obj \
          -+winstate.obj \
          -+winsub.obj \
          -+wintile.obj \
          -+winuse.obj \
          -+winvir.obj \
          -+winwksp.obj \
          -+winzoom.obj

!if $d(DEBUG)

.cpp.obj:
  $(CC) -v {$<  }

fli$(MODEL).lib: fli.cfg $(FLIOBJ)
  CD $(MODEL)
  tlib @&&!
..\$* /C $(FLILIB)
!
  CD ..

!else

.cpp.obj:
  $(CC) {$<  }

fli$(MODEL).lib: fli.cfg $(FLIOBJ)
  CD $(MODEL)
  tlib @&&!
..\$* /C/0 $(FLILIB)
!
  CD ..

!endif

blbox.obj: blbox.cpp fli.h
blboxatt.obj: blboxatt.cpp fli.h
blboxfil.obj: blboxfil.cpp fli.h
blbvrvs.obj: blbvrvs.cpp fli.h
blbvsvr.obj: blbvsvr.cpp fli.h
blccons.obj: blccons.cpp fli.h
blchange.obj: blchange.cpp fli.h
blchdown.obj: blchdown.cpp fli.h
blchfill.obj: blchfill.cpp fli.h
blchrep.obj: blchrep.cpp fli.h
blcls.obj: blcls.cpp fli.h
blcomp.obj: blcomp.cpp fli.h
blcons.obj: blcons.cpp fli.h
blcopy.obj: blcopy.cpp fli.h
blcursor.obj: blcursor.cpp fli.h
bldchar.obj: bldchar.cpp fli.h
blerase.obj: blerase.cpp fli.h
blextend.obj: blextend.cpp fli.h
blfresh.obj: blfresh.cpp fli.h colors.h
blfromto.obj: blfromto.cpp fli.h
blfunc.obj: blfunc.cpp fli.h
blgetkey.obj: blgetkey.cpp fli.h
blgetxy.obj: blgetxy.cpp fli.h
blgotoxy.obj: blgotoxy.cpp fli.h
blhline.obj: blhline.cpp fli.h colors.h
blisbw.obj: blisbw.cpp fli.h
bllineat.obj: bllineat.cpp fli.h
blone.obj: blone.cpp fli.h
blpal.obj: blpal.cpp fli.h
blputget.obj: blputget.cpp fli.h
blquick.obj: blquick.cpp fli.h
blscroll.obj: blscroll.cpp fli.h
blseekey.obj: blseekey.cpp fli.h
blshadow.obj: blshadow.cpp fli.h
bltext.obj: bltext.cpp fli.h
bluser.obj: bluser.cpp fli.h
blvrvr.obj: blvrvr.cpp fli.h
blvrvs.obj: blvrvs.cpp fli.h
blvsvr.obj: blvsvr.cpp fli.h
blwin.obj: blwin.cpp fli.h
diabcd.obj: diabcd.cpp fli.h colors.h elements.h defines.h
diachar.obj: diachar.cpp fli.h colors.h elements.h defines.h
diacheck.obj: diacheck.cpp fli.h colors.h elements.h defines.h
diacombo.obj: diacombo.cpp fli.h colors.h elements.h defines.h
diadoubl.obj: diadoubl.cpp fli.h colors.h elements.h defines.h
diaelem.obj: diaelem.cpp fli.h colors.h elements.h defines.h
diafloat.obj: diafloat.cpp fli.h colors.h elements.h defines.h
diagen.obj: diagen.cpp fli.h colors.h elements.h defines.h
diahrad.obj: diahrad.cpp fli.h colors.h elements.h defines.h
diaint.obj: diaint.cpp fli.h colors.h elements.h defines.h
dialong.obj: dialong.cpp fli.h colors.h elements.h defines.h
diamulti.obj: diamulti.cpp fli.h colors.h elements.h defines.h
dianum.obj: dianum.cpp fli.h colors.h elements.h defines.h
diapick.obj: diapick.cpp fli.h colors.h elements.h defines.h
diapush.obj: diapush.cpp fli.h colors.h elements.h defines.h
diaspick.obj: diaspick.cpp fli.h colors.h elements.h defines.h
diavrad.obj: diavrad.cpp fli.h colors.h elements.h defines.h
dlgact.obj: dlgact.cpp fli.h defines.h
dlgadd.obj: dlgadd.cpp fli.h
dlgcons.obj: dlgcons.cpp fli.h colors.h
dlgelem.obj: dlgelem.cpp fli.h
dlggroup.obj: dlggroup.cpp fli.h
dlghot.obj: dlghot.cpp fli.h
dlgjump.obj: dlgjump.cpp fli.h defines.h
dlgone.obj: dlgone.cpp fli.h
dlgshow.obj: dlgshow.cpp fli.h colors.h defines.h
dlguse.obj: dlguse.cpp fli.h defines.h
flicolor.obj: flicolor.cpp fli.h colors.h
flievent.obj: flievent.cpp fli.h defines.h
flihelp.obj: flihelp.cpp fli.h defines.h colors.h
flimouse.obj: flimouse.cpp fli.h defines.h
fliprot.obj: fliprot.cpp fli.h
infobox.obj: infobox.cpp fli.h colors.h defines.h elements.h
maskbcd.obj: maskbcd.cpp fli.h
maskch.obj: maskch.cpp fli.h
maskchar.obj: maskchar.cpp fli.h
maskdbl.obj: maskdbl.cpp fli.h
maskflt.obj: maskflt.cpp fli.h
maskint.obj: maskint.cpp fli.h
masklong.obj: masklong.cpp fli.h
masknum.obj: masknum.cpp fli.h
popup.obj: popup.cpp fli.h colors.h defines.h
winalter.obj: winalter.cpp fli.h fliwin.h
winavail.obj: winavail.cpp fli.h fliwin.h
wincall.obj: wincall.cpp fli.h fliwin.h
wincas.obj: wincas.cpp fli.h fliwin.h
wincheck.obj: wincheck.cpp fli.h fliwin.h colors.h
winclose.obj: winclose.cpp fli.h fliwin.h colors.h
wincons.obj: wincons.cpp fli.h fliwin.h
windef.obj: windef.cpp fli.h colors.h defines.h fliwin.h
winecho.obj: winecho.cpp fli.h fliwin.h
winfall.obj: winfall.cpp fli.h fliwin.h
winfind.obj: winfind.cpp fli.h fliwin.h
winfresh.obj: winfresh.cpp fli.h fliwin.h colors.h
winhot.obj: winhot.cpp fli.h fliwin.h
winindex.obj: winindex.cpp fli.h fliwin.h
winitems.obj: winitems.cpp fli.h fliwin.h colors.h
winlast.obj: winlast.cpp fli.h fliwin.h
winlist.obj: winlist.cpp fli.h fliwin.h elements.h colors.h
winman.obj: winman.cpp fli.h fliwin.h defines.h
winmark.obj: winmark.cpp fli.h fliwin.h
winmcall.obj: winmcall.cpp fli.h fliwin.h
winmove.obj: winmove.cpp fli.h fliwin.h colors.h
winmenu.obj: winmenu.cpp fli.h fliwin.h
winnew.obj: winnew.cpp fli.h fliwin.h
winnext.obj: winnext.cpp fli.h fliwin.h
winopt.obj: winopt.cpp fli.h fliwin.h
winpyra.obj: winpyra.cpp fli.h fliwin.h
winsel.obj: winsel.cpp fli.h fliwin.h
winset.obj: winset.cpp fli.h fliwin.h colors.h
winsize.obj: winsize.cpp fli.h fliwin.h colors.h
winstate.obj: winstate.cpp fli.h colors.h fliwin.h defines.h
winsub.obj: winsub.cpp fli.h fliwin.h
wintile.obj: wintile.cpp fli.h fliwin.h
winuse.obj: winuse.cpp fli.h defines.h fliwin.h
winvir.obj: winvir.cpp fli.h defines.h fliwin.h
winwksp.obj: winwksp.cpp fli.h fliwin.h
winzoom.obj: winzoom.cpp fli.h fliwin.h

fli.cfg: fli.mak
  copy &&|
-a
-c
-f
-ff
-K
-k-
-P
-V
-vi-
-X
$(PRECOMP)
-wbbf
-weas
-wpin
-wamb
-wamp
-wasm
-wdef
-wnod
-wpro
-wstv
-wuse
-wcln
-wsig
-wucp
-wpre
-I$(INCLUDES)
-L$(LIBRARIES)
| fli.cfg


