//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "fliwin.h"
#include "colors.h"
#include "elements.h"
#include "dds.h"

#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <alloc.h>

//-------------------------------------------------------------------------
//
// This is a generic pick list that is used with the testing system
//
//-------------------------------------------------------------------------

class CustomPickList : public DiaPickGeneric
{
  public:

    int Item;
    int ItemCount;

    CustomPickList(int _X,int _Y,int _Width,int _Height)
     : DiaPickGeneric(_X,_Y,_Width,_Height,Item,ItemCount)
    {
      Item=0;
      ItemCount=18;
    }

    char *GetItem(int ItemNumber)
    {
      static char *Items[] =
        { "This","Is","A","Test","Pick","List","So","You","Can","See",
          "If","It","Works","Correctly","In","Your","Own","Program!" };
      return Items[ItemNumber];
    }
};

//-------------------------------------------------------------------------
//
// Dialog Tester class
//
//-------------------------------------------------------------------------

class TestingDialog : public DialogClass
{
public:
  int EventHandler(int);
  TestingDialog(int Width,int Height,char *Title) :
    DialogClass(Width,Height,Title) { };
};

int TestingDialog::EventHandler(int Event)
{
	if (Event==kbEsc ||
			Event==kbCr ||
			Event==CloseEvent ||
			Event==OutsideEvent)
		return StopEvent;
	return CompleteEvent;
}

//-------------------------------------------------------------------------
//
// Dialog Tester
//
//-------------------------------------------------------------------------

void DialogWindow::TestDialog()
{
  // check for elements

  TestingDialog &Dialog=*new TestingDialog(Width,Height,Title);

  MouseHide();

  //-------------------------------------------------------------------------
  //
  // Output Blaze Drawing Code (not Text)
  //
  //-------------------------------------------------------------------------

  if (NumberPieces)
  {
    for (int i=0;i<NumberPieces;i++)
    {
      PieceHandler &Piece=*Pieces[i];
      if (Piece.LayOut<PieceHandler::__DUMMY__)
      {
        switch(Piece.LayOut)
        {
          case PieceHandler::Box:
            Dialog.Blaze.Box(Piece.X,Piece.Y,Piece.Width,Piece.Height,
              Piece.Color);
            break;

          case PieceHandler::FilledBox:
            Dialog.Blaze.BoxFilled(Piece.X,Piece.Y,Piece.Width,Piece.Height,
              Piece.Color);
            break;

          case PieceHandler::HorizontalLine:
            Dialog.Blaze.CharacterRepeater(Piece.X,Piece.Y,Piece.Width,
              Piece.Color,196);
            break;

          case PieceHandler::VerticalLine:
            Dialog.Blaze.CharacterRepeaterDown(Piece.X,Piece.Y,Piece.Height,
              Piece.Color,179);
            break;

          case PieceHandler::Shadow:
            Dialog.Blaze.Shadow(Piece.X,Piece.Y,Piece.Width,Piece.Height);
            break;

          case PieceHandler::EraseArea:
            Dialog.Blaze.EraseArea(Piece.X,Piece.Y,Piece.Width,Piece.Height,
              Piece.Color);
            break;

          case PieceHandler::ColorizeArea:
            Dialog.Blaze.BoxAttribute(Piece.X,Piece.Y,Piece.Width,
              Piece.Height,Piece.Color);
            break;
        }
      }
    }
  }

  //-------------------------------------------------------------------------
  //
  // Output Blaze Text Code
  //
  //-------------------------------------------------------------------------

  for (int y=0;y<Height;y++)
  {
    char *OutPut=Interior[y];
    for (int x=0;x<Width;x++,OutPut+=2)
    {
      if (*OutPut)
        Dialog.Blaze (x,y) << (int)*(OutPut+1) << *OutPut;
    }
  }

  //-------------------------------------------------------------------------
  //
  // Output Group Headings
  //
  //-------------------------------------------------------------------------

  if (NumberPieces)
  {
    for (int i=0;i<NumberPieces;i++)
    {
      PieceHandler &Piece=*Pieces[i];
      if (Piece.LayOut>PieceHandler::__DUMMY2__)
      {
        Dialog.GroupHeading(Piece.X,Piece.Y,Piece.GroupCode,Piece.Text,0);
      }
    }
  }

  //-------------------------------------------------------------------------
  //
  // Output Dialog Class Code
  //
  //-------------------------------------------------------------------------

  int *IntStorage=new int[NumberPieces];
  long *LongStorage=new long[NumberPieces];
  char **CharacterStorage=0;

  int NumInts=0;
  int NumLongs=0;
  int NumChars=0;

  if (NumberPieces)
  {
    for (int i=0;i<NumberPieces;i++)
    {
      PieceHandler &Piece=*Pieces[i];

      if (Piece.LayOut<PieceHandler::__DUMMY__ ||
        Piece.LayOut>PieceHandler::__DUMMY2__)
        continue;

      DialogElement *Save;

      // Declare variables

      switch(Piece.LayOut)
      {
        case PieceHandler::Character:
          CharacterStorage=(char **)realloc(CharacterStorage,++NumChars*sizeof(char *));
          CharacterStorage[NumChars-1]=
            new char[(!Piece.MaskWidth)?(strlen(Piece.Mask)+1):(Piece.MaskWidth+1)];
          *(CharacterStorage[NumChars-1]+0)=0;
          break;

        case PieceHandler::Integer:
        case PieceHandler::Long:
        case PieceHandler::Float:
        case PieceHandler::Double:
        case PieceHandler::Bcd:
          LongStorage[NumLongs++]=0;
          break;

        case PieceHandler::Check:
        case PieceHandler::HRadio:
        case PieceHandler::VRadio:
          IntStorage[NumInts++]=0;
          break;
      }

      // Declare elements

      switch(Piece.LayOut)
      {
        case PieceHandler::Character:
          Save=new DiaChar(Piece.X,Piece.Y,Piece.Mask,CharacterStorage[NumChars-1],
            Piece.ScrollWidth,Piece.MaskCharacter,Piece.MaskWidth);
          break;

        case PieceHandler::Integer:
        case PieceHandler::Long:
        case PieceHandler::Float:
        case PieceHandler::Double:
        case PieceHandler::Bcd:
          Save=new DiaLong(Piece.X,Piece.Y,Piece.Mask,LongStorage[NumLongs-1]);
          break;

        case PieceHandler::Push:
          Save=new DiaPushButton(Piece.X,Piece.Y,Piece.Text,0,0);
          break;

        case PieceHandler::Check:
          Save=new DiaCheckBox(Piece.X,Piece.Y,IntStorage[NumInts-1],Piece.Text,0);
          break;

        case PieceHandler::HRadio:
          Save=new DiaHorizRadio(Piece.X,Piece.Y,IntStorage[NumInts-1],0,0);
          break;

        case PieceHandler::VRadio:
          Save=new DiaVertRadio(Piece.X,Piece.Y,IntStorage[NumInts-1],0,0);
          break;

        case PieceHandler::PickGeneric:
          Save=new CustomPickList(Piece.X,Piece.Y,Piece.Width-3,Piece.Height);
          break;
      }

      // Give the dialog controller information about the element

      if (Piece.GroupCode)
        Dialog.GroupElement(Piece.GroupCode,Save);
      else
        Dialog.Element(Save);

      // For radio buttons

      if (Piece.LayOut==PieceHandler::HRadio ||
        Piece.LayOut==PieceHandler::VRadio)
      {
        for (int j=0;j<10;j++)
        {
          if (!*(Piece.Elements[j]+0))
            break;
          Dialog + Piece.Elements[j];
        }
      }

      // Place other connection pieces

      if (Piece.Prompter && *Piece.HotKey)
      {
        Dialog.HotKey(Piece.PromptX,Piece.PromptY,Piece.Prompter,0);
      }

      if (Piece.Help && *Piece.Help)
      {
        Dialog.Help(Piece.Help);
      }
    }
  }

  //-------------------------------------------------------------------------
  //
  // Pop up the dialog
  //
  //-------------------------------------------------------------------------

  Dialog.UseDialog();
  delete &Dialog;

  //-------------------------------------------------------------------------
  //
  // Free up declared variables
  //
  //-------------------------------------------------------------------------

  if (NumInts)
    delete IntStorage;

  if (NumLongs)
    delete LongStorage;

  if (NumChars)
  {
    for (int i=0;i<NumChars;i++)
      delete CharacterStorage[i];
    delete CharacterStorage;
  }
}


