//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "elements.h"
#include "mask.h"
#include "colors.h"

#include <string.h>

const layoutContinue=30000;
const layoutCancel=30001;
const layoutButtons=30002;

//-------------------------------------------------------------------------
//
// Event handler for the radio button definition dialog
// This dialog defines each button
//
//-------------------------------------------------------------------------

int ButtonDialog::EventHandler(int Event)
{
	if (Event==kbEsc ||
			Event==kbCr ||
			Event==CloseEvent ||
			Event==OutsideEvent ||
			Event==layoutContinue ||
			Event==layoutCancel)
		return StopEvent;
	return CompleteEvent;
}

//-------------------------------------------------------------------------
//
// Event handler for the *main* radio button definition dialog
// This dialog defines the global characteristics
//
//-------------------------------------------------------------------------

int RadioDialog::EventHandler(int Event)
{
	if (Event==kbEsc ||
			Event==kbCr ||
			Event==CloseEvent ||
			Event==OutsideEvent ||
			Event==layoutContinue ||
			Event==layoutCancel)
		return StopEvent;

  if (Event==layoutButtons)
  {
    ButtonDialog &Buttons=*new ButtonDialog();

    for (int i=0;i<10;i++)
      strcpy(Buttons.RadioButtons[i],RadioButtons[i]);

    if (Buttons.GetButtons())
    {
      for (int q=0;q<10;q++)
        RadioButtons[q][0]=0;

      for (int i=0,j=0;i<10;i++)
      {
        if (Buttons.RadioButtons[i][0])
          strcpy(RadioButtons[j++],Buttons.RadioButtons[i]);
      }
    }

    delete &Buttons;

    return CompleteEvent;
  }

	return CompleteEvent;
}

//-------------------------------------------------------------------------
//
// Show and feed in currently defined buttons
//
//-------------------------------------------------------------------------

ButtonDialog::ButtonDialog() :
  DialogClass(48,17,"Button Definitions")
{
  Blaze.Box(1,1,44,12,Colors.DiaInterior);

  GroupHeading(16,1,1,"~Radio Buttons",kbAltR);

  for (int i=0;i<10;i++)
  {
    RadioButtons[i][0]=0;
    GroupElement(1,new DiaChar(3,2+i,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",RadioButtons[i]));
    Help("Define this radio button");
  }

  Element(new DiaPushButton(11,13,"Continue",layoutContinue,0,1));
	Help("Accept these radio buttons");

  Element(new DiaPushButton(25,13,"Cancel",layoutCancel));
	Help("Do not accept these radio buttons");
}

//-------------------------------------------------------------------------
//
// Get the radio buttons
//
//-------------------------------------------------------------------------

int ButtonDialog::GetButtons()
{
DoAgain:

	int Save=UseDialog();

	if (Save==kbCr || Save==layoutContinue)
  {
    for (int i=0,j=0;i<10;i++)
    {
      if (RadioButtons[i][0])
        j++;
    }

    if (!j)
    {
      InfoBox NotValid;

      NotValid
        + "You have not defined any radio"
        + "buttons for this element.";

      NotValid.Title("Warning");
      NotValid.UseInfoBox();
    }

    return 1;
  }

  return 0;
}

//-------------------------------------------------------------------------
//
// Define the global radio button dialog
//
//-------------------------------------------------------------------------

RadioDialog::RadioDialog(int Gp,int Hp,int Sl) :
  DialogClass(78,19,"Radio Specifications")
{
  VariableName[0]=0;
  Prompter[0]=0;
  HotKeyDefine[0]=0;
  DerivedClass[0]=0;
  HelpLine[0]=0;

  for (int i=0;i<10;i++)
    RadioButtons[i][0]=0;

  Enabled=0;

  GroupingCode=Gp;
  HelpScreen=Hp;
  SetForLiving=Sl;

  Blaze.Box(1,1,57,7,Colors.DiaInterior);
  Blaze.Box(1,8,57,5,Colors.DiaInterior);
  Blaze.Box(1,13,74,3,Colors.DiaInterior);

  GroupHeading(18,1,1,"Element ~Characteristics",kbAltC);
  GroupHeading(17,8,2,"~Derivision Characteristics",kbAltD);
  GroupHeading(30,13,3,"Help/Prompt ~Line",kbAltL);

	GroupElement(1,new DiaChar(12,2,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",VariableName));
	Help("Enter the variable name that this element will be placed into");
	HotKey(3,2,"~Variable",kbAltV);

	GroupElement(1,new DiaChar(12,4,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",Prompter));
	Help("Enter the prompter to use for this element (~ for hot key)");
	HotKey(3,4,"~Prompter",kbAltP);

	GroupElement(1,new DiaChar(11,6,"xxxxxxxxxxxxx",HotKeyDefine));
  Help("Enter the hot key #define to assign to this element (0 for none)");
	HotKey(3,6,"~Hot Key",kbAltH);

	GroupElement(1,new DiaInt(39,6,"###",GroupingCode));
  Available(Enabled);
	Help("Enter the group to assign this element to (0 for none)");
	HotKey(25,6,"~Grouping Code",kbAltG);

	GroupElement(1,new DiaInt(51,6,"#####",HelpScreen));
	Help("Enter the help screen for this element (0 for none)");
	HotKey(43,6,"~Help Id",kbAltG);

  GroupElement(2,new DiaHorizRadio(17,9,SetForLiving,0,0));
  (*this) + "Do Not Derive!" + "Derive a Class";
  Help("Should a derived class be created for this element?");
  HotKey(3,9,"~Derived Class",kbAltD);

	GroupElement(2,new DiaChar(19,11,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",DerivedClass));
	Help("Enter the name of the derived class");
	HotKey(3,11,"~Name of Derived",kbAltN);

	GroupElement(3,new DiaChar(13,14,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",HelpLine));
	Help("Help that you would like to appear at the bottom of the screen");
	HotKey(3,14,"Help ~Line",kbAltL);

	Element(new DiaPushButton(62,4,"~Buttons!",layoutButtons,kbAltB));
	Help("Define the radio buttons");

  Element(new DiaPushButton(62,7,"Continue",layoutContinue,0,1));
	Help("Accept this title and continue");

  Element(new DiaPushButton(63,10,"Cancel",layoutCancel));
	Help("Do not accept this title");
}

//-------------------------------------------------------------------------
//
// Get the global radio button information
//
//-------------------------------------------------------------------------

int RadioDialog::GetRadio()
{
DoAgain:

	int Save=UseDialog();

	if (Save==kbCr || Save==layoutContinue)
  {
    if (!VariableName[0])
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, you must define a variable"
        + "name.  This variable name signifies"
        + "where you would like the input"
        + "from this element to go.";

      NotValid.Title("Need a Variable");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (Prompter[0] && !HotKeyDefine[0])
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, if you define a prompter"
        + "you MUST define a hot key to"
        + "accompany it.  Enter a \"0\" in the"
        + "input spot if there isn't one.";

      NotValid.Title("Need a Hot Key");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (HelpScreen && (HelpScreen<1000 || HelpScreen>32000))
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, the help screen that you"
        + "specified is invalid.  It must"
        + "be between 1000 and 32000.";

      NotValid.Title("Incorrect Help");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (SetForLiving && !DerivedClass[0])
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, a name for the derived"
        + "class must be specified.";

      NotValid.Title("Missing Derived");
      NotValid.UseInfoBox();

      goto DoAgain;
    }

    for (int i=0,j=0;i<10;i++)
    {
      if (RadioButtons[i][0])
        j++;
    }

    if (!j)
    {
      InfoBox NotValid;

      NotValid
        + "You have not defined any radio"
        + "buttons for this element.";

      NotValid.Title("No Buttons");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    return 1;
  }

  return 0;
}
