//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "elements.h"
#include "colors.h"
#include "fliwin.h"
#include "dds.h"

#include <io.h>
#include <sys\stat.h>
#include <fcntl.h>

#pragma warn -inl
#pragma warn -lvc

//-------------------------------------------------------------------------
//
// Control panel event handler
//
//-------------------------------------------------------------------------

class ControlPanelDialog : public DialogClass
{
public:

  int VideoModeChanged;
  int ColorsChanged;
  __FusionColors ColorSet;

  ControlPanelDialog() : DialogClass(37,18,"Control Panel")
    { VideoModeChanged=0;
      ColorsChanged=0;
      ColorSet=Colors; }

  int ChangeColors(__FusionColors &Colorize);
  int ChangeVideoMode();

  int EventHandler(int Event)
  {
    if (Event==kbEsc ||
        Event==kbCr ||
        Event==CloseEvent ||
        Event==OutsideEvent ||
        Event==panelAcceptButton)
      return StopEvent;
    if (Event==panelColorButton)
      ColorsChanged=ChangeColors(ColorSet);
    if (Event==panelVideoButton)
      VideoModeChanged=ChangeVideoMode();
    return CompleteEvent;
  }
};

//-------------------------------------------------------------------------
//
// Storage for the available panel video modes
//
//-------------------------------------------------------------------------

static int VideoModes[] =
  { Normal_80x25,
    EGA_VGA_43or50,
    ATI_Wonder_132x25,
    ATI_Wonder_132x44,
    Compaq_VGS_132x25,
    Compaq_VGS_132x28,
    Compaq_VGS_132x43,
    Compaq_VGS_132x50,
    Compaq_VGS_132x60,
    Genoa_VGA_132x25,
    Genoa_VGA_132x28,
    Genoa_VGA_132x43,
    Orchid_VGA_80x60,
    Orchid_VGA_132x25,
    Orchid_VGA_132x28,
    Orchid_VGA_132x44,
    Paradise_132x25,
    Paradise_132x43,
    Sigma_VGA_132x25,
    Sigma_VGA_132x44,
    STB_VGA_132x25,
    STB_VGA_132x44,
    Tecmar_132x25,
    Tseng_132x25,
    Tseng_132x28,
    Tseng_132x44,
    VEGA_80x43,
    VEGA_80x60,
    VEGA_100x60,
    VEGA_120x25,
    VEGA_120x43,
    VEGA_132x25,
    VEGA_132x43 };

//-------------------------------------------------------------------------
//
// Window system interface behavior control dialog
//
// RememberLastVideo is used to save the last video mode change.  It is
// necessary in case the video mode isn't changed at a dialog and helps
// guarantee that the user won't lose the video mode setting when using
// DDS at another time.
//
//-------------------------------------------------------------------------

static int RememberLastVideo=0;

int DesignerWindow::ControlPanel()
{
  ControlPanelDialog &Behave = *new ControlPanelDialog();

  Behave.Element(new DiaVertRadio(1,2,MenuManager::IsPullDown,0,0));
  Behave + "Pop Down" + "Pull Down";
  Behave.Help("Select the type of menu control that you desire");
  Behave.HotKey(1,1,"~Menu Style",kbAltM);
  Behave.FusionHelp(10010);

  int Repeat;

  if (MouseRepeatSpeed)
    Repeat=0;
  else
    Repeat=1;

  Behave.Element(new DiaVertRadio(19,2,Repeat,0,0));
  Behave + "Slow     " + "Fast     ";
  Behave.Help("Select the speed of the automatic mouse repeat");
  Behave.HotKey(19,1,"Mouse ~Repeat",kbAltR);
  Behave.FusionHelp(10011);

  int Click;

  if (MouseDoubleClickFactor<=7)
    Click=0;
  else if (MouseDoubleClickFactor>7 && MouseDoubleClickFactor<=11)
    Click=1;
  else
    Click=2;

  Behave.Element(new DiaVertRadio(1,6,Click,0,0));
  Behave + "Short    " + "Normal   " + "Long    ";
  Behave.Help("Select the speed of the double click");
  Behave.HotKey(1,5,"~Double Click",kbAltD);
  Behave.FusionHelp(10012);

  int Delay;

  if (MouseRepeatDelay<3)
    Delay=0;
  else if (MouseRepeatDelay>=3 && MouseRepeatDelay<5)
    Delay=1;
  else
    Delay=2;

  Behave.Element(new DiaVertRadio(19,6,Delay,0,0));
  Behave + "Short    " + "Normal   " + "Long     ";
  Behave.Help("Select the delay before the automatic mouse repeat");
  Behave.HotKey(19,5,"Repeat ~Lag",kbAltL);
  Behave.FusionHelp(10013);

  Behave.Element(new DiaVertRadio(1,11,MenuManager::Beneath,0,0));
  Behave + "Right\x1a   " + "Below\x19   ";
  Behave.Help("Select the location of the sub menus");
  Behave.HotKey(1,10,"Sub Me~nus",kbAltN);
  Behave.FusionHelp(10020);

  Behave.Element(new DiaVertRadio(19,11,FusionShadowing,0,0));
  Behave + "Disabled " + "Enabled  ";
  Behave.Help("Turn the shadowing capability on or off");
  Behave.HotKey(19,10,"S~hadows",kbAltH);
  Behave.FusionHelp(10020);

  Behave.Element(new DiaPushButton(1,14,"Color~s",panelColorButton,kbAltS));
  Behave.Help("Change the window, menu, or miscellaneous colors");

  Behave.Element(new DiaPushButton(12,14,"~Videos",panelVideoButton,kbAltV));
  Behave.Help("Change the video mode");

  Behave.Element(new DiaPushButton(23,14,"Continue",panelAcceptButton,0,1));
  Behave.Help("Press to change the settings and save them to your disk");

  int BehaveCheck=Behave.UseDialog();

  if (BehaveCheck==kbCr || BehaveCheck==panelAcceptButton)
  {
    if (!Click)
      MouseDoubleClickFactor=7;
    else if (Click==1)
      MouseDoubleClickFactor=10;
    else
      MouseDoubleClickFactor=13;

    if (!Repeat)
      MouseRepeatSpeed=2;
    else
      MouseRepeatSpeed=0;

    if (!Delay)
      MouseRepeatDelay=1;
    else if (Delay==1)
      MouseRepeatDelay=3;
    else
      MouseRepeatDelay=5;

    int VideoModeChanged=Behave.VideoModeChanged;
    int ColorsChanged=Behave.ColorsChanged;

    // Save the settings into a defaults file

    int Handle=open("PANEL.FLI",O_CREAT|O_TRUNC|O_RDWR|O_BINARY,S_IREAD|S_IWRITE);

    write(Handle,&MouseDoubleClickFactor,sizeof(int));
    write(Handle,&MouseRepeatSpeed,sizeof(int));
    write(Handle,&MouseRepeatDelay,sizeof(int));
    write(Handle,&MenuManager::Beneath,sizeof(int));
    write(Handle,&MenuManager::IsPullDown,sizeof(int));
    write(Handle,&FusionShadowing,sizeof(int));

    if (RememberLastVideo && !VideoModeChanged)
      write(Handle,&RememberLastVideo,sizeof(int));
    else
    {
      RememberLastVideo=VideoModeChanged;
      write(Handle,&VideoModeChanged,sizeof(int));
    }

    write(Handle,&Behave.ColorSet,sizeof(__FusionColors));

    close(Handle);

    if (ColorsChanged)
      Colors=Behave.ColorSet;

    delete &Behave;

    if (VideoModeChanged)
    {
      RemoveAllMenus();

      BlazeClass Blaze;
      Blaze[VideoModes[VideoModeChanged-1]];
      -Blaze;
    }
    return (VideoModeChanged)?1:ColorsChanged;
  }

  delete &Behave;

  return 0;
}

//-------------------------------------------------------------------------
//
// AutoPowerupSequencer -- This loads saved control panel settings at
// program startup.  It is presented with the lowest priority number so
// it is loaded LAST at program startup to ensure that the colors class
// is correctly loaded and is not overriden.  In addition, this must
// activate *AFTER* the FLI video protection feature.
//
// The PanelAutoEngaged variable is set to a non-zero value if the
// panel settings file exists.  This variable can be accessed anywhere
// in your program to see if settings were loaded.  This can be used
// if you override certain items at startup if the panel file doesn't
// exist.  See the DDS.CPP file for an example of this.
//
//-------------------------------------------------------------------------

int PanelAutoEngaged=0;

void AutoPowerupSequencer()
{
  if (access("PANEL.FLI",0))
    return;

  PanelAutoEngaged=1;

  int Handle=open("PANEL.FLI",O_RDWR|O_BINARY,S_IREAD|S_IWRITE);

  lseek(Handle,0,SEEK_SET);

  int VideoModeChanged, ColorsChanged;

  read(Handle,&MouseDoubleClickFactor,sizeof(int));
  read(Handle,&MouseRepeatSpeed,sizeof(int));
  read(Handle,&MouseRepeatDelay,sizeof(int));
  read(Handle,&MenuManager::Beneath,sizeof(int));
  read(Handle,&MenuManager::IsPullDown,sizeof(int));
  read(Handle,&FusionShadowing,sizeof(int));
  read(Handle,&VideoModeChanged,sizeof(int));

  if (VideoModeChanged)
  {
    BlazeClass Blaze;
    Blaze[VideoModes[VideoModeChanged-1]];
    RememberLastVideo=VideoModeChanged;
    -Blaze;
  }

  read(Handle,&Colors,sizeof(__FusionColors));

  close(Handle);
}

#pragma startup AutoPowerupSequencer 255

//-------------------------------------------------------------------------
//
// Event handler for color changing dialog
//
//-------------------------------------------------------------------------

class ColorDialog : public DialogClass
{
public:

  ColorDialog() : DialogClass(64,18,"Object Colors")
    {  }

  int EventHandler(int Event)
  {
    if (Event==kbEsc ||
        Event==kbCr ||
        Event==CloseEvent ||
        Event==OutsideEvent ||
        Event==colorChange ||
        Event==colorCancel)
      return StopEvent;
    return CompleteEvent;
  }
};

//-------------------------------------------------------------------------
//
// Color list and changing dialog
//
//-------------------------------------------------------------------------

class ColorList : public DiaPickList, public CurrentColor
{
public:

  __FusionColors &ColorSet;

  ColorList(int X,int Y,int Width,int Height,int &ItemNumber,int &NumberOfItems,
    char **ListOfItems,__FusionColors &Colorize) :
  DiaPickList(X,Y,Width,Height,ItemNumber,NumberOfItems,ListOfItems) ,
  ColorSet(Colorize)
  {
    int *Panel=&ColorSet.MenuBorder;
    TheColor=(Panel+DiaPickList::Item);
  }

  int EventHandler(int Event)
  {
    int Item=DiaPickList::Item;

    int Returned=DiaPickList::EventHandler(Event);

    if (Item!=DiaPickList::Item)
    {
      int *Panel=&ColorSet.MenuBorder;
      TheColor=(Panel+DiaPickList::Item);
      return OtherRefreshEvent;
    }
    else
      return Returned;
  }
};

int ControlPanelDialog::ChangeColors(__FusionColors &Colorize)
{
  static char *Coloring[] =
    {
      "Menus        Border",
      "Menus        Close Icon",
      "Menus        Disabled Option",
      "Menus        HiLighted Option",
      "Menus        Interior",
      "Menus        Quick Key",
      "Menus        Title",
      "Menus        Hot Key",
      "Menus        Pointer to Sub Menu",
      "Menus        Check Mark",
      "Menus        Selectables",
      "Menu Bar     Quick Key",
      "Menu Bar     Normal Text",
      "Dialog       Numerical Element",
      "Dialog       HiLighted Numerical Element",
      "Dialog       Character Element",
      "Dialog       HiLighted Character Element",
      "Dialog       Push Button",
      "Dialog       Quick Key for Push Button",
      "Dialog       HiLighted Push Button",
      "Dialog       Active Push Button",
      "Dialog       Check Box",
      "Dialog       Check Mark",
      "Dialog       HiLighted Check Box",
      "Dialog       Check Mark Quick Key",
      "Dialog       Radio Buttons",
      "Dialog       Radio Button Check Mark",
      "Dialog       HiLighted Radio Button",
      "Dialog       Pick List",
      "Dialog       Marked Pick List Item",
      "Dialog       HiLighted Pick List Item",
      "Dialog       Pick List Scroll Bar",
      "Dialog       Border",
      "Dialog       Close Icon",
      "Dialog       Interior",
      "Dialog       Title",
      "Dialog       Locator",
      "Dialog       Bold Locator",
      "Dialog       Locator Quick Key",
      "Dialog       Disabled Locator",
      "Dialog       Group Heading",
      "Dialog       Bold Group Heading",
      "Dialog       Group Quick Key",
      "Prompt Line  Hot Key",
      "Prompt Line  Description",
      "Work Space   Background Color",
      "Window       Border",
      "Window       Icons",
      "Window       Title",
      "Window       Scroll Bars",
      "Window       Size Corner",
      "Window       Interior",
      "Window       Bold Interior",
      "Window       Alternate Interior",
      "Window       Window in Background"
      };

  ColorDialog &Dialog=*new ColorDialog();

  int Current=0;

  Dialog.Element(new ColorList(1,2,40,11,Current,55,Coloring,Colorize));
  Dialog.HotKey(1,1,"~Objects",kbAltO);
  Dialog.Help("Select the item of whose colors you wish to change");

  Dialog.Element(new ForeGround(47,3,47,14));
  Dialog.HotKey(48,1,"~Foreground",kbAltF);
  Dialog.Help("Select the foreground color for this object");

  Dialog.Element(new BackGround(47,10,47,14));
  Dialog.HotKey(48,8,"~Background",kbAltB);
  Dialog.Help("Select the background color for this object");

  Dialog.Element(new DiaPushButton(7,14,"Change Colors",colorChange,0,1));
  Dialog.Help("Change the colors to the newly selected colors");

  Dialog.Element(new DiaPushButton(29,14,"Cancel",colorCancel));
  Dialog.Help("Do not change the colors");

  Dialog.Blaze.Box(45,1,16,7,Colors.DiaInterior);
  Dialog.Blaze.Box(45,8,16,5,Colors.DiaInterior);
  Dialog.Blaze.UserBoxDefineQuick(2);
  Dialog.Blaze.Box(45,13,16,3,Colors.DiaInterior);
  Dialog.Blaze.UserBoxDefineQuick(1);
  Dialog.Blaze (50,13) << Colors.DiaInterior << "Sample";

  int Remember=Dialog.UseDialog();

  delete &Dialog;

  return (Remember==kbCr || Remember==colorChange || Remember==MousedEvent)?1:0;
}

//-------------------------------------------------------------------------
//
// Video mode changing dialog
//
//-------------------------------------------------------------------------

class VideoModeDialog : public DialogClass
{
public:

  VideoModeDialog() : DialogClass(37,14,"Video Mode")
    {  }

  int EventHandler(int Event)
  {
    if (Event==kbEsc ||
        Event==kbCr ||
        Event==CloseEvent ||
        Event==OutsideEvent ||
        Event==videoChange ||
        Event==videoCancel)
      return StopEvent;
    return CompleteEvent;
  }
};

int ControlPanelDialog::ChangeVideoMode()
{
  static char *Videos[] =
    { "Standard 80x25",
      "EGA/VGA 43x25 or 50x25",
      "ATI Wonder 132x25",
      "ATI Wonder 132x43",
      "Compaq Integrated VGS 132x25",
      "Compaq Integrated VGS 132x28",
      "Compaq Integrated VGS 132x43",
      "Compaq Integrated VGS 132x50",
      "Compaq Integrated VGS 132x60",
      "Genoa VGA 132x25",
      "Genoa VGA 132x28",
      "Genoa VGA 132x43",
      "Orchid VGA 80x60",
      "Orchid VGA 132x25",
      "Orchid VGA 132x28",
      "Orchid VGA 132x44",
      "Paradise VGA 132x25",
      "Paradise VGA 132x43",
      "Sigma VGA 132x25",
      "Sigma VGA 132x43",
      "STB VGA 132x25",
      "STB VGA 132x43",
      "Tecmar VGA 132x25",
      "Tseng VGA 132x25",
      "Tseng VGA 132x28",
      "Tseng VGA 132x44",
      "VEGA VGA 80x43",
      "VEGA VGA 80x60",
      "VEGA VGA 100x60",
      "VEGA VGA 120x25",
      "VEGA VGA 120x43",
      "VEGA VGA 132x25",
      "VEGA VGA 132x43" };

  VideoModeDialog &Dialog=*new VideoModeDialog();

  int Current=0;

  Dialog.Element(new DiaPickList(1,1,30,8,Current,33,Videos));
  Dialog.Help("Select the video mode that you would like to switch to");

  Dialog.Element(new DiaPushButton(7,10,"Change",videoChange,0,1));
  Dialog.Help("Change to the selected video mode");

  Dialog.Element(new DiaPushButton(19,10,"Cancel",videoCancel));
  Dialog.Help("Do not change to the selected video mode");

  int Remember=Dialog.UseDialog();

  delete &Dialog;

  if (Remember==videoChange || Remember==kbCr || Remember==MousedEvent)
    return Current+1;

  return 0;
}

