//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "elements.h"
#include "mask.h"
#include "colors.h"

const layoutContinue=30000;
const layoutCancel=30001;

//-------------------------------------------------------------------------
//
// This is the event handler for the character/numeric mask dialog
//
//-------------------------------------------------------------------------

int MaskDialog::EventHandler(int Event)
{
	if (Event==kbEsc ||
			Event==kbCr ||
			Event==CloseEvent ||
			Event==OutsideEvent ||
			Event==layoutContinue ||
			Event==layoutCancel)
		return StopEvent;
	return CompleteEvent;
}

//-------------------------------------------------------------------------
//
// Construct the dialog and display it
//
//-------------------------------------------------------------------------

MaskDialog::MaskDialog(int Gp,int Hp,int Sl) :
  DialogClass(78,21,"Element Specifications")
{
  ElementMask[0]=0;
  VariableName[0]=0;
  Prompter[0]=0;
  HotKeyDefine[0]=0;
  DerivedClass[0]=0;
  HelpLine[0]=0;

  GroupingCode=Gp;
  HelpScreen=Hp;
  SetForLiving=Sl;

  MaskCharacter[0]=0;
  MaskWidth=0;
  ScrollWidth=0;

  CharacterActive=0;

  Blaze.Box(1,1,57,9,Colors.DiaInterior);
  Blaze.Box(58,1,17,7,Colors.DiaInterior);
  Blaze.Box(1,10,57,5,Colors.DiaInterior);
  Blaze.Box(1,15,74,3,Colors.DiaInterior);

  GroupHeading(18,1,1,"Element ~Characteristics",kbAltC);
  GroupHeading(63,1,4,"~Extras",kbAltE);
  GroupHeading(17,10,2,"~Derivision Characteristics",kbAltD);
  GroupHeading(30,15,3,"Help/Prompt ~Line",kbAltL);

	GroupElement(1,new DiaChar(16,2,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",ElementMask));
	Help("Enter the mask for this dialog element");
	HotKey(3,2,"~Element Mask",kbAltE);

	GroupElement(1,new DiaChar(12,4,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",VariableName));
	Help("Enter the variable name that this element will be placed into");
	HotKey(3,4,"~Variable",kbAltV);

	GroupElement(1,new DiaChar(12,6,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",Prompter));
	Help("Enter the prompter to use for this element (~ for hot key)");
	HotKey(3,6,"~Prompter",kbAltP);

	GroupElement(1,new DiaChar(11,8,"xxxxxxxxxxxxx",HotKeyDefine));
  Help("Enter the hot key #define to assign to this element (0 for none)");
	HotKey(3,8,"~Hot Key",kbAltH);

	GroupElement(1,new DiaInt(39,8,"###",GroupingCode));
	Help("Enter the group to assign this element to (0 for none)");
	HotKey(25,8,"~Grouping Code",kbAltG);

	GroupElement(1,new DiaInt(51,8,"#####",HelpScreen));
	Help("Enter the help screen for this element (0 for none)");
	HotKey(43,8,"~Help Id",kbAltG);

	GroupElement(4,new DiaInt(70,2,"###",ScrollWidth));
  Available(CharacterActive);
	Help("Enter the width to show on the dialog (0 for non-scrolling)");
	HotKey(60,2,"~Scrolling",kbAltS);

	GroupElement(4,new DiaChar(72,4,"x",MaskCharacter));
  Available(CharacterActive);
	Help("Enter the character for the quick mask (Leave blank for none)");
	HotKey(60,4,"~Mask Char",kbAltM);

	GroupElement(4,new DiaInt(70,6,"###",MaskWidth));
  Available(CharacterActive);
	Help("Enter the width for the quick mask (0 for none)");
	HotKey(60,6,"Msk ~Width",kbAltW);

  GroupElement(2,new DiaHorizRadio(17,11,SetForLiving,0,0));
  (*this) + "Do Not Derive!" + "Derive a Class";
  Help("Should a derived class be created for this element?");
  HotKey(3,11,"~Derived Class",kbAltD);

	GroupElement(2,new DiaChar(19,13,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",DerivedClass));
	Help("Enter the name of the derived class");
	HotKey(3,13,"~Name of Derived",kbAltN);

	GroupElement(3,new DiaChar(13,16,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",HelpLine));
	Help("Help that you would like to appear at the bottom of the screen");
	HotKey(3,16,"Help ~Line",kbAltL);

  Element(new DiaPushButton(62,9,"Continue",layoutContinue,0,1));
	Help("Accept this title and continue");

  Element(new DiaPushButton(63,12,"Cancel",layoutCancel));
	Help("Do not accept this title");
}

//-------------------------------------------------------------------------
//
// Get the mask input from the user
//
//-------------------------------------------------------------------------

int MaskDialog::GetMask()
{
DoAgain:

	int Save=UseDialog();

	if (Save==kbCr || Save==layoutContinue)
  {
    if (!ElementMask[0] && !MaskWidth)
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, you must define a mask"
        + "for all input styles of elements!";

      NotValid.Title("Need a Mask");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (!VariableName[0])
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, you must define a variable"
        + "name.  This variable name signifies"
        + "where you would like the input"
        + "from this element to go.";

      NotValid.Title("Need a Variable");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (Prompter[0] && !HotKeyDefine[0])
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, if you define a prompter"
        + "you MUST define a hot key to"
        + "accompany it.  Enter a \"0\" in the"
        + "input spot if there isn't one.";

      NotValid.Title("Need a Hot Key");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (HelpScreen && (HelpScreen<1000 || HelpScreen>32000))
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, the help screen that you"
        + "specified is invalid.  It must"
        + "be between 1000 and 32000.";

      NotValid.Title("Incorrect Help");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (SetForLiving && !DerivedClass[0])
    {
      InfoBox NotValid;

      NotValid
        + "Sorry, a name for the derived"
        + "class must be specified.";

      NotValid.Title("Missing Derived");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if ((MaskWidth && !MaskCharacter[0]) ||
      (MaskCharacter[0] && !MaskWidth))
    {
      InfoBox NotValid;

      NotValid
        + "To do a quick mask, you must define"
        + "both the mask character and the quick"
        + "mask width.  Please specify both.";

      NotValid.Title("Incorrect Quick Mask");
      NotValid.UseInfoBox();

      goto DoAgain;
    }
    if (ScrollWidth && ScrollWidth<5)
    {
      InfoBox NotValid;

      NotValid
        + "It is recommended that the width of"
        + "the scrolling character box be at"
        + "least 5 characters wide.";

      NotValid.Title("Make Wider");
      NotValid.UseInfoBox();

      goto DoAgain;
    }

    return 1;
  }

  return 0;
}
