//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "fliwin.h"
#include "colors.h"
#include "dds.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "open.h"
#include "yesno.h"

int ZPositioning=0;

//-------------------------------------------------------------------------
//
// This is the GLOBAL event handler for the DDS workspace
// The LOCAL (or window) event handler is in DIAWIN.CPP
//
//-------------------------------------------------------------------------

int DesignerWindow::EventHandler(int Event)
{
  switch(Event)
  {
    case winChDir:
      ChDirDialog &ChDir=*new ChDirDialog();
      ChDir.UseDialog();
      delete &ChDir;
      return CompleteEvent;

    case winDOSShell:
      BlazeClass Blaze;
      char *Screen = new char[Blaze.ComputeNeededBytes(Blaze.WhatWidth(),Blaze.WhatHeight())];
      MouseShutDown();
      Blaze.Window(0,0,Blaze.WhatWidth(),Blaze.WhatHeight());
      Blaze.GetArea(0,0,Blaze.WhatWidth(),Blaze.WhatHeight(),Screen);
      Blaze.EraseArea(0,0,Blaze.WhatWidth(),Blaze.WhatHeight(),7);
      Blaze.GotoXY(0,0);
      Blaze.VisibleCursor();
      puts("Type EXIT to return to the FLI Dialog Designer");
      system("");
      Blaze.InvisibleCursor();
      Blaze.PutArea(0,0,Screen);
      MouseReStart();
      MouseShow();
      delete Screen;
      return CompleteEvent;

    case winOpen:
      if (NumberOfWindows)
        return Event;

      OpenDialog &Open=*new OpenDialog("*.DDS");
      char *File=Open.OpenFile();

      if (!File || !*File)
      {
        delete &Open;
        return CompleteEvent;
      }

      char Filer[100];
      strcpy(Filer,File);
      delete &Open;

      if (File && *File)
      {
        RemoveAllMenus();

			  if (!NewWindow(new DialogWindow(Filer),0))
				  return CompleteEvent;

        goto Menus;
      }

      return CompleteEvent;

    case winAbout:
      Welcome->Title("About");
      Welcome->UseInfoBox();
      return CompleteEvent;

    case winExit:
      {
        YesNo &Query=*new YesNo();
        Query + "Are you sure that you want to exit?";
        Query.Title("Please Confirm");
        int Response=Query.UseYesNo();
        delete &Query;
        if (!Response)
          return CompleteEvent;
      }
      return StopEvent;

    case layoutMove:
      MoveWindow();
      return CompleteEvent;

    case layoutSize:
      SizeWindow();
      return CompleteEvent;

    case winNew:

			if (NumberOfWindows)
				return Event;

			if (!NewWindow(new DialogWindow(),0))
				return CompleteEvent;

Menus:

			NewMenu("~Layout","Dialog layout characteristics",kbAltL);
				Option("~Specifiers ...","Specify the specifiers of this dialog",layoutSpecs);
				Option("~Test Dialog ...","Test the dialog and see how it performs",layoutTest);
				HotKey("Alt-T",kbAltT);
        BlankLine();
				Option("~Edit Mode","Select the Edit Mode",layoutEditMode);
				Selectable(ZPositioning,"Normal Edit","Z Positioning",(char*)0);
				HotKey("Alt-Z",kbAltZ);
        BlankLine();
        Option("~Move Dialog","Move the dialog (for non-mousers)",layoutMove);
        Option("~Size Dialog","Size the dialog (for non-mousers)",layoutSize);

			NewMenu("~Element","Place an element on the dialog",kbAltE);
				Option("~Character","Drop a character or scrolling character element (Quick Masks too!)",elementChar);
				HotKey("Ctrl-C",kbCtrlC);
				Option("~Integer","Drop an integer element",elementInt);
				HotKey("Ctrl-I",kbCtrlI);
				Option("~Long","Drop a long integer element",elementLong);
				HotKey("Ctrl-L",kbCtrlL);
				Option("~Float","Drop a floating point element",elementFloat);
				HotKey("Ctrl-F",kbCtrlF);
				Option("~Double","Drop a double floating point element",elementDouble);
				HotKey("Ctrl-D",kbCtrlD);
				Option("~Bcd","Drop a BCD element",elementBcd);
				HotKey("Ctrl-B",kbCtrlB);
        BlankLine();
				Option("~Vertical Radio Buttons","Drop a radio button element",elementVRadio);
	  		HotKey("Ctrl-V",kbCtrlV);
        Option("~Horizontal Radio Buttons","Drop a radio button element",elementHRadio);
  			HotKey("Ctrl-Z",kbCtrlZ);
				Option("Chec~k Box","Drop a check box element",elementCheck);
				HotKey("Ctrl-K",kbCtrlK);
				Option("P~ush Button","Drop a push button element",elementPush);
				HotKey("Ctrl-U",kbCtrlU);
				Option("~Generic Pick List","Drop a generic pick list element",elementPickGeneric);
        HotKey("Ctrl-P",kbCtrlP);
        BlankLine();
				Option("~Group Heading","Drop a group heading",elementHeading);
        HotKey("Ctrl-G",kbCtrlG);

			NewMenu("~Draw","Draw a Blaze elements in the dialog box",kbAltD);
				Option("~Box","Draw a hollow box",drawBox);
				HotKey("Alt-B",kbAltB);
				Option("F~illed Box","Draw a filled box",drawFillBox);
				HotKey("Alt-I",kbAltI);
				Option("~Horizontal Line","Draw a horizontal line",drawHLine);
				HotKey("Alt-H",kbAltH);
				Option("~Vertical Line","Draw a vertical line",drawVLine);
				HotKey("Alt-V",kbAltV);
				Option("~Shadow","Draw a shadow",drawShadow);
				HotKey("Alt-S",kbAltS);
				Option("E~rase Area","Erase or blank an area",drawErase);
				HotKey("Alt-R",kbAltR);
				Option("~Transparent Box","Draw a transparent box",drawTrans);
				HotKey("Alt-N",kbAltN);
				Option("~Plop Character","Drop a character",drawPlop);
				HotKey("Alt-P",kbAltP);
				BlankLine();
				Option("Change ~Drawing Color","Change the current color",drawColor);
				HotKey("F4",kbF4);

			NewMenu("~Manipulate","Manipulate the way the dialog appears",kbAltM);
				Option("Throw ~Back","Throw a drawing object to the rear of the dialog",manipBack);
				HotKey("F5",kbF5);
				Option("Pull ~Forward","Pull a drawing object to the top of the dialog",manipForward);
				HotKey("F6",kbF6);
				Option("Element ~Rearrange","Rearrange the order of the elements on the dialog",manipReArrange);
					SubMenu();
					Option("Move to ~Start","Make an element the starting point for the dialog",manipToStart);
          HotKey("Ctrl-Home",kbCtrlHome);
					Option("Move to ~End","Make an element the last on the dialog",manipToEnd);
          HotKey("Ctrl-End",kbCtrlEnd);
					Option("Slide One E~arlier","Move element one step closer to the start of the dialog",manipEarlier);
          HotKey("Ctrl-PgUp",kbCtrlPgUp);
          Option("Slide One ~Later","Move element one step closer to the end of the dialog",manipLater);
          HotKey("Ctrl-PgDn",kbCtrlPgDn);
					EndSubMenu();
				BlankLine();
				Option("~Size or Edit","Size a drawn object or edit an element",manipSize);
				HotKey("F7",kbF7);
				Option("~Move","Move an object, element, or prompter",manipMove);
				HotKey("F8",kbF8);
				Option("Move ~Text","Move a block of text",manipMoveText);
				Option("~Copy","Copy an object or element",manipCopy);
				HotKey("F9",kbF9);
				Option("C~opy Text","Copy a block of text",manipCopyText);
				Option("~Delete a Piece","Delete an element or drawn object",manipDeletePiece);
        HotKey("F3",kbF3);
        BlankLine();
				Option("T~ext Color","Change the color of some text to the current color",manipTextColor);
				Option("Ob~ject Color","Change the color of a drawn object to the current color",manipObjectColor);

			SetMenus();

			return RefreshEvent;

		case CloseEvent:
			DeleteLastMenu();
			DeleteLastMenu();
			DeleteLastMenu();
			DeleteLastMenu();
			SetMenus();
			return CompleteEvent;

		case winControlPanel:
			if (ControlPanel())
				RefreshWorkSpace();
      if (BlazeClass::WhatWidth()>80 || BlazeClass::WhatHeight()>25)
      {
        InfoBox &NotAvailable = *new InfoBox;
        NotAvailable
              + "It isn't advisable to create a dialog box"
              + "that is larger than the default 80x25"
              + "display mode, because the end user may"
              + "not have video support for this mode."
              + ""
              + "If you know that your end users have"
              + "support for this video mode, then enjoy"
              + "yourself and start designing!";
        NotAvailable.Title("Recommendation");
        NotAvailable.UseInfoBox();
        delete &NotAvailable;
      }
      return CompleteEvent;

    case winCallMenu:
      CallMenu();
      return CompleteEvent;
  }
  return Event;
}
