//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//

#include "fliwin.h"
#include "elements.h"
#include "mask.h"
#include "dds.h"
#include "colors.h"

#include <alloc.h>
#include <string.h>

//-------------------------------------------------------------------------
//
// This places an element on the dialog
//
//-------------------------------------------------------------------------

void DialogWindow::PlaceElement(int Object)
{
  MaskDialog *Mask=0;
  CheckDialog *CheckMask=0;
  PushDialog *PushMask=0;
  GroupDialog *GroupMask=0;
  RadioDialog *RadioMask=0;
  PickDialog *PickMask=0;

	Pieces=(PieceHandler **)realloc(Pieces,++NumberPieces*sizeof(char *));

	switch (Object)
	{
		case PieceHandler::Character:
      Mask=new MaskDialog();
      Mask->CharacterActive=1;
      if (Mask->GetMask())
      {
        Pieces[NumberPieces-1]=new Character(&Blaze,CursorX,CursorY,strlen(Mask->ElementMask),1,Colors.CharNormal);
        break;
      }
      delete Mask;
      NumberPieces--;
			return;

		case PieceHandler::Integer:
      Mask=new MaskDialog();
      if (Mask->GetMask())
      {
        Pieces[NumberPieces-1]=new Integer(&Blaze,CursorX,CursorY,strlen(Mask->ElementMask),1,Colors.NumNormal);
        break;
      }
      delete Mask;
      NumberPieces--;
			return;

		case PieceHandler::Long:
      Mask=new MaskDialog();
      if (Mask->GetMask())
      {
        Pieces[NumberPieces-1]=new Long(&Blaze,CursorX,CursorY,strlen(Mask->ElementMask),1,Colors.NumNormal);
        break;
      }
      delete Mask;
      NumberPieces--;
			return;

		case PieceHandler::Float:
      Mask=new MaskDialog();
      if (Mask->GetMask())
      {
        Pieces[NumberPieces-1]=new Float(&Blaze,CursorX,CursorY,strlen(Mask->ElementMask),1,Colors.NumNormal);
        break;
      }
      delete Mask;
      NumberPieces--;
			return;

		case PieceHandler::Double:
      Mask=new MaskDialog();
      if (Mask->GetMask())
      {
        Pieces[NumberPieces-1]=new Double(&Blaze,CursorX,CursorY,strlen(Mask->ElementMask),1,Colors.NumNormal);
        break;
      }
      delete Mask;
      NumberPieces--;
			return;

		case PieceHandler::Bcd:
      Mask=new MaskDialog();
      if (Mask->GetMask())
      {
        Pieces[NumberPieces-1]=new Bcd(&Blaze,CursorX,CursorY,strlen(Mask->ElementMask),1,Colors.NumNormal);
        break;
      }
      delete Mask;
      NumberPieces--;
			return;

		case PieceHandler::Check:
      CheckMask=new CheckDialog();
      if (CheckMask->GetCheck())
      {
        Pieces[NumberPieces-1]=new Check(&Blaze,CursorX,CursorY,strlen(CheckMask->CheckText)+6,1,Colors.CheckText);
        if (strchr(CheckMask->CheckText,'~'))
          Pieces[NumberPieces-1]->Width--;
        break;
      }
      delete CheckMask;
      NumberPieces--;
			return;

		case PieceHandler::Push:
      PushMask=new PushDialog();
      if (PushMask->GetPush())
      {
        Pieces[NumberPieces-1]=new Push(&Blaze,CursorX,CursorY,strlen(PushMask->PushText)+2,1,Colors.ButtonNormal);
        if (strchr(PushMask->PushText,'~'))
          Pieces[NumberPieces-1]->Width--;
        break;
      }
      delete PushMask;
      NumberPieces--;
			return;

		case PieceHandler::GroupHeading:
      GroupMask=new GroupDialog();
      if (GroupMask->GetGroup())
      {
        Pieces[NumberPieces-1]=new GroupHeading(&Blaze,CursorX,CursorY,strlen(GroupMask->GroupText),1,Colors.DiaHeading);
        if (strchr(GroupMask->GroupText,'~'))
          Pieces[NumberPieces-1]->Width--;
        break;
      }
      delete GroupMask;
      NumberPieces--;
			return;

		case PieceHandler::HRadio:
      RadioMask=new RadioDialog();
      RadioMask->Enabled=1;
      if (RadioMask->GetRadio())
      {
        for (int i=0,j=1;i<10;i++)
        {
          if (!RadioMask->RadioButtons[i][0])
            continue;
          j+=(strlen(RadioMask->RadioButtons[i])+5);
        }
        Pieces[NumberPieces-1]=new HRadio(&Blaze,CursorX,CursorY,j,1,Colors.RadioText);
        break;
      }
      delete RadioMask;
      NumberPieces--;
			return;

		case PieceHandler::VRadio:
      RadioMask=new RadioDialog();
      if (RadioMask->GetRadio())
      {
        for (int i=0,j=0,k=0;i<10;i++)
        {
          if (!RadioMask->RadioButtons[i][0])
            continue;
          k++;
          if ((strlen(RadioMask->RadioButtons[i])+6)>j)
            j=strlen(RadioMask->RadioButtons[i])+6;
        }
        Pieces[NumberPieces-1]=new VRadio(&Blaze,CursorX,CursorY,j,k,Colors.RadioText);
        break;
      }
      delete RadioMask;
      NumberPieces--;
			return;

    case PieceHandler::PickGeneric:
      PickMask=new PickDialog();
      if (PickMask->GetPick())
      {
        Pieces[NumberPieces-1]=new PickGeneric(&Blaze,CursorX,CursorY,PickMask->Width+3,PickMask->Height,Colors.PickText);
        break;
      }
      delete PickMask;
      NumberPieces--;
			return;
	}

  PieceHandler &Piece=*Pieces[NumberPieces-1];

  if (Mask)
  {

    Piece.Mask=new char[50];
    strcpy(Piece.Mask,Mask->ElementMask);

    Piece.Variable=new char[50];
    strcpy(Piece.Variable,Mask->VariableName);

    Piece.Prompter=new char[50];
    strcpy(Piece.Prompter,Mask->Prompter);

    Piece.HotKey=new char[30];
    strcpy(Piece.HotKey,Mask->HotKeyDefine);

    Piece.Help=new char[65];
    strcpy(Piece.Help,Mask->HelpLine);

    Piece.DerivedClass=new char[50];
    strcpy(Piece.DerivedClass,Mask->DerivedClass);

    Piece.GroupCode=Mask->GroupingCode;
    Piece.HelpId=Mask->HelpScreen;
    Piece.ToBeDerived=Mask->SetForLiving;

    Piece.MaskCharacter=Mask->MaskCharacter[0];
    Piece.MaskWidth=Mask->MaskWidth;
    Piece.ScrollWidth=Mask->ScrollWidth;

    if (Piece.ScrollWidth)
      Piece.Width=Piece.ScrollWidth+2;
    else if (Piece.MaskWidth)
      Piece.Width=Piece.MaskWidth;
    else
      Piece.Width=strlen(Piece.Mask);

    delete Mask;

    if (*Piece.Prompter)
      PlacePrompter(Piece);
  }

  if (CheckMask)
  {

    Piece.Text=new char[50];
    strcpy(Piece.Text,CheckMask->CheckText);

    Piece.HotKey=new char[30];
    strcpy(Piece.HotKey,CheckMask->HotKeyDefine);

    Piece.Variable=new char[50];
    strcpy(Piece.Variable,CheckMask->VariableName);

    Piece.Help=new char[65];
    strcpy(Piece.Help,CheckMask->HelpLine);

    Piece.DerivedClass=new char[50];
    strcpy(Piece.DerivedClass,CheckMask->DerivedClass);

    Piece.GroupCode=CheckMask->GroupingCode;
    Piece.HelpId=CheckMask->HelpScreen;
    Piece.ToBeDerived=CheckMask->SetForLiving;

    delete CheckMask;

  }

  if (PushMask)
  {

    Piece.Text=new char[50];
    strcpy(Piece.Text,PushMask->PushText);

    Piece.Constant=new char[50];
    strcpy(Piece.Constant,PushMask->Constant);

    Piece.HotKey=new char[30];
    strcpy(Piece.HotKey,PushMask->HotKeyDefine);

    Piece.Help=new char[65];
    strcpy(Piece.Help,PushMask->HelpLine);

    Piece.DerivedClass=new char[50];
    strcpy(Piece.DerivedClass,PushMask->DerivedClass);

    Piece.GroupCode=PushMask->GroupingCode;
    Piece.HelpId=PushMask->HelpScreen;
    Piece.ToBeDerived=PushMask->SetForLiving;

    delete PushMask;

  }

  if (GroupMask)
  {

    Piece.Text=new char[50];
    strcpy(Piece.Text,GroupMask->GroupText);

    Piece.HotKey=new char[30];
    strcpy(Piece.HotKey,GroupMask->HotKeyDefine);

    Piece.GroupCode=GroupMask->GroupingCode;

    delete GroupMask;

  }

  if (RadioMask)
  {

    Piece.Variable=new char[50];
    strcpy(Piece.Variable,RadioMask->VariableName);

    Piece.Prompter=new char[50];
    strcpy(Piece.Prompter,RadioMask->Prompter);

    Piece.HotKey=new char[30];
    strcpy(Piece.HotKey,RadioMask->HotKeyDefine);

    Piece.Help=new char[65];
    strcpy(Piece.Help,RadioMask->HelpLine);

    Piece.DerivedClass=new char[50];
    strcpy(Piece.DerivedClass,RadioMask->DerivedClass);

    Piece.GroupCode=RadioMask->GroupingCode;
    Piece.HelpId=RadioMask->HelpScreen;
    Piece.ToBeDerived=RadioMask->SetForLiving;

    Piece.Elements=new char*[10];

    for (int i=0;i<10;i++)
    {
      Piece.Elements[i]=new char[50];
      strcpy(Piece.Elements[i],RadioMask->RadioButtons[i]);
    }

    delete RadioMask;

    if (*Piece.Prompter)
      PlacePrompter(Piece);

  }

  if (PickMask)
  {

    Piece.Prompter=new char[50];
    strcpy(Piece.Prompter,PickMask->Prompter);

    Piece.HotKey=new char[30];
    strcpy(Piece.HotKey,PickMask->HotKeyDefine);

    Piece.Help=new char[65];
    strcpy(Piece.Help,PickMask->HelpLine);

    Piece.DerivedClass=new char[50];
    strcpy(Piece.DerivedClass,PickMask->DerivedClass);

    Piece.HelpId=PickMask->HelpScreen;
    Piece.ToBeDerived=1;

    delete PickMask;

    if (*Piece.Prompter)
      PlacePrompter(Piece);

  }

  RemoveTheMenus();

  VirtualizedInterior();
}

//-------------------------------------------------------------------------
//
// This permits positioning of the prompter on the dialog
//
//-------------------------------------------------------------------------

void DialogWindow::PlacePrompter(PieceHandler &Piece)
{
  RemoveTheMenus();

  Piece.DrawFigure();

  Blaze.HelpLine(0,"Use the keyboard or mouse to place the prompter");

  MousePosition(X+Piece.PromptX+1,Y+Piece.PromptY+1);
  MouseLocate();

  Event EventHandler;

  int MouseX=MouseHorizontal;
  int MouseY=MouseVertical;

  for (;;)
  {
    switch (EventHandler.GetEvent())
    {
      case kbUp:
        if (!Piece.PromptY)
          continue;
        Piece.PromptY--;
        VirtualizedInterior();
        break;

      case kbDown:
        if (Piece.PromptY>=Blaze.WhatWinHeight()-1)
          break;
        Piece.PromptY++;
        VirtualizedInterior();
        break;

      case kbLeft:
        if (!Piece.PromptX)
          continue;
        Piece.PromptX--;
        VirtualizedInterior();
        break;

      case kbRight:
        if (Piece.PromptX>=Blaze.WhatWinWidth()-1)
          break;
        Piece.PromptX++;
        VirtualizedInterior();
        break;

      case MousedEvent:
        if (MouseEvent&MouseMoved)
        {
          int NewX=MouseHorizontal-MouseX;
          int NewY=MouseVertical-MouseY;
          Piece.PromptX+=NewX;
          Piece.PromptY+=NewY;
          MouseX=MouseHorizontal;
          MouseY=MouseVertical;

          if (Piece.PromptX<0)
            Piece.PromptX=0;
          if (Piece.PromptY<0)
            Piece.PromptY=0;

          if (Piece.PromptX>Blaze.WhatWinWidth()-1)
            Piece.PromptX=Blaze.WhatWinWidth()-1;
          if (Piece.PromptY>Blaze.WhatWinHeight()-1)
            Piece.PromptY=Blaze.WhatWinHeight()-1;

          if (MouseX!=Piece.PromptX+X+1 || MouseY!=Piece.PromptY+Y+1)
          {
            MousePosition(X+Piece.PromptX+1,Y+Piece.PromptY+1);
            MouseLocate();
            MouseX=MouseHorizontal;
            MouseY=MouseVertical;
          }

          VirtualizedInterior();
        }
        if (MouseEvent&MouseLeftButtonRelease)
          return;
        break;

      case kbCr:
        return;
    }
  }
}
