//
// The Fusion Library Interface for DOS
// Version 1.02
// Copyright (C) 1990, 1991
// Software Dimensions
//
// Dialog Development System
//
// Main Module
//

#include "fliwin.h"
#include "colors.h"
#include "dds.h"

#include <stdio.h>
#include <alloc.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

InfoBox *Welcome;

int OverrideBlaze=0;
int OmitComments=0;

extern int PanelAutoEngaged;

//-------------------------------------------------------------------------
//
// Current Time Displayer (GlobalLive)
//
//-------------------------------------------------------------------------

void MemoryFree()
{
  static BlazeClass Blaze;
  static int Clicker=0;

  Blaze.Window(0,0,Blaze.WhatWidth(),Blaze.WhatHeight());

  struct tm *time_now;
  time_t secs_now;

  char TimeClock[30];

  tzset();
  time(&secs_now);
  time_now=localtime(&secs_now);

  strftime(TimeClock,15,"%I:%M %p ",time_now);
  strcat(TimeClock,(Clicker)?"\x9":"\x7");

  Blaze (Blaze.WhatWidth()-11,0)
    << Colors.MenuBarNormal
    << TimeClock;

  Clicker=(Clicker)?0:1;
}

//-------------------------------------------------------------------------
//
// Main startup module
//
//-------------------------------------------------------------------------

void main()
{
  BlazeClass Blaze;

  //-------------------------------------------------------------------------
  //
  // Alter the colors if in the color mode -- switches bars to blue
  // background instead of white, since the screen is white enough
  // because of the dialog.  This only happens if there isn't a panel
  // settings file saved onto the disk -- since the user may have altered
  // the settings and we don't want to mess up the settings.
  //
  //-------------------------------------------------------------------------

  if (!PanelAutoEngaged)
  {
    if (!Blaze.IsBlackWhite())
    {
      Colors.PromptLineBold=fYellow|bBlue;
      Colors.PromptLineNormal=fWhite|bBlue;
      Colors.MenuBarBold=fYellow|bBlue;
      Colors.MenuBarNormal=fWhite|bBlue;
    }

    FusionShadowing=1;
  }

	FLIVideoProtect++;

	FusionHelp::DefineHelp("DDS.HLP");
  FusionHelp::DisableHelp(); // help system shut off

	Blaze.FreshWorkSpace();

  //-------------------------------------------------------------------------
  //
  // Set up global live function (time displayer)
  //
  //-------------------------------------------------------------------------

	Event::GlobalLive(MemoryFree);
  Event::SetLiveTime(20);

  //-------------------------------------------------------------------------
  //
  // Define the info box that tells about the program and version
  //
  // It is a violation of Software Dimensions copyright to remove or alter
  // the information contained in this information box.  Any alterations
  // made to this dialog box can only be made with express written
  // permission from Software Dimensions and Robert Miller.
  //
  //-------------------------------------------------------------------------

	Welcome = new InfoBox;
	(*Welcome) + "Fusion Dialog Development System"
					+ ""
          + "Software Version 1.02"
          + "Production Dated: "__DATE__" "__TIME__
          + "Compiled Under Large Model"
          + ""
          + "Developed by Robert Miller"
          + "Copyright (C) 1991 by Software Dimensions"
          + ""
          + "\"Beyond the Future\"";
  Welcome->UseInfoBox();

  //-------------------------------------------------------------------------
  //
  // Define workspace and global help code
  //
  //-------------------------------------------------------------------------

  FusionWindow &Window=*new DesignerWindow();

  Window.GlobalHelp(1500);

  //-------------------------------------------------------------------------
  //
  // Define the file menu (other menus displayed when window is opened)
  //
  //-------------------------------------------------------------------------

  Window.NewMenu("","Control Panel",kbAltSpace,winControlPanel);
    Window.Option("Con~trol Panel ...","A control panel to customize mouse and menu settings",winControlPanel);
    Window.Option("A~bout ...","About the designer",winAbout);

  Window.NewMenu("~File","File management features",kbAltF);
		Window.Option("~New","Open a new dialog window",winNew);
    Window.Option("~Open ...","Open a dialog",winOpen);
		Window.Option("~Save","Save this dialog",winSave);
		Window.Available(Window.NumberOfWindows);
		Window.HotKey("F2",kbF2);
		Window.Option("Save ~As ...","Change the file save name",winSaveAs);
		Window.Available(Window.NumberOfWindows);
		Window.Option("~Change Directory","Change the current directory",winChDir);
		Window.BlankLine();
		Window.Option("~Generate C++ Code","Generate C++ source code");
    Window.Available(Window.NumberOfWindows);
    Window.SubMenu();

      Window.Option("~Override Blaze Colors","Should the colors that you have selected be overridden?");
      Window.CheckMark(OverrideBlaze);
      Window.Option("Omit ~Comments","Should the usage instructions be omitted from the C++ file?");
      Window.CheckMark(OmitComments);
      Window.BlankLine();
      Window.Option("~Generate C++ Code","Generate C++ source code",winGenCPP);

    Window.EndSubMenu();
    Window.BlankLine();
    Window.Option("~DOS Shell","Suspend the Dialog Designer and shell to DOS",winDOSShell);
    Window.Option("E~xit Dialog Designer","Leave the designer",winExit);
    Window.HotKey("Alt-X",kbAltX);

  //-------------------------------------------------------------------------
  //
  // Define all keys that will show up on the prompt line
  //
  //-------------------------------------------------------------------------

  Window.DefineNormKey("F2","Save",winSave);
  Window.DefineNormKey("F3","Del",manipDeletePiece);
  Window.DefineNormKey("F4","Color",drawColor);
  Window.DefineNormKey("F5","Back",manipBack);
  Window.DefineNormKey("F6","Front",manipForward);
  Window.DefineNormKey("F7","Size/Edit",manipSize);
  Window.DefineNormKey("F8","Move",manipMove);
  Window.DefineNormKey("F9","Copy",manipCopy);
  Window.DefineNormKey("F10","Menu",winCallMenu,kbF10);

  Window.DefineAltKey("B","Box",drawBox);
  Window.DefineAltKey("I","Filled",drawFillBox);
  Window.DefineAltKey("H","HLine",drawHLine);
  Window.DefineAltKey("V","VLine",drawVLine);
  Window.DefineAltKey("S","Shadow",drawShadow);
  Window.DefineAltKey("R","Erase",drawErase);
  Window.DefineAltKey("P","Plop",drawPlop);
  Window.DefineAltKey("N","Trans",drawTrans);
  Window.DefineAltKey("T","Test",layoutTest);
  Window.DefineAltKey("X","Exit",winExit);

  Window.DefineCtrlKey("C","Char",elementChar);
  Window.DefineCtrlKey("I","Int",elementInt);
  Window.DefineCtrlKey("L","Long",elementLong);
  Window.DefineCtrlKey("F","Float",elementFloat);
  Window.DefineCtrlKey("D","Double",elementDouble);
  Window.DefineCtrlKey("B","Bcd",elementBcd);
  Window.DefineCtrlKey("V","Vert",elementVRadio);
  Window.DefineCtrlKey("Z","Horiz",elementHRadio);
  Window.DefineCtrlKey("K","Check",elementCheck);
  Window.DefineCtrlKey("U","Button",elementPush);

  //-------------------------------------------------------------------------
  //
  // Define maximum allowed windows and engage the DDS!
  // Global event handler can be found in GLOBAL.CPP
  //
  //-------------------------------------------------------------------------

  Window.MaximumWindows(1);

  Window.EngageFusion();

  delete &Window;
  delete Welcome;
}

//-------------------------------------------------------------------------
//
// Goodbye Message!
//
//-------------------------------------------------------------------------

void AAAA_GoodBye()
{
  puts("Thank you for using the Dialog Development System\n\r"
    "Brought to you by Robert M Miller and Software Dimensions");
}

// The docs say to stay away from priorities below 64, but this
// is safe and we *WANT* to make sure that our goodbye message displays
// at program exists.

#pragma exit AAAA_GoodBye 0
