//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// Main Header File for all DialogClass elements
//
// If you include this file, without including FLI.H first -- this file
// will automatically include it for you
//

// ==========================================================================
// Consult the reference manual for complete function reference of all
// functions within this header file.  All variables are documented
// inside this header file, for ease of use when modifying the supplied
// source code.  For additional class information, please consult the
// Software Dimensions BBS.  Telephone numbers are included in the
// READ.ME file and in the documentation.
// ==========================================================================

#ifndef __cplusplus
#error Please switch to C++ mode before using Fusion
#endif

#ifdef __PASCAL__
#error The Pascal calling convention cannot be used with Fusion
#endif

#ifndef __FusionElements__
#define __FusionElements__

#ifndef __Fusion__
#include "fli.h"
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// TREE OF INHERITANCE WITHIN THE DIALOG CLASS
//
// DialogElement
//  
//   CharMask * -> In FLI.H
//        DiaChar $
//              DiaCombo $
//   NumberMask * -> In FLI.H
//        Numerics
//              DiaInt $
//              DiaLong $
//              DiaFloat $
//              DiaDouble $
//              DiaBcd $
//   DiaVertRadio $
//   DiaHorizRadio $
//   DiaCheckBox $
//   DiaPushButton $
//   DiaPickGeneric $
//       DiaPickList $
//       DiaStructPickList $
//   DiaMulti $
//
// * CharMask/NumberMask can be found in FLI.H.  These two classes are
//   also used by BlazeClass for all masked output
// $ These are classes that are "plug and play" ready.  In other words,
//   you can derive from these classes without any modifications.  See the
//   FLI documentation for usage instructions
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// class DiaChar
//
// Handles masked character based input
//
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

class DiaChar : public DialogElement, public CharMask
{
public:

  char *Value;                      // Current status of input -- contains
                                    // the string with the user input

  char *Mask;                       // The character mask
  char *AssembleMask;               // The character mask with all non-mask,
                                    // walkaround characters stripped out

  int TotalMaskWidth;               // Actual width of the mask
  int CurrentLocation;              // Current location of the input cursor

  int QuickMasked;                  // Was it quick masked?

  int AtLeft;                       // What position of string is at the left
                                    // of the display?
  int VisualWidth;                  // What is the visual width?

  int NoEditErase;                  // Should the cursor be reset?
  int EditOverriden;                // Is edit overriden?

private:

  int Width;                        // Duplicate of Width in DialogElement
                                    // class to be used only by the DiaChar
                                    // class.  Used specifically for elements
                                    // created by deriving the DiaChar class.

public:

  DiaChar(int,int,char *,char *,int=0,char=0,int=0,int=0);
  ~DiaChar();

  void Show();
  void HighLight();
  void ScrollUpdate(int);

  int EventHandler(int);
  int GetPhysical();
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// class Numerics
//
// Base class for handling numeric mask
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

class Numerics : public DialogElement, public NumberMask
{
public:

  char *Mask;                       // Contains the numerical mask
  char *Value;                      // Contains the current value in
                                    // text format

  int AllowedNegative;              // Can be negative (1) or not (0)
  int AllowedBeforeDecimal;         // Number of digits before decimal
  int AllowedAfterDecimal;          // Number of digits after decimal

  int CurrentLocation;              // Current location in the string
  int NoEditErase;                  // Should the cursor be reset?
  int EditOverriden;                // Is edit overriden?

  int EventValidation(int);
  void TrimTrailingZeros();

  Numerics(int);
  ~Numerics();

  void Show();
  void HighLight();
  int EventHandler(int Event) = 0;
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// class DiaInt
// class DiaLong
// class DiaFloat
// class DiaDouble
// class DiaBcd
//
// These classes handle all numeric based input.
//
// Class DiaBcd is only declared if the bcd.h header file was included BEFORE
// this header file
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#define Frame(ClassName,NumericType)\
class ClassName : public Numerics \
{ \
public: \
\
  NumericType &Value; \
\
  ClassName(int,int,char *,NumericType &,int=0); \
\
  void Show(); \
  int EventHandler(int); \
};

Frame(DiaInt,int);
Frame(DiaLong,long);
Frame(DiaFloat,float);
Frame(DiaDouble,double);

#ifdef __BCD_H
Frame(DiaBcd,bcd);
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// class DiaHorizRadio
// class DiaVertRadio
//
// These classes handle all radio button based input.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#undef Frame

#define Frame(ClassName)\
class ClassName : public DialogElement \
{ \
public: \
\
  int &Item; \
  char **Items; \
  int ItemCount; \
  int IsQueued; \
\
  ClassName(int,int,int &,int,char **); \
  ~ClassName(); \
\
  void operator+ (char *); \
\
  void Show(); \
  void HighLight(); \
  int EventHandler(int); \
};

Frame(DiaVertRadio);
Frame(DiaHorizRadio);

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// class DiaCheckBox
//
// This class handles check box based input.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

class DiaCheckBox : public DialogElement
{
public:

  int &Checked;                     // Is this item checked (1) or not (0)
  char *CheckText;                  // Text for next to check mark

  DiaCheckBox(int,int,int &,char *,int=0);

  void Show();
  void HighLight();
  int EventHandler(int);
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// class DiaPushButton
//
// The ACTION element should be one of the following:
//
//    1000+  Send this event code along to the EventHandler() function
//           of DialogClass.  At that point, the EventHandler() should
//           determine the actual result of the button press
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

class DiaPushButton : public DialogElement
{
public:

  int Action;                       // Desired action (after pressed)
  int Pushed;                       // Is button in (1) or out (0)
  int Active;                       // This is the active button
  char *Button;                     // Text for button

  DiaPushButton(int,int,char *,int,int=0,int=0);

  void Show();
  void HighLight();
  int EventHandler(int);
  void PushIn();
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// class DiaPickGeneric
//
// This class handles all pick lists.
//
// This is a generic pick lister.  Just override the GetItem function call
// and you can create a custom pick list style.  The GetItem function
// accepts one argument that is an integer representing the item # that
// is needed for this list.  The GetItem function returns a character
// string that should be displayed in the list.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

class DiaPickGeneric : public DialogElement
{
public:

  int &Item;                        // Current item
  int &ItemCount;                   // Number of items
  int ItemAtTopOfList;              // Current item at the top of the list

  DiaPickGeneric(int,int,int,int,int &,int &);

  void Show();
  void HighLight();
  void ScrollBar();
  int EventHandler(int);
  int QuikFind(int,int,int);

  virtual char *GetItem(int) = 0;
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// class DiaPickList
//
// This class handles all pick lists.
//
// This class is passed a list of CHAR elements.  For instance, the calling
// program could have a "char *Mine[] = { "HELLO","THIS" };" declaration.
// All you have to do is pass a pointer of MINE through ITEM and set ITEMCOUNT
// to the number of elements in the array.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

class DiaPickList : public DiaPickGeneric
{
public:

  char **Items;                     // Text for each item

  DiaPickList(int,int,int,int,int &,int &,char **);

  char *GetItem(int);
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// class DiaStructPickList
//
// This class handles all pick lists.
//
// This class works differently than the PICKLIST class, because it allows
// you to point to a string within a structure.  Just pass a pointer to the
// first element through the ITEMS argument, set the structure width through
// the STRUCTWIDTH argument, and tell it how many items through the
// ITEMCOUNT argument and you are off and running.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

class DiaStructPickList : public DiaPickGeneric
{
public:

  int StructWidth;                  // Width of the structure
  void *Items;                      // Pointer to first character item
                                    // in the structure array

  DiaStructPickList(int,int,int,int,int &,int &,int,void *);

  char *GetItem(int);
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// class DiaCombo
//
// This class handles combo boxes -- this is a combination of a DiaChar
// box and a DiaPickGeneric class.  This is a great example of the power
// of the reusability of C++.  Check out DIACOMBO.CPP and see how little
// code was required to pull of this new element.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

class DiaCombo : public DiaChar
{
public:

  int &ItemCount;                   // Number of items
  int Item;                         // Current item

  DiaCombo(int,int,int &,char *,char *,int=0,char=0,int=0,int=0);

  void Show();
  void HighLight();
  int EventHandler(int);

  virtual char *GetItem(int) = 0;
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// class DiaMulti
//
// This class handles multi line input elements.  It features a few wordstar
// like commands without scroll bars.
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

class DiaMulti : public DialogElement
{
public:

  int CurX;                         // Current X position
  int CurY;                         // Current Y position
  int MaxWidth;                     // Maximum width of the string
  int Relative;                     // Relative position inside string

  int Start, End;                   // Starting and Ending point of string

  char *String;                     // The string where the multiline text
                                    // should be placed.

  DiaMulti(int,int,int,int,char *);

  void Show();
  void HighLight();
  int EventHandler(int);
  void Display(int);
  void Triangulate(int);
};

#endif
