//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// Define Header File
//
// YOU DO NOT NEED TO INCLUDE THIS HEADER FILE IN YOUR PROGRAMS!
// JUST INCLUDING FLI.H WILL DO THIS FOR YOU AUTOMATICALLY!
//

#ifndef __FusionDefines__
#define __FusionDefines__

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//
//                                                                           //
// enum Coloring - Defines colors                                            //
//                                                                           //
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

enum Coloring
{
  fBlack,
  fBlue,
  fGreen,
  fCyan,
  fRed,
  fMagenta,
  fBrown,
  fLightGray,
  fGray,
  fLightBlue,
  fLightGreen,
  fLightCyan,
  fLightRed,
  fLightMagenta,
  fYellow,
  fWhite,

  bBlack=0,
  bBlue=16,
  bGreen=32,
  bCyan=48,
  bRed=64,
  bMagenta=80,
  bBrown=96,
  bWhite=112,
  Flashing=128
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//
//                                                                           //
// enum _ExtendedVideoModes - Defines extended text video modes              //
//                                                                           //
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

enum _ExtendedVideoModes
{
  Default=0,
  Normal_80x25=500,
  EGA_VGA_43or50=600,

  Paradise_132x43=84,
  Paradise_132x25,

  ATI_Wonder_132x25=35,
  ATI_Wonder_132x44=51,

  VGA_Wizard_80x34=50,
  VGA_Wizard_80x45,
  VGA_Wizard_132x25=35,
  VGA_Wizard_132x44=34,

  Compaq_VGS_132x25=35,
  Compaq_VGS_132x28,
  Compaq_VGS_132x43=34,
  Compaq_VGS_132x50=39,
  Compaq_VGS_132x60,

  Genoa_VGA_132x25=35,
  Genoa_VGA_132x28,
  Genoa_VGA_132x43=34,

  Orchid_VGA_80x60=38,
  Orchid_VGA_132x25=35,
  Orchid_VGA_132x28,
  Orchid_VGA_132x44=34,

  Sigma_VGA_132x25=28,
  Sigma_VGA_132x44,

  STB_VGA_132x25=35,
  STB_VGA_132x44=34,

  Video7_80x43=64,
  Video7_132x25,
  Video7_132x43,
  Video7_80x60,
  Video7_100x60,
  Video7_132x28,

  Tecmar_132x25=23,

  Tseng_132x44=34,
  Tseng_132x25,
  Tseng_132x28,

  VEGA_80x43=64,
  VEGA_132x25,
  VEGA_132x43,
  VEGA_80x60,
  VEGA_100x60,
  VEGA_120x25=77,
  VEGA_120x43
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//
//                                                                           //
// enum _KeyBoard - Defines the available keys                               //
//                                                                           //
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

enum _KeyBoard
{
  kbEsc=27,
  kbBackSpace=8,
  kbCr=13,
  kbTab=9,
  kbF1=315,
  kbF2,
  kbF3,
  kbF4,
  kbF5,
  kbF6,
  kbF7,
  kbF8,
  kbF9,
  kbF10,
  kbLeft=331,
  kbRight=333,
  kbHome=327,
  kbUp,
  kbPgUp,
  kbEnd=335,
  kbDown,
  kbPgDn,
  kbIns,
  kbDel,

  kbShiftTab=271,
  kbShiftF1=340,
  kbShiftF2,
  kbShiftF3,
  kbShiftF4,
  kbShiftF5,
  kbShiftF6,
  kbShiftF7,
  kbShiftF8,
  kbShiftF9,
  kbShiftF10,

  kbCtrlLeftArrow=371,
  kbCtrlRightArrow,
  kbCtrlPgUp=388,
  kbCtrlPgDn=374,
  kbCtrlEnd=373,
  kbCtrlHome=375,
  kbCtrlF1=350,
  kbCtrlF2,
  kbCtrlF3,
  kbCtrlF4,
  kbCtrlF5,
  kbCtrlF6,
  kbCtrlF7,
  kbCtrlF8,
  kbCtrlF9,
  kbCtrlF10,
  kbCtrlA=1,
  kbCtrlB,
  kbCtrlC,
  kbCtrlD,
  kbCtrlE,
  kbCtrlF,
  kbCtrlG,
  kbCtrlH,
  kbCtrlI,
  kbCtrlJ,
  kbCtrlK,
  kbCtrlL,
  kbCtrlM,
  kbCtrlN,
  kbCtrlO,
  kbCtrlP,
  kbCtrlQ,
  kbCtrlR,
  kbCtrlS,
  kbCtrlT,
  kbCtrlU,
  kbCtrlV,
  kbCtrlW,
  kbCtrlX,
  kbCtrlY,
  kbCtrlZ,

  kbAltF1=360,
  kbAltF2,
  kbAltF3,
  kbAltF4,
  kbAltF5,
  kbAltF6,
  kbAltF7,
  kbAltF8,
  kbAltF9,
  kbAltF10,
  kbAlt1=376,
  kbAlt2,
  kbAlt3,
  kbAlt4,
  kbAlt5,
  kbAlt6,
  kbAlt7,
  kbAlt8,
  kbAlt9,
  kbAlt0,
  kbAltDash,
  kbAltEqual,
  kbAltQ=272,
  kbAltW,
  kbAltE,
  kbAltR,
  kbAltT,
  kbAltY,
  kbAltU,
  kbAltI,
  kbAltO,
  kbAltP,
  kbAltA=286,
  kbAltS,
  kbAltD,
  kbAltF,
  kbAltG,
  kbAltH,
  kbAltJ,
  kbAltK,
  kbAltL,
  kbAltZ=300,
  kbAltX,
  kbAltC,
  kbAltV,
  kbAltB,
  kbAltN,
  kbAltM,

  kbAltSpace=550
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//
//                                                                           //
// enum _EventCodes - Event codes for Fusion                                 //
//                                                                           //
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

enum _EventCodes
{
                            // Error Events --

  NoElement=900,            // No elements have been allocated
  NoAvailableElement,       // None of the elements are available
  NoAvailableMenus,         // When no menus are available
  MemoryAllocationError,    // Fusion ran out or had problems with memory
  NoAvailableOptions,       // No menu options were available

                            // Other Events (from GetEvent()) --

  ShiftEvent,               // The shift state has changes (i.e. Alt, Ctrl)

                            // Mouse Events --

  MousedEvent,              // A mouse action occured
  ValidatedMousedEvent,     // Special mouse event for dialogs.  This
                            // type of event is within the bounds of
                            // the present element
  CloseEvent,               // Close icon on window was pressed
  MoveEvent,                // Window was moved
  ZoomEvent,                // Window was zoomed
  SizeEvent,                // Window was sized
  OutsideEvent,             // Mousing outside of window
  HelpEvent,                // The help system was engaged

                            // Dialog/FusionWindow Events --

  CompleteEvent,            // Event executed cleanly, proceed normally
  RefreshEvent,             // Refresh all elements on the dialog
  OtherRefreshEvent,        // Refresh all elements except the current one
  StopEvent,                // Stop using the dialog
  AbortEvent,               // Abort using a dialog and immediately
  RestartEvent,             // Restarts the dialog box
  FailedEvent,              // A validation() or available() function
                            // failed
  MagnetEvent,              // Jumps to previously magnetized object
  RefreshMagnetEvent,       // Jumps to previously magnetized object and
                            // does a refresh just like RefreshEvent
  OtherRefreshMagnetEvent,  // Jumps to previously magnetized object and
                            // does a refresh just like OtherRefreshEvent
  LastElementEvent,         // At last element
  FirstElementEvent,        // At first element
  NextElementEvent,         // Go to next element
  PreviousElementEvent,     // Go to previous element
  NextGroupEvent,           // Go to next group
  PreviousGroupEvent,       // Go to previous group
  NextWithinGroupEvent,     // Go to next element within group
  PreviousWithinGroupEvent, // Go to previous element within group
  FullValidationEvent,      // Fully validates a dialog
  MenuEvent,                // Something happened with the menus
  NothingEvent,             // Nothing happened
  MenusRemoved,             // All menus were removed
  SwitchEvent,              // Just switched to another window
  EngageEvent,              // Passed to global event handler when engaged
  DisEngageEvent,           // Passed to global event handler when exited
  VirtualEvent,             // When a virtual window event occurs this is
                            // passed to the window that requests it
  ClickEvent,               // You double clicked within an element

                            // PopUp Events --

  RemoveMenu,               // Remove the menus from the screen
  KeepMenu                  // Keep the menu on the screen
};

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//
//                                                                           //
// These are the events retuned in MouseEvent                                //
//                                                                           //
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-//

const MouseMoved=1;
const MouseLeftButtonPress=2;
const MouseLeftButtonRelease=4;
const MouseRightButtonPress=8;
const MouseRightButtonRelease=16;
const MouseDoubleClick=32;
const MouseHeldDown=64;

const LeftButton=1;
const RightButton=2;
const CenterButton=4;

#endif
