#include "buttons.h"
char *aszMnemonics[] = 	{   "@1", "@2", "@3",	/* PF 1 to 3 */ 
							"@4", "@5", "@6",  	/* PF 4 to 6 */
                        	"@7", "@8", "@9",   /* PF 7 to 9 */
                        	"@a", "@b", "@c",   /* PF 10 to 12 */
                        	"@x", "@y", "@z", 	/* PA1 to 3 */
                        	"@E", "@C", "@R" };	/* Enter, Clear, Reset */
                        	
char *aszDefaultLabels[] = {"PF1", "PF2", "PF3", 
							"PF4", "PF5", "PF6", 
							"PF7", "PF8", "PF9", 
							"PF10","PF11", "PF12",
							"PA1", "PA2", "PA3", 
							"Enter", "Clear", "Reset"};	
							
HANDLE hWindowInstance;
arPF_KEYS arKeys;
static LPSTR FindDll(LPSTR);
HLLAPI_FUNCTION_PTR HllapiFn;
HINSTANCE hDll;                           


/***************************************************************************
 *                                                                         *
 *  FUNCTION : ButtonsWndProc (HWND, unsigned, WORD, LONG)                 *
 *                                                                         *
 *  PURPOSE  : Window function for the application.                        *
 *                                                                         *
 ***************************************************************************/

long FAR PASCAL ButtonsWndProc(HWND hWnd, unsigned message, WORD wParam, LONG lParam)
{                                                                                    
	LONG lRc;

    switch (message)
    {

        case WM_CREATE:
            FindPfKeys(&arKeys);
            lRc = 0;
            break;

        case WM_SIZE:
            /* Resize buttons window and redraw */
           	DrawButtons(hWnd, &arKeys);
            lRc = 0;
            break;

        case WM_DESTROY:
            /* Cleanup time */
			CleanupHllapi();            
            PostQuitMessage(0);
            lRc = 0;
            break;

        case WM_COMMAND:
       		(*(arKeys[wParam].fnFunction))(hWnd, &arKeys[wParam]); 
			break;

        case WM_TIMER:
        	switch (wParam)
        	{
        		case TMR_POLL:   
        			if (!IsXClock())
        			{                                            
        				KillTimer(hWnd, TMR_POLL);		/* Quit polling */
        				SetTimer(hWnd, TMR_REFRESH, REFRESH_INTERVAL, NULL);
        			}                                                   
        			lRc = 0;
        			break;	
        		case TMR_REFRESH:	                                      
        			KillTimer(hWnd, TMR_REFRESH);	
        			RefreshButtons(hWnd, NULL);		/* Refresh the buttons */
        			lRc = 0;        			
        			break;                                     
        		default:
        		    lRc = DefWindowProc(hWnd, message, wParam, lParam);	
        	}               
        	break;

        default:
            /* Perform the default window processing */
            lRc = DefWindowProc(hWnd, message, wParam, lParam);
    }
    return(lRc);
}

/***************************************************************************
 *                                                                         *
 *  FUNCTION : FindOVPfKeys									               *
 *                                                                         *
 *  PURPOSE  : Search the screen pfkey descriptions						   * 
 *             If you don't find any, use the default button definitions   *
 *  NOTE:      The code/algorithms to search the screen are in seperate    *
 *             functions.                                                  *
 *                                                                         *
 ***************************************************************************/

void FindPfKeys(arPF_KEYS *arPfKeys)
{
	int n;

	if (!FindOVPfKeys(arPfKeys))
	{
		for (n=0; n<NUMBER_OF_PFKEYS; n++)
		{   
			strcpy((*arPfKeys)[n].szLabel, aszDefaultLabels[n]);
			strcpy((*arPfKeys)[n].szMnemonic, aszMnemonics[n]);
			(*arPfKeys)[n].fnFunction = PressButton;			
		}                                  
	
	}
}	





/***************************************************************************
 *                                                                         *
 *  FUNCTION : FindOVPfKeys									               *
 *                                                                         *
 *  PURPOSE  : Search the screen for OV (Profs) pfkey descriptions.        * 
 *             If you don't find any, use the default button definitions   *
 *                                                                         *
 ***************************************************************************/

BOOL FindOVPfKeys(arPF_KEYS *arPfKeys)
{   
	int nOffset=1;
	char szString[80];
	enum { FIND_NUMBER, FIND_FUNCTION, FIND_COMPLETE, FIND_ERROR } eState;
	int n;        
	long lPfNumber = 0;
	char *szLabel;
	BOOL fFoundOne = FALSE;

	for (n=0; n<NUMBER_OF_PFKEYS; n++)
	{   
		memset((*arPfKeys)[n].szLabel, 0, sizeof((*arPfKeys)[n].szLabel));
		memset((*arPfKeys)[n].szMnemonic, 0, sizeof((*arPfKeys)[n].szMnemonic));
	}                                  

	nOffset = SearchPS("PF",nOffset);
	while (nOffset > 0)
	{
		CopyPsToString(szString, 80, nOffset+2);
		
		for (n=0, eState = FIND_NUMBER; 
			(n< sizeof(szString)) && (eState < FIND_COMPLETE); 	
			n++)
		{ 
			switch(eState)
			{
			case FIND_NUMBER:
				if (szString[n] == ' ')
				{
					szString[n]='\0';
					lPfNumber = atol(szString);
					if (lPfNumber == 0L)
					{
						nOffset = nOffset+n+1;
						eState = FIND_ERROR;
					}		
					else
					{
						szLabel = &szString[n]+1;
						nOffset = nOffset+n+1;
						eState = FIND_FUNCTION;
					}	
				}			
				break;
					
			case FIND_FUNCTION:	
				if (strncmp(&szString[n], "  ", 2) == 0)
				{
					szString[n] = '\0';       
					nOffset = nOffset + n - 1;
					eState = FIND_COMPLETE;
				}
				else if	(strnicmp(&szString[n], " PF", 3) == 0)
				{
					szString[n] = '\0';       
					nOffset = nOffset+ n - 1;
					eState = FIND_COMPLETE;
				}
				break;
			}	                     
		} 
		if ((eState == FIND_COMPLETE) && (lPfNumber <= NUMBER_OF_PFKEYS))
		{       
			fFoundOne = TRUE;                                                 
			strcpy((*arPfKeys)[lPfNumber-1].szLabel, szLabel);
			strcpy((*arPfKeys)[lPfNumber-1].szMnemonic, aszMnemonics[lPfNumber-1]);
			(*arPfKeys)[lPfNumber-1].fnFunction = PressButton;
		}	
		if (n == sizeof(szString))
			nOffset += sizeof(szString);
			
		nOffset = SearchPS("PF",nOffset);
	}
    
		                                                       
	return(fFoundOne);
}
/***************************************************************************
 *                                                                         *
 *  FUNCTION : DrawButtons                                                 *
 *                                                                         *
 *  PURPOSE  : Draw all the buttons required                               *
 *                                                                         *
 ***************************************************************************/

void DrawButtons(HWND hWnd, arPF_KEYS *arPfKeys)
{
	int 	n;
    size_t  nLongestKey=0;                  
    RECT 	rWinRect;
    int 	nButtonWidth;
    int 	nButtonHeight;                                             
    int 	nX=0, nY=0;
    int 	nKeysOnLineSoFar;
    int		nKeysPerLine;
    int 	nKeys=0;
    int     nLines;
    rPF_KEYS *gprPfKey;
    BOOL 	fRc;
	
	GetClientRect(hWnd, &rWinRect); 	
	
	for (n=0; n<NUMBER_OF_BUTTONS; n++)
	{   
		if ((*arPfKeys)[n].szLabel[0] != '\0')
		{
			nKeys+=1;	 		            
			nLongestKey=MAX(strlen((*arPfKeys)[n].szLabel), nLongestKey);
		}	
	}                                  
    nLongestKey+=2;							/* Leave space around it */
    nLongestKey *= LOWORD(GetDialogBaseUnits());  /* Size in pixels */
    
	nKeysPerLine = MIN(nKeys,(int) ((rWinRect.right - rWinRect.left) / nLongestKey));
	if (nKeysPerLine == 0)
		nKeysPerLine = 1;

	nLines = nKeys / nKeysPerLine;
	if (nKeys % nLines != 0)
		nLines++;
		
	nButtonWidth =  (rWinRect.right - rWinRect.left) / nKeysPerLine;
	nButtonHeight = (rWinRect.bottom - rWinRect.top) / nLines;
	                            
	nKeysOnLineSoFar = 1;	                            
	for (n=0; n<NUMBER_OF_BUTTONS; n++)
	{                         
		gprPfKey = &((*arPfKeys)[n]);                     
		if (gprPfKey->hWnd != NULL)
		{
			fRc = DestroyWindow(gprPfKey->hWnd);
			gprPfKey->hWnd = NULL;
		}	
		if (gprPfKey->szLabel[0] != '\0')	
		{
			gprPfKey->hWnd = CreateWindowEx(WS_EX_NOPARENTNOTIFY, "BUTTON", gprPfKey->szLabel, 
										WS_VISIBLE | WS_CHILD | BS_PUSHBUTTON , 
										nX, nY, 
										nButtonWidth, nButtonHeight, 
										hWnd, n, hWindowInstance, NULL);
				
			if (++nKeysOnLineSoFar > nKeysPerLine)
			{   
				nX = 0;
				nY += nButtonHeight;
				nKeysOnLineSoFar = 1;
			}
			else
				nX+= nButtonWidth;
		}		
    }
    
	return;
}

/***************************************************************************
 *                                                                         *
 *  FUNCTION : PressButton(rPF_KEYS *gprPfKey)                             *
 *                                                                         *
 *  PURPOSE  : Press the function key specifed in gprPfKey,                *
 *                                                                         *
 ***************************************************************************/

BOOL PressButton(HWND hWnd, rPF_KEYS *gprPfKey)
{
	SendKey(gprPfKey->szMnemonic);
	SetTimer(hWnd, TMR_POLL, POLL_INTERVAL, NULL);
	return(TRUE);
}
	
/***************************************************************************
 *                                                                         *
 *  FUNCTION : RefreshButton(rPF_KEYS *gprPfKey)                           *
 *                                                                         *
 *  PURPOSE  : Refresh the buttons window                                  *
 ***************************************************************************/

BOOL RefreshButtons(HWND hWnd, rPF_KEYS *gprPfKey)
{
    FindPfKeys(&arKeys);
  	DrawButtons(hWnd, &arKeys);

	return(TRUE);
}
	
/***************************************************************************
 *                                                                         *
 *  FUNCTION : WinMain (HANDLE, HANDLE, LPSTR, int)                        *
 *                                                                         *
 *  PURPOSE  : Calls the initialization function, creates the main appli-  *
 *             cation window, and enters the message loop.                 *
 *                                                                         *
 ***************************************************************************/

int PASCAL WinMain(HANDLE hInst, HANDLE hPrev, LPSTR lpszCmdLine, int cmdShow)
{
    HWND  hWnd;
    MSG   msg;

	hWindowInstance = hInst;			/* Save instance handle as global variable */
	
	if (!InitializeHllapi())
		return(FALSE);
	
	InitializeKeys(&arKeys);
	
    if (!hPrev)
    {
        /* First instance -- register window class */
        if (!Initialize(hInst))
            return(FALSE);
    }


    hWnd = CreateWindow( (LPSTR) WINDOW_CLASS_NAME, 	/* class name              */
                             (LPSTR) WINDOW_NAME, 	/* The window name         */
                             WINDOW_STYLE,        	/* window style            */
                             CW_USEDEFAULT,  	 	/* use default positioning */
                             CW_USEDEFAULT,   		/* y ignored               */
                             400,			   		/* use our size        */
                             180,			   		/* y ignored               */
                             NULL,             		/* NULL parent handle      */
                             NULL,             		/* NULL menu/child handle  */
                             hInst,            		/* program instance        */
                             NULL              		/* NULL data structure ref.*/
               );



    ShowWindow(hWnd, cmdShow);

    /* Process messages until program termination */
    while (GetMessage((LPMSG) &msg, NULL, 0, 0))
    {
        TranslateMessage((LPMSG) &msg);
        DispatchMessage((LPMSG) &msg);
    }
    return(msg.wParam);
}


/***************************************************************************
 *                                                                         *
 *  FUNCTION : Initialize()                                                *
 *                                                                         *
 *  PURPOSE  : Registers the application window class and does whatever    *
 *             initialization is required.                                 *
 *                                                                         *
 ***************************************************************************/

BOOL Initialize(HANDLE hInst)
{
    PWNDCLASS pClass;

    pClass = (PWNDCLASS) LocalAlloc(LPTR, sizeof(WNDCLASS));

    pClass->lpszClassName = WINDOW_CLASS_NAME;
    pClass->hbrBackground = GetStockObject(GRAY_BRUSH);
    pClass->style         = CS_VREDRAW | CS_HREDRAW | CS_BYTEALIGNCLIENT;
    pClass->hInstance     = hInst;
    pClass->lpfnWndProc   = ButtonsWndProc;
    pClass->hCursor       = LoadCursor(NULL, IDC_ARROW);
    pClass->hIcon         = LoadIcon(NULL,  IDI_EXCLAMATION);

    if (!RegisterClass((LPWNDCLASS) pClass))
    {
        /* Error registering class -- return */
        return(FALSE);
    }

    LocalFree((HANDLE) pClass);

    return(TRUE);
}

/***************************************************************************
 *                                                                         *
 *  FUNCTION : InitializeKeys (HWND, unsigned, WORD, LONG)                 *
 *                                                                         *
 *  PURPOSE  : Initialize the keys array                                   *
 *                                                                         *
 ***************************************************************************/
                            
BOOL InitializeKeys(arPF_KEYS *arKeys)
{
	strcpy((*arKeys)[FIRST_NON_PF_KEY].szLabel, "Refresh");
	(*arKeys)[FIRST_NON_PF_KEY].fnFunction = RefreshButtons;
	
	return(TRUE);
}	

/***************************************************************************
 *                                                                         *
 *  FUNCTION : InitializeHllapi                                            *
 *                                                                         *
 *  PURPOSE  : Make the HLLAPI calls needed to get started                 *
 *                                                                         *
 ***************************************************************************/
                            

int  InitializeHllapi()
{
    char szSessionParms[]="STRLEN SRCHFROM SRCHFRWD NWAIT";                     
    char szDllPath[256];
    WORD wLength;
    WORD wVerb;
    WORD wRc=0;

	hDll = LoadLibrary(FindDll(szDllPath));
	if (hDll < HINSTANCE_ERROR)
	{
		MessageBox(NULL, "Unable to load HLLAPI DLL", "Buttons", MB_ICONEXCLAMATION | MB_OK);
		return(FALSE);
	}                 
	HllapiFn=(HLLAPI_FUNCTION_PTR)GetProcAddress(hDll, "HLLAPI");
	if (HllapiFn == NULL)
	{
		MessageBox(NULL, "HLLAPI DLL doesn't contain a HLLAPI function", 
						"Buttons", MB_ICONEXCLAMATION | MB_OK);
		return(FALSE);
	}

    wVerb = RESETSYSTEM;
	(HllapiFn)(&wVerb, NULL, NULL, &wRc);

    wVerb = SETSESSIONPARAMETERS;
    wLength = sizeof(szSessionParms)-1; 
	(HllapiFn)(&wVerb, szSessionParms, &wLength, &wRc);
	if (wRc != HLLOK)
		return(FALSE);
		
    wVerb = CONNECTPS;
    wLength = 1;
	(HllapiFn)(&wVerb, "A", &wLength, &wRc);
	if (wRc != HLLOK)
	{
		MessageBox(NULL, "Can't connect to PS A", "Buttons", MB_ICONEXCLAMATION | MB_OK);
		return(FALSE);
	}	
	return(TRUE);
}

/***************************************************************************
 *                                                                         *
 *  FUNCTION : CleanupHllapi                                               *
 *                                                                         *
 *  PURPOSE  : Make the function calls required to cleanup HLLAPI "session"*
 *                                                                         *
 ***************************************************************************/
                            

int  CleanupHllapi()
{
	WORD wRc;
	WORD wVerb=RESETSYSTEM;
	
	if (HllapiFn != NULL)
	{
		(HllapiFn)(&wVerb, NULL, NULL, &wRc);
	}	
	
	if (hDll != 0)
	{
		FreeLibrary(hDll);
	}
	
	return(TRUE);	
}

/***************************************************************************
 *                                                                         *
 *  FUNCTION : SearchPS                                                    *
 *                                                                         *
 *  PURPOSE  : Front-end the SEARCH_PS HLLAPI function call                *
 *                                                                         *
 ***************************************************************************/
                            

int  SearchPS(char *sz, int offset)
{              
	WORD wLength;
	WORD wRc = offset;
	int  nRc;
	WORD wVerb=SEARCHPS;
	            
	wLength = strlen(sz);
		            
	(HllapiFn)(&wVerb, sz, &wLength, &wRc);
	if (wRc != HLLOK)
		nRc = -(int)wRc;
	else
		nRc = wLength;	
		
	return(nRc);	
}
/***************************************************************************
 *                                                                         *
 *  FUNCTION : CopyPsToString                                              *
 *                                                                         *
 *  PURPOSE  : Front-end the COPYPSTOSTR HLLAPI function call              *
 *                                                                         *
 ***************************************************************************/
                            

int  CopyPsToString(char *sz, int length, int offset)
{
	WORD wLength;
	WORD wRc;
	WORD wVerb=COPYPSTOSTR;
	int  nRc;
	            
	wLength = length;
	wRc = offset;
		            
	(HllapiFn)(&wVerb, sz, &wLength, &wRc);
	nRc = -(int)wRc;
	
	return(nRc);	
	
}                                                                         

/***************************************************************************
 *                                                                         *
 *  FUNCTION : SendKey                                                     *
 *                                                                         *
 *  PURPOSE  : Front-end the SENDKEY HLLAPI function call                  *
 *                                                                         *
 ***************************************************************************/
                            

 
int  SendKey(char *sz)       
{
	WORD wLength;
	WORD wRc;
	WORD wVerb=SENDKEY;
	int  nRc;
	            
	wLength = strlen(sz);
		            
	(HllapiFn)(&wVerb, sz, &wLength, &wRc);
	nRc = -(int)wRc;
	
	return(nRc);	
} 
                                                              
/***************************************************************************
 *                                                                         *
 *  FUNCTION : IsXClock                                                    *
 *                                                                         *
 *  PURPOSE  : Check to see if presentation space is available to write to *
 *                                                                         *
 ***************************************************************************/
                            
                                                              
BOOL  IsXClock(void)       
{
	WORD wRc;
	WORD wVerb=WAIT;
	BOOL fAnswer;
	            
	(HllapiFn)(&wVerb, NULL, NULL, &wRc);

	if (wRc != 0)
		fAnswer = TRUE;
	else
		fAnswer = FALSE;
				
	return(fAnswer);	
}

/***************************************************************************
 *                                                                         *
 *  FUNCTION : FindDll                                                     *
 *                                                                         *
 *  PURPOSE  : Provide the name of the HLLAPI DLL to be loaded             *
 *                                                                         *
 ***************************************************************************/
                            

LPSTR FindDll(LPSTR szDllName)
{
	_fstrcpy(szDllName, "EHLLAPI.DLL");
	
	return(szDllName);	
}	                            