
FUNCTION ValFile
PARAMETERS pcName, pnErrNo
*----------------------------------------------------------------------------
* NAME
*   ValFile() - Vaidate a file name
*
* PARAMETERS
*   pcName     = Name of the file
*   pnErrNo    = Return the error number, 0 if OK, 1 - doesn't exist, ...
*
*----------------------------------------------------------------------------
    PRIVATE lOk, fh, cErrMsg, lVoid

    lOk = .T.
    IF AT( " ", LTRIM( TRIM( m->pcName ) ) ) > 0
        lOk = .F.
        pnErrNo = 1049
        RETURN ( m->lOk )
    ENDIF
    fh = 0   
    ON ERROR lOk = .F.
    fh = FOPEN( m->pcName )
    cErrMsg = MESSAGE()
    pnErrNo = ERROR()
    ON ERROR
    IF m->fh > 0
        lVoid = FCLOSE( m->fh )
    ENDIF
    IF m->pnErrNo = 1                      && File not found!
        *----------------------------
        *-- Check for real file names
        *----------------------------
        DO CASE
            CASE SPACE(1) $ LTRIM( TRIM( m->pcName ) )
                pnErrNo = 1049

            CASE ISBLANK( FileRoot( m->pcName ) )
                pnErrNo = 1049

            CASE UPPER( m->pcName ) = [<EMPTY>]
                pnErrNo = 1049

            OTHERWISE
                *-----------------------------------------
                *-- Check to see if we can create the file
                *-- If not, the file name is bogus
                *-----------------------------------------
                IF FILE(m->pcName)
                    lOk = .T.
                    pnErrNo = 0
                ELSE    
                    lOk = .T.
                    ON ERROR lOk = .F.
                    fh = FCREATE( m->pcName )
                    cErrMsg = MESSAGE()
                    pnErrNo = ERROR()
                    ON ERROR
                    IF m->fh > 0
                        lVoid = FCLOSE( m->fh )
                        ERASE ( m->pcName )
                        pnErrNo = 1
                        lOk = .T.
                    ELSE
                        pnErrNo = 1049
                    ENDIF
                ENDIF    
        ENDCASE
    ELSE
        IF m->pnErrNo > 1
            lOk = .F.
        ENDIF
    ENDIF
RETURN ( m->lOk )
*-- EOF: ValFile( pcName )

