PROCEDURE UpLook
PARAMETERS pcForm
*----------------------------------------------------------------------------
* NAME
*   UpLook - Update the lookup fields after moving the record pointer.
*
* PARAMETERS
*   pcForm     = Object reference to the active form.
*
*----------------------------------------------------------------------------
    PRIVATE oF, oC

    *---------------------------------------
    *-- Check for need to scan lookup fields
    *---------------------------------------
    IF TYPE( "pcForm.Scan4Look" ) = "N" .AND. pcForm.Scan4Look > 0

        *-----------------------------------------------------------
        *-- For Each field that has a lookup, call LookRef to update
        *-- the value of the look fields.
        *-----------------------------------------------------------
        oF = pcForm.First
        oC = m->oF
        DO WHILE .T.
            IF oC.ClassName = "ENTRYFIELD"
                IF TYPE( "oC.LookTag" ) = "C"
                    SELECT (oC.LookAlias)
                    SEEK EVAL( oc.DataLink )
                ENDIF
            ENDIF
            oC = oC.After
            IF oC = m->oF
                EXIT
            ENDIF
        ENDDO

    ENDIF

    IF TYPE( "pcForm.CurrMast" ) = "C"
        SELECT ( pcForm.CurrMast )
    ENDIF
RETURN
*-- EOP: UpLook WITH pcForm


