PROCEDURE UpDetail
PARAMETERS poForm
*----------------------------------------------------------------------------
* NAME
*   UpDetail - Update the SET KEY TO after a change in the master record
*
* PARAMETERS
*   poForm     = oRef to Form
*
*----------------------------------------------------------------------------
	PRIVATE oFirst, oCurrent
	
    *--------------------------------------------------------------
    *-- Assume for now that the link is on the master's primary key
    *--------------------------------------------------------------
    SELECT (poForm.CurrMast)

    *---------------------------------------------------
    *-- Loop thru detail regions and reset the key range
    *---------------------------------------------------
    oFirst = Form.FileList
    oFirst = oFirst.First
    oCurrent = m->oFirst
    DO WHILE .T.

        IF TYPE( "oCurrent.StatusMessage" ) = "C" .AND. ;
           LEFT( oCurrent.StatusMessage, 6 ) = "Detail"
            SELECT (oCurrent.FileAlias)
            SET KEY TO EVAL( oCurrent.MastKeyFld )
            GO TOP
        ENDIF

        oCurrent = oCurrent.After
        IF m->oCurrent = m->oFirst
            EXIT
        ENDIF
    ENDDO

    SELECT (poForm.CurrMast)

RETURN
*-- EOP: UpDetail WITH poForm




