FUNCTION TmpName    && Returns a pseudo-random file root name
PARAMETER pc_ext
*--------------------------------------------------------------------
* NAME
*   TmpName - Returns a pseudo-random file root name.
*
* SYNOPSIS
*   TmpName( [.ext] )
*
* DESCRIPTION
*   TmpName() returns an pseudo-random string of
*   digits suitable for use as a temporary file name.
*   Eight digits (sometimes fewer) are returned.
*   Successive calls to TmpName() can be used to
*   generate a series of unique file names.
*
*   An optional file extension can be passed as an
*   argument.  If this is done, TmpName will make
*   sure that the file name it returns does not already
*   exist within the current dBASE path setting.
*
* PARAMETERS
*   pc_ext - optional file name extension.  May optionally
*   start with a ".", followed by up to three characters.
*   (Note that some characters are not allowed in file names,
*    depending on the specific operating system in use.)
*
* EXAMPLE
*
*   lc_tmpfile = TmpName(".TMP")
*   * Possible return value: "87113336.TMP"
*   USE master
*   COPY TO (lc_tmpfile)
*   * The file "87113336.TMP" would now exist
*
* LIMITATIONS
*   If TmpName() is used without the extension
*   parameter, the FILE() function can be used to
*   make certain that a created file name does not
*   already exist.
*
*   TmpName() assumes the extension argument has
*   only characters allowed in filenames.
*
*   Note also that leading 0's will not be returned.
*   If you desire exactly eight digits, this line:
*     TRANSFORM( RAND(-1) * 100000000, "@L 99999999" )
*   returns a random string of digits that is always
*   eight characters long.
*
* SEE ALSO:
*   RAND(), FILE()
*
*--------------------------------------------------------------------
    PRIVATE lc_env, lc_ext, lc_prefix, lc_root, lc_slash, ;
    ll_err, lh_chkit, cID

    IF LEFT( OS(), 3 ) = "DOS"
        lc_slash = "\"
    ELSE
        lc_slash = "/"
    ENDIF

    lh_chkit = 0

    lc_env = ""
    lc_prefix = ""
    cID = ID()
    IF .NOT. ISBLANK( m->cID )
        IF LEN( m->cID ) = 1
            cID = m->cID + "_"
        ENDIF
        lc_Prefix = LEFT( m->cID, 2 ) + "_"
    ELSE
        lc_Prefix = "XT_"
    ENDIF

    IF PCOUNT() = 0
        lc_Root = m->lc_prefix + LTRIM( STR( RAND( -1 ) * 100000000, 8 ) )
        lc_root = TRIM( LEFT( m->lc_Root + SPACE(8), 8 ) )
        RETURN( m->lc_root )
    ELSE

        IF .NOT. "." $ m->pc_ext
            lc_ext = "." + m->pc_ext
        ELSE
            lc_ext = m->pc_ext
        ENDIF

        lc_ext = SUBSTR(m->lc_ext, 1, 4)

        DO WHILE .T.
            lc_Root = m->lc_prefix + LTRIM( STR( RAND( -1 ) * 100000000, 8 ) )
            lc_root = TRIM( LEFT( m->lc_Root + SPACE(8), 8 ) )

            IF .NOT. FILE( m->lc_root + m->lc_ext )
                RETURN( m->lc_root + m->lc_ext )
            ENDIF

        ENDDO

    ENDIF
*-- EOF: TmpName( [.ext] )

