
* Program............: C:\DAVINCI\SRC\IDE\SYSHELP.FRG
* Date...............: 6-09-94
* Versions...........: dBASE 5.0, Report
*
* Notes:
* ------
* Prior to running this procedure with the DO command
* it is necessary use LOCATE because the CONTINUE
* statement is in the main loop.
*
*-- Parameters
PARAMETERS gl_noeject, gl_plain, gl_summary, gc_heading, gc_extra
** The first three parameters are of type Logical.
** The fourth parameter is a string.  The fifth is extra.
PRIVATE _peject, _wrap, ll_heading, ll_temp, ll_toprint
ll_heading = .F.
ll_toprint = (SET("PRINTER") = "ON")

*-- Test for no records found
IF EOF() .OR. .NOT. FOUND()
   RETURN
ENDIF

*-- turn word wrap mode off
_wrap=.F.

IF _plength < 1 + 1 + 2
   SET DEVICE TO SCREEN
   DEFINE WINDOW gw_report FROM 7,17 TO 11,62 DOUBLE
   ACTIVATE WINDOW gw_report
   @ 0,1 SAY "Increase the page length for this report."
   @ 2,1 SAY "Press any key ..."
   x=INKEY(0)
   DEACTIVATE WINDOW gw_report
   RELEASE WINDOW gw_report
   RETURN
ENDIF

_plineno=0          && set lines to zero
*-- NOEJECT parameter
IF gl_noeject
   IF _peject="BEFORE"
      _peject="NONE"
   ENDIF
   IF _peject="BOTH"
      _peject="AFTER"
   ENDIF
ENDIF

*-- Set-up environment
ON ESCAPE DO Prnabort
IF SET("TALK")="ON"
   SET TALK OFF
   gc_talk="ON"
ELSE
   gc_talk="OFF"
ENDIF
gc_space=SET("SPACE")
SET SPACE OFF
gc_time=TIME()      && system time for predefined field
gd_date=DATE()      && system date  "    "    "     "
gl_fandl=.F.        && first and last page flag
gl_prntflg=.T.      && Continue printing flag
gl_widow=.T.        && flag for checking widow bands
gn_length=LEN(m->gc_heading)  && store length of the HEADING
gn_level=2          && current band being processed
gn_page=_pageno     && grab current page number
gn_pspace=_pspacing && get current print spacing


*-- Set up procedure for page break
gn_atline=_plength - 1
ON PAGE AT LINE m->gn_atline EJECT PAGE

*-- Print Report

PRINTJOB

IF gl_plain
   ON PAGE AT LINE m->gn_atline DO Pgplain
ELSE
   ON PAGE AT LINE m->gn_atline DO Pgfoot
ENDIF

gl_fandl=.T.        && first physical page started

*-- File Loop
DO WHILE FOUND() .AND. .NOT. EOF() .AND. m->gl_prntflg
   gn_level=0
   *-- Detail lines
   IF m->gl_summary
      DO Upd_Vars
   ELSE
      DO __Detail
   ENDIF
   gl_widow=.T.         && enable widow checking
   CONTINUE
ENDDO

IF m->gl_prntflg
ELSE
   DO Reset
   RETURN
ENDIF

ON PAGE

ENDPRINTJOB

DO Reset
RETURN
* EOP: C:\DAVINCI\SRC\IDE\SYSHELP.FRG

*-- Update summary fields and/or calculated fields.
PROCEDURE Upd_Vars
RETURN
* EOP: Upd_Vars

*-- Set flag to get out of DO WHILE loop when escape is pressed.
PROCEDURE Prnabort
gl_prntflg=.F.
RETURN
* EOP: Prnabort



PROCEDURE __Detail
IF 6 * gn_pspace < gn_atline - 1
   IF m->gl_widow .AND. _plineno+6 * m->gn_pspace > m->gn_atline + 1
      EJECT PAGE
   ENDIF
ENDIF
DO Upd_Vars
?
?? "Help Frame:" AT 15
?
?? Hlptitle FUNCTION "T" AT 15
?
?
?? Hlpframe FUNCTION "V50" AT 15
?
?
RETURN
* EOP: __Detail


PROCEDURE Pgfoot
PRIVATE _box
gl_widow=.F.         && disable widow checking
EJECT PAGE
*-- is the page number greater than the ending page
IF _pageno > _pepage
   GOTO BOTTOM
   SKIP
   gn_level=0
ENDIF
RETURN
* EOP: Pgfoot

*-- Process page break when PLAIN option is used.
PROCEDURE Pgplain
PRIVATE _box
EJECT PAGE
RETURN
* EOP: Pgplain

*-- Reset dBASE environment prior to calling report
PROCEDURE Reset
SET SPACE &gc_space.
SET TALK &gc_talk.
ON ESCAPE
ON PAGE
RETURN
* EOP: Reset



