FUNCTION SubmitFm
PARAMETERS poForm
*----------------------------------------------------------------------------
* NAME
*   SubmitFm - Submit the current record.  If it fails display a message
*              and return .F.
*
* PARAMETERS
*   poForm     = Object reference to the form
*
*----------------------------------------------------------------------------
    PRIVATE cIntlTry, lOk

    cIntlTry = [Cannot write this record. Try again or cancel the form.]
    lOk      = .T.

    *--------------------------------------------------------
    *-- Make sure this is a form object before doing anything
    *--------------------------------------------------------
    IF TYPE( "poForm.Classname" ) = "C" .AND. poForm.Classname = "FORM"

        *-----------------------------------------------------------------
        *-- If current record was modified, write it, otherwise do nothing
        *-----------------------------------------------------------------
        IF poForm.Modified()

            lOk = poForm.Submit()

            *---------------------------------------------------------------
            *-- Display an information message if Submit() failed.  Submit()
            *-- can fail a number of ways.  For instance, if the record
            *-- lock failed before writing, Submit() returns false.
            *-- Submit() also fails if an event handler closed the database
            *-- for the form.
            *---------------------------------------------------------------
            IF .NOT. lOk
                DO InfoMsg WITH m->cIntlTry
            ENDIF
        ENDIF
    ENDIF

RETURN lOk
*-- EOP: SubmitFm WITH poForm
