*************************************************************
* FILE RBCBCHG.PRG
* Shows how to use the OnChange property of radiobuttons and
* check boxes. This sample program accompanies Chapter 22
* of the "Programmer's Guide." 
*************************************************************
DEFINE FORM f FROM 9,15 TO 15,65 ;
   PROPERTY Text "Checkbox and Radiobutton selection"
      
DEFINE CHECKBOX chk OF f AT 1,9 ;
   PROPERTY Text " OFF ", OnChange ObjChg

*------------------------------------------------------------
* rb1 is the first radio button in a group. By default,
* Group and Tabstop are .T., and its Value is .T.
*------------------------------------------------------------
DEFINE RADIOBUTTON rb1 OF f AT 1,28 ;
   PROPERTY Text " ON ", OnChange ObjChg

*------------------------------------------------------------
* rb2 is the second radio button in a group. Make Group
* and Tabstop .F. so it will behave like part of a group.
* By default, its Value is .F.
*------------------------------------------------------------
DEFINE RADIOBUTTON rb2 OF f AT 2,28 ;
   PROPERTY Text " OFF ", Group .F., Tabstop .F., ;
   OnChange ObjChg

lVoid = f.Open()                     && Open the form window.
lVoid = f.chk.SetFocus()             && Force focus to checkbox.

PROCEDURE ObjChg                     && OnChange event handler for all three controls.
   this.Text = IIF (this.Value, " ON", " OFF") && Set text for control to ON if its value
RETURN                                         && is .T. and OFF if its value is .F.
