PROCEDURE OKHand
*----------------------------------------------------------------------------
* NAME
*   OKHand - Generic OK Button handler
*
* DESCRIPTION
*   Closes the form and sets the form's Action custom property value .T.
*----------------------------------------------------------------------------
#include "talkoff.hdb"

    PRIVATE lClose, lVoid, oForm

    oForm = m->Form                     && Save the Form object reference
                                        && in case InfoMsg is needed.
    lClose = .T.

    Form.Action = .T.
    IF TYPE( "Form.CurrMast" ) = "C"
        SELECT ( Form.CurrMast )
        lClose = SubmitFm( m->Form )
    ENDIF

    IF m->lClose
        lVoid = oForm.Close()
    ENDIF
    
#include "talkon.hdb"
RETURN
*-- EOP: OKHand

PROCEDURE HelpObj
*-----------------------------------------------------------------
* NAME
*   HelpObj - Displays user-defined help, if any, for this button.
*
* DESCRIPTION
*   This routine is required here because you can have only one
*   ProcFile reference per object.
*
*-----------------------------------------------------------------
    IF This.ClassName # "MENUITEM"
        DO HelpDspy WITH m->This
    ELSE
        IF TYPE("Form.ActiveControl()") = "O"
            DO HelpDspy WITH Form.ActiveControl()
        ENDIF
    ENDIF
RETURN

