***------------------------------------------------------------------***
***------------------------------------------------------------------***
***  File   :  NCO.H
***  Program:  dCALCULATOR
***  Date   :  April 25, 1994
***  Copyright, Borland International
***------------------------------------------------------------------***
***------------------------------------------------------------------***

***--COMPILE TIME OPTIONS----------------------------------------------
*** This options are determined when the file is compiled (not at
*** run time)

#define EDFRAME                      && If commented out, the editor
                                     && will be displayed with default
                                     && frames, otherwise text fields
                                     && will emulate a rectangle

#define FOLDER                       && If commented out, the folder
                                     && line will not be drawn between
                                     && calculator and tape parts
#ifdef FOLDER
   #define FOLDERADJ    4            && Adjustment for width of form
#else                                && and positioning of editor
   #define FOLDERADJ    0
#endif

#define MAXDISP         19           && The numeric display width
#define DCML            MAXDISP - 3  && Set decimal value.  Less 3
                                     && spaces because of  0.  of display

***--MACROS------------------------------------------------------------
*** Used instead of functions.  Faster to execute, but occupy more space
*** A copy is replacing each call to the macro in the command line.

#define  CENTER(Text,Width)          (SPACE((Width-LEN(Text))/2)+Text)
#define  ALLTRIM(String)             (LTRIM(RTRIM(String)))

***--GENERAL USAGE CODES-----------------------------------------------
*** Used for clearer code and easier maintenance & changes in code.

#define NULL              ""
#define NILL               0
#define NILLSTR           "0"
#define TRUE              .T.
#define FALSE             .F.

                                      &&  Memory Functions:
#define M_ADD             1           &&  Add Memory
#define M_SUB             2           &&  Substract memory
#define M_REC             3           &&  Recall Memory
#define M_CLR             4           &&  Clear Memory

                                      &&  Error Codes:
#define E_NEG_SQR         1           &&  Square root of a negative number
#define E_OVER_FLD        2           &&  Overflow of display value
#define E_OVER_FLM        3           &&  Overflow of memory value
#define E_DIVISION        4           &&  Division by zero
#define E_PRINTER         5           &&  Printer problem
#define E_SAVETAPE        6           &&  Tape is not available
#define E_ALREADY         7           &&  Calculator is already running

                                      &&  Calculator Mode:
#define HEX_MODE          "H"         &&  Hexadecimal mode
#define DEC_MODE          "D"         &&  Decimal mode

                                      &&  Symbols and Operators Codes:
#define PLUS              1           &&  Plus
#define MINUS             2           &&  Minus
#define MULTI             3           &&  Multiplication
#define DIVIDE            4           &&  Division
#define EQUAL             5           &&  Equal
#define SQUARE            6           &&  Square Root
#define PERCE             7           &&  Percent
#define PLUSMI            8           &&  Plus/Minus

                                      &&  Display/Printing Symbols:
#define SYMBOLPLUS        "+"         &&  Plus
#define SYMBOLMINUS       "-"         &&  Minus
#define SYMBOLMULTI       "*"         &&  Multiplication
#define SYMBOLDIVIDE      "/"         &&  Division
#define SYMBOLEQUAL       "="         &&  Equal
#define SYMBOLSQUARE      ""         &&  Square Root
#define SYMBOLPERCE       "%"         &&  Percent
#define SYMBOLPLUSMI      ""         &&  Plus/Minus

                                      &&  Display/Printing Symbols:
#define SYMBOLBLANK       " "         &&  Blank
#define SYMBOLCLEAR       "C"         &&  Clear
#define SYMBOLRECALL      "R"         &&  Recall
#define SYMBOLMEMORY      "M"         &&  Memory
#define SYMBOLPRINT       "P"         &&  Printer

                                      &&  Display/Printing Symbols:
#define ZERO              "0"         &&  0
#define ONE               "1"         &&  1
#define TWO               "2"         &&  2
#define THREE             "3"         &&  3
#define FOUR              "4"         &&  4
#define FIVE              "5"         &&  5
#define SIX               "6"         &&  6
#define SEVEN             "7"         &&  7
#define EIGHT             "8"         &&  8
#define NINE              "9"         &&  9

                                      &&  File Names:
#define PP_TAPEFILENAME   "NCO.TAP"   &&  Tape file name (text file)
#define PP_SAVEFILENAME   "NCO.SAV"   &&  Save file name (mem file)

                                      &&  Left margin of tape lines
#define LMARGIN           " "         &&  Precedes calculation display

                                      &&  Rectangles Border Styles:
#define RAISED            1           &&  Raised border style
#define LOWERED           2           &&  Lowered border style

***--ALL DISPLAYED STRINGS---------------------------------------------
*** Change those if necessary (a foreign language). No other displayed
*** strings are in NCO.PRG. (except numerals 0-9)

#define PP_C_CFORM_HEADER           "dCalculator"
#define PP_LOGO_LINE1               "A dBASE 5 Calculator"
#define PP_LOGO_LINE2               "All Rights Reserved (R) TO"
#define PP_LOGO_LINE3               "Borland International, 1994"
#define PP_LOGO_LINE4               ""
#define PP_C_CFORM_PS_TEXT          "&Paste"
#define PP_C_CFORM_TP_TEXT          "&Tape"
#define PP_C_CFORM_PR_TEXT          "P&rint"
#define PP_C_CFORM_NW_TEXT          "&New"
#define PP_C_CFORM_HD_TEXT          "&H/D"
#define PP_C_CFORM_AB_TEXT          "Ab&out"
#define PP_C_CFORM_PS_MESS          "Paste the numeric display to calling program."
#define PP_C_CFORM_TP_MESS          "Toggle tape recording ON/OFF.  If tape is on, calculations saved to to file."
#define PP_C_CFORM_PR_MESS          "Toggle printer ON/OFF.  If printer is on, calculations redirected to LPT1."
#define PP_C_CFORM_NW_MESS          "New calculator session, clear display, clear memory, and start new tape."
#define PP_C_CFORM_HD_MESS          "Toggle between Hexadecimal and Decimal modes."
#define PP_C_CFORM_MADD_MESS        "Add value in display to that in memory."
#define PP_C_CFORM_MSUB_MESS        "Subtract value in display from that of memory."
#define PP_C_CFORM_MRCL_MESS        "Recall memory value from memory register to display register."
#define PP_C_CFORM_MCLR_MESS        "Clear value stored in memory register."
#define PP_TAPE_MODE_HEX            "[ Hexadecimal Mode"
#define PP_TAPE_MODE_DEC            "[ Decimal Mode"
#define PP_TAPE_OFF_LINE1           " Tape: " + DTOC(DATE())
#define PP_TAPE_OFF_LINE2           " OFF : " + TIME()
#define PP_CERR_MESS1               "Error C101: Negative number"
#define PP_CERR_MESS2               "Error C102: Numeric overflow"
#define PP_CERR_MESS3               "Error C103: Memory overflow"
#define PP_CERR_MESS4               "Error C104: Division by zero"
#define PP_CERR_MESS5               "Error C105: Printer not available"
#define PP_CERR_MESS6               "Error C106: Tape not available"
#define PP_CERR_MESS7               "Error C107: dCalculator is running"
#define PP_LOGO_PUSH                "&OK"
#define PP_CERR_PUSH                "&OK"
#define PP_CERR_HEADER              PP_C_CFORM_HEADER + " Error"

***--FORM DEFAULT POSITION (NO TAPE)-----------------------------------
*** All coordinates are relative to the screen

#define PP_CALCFORM_HEIGHT        19      &&  Height of form
#define PP_CALCFORM_WIDTH         29      &&  Width (without tape)

#define PP_CALCFORM_TOP            1      && CalcForm Form
#define PP_CALCFORM_LEFT          12
#define PP_CALCFORM_BOTTOM        PP_CALCFORM_TOP  + PP_CALCFORM_HEIGHT
#define PP_CALCFORM_RIGHT         PP_CALCFORM_LEFT + PP_CALCFORM_WIDTH


***--FRAME RECTANGLES--------------------------------------------------
*** These are the main rectangles of the calculator part (left part)
*** The coordinates are relative to CalcForm form.

#define PP_R00_TOP                    0      && Indicators rect.
#define PP_R00_LEFT                   0      &&
#define PP_R00_BOTTOM  PP_R00_TOP  +  3
#define PP_R00_RIGHT   PP_R00_LEFT +  3

#define PP_R01_TOP                    0      && Display rect.
#define PP_R01_LEFT                   5
#define PP_R01_BOTTOM  PP_R01_TOP  +  3
#define PP_R01_RIGHT   PP_R01_LEFT + 22

#define PP_R02_TOP                    4      && Operators, functions,
#define PP_R02_LEFT                   0      && and digits rect.
#define PP_R02_BOTTOM  PP_R02_TOP  + 13
#define PP_R02_RIGHT   PP_R02_LEFT + 27

***--TOP DISPLAY OBJECT POSITIONS--------------------------------------
*** Covers the Indicators (R00) and Display (R01) rectangles.

*** Indicators objects
#define PP_TOP1_TOP     PP_R00_TOP    +  1      && Printer Indicator
#define PP_TOP1_LEFT    PP_R00_LEFT   +  1

#define PP_TOP2_TOP     PP_R00_TOP    +  1      && Memory Indicator
#define PP_TOP2_LEFT    PP_R00_LEFT   +  2

#define PP_TOP3_TOP     PP_R00_TOP    +  2      && Mode Indicator
#define PP_TOP3_LEFT    PP_R00_LEFT   +  1

#define PP_TOP4_TOP     PP_R00_TOP    +  2      && Last Operator Indicator
#define PP_TOP4_LEFT    PP_R00_LEFT   +  2

*** Display objects
#define PP_TOP5_TOP     PP_R01_TOP    +  1      && Memory display
#define PP_TOP5_LEFT    PP_R01_LEFT   +  2

#define PP_TOP6_TOP     PP_R01_TOP    +  2      && Calculator display
#define PP_TOP6_LEFT    PP_R01_LEFT   +  2

***--FUNCTIONS RECTANGLE AND OBJECT POSITIONS--------------------------------
*** The coordinates are relative to bottom rectangle (R02)

#define PP_R1_TOP     PP_R02_TOP  +  1         && Functions rect.
#define PP_R1_LEFT    PP_R02_LEFT +  1
#define PP_R1_BOTTOM  PP_R1_TOP   +  3
#define PP_R1_RIGHT   PP_R1_LEFT  + 25

#define PP_S1_TOP     PP_R1_TOP  +  1          && Paste
#define PP_S1_LEFT    PP_R1_LEFT +  1
#define PP_S5_TOP     PP_R1_TOP  +  1          && New
#define PP_S5_LEFT    PP_R1_LEFT +  9
#define PP_S2_TOP     PP_R1_TOP  +  1          && Tape
#define PP_S2_LEFT    PP_R1_LEFT + 15

#define PP_S3_TOP     PP_R1_TOP  +  2          && Printer
#define PP_S3_LEFT    PP_R1_LEFT +  1
#define PP_S6_TOP     PP_R1_TOP  +  2          && H/D
#define PP_S6_LEFT    PP_R1_LEFT +  9
#define PP_S4_TOP     PP_R1_TOP  +  2          && About
#define PP_S4_LEFT    PP_R1_LEFT + 15

***--DIGITS RECTANGLE AND OBJECT POSITIONS-----------------------------
*** The coordinates are relative to bottom rectangle (R02)

#define PP_R2_TOP     PP_R02_TOP  +  5        && Digits rect.
#define PP_R2_LEFT    PP_R02_LEFT +  1
#define PP_R2_BOTTOM  PP_R2_TOP   +  7
#define PP_R2_RIGHT   PP_R2_LEFT  + 12

#define PP_S10_TOP    PP_R2_TOP  + 1          && D
#define PP_S10_LEFT   PP_R2_LEFT + 1
#define PP_S11_TOP    PP_R2_TOP  + 1          && E
#define PP_S11_LEFT   PP_R2_LEFT + 4
#define PP_S12_TOP    PP_R2_TOP  + 1          && F
#define PP_S12_LEFT   PP_R2_LEFT + 7

#define PP_S7_TOP     PP_R2_TOP  + 2          && A
#define PP_S7_LEFT    PP_R2_LEFT + 1
#define PP_S8_TOP     PP_R2_TOP  + 2          && B
#define PP_S8_LEFT    PP_R2_LEFT + 4
#define PP_S9_TOP     PP_R2_TOP  + 2          && C (HEX)
#define PP_S9_LEFT    PP_R2_LEFT + 7

#define PP_S14_TOP    PP_R2_TOP  + 3          && 7
#define PP_S14_LEFT   PP_R2_LEFT + 1
#define PP_S15_TOP    PP_R2_TOP  + 3          && 8
#define PP_S15_LEFT   PP_R2_LEFT + 4
#define PP_S16_TOP    PP_R2_TOP  + 3          && 9
#define PP_S16_LEFT   PP_R2_LEFT + 7

#define PP_S20_TOP    PP_R2_TOP  + 4          && 4
#define PP_S20_LEFT   PP_R2_LEFT + 1
#define PP_S21_TOP    PP_R2_TOP  + 4          && 5
#define PP_S21_LEFT   PP_R2_LEFT + 4
#define PP_S22_TOP    PP_R2_TOP  + 4          && 6
#define PP_S22_LEFT   PP_R2_LEFT + 7

#define PP_S26_TOP    PP_R2_TOP  + 5          && 1
#define PP_S26_LEFT   PP_R2_LEFT + 1
#define PP_S27_TOP    PP_R2_TOP  + 5          && 2
#define PP_S27_LEFT   PP_R2_LEFT + 4
#define PP_S28_TOP    PP_R2_TOP  + 5          && 3
#define PP_S28_LEFT   PP_R2_LEFT + 7

#define PP_S33_TOP    PP_R2_TOP  + 6          && . (or country decimal point)
#define PP_S33_LEFT   PP_R2_LEFT + 1
#define PP_S32_TOP    PP_R2_TOP  + 6          && 0
#define PP_S32_LEFT   PP_R2_LEFT + 4
#define PP_S34_TOP    PP_R2_TOP  + 6          && 
#define PP_S34_LEFT   PP_R2_LEFT + 7

***--OPERATORS RECTANGLE AND OBJECT POSITIONS---------------------------
*** The coordinates are relative to bottom rectangle (R02)

#define PP_R3_TOP     PP_R02_TOP  +  5        && Operators rect.
#define PP_R3_LEFT    PP_R02_LEFT + 15
#define PP_R3_BOTTOM  PP_R3_TOP   +  7
#define PP_R3_RIGHT   PP_R3_LEFT  + 11

#define PP_S13_TOP    PP_R3_TOP  + 1          && M+
#define PP_S13_LEFT   PP_R3_LEFT + 1
#define PP_S25_TOP    PP_R3_TOP  + 1          && MR
#define PP_S25_LEFT   PP_R3_LEFT + 5

#define PP_S19_TOP    PP_R3_TOP  + 2          && M-
#define PP_S19_LEFT   PP_R3_LEFT + 1
#define PP_S31_TOP    PP_R3_TOP  + 2          && MC
#define PP_S31_LEFT   PP_R3_LEFT + 5

#define PP_S35_TOP    PP_R3_TOP  + 3          && +
#define PP_S35_LEFT   PP_R3_LEFT + 1
#define PP_S29_TOP    PP_R3_TOP  + 3          && -
#define PP_S29_LEFT   PP_R3_LEFT + 5

#define PP_S23_TOP    PP_R3_TOP  + 4          && *
#define PP_S23_LEFT   PP_R3_LEFT + 1
#define PP_S17_TOP    PP_R3_TOP  + 4          && /
#define PP_S17_LEFT   PP_R3_LEFT + 5

#define PP_S24_TOP    PP_R3_TOP  + 5          && 
#define PP_S24_LEFT   PP_R3_LEFT + 1
#define PP_S30_TOP    PP_R3_TOP  + 5          && %
#define PP_S30_LEFT   PP_R3_LEFT + 5

#define PP_S36_TOP    PP_R3_TOP  + 6          && =
#define PP_S36_LEFT   PP_R3_LEFT + 1
#define PP_S18_TOP    PP_R3_TOP  + 6          && C(lear)
#define PP_S18_LEFT   PP_R3_LEFT + 5

***--EDITOR RECTANGLE AND POSITIONS------------------------------------
*** The coordinates are relative to CalcForm form

#define PP_R4_TOP                    0          && Editor rect.
#define PP_R4_LEFT    FOLDERADJ   + 29
#define PP_R4_BOTTOM  PP_R4_TOP   + 17
#define PP_R4_RIGHT   PP_R4_LEFT  + MAXDISP + 6

#define PP_ED_TOP     PP_R4_TOP    + 1          && Editor object
#define PP_ED_LEFT    PP_R4_LEFT   + 1
#define PP_ED_BOTTOM  PP_R4_BOTTOM - 1
#define PP_ED_RIGHT   PP_R4_RIGHT  - 1

***--ERROR FORM RECTANGLE---------------------------------------------
*** All coordinates are relative to CErrForm form

#define PP_RE1_TOP                               0     && Error rect.
#define PP_RE1_LEFT                              0
#define PP_RE1_BOTTOM             PP_RE1_TOP  +  5
#define PP_RE1_RIGHT              PP_RE1_LEFT + 38

***--ABOUT FORM POSITION----------------------------------------------
*** All coordinates are relative to the screen

#define PP_ABOUTFORM_TOP                               5
#define PP_ABOUTFORM_LEFT                             20
#define PP_ABOUTFORM_BOTTOM       PP_ABOUTFORM_TOP  +  9
#define PP_ABOUTFORM_RIGHT        PP_ABOUTFORM_LEFT + 40

***--ABOUT FORM RECTANGLE---------------------------------------------
*** All coordinates are relative to LogoForm

#define PP_RA1_TOP                               0      && About rect.
#define PP_RA1_LEFT                              0
#define PP_RA1_BOTTOM             PP_RA1_TOP  +  7
#define PP_RA1_RIGHT              PP_RA1_LEFT + 38

                                  && Width of inside of rectangle
#define PP_ABOUTWIDTH             PP_ABOUTFORM_RIGHT - PP_ABOUTFORM_LEFT - 3

***--All COLOR STRINGS-------------------------------------------------

*** CalcForm Form Colors
#define PP_C_CFNORMAL      "W+/W"      &&  Normal
#define PP_C_CFICON        "N/W"       &&  Icon
#define PP_C_CFBORDER      "W/W"       &&  Border (all states)
#define PP_C_CFHIGH        "GR+/W"     &&  Highlight
#define PP_C_CFTEXT        "B/W"       &&  Text (additional)
#define PP_C_CFFOLDER      "N+/W"      &&  Folder line
#define PP_C_CFEDITOR      "N/W"       &&  Editor (all parts)

** CalcForm Form Mono Colors
#define PP_M_CFNORMAL      "W/N"       &&  Normal
#define PP_M_CFICON        "N+/N"      &&  Icon
#define PP_M_CFBORDER      "N/N"       &&  Border (all states)
#define PP_M_CFHIGH        "W+/N"      &&  Highlight
#define PP_M_CFTEXT        "W/N"       &&  Text (additional)
#define PP_M_CFFOLDER      "N+/N"      &&  Folder line
#define PP_M_CFEDITOR      "W/N"       &&  Editor (all parts)

*** CalcForm Form Indicators & Display Rectangles Colors
#define PP_C_CFTBLANK      "W/W"       &&  Blank
#define PP_C_CFTPRINT      "B+/W"      &&  Printer
#define PP_C_CFTMEMORY     "G+/W"      &&  Memory
#define PP_C_CFTOPRATR     "GR+/W"     &&  Operator
#define PP_C_CFTHEXDEC     "GR+/W"     &&  Mode
#define PP_C_CFTDISPLAY    "R+/N"      &&  Display

*** CalcForm Form Top Display Mono Colors
#define PP_M_CFTBLANK      "N/N"       &&  Blank
#define PP_M_CFTPRINT      "W+/N"      &&  Printer
#define PP_M_CFTMEMORY     "W+/N"      &&  Memory
#define PP_M_CFTOPRATR     "W+/N"      &&  Operator
#define PP_M_CFTHEXDEC     "W+/N"      &&  Mode
#define PP_M_CFTDISPLAY    "N/W"       &&  Display

*** CalcForm Form Pushbuttons Colors
#define PP_C_CFPNORMAL     "W+/W"      &&  Normal
#define PP_C_CFPPNORMAL    "GR+/W"     &&  Pick Normal
#define PP_C_CFPHILITE     "W+/W"      &&  HighLight
#define PP_C_CFPPHILITE    "BG+/W"     &&  Pick HighLight
#define PP_C_CFPSHADOW     "W/W"       &&  Shadow
#define PP_C_CFPDISABLE    "N+/W"      &&  Disabled
#define PP_C_CFPCLEAR      "R/W"       &&  Clear Button Normal Color

*** CalcForm Form Pushbuttons Mono Colors
#define PP_M_CFPNORMAL     "W/N"       &&  Normal
#define PP_M_CFPPNORMAL    "W+/N"      &&  Pick Normal
#define PP_M_CFPHILITE     "N/W"       &&  HighLight
#define PP_M_CFPPHILITE    "W+/W"      &&  Pick HighLight
#define PP_M_CFPSHADOW     "N/N"       &&  Shadow
#define PP_M_CFPDISABLE    "N+/N"      &&  Disabled
#define PP_M_CFPCLEAR      "W/N"       &&  Clear Button Normal Color

*** Errors Form Colors
#define PP_C_EFBUTTON      "W+/R"      &&  Pushbutton
#define PP_C_EFNORMAL      "R/W"       &&  Normal
#define PP_C_EFHILITE      "GR+/R"     &&  HighLight

*** Errors Form Mono Colors
#define PP_M_EFBUTTON      "W+/N"      &&  Pushbutton
#define PP_M_EFNORMAL      "W/N"       &&  Normal
#define PP_M_EFHILITE      "W+/N"      &&  HighLight


***------------------------------------------------------------------***
*** END OF FILE NCO.H
***------------------------------------------------------------------***
