PROCEDURE LookRef
PARAMETERS pcAlias, poLookup
*----------------------------------------------------------------------------
* NAME
*   LookRef - Refresh fields in the lookup table after a record movement
*
* PARAMETERS
*   pcAlias     = Alias name to look for using DataLink
*   poLookFld   = oRef to lookup field
*
*----------------------------------------------------------------------------
    PRIVATE oParent, oFirst, oCurrent, cDataLink, cData

    *---------------------------------
    *-- For each field with a datalink
    *---------------------------------
    oParent = poLookup.Parent
    oFirst = oParent.First
    oCurrent = m->oFirst
    DO WHILE .T.

        IF TYPE( "oCurrent.DataLink" ) = "C"

            IF .NOT. TYPE( oCurrent.DataLink ) $ "MG"

                IF UPPER( pcAlias + "->" ) $ UPPER( oCurrent.DataLink )
                    *-------------------------------------------------------
                    *-- Now refresh the value from the source database files
                    *-- to sync up the lookup file values.
                    *-------------------------------------------------------
                    oCurrent.Value = EVALUATE( oCurrent.DataLink )

                ENDIF

            ENDIF

        ENDIF

        oCurrent = oCurrent.After

        IF oCurrent = m->oFirst
            EXIT
        ENDIF
    ENDDO

    SELECT( m->pcAlias )

RETURN
*-- EOP: LookRef WITH pcAlias, poLookup




