FUNCTION FileRoot
PARAMETER pc_fname
*--------------------------------------------------------------------
* NAME
*   FileRoot - Returns "root" of a filename.
*
* SYNOPSIS
*   FileRoot( pc_fname )
*
* DESCRIPTION
*   FileRoot() isolates the filename, up to the first eight
*   characters, from a full path description.  That is, the
*   file extension, if any, is not returned.  Note that the
*   following can all be valid filespecs within dBASE:
*     FOO
*     FOO.BAR
*     C:FOO
*     C:FOO.BAR
*     C:\FOO
*     C:\FOO.BAR
*     C:\FOO\FOO
*     C:\FOO\FOO.BAR
*     C:\FOO.BAR\FOO
*     C:\FOO.BAR\FOO.BAR
*     ..\FOO.BAR
*
*   No upper or lower case conversion occurs.
*
* PARAMETER
*   pc_fname - A character full DOS filespec.
*
* EXAMPLE
*   lc_root = FileRoot( "C:\TEST\FOO.PRG" )
*     ( lc_root will equal "FOO" )
*
* SEE ALSO
*   FILEDRV(), FILEPATH(), FILETYPE()
*
*--------------------------------------------------------------------

  PRIVATE lc_result, lc_slash

  lc_slash = "\"

  *-- Add "." to end to easily handle file with no extension:
  lc_result = LTRIM( RTRIM( m->pc_fname ) ) + "."

  IF m->lc_slash $ m->lc_result
    lc_result = SUBSTR( m->lc_result, RAT(m->lc_slash, m->lc_result) + 1 )
  ELSE

    IF ":" $ m->lc_result
      lc_result = SUBSTR( m->lc_result, AT(":", m->lc_result) + 1 )
    ENDIF

  ENDIF

RETURN UPPER( SUBSTR(m->lc_result, 1, AT(".", m->lc_result ) - 1 ) )

*-- EOF: FileRoot( pc_fname )

