FUNCTION FilePath
PARAMETER pc_fname
*--------------------------------------------------------------------
* NAME
*   FilePath - Returns path portion of a complete filespec.
*
* SYNOPSIS
*   FilePath( pc_fname )
*
* DESCRIPTION
*   FilePath() returns the path from the full
*   description of the file specified by pc_fname.
*   The drive letter, if any, is not returned.
*
*   If the filespec does not contain a path, the
*   null string ("") is returned.
*
* PARAMETER
*   pc_fname - A character full DOS filespec.
*
* EXAMPLE
*   lc_fpath = FilePath( "C:\TEST\FOO.PRG" )
*     ( lc_fpath will equal "\TEST\" )
*
*   lc_fpath = FilePath( "MYFILE.TXT" )
*     ( lc_fpath will equal "" )
*
* SEE ALSO
*   _FILEDRV(), _FILEROOT(), _FILETYPE()
*
*--------------------------------------------------------------------
  PRIVATE ln_pathpos, lc_slash, nLastSlash
  
  nLastSlash = RAT( "\", m->pc_fName )
  isDrive = AT( ":", m->pc_fName ) = 2
  IF m->isDrive
    ln_PathPos = 3
  ELSE
    ln_PathPos = 1
  ENDIF

RETURN( IIF( m->ln_pathpos > 0, ;
             SUBSTR( m->pc_fname, m->ln_pathpos, ;
                     m->nLastSlash - m->ln_pathpos + 1 ),;
             "" ) )
*-- EOF: FilePath( pc_fname )

