
PROCEDURE ErrMsg
PARAMETER poMsgBox
*-----------------------------------------------------------------------
* NAME
*   ErrMsg - Display an error message in a dialog box
*
* PARAMETER                                                        Default
*   poMsgBox.Message    = Message to output, upto 110 characters   ""
*           .BoxTitle   = Title for box                            "Error"
*           .OkBtn      = Have OK button                           .T.
*           .OkText     = OK text, can be Yes                      "~O~K"
*           .OkFocus    = Set focus to OK                          .T.
*           .CancelBtn  = Include Cancel button.                   .F.
*           .CancelText = Cancel text, can be No also              ""
*           .CancelFoc  = Set focus to Cancel                      .F.
*           .HelpBtn    = Help button, stays in box afterwards     .F.
*           .HelpText   = Help text                                ""
*           .HelpFocus  = Set focus to Help                        .F.
*           .HelpClick  = Name of OnHelp event handler to run      ""
*           .HelpId     = Help frame id                            ""
*           .HelpFile   = Help file name                           ""
*           .HelpProc   = ProcFile reference for the help button   ""
*           .DrawBox    = Set to .T. to draw box around text       .T.
*           .OkChosen   = OK Button was selected, otherwise .F.    .F.
*
* DEPENDENCIES
*   HelpCTit - Help System function for centering a title
*-----------------------------------------------------------------------
#include "errmsg.hdb"

    PRIVATE cMsgText, nSemiColon, Err_Msg1, Err_Msg2, cLine, nLastSpace, ;
            nMaxBtn, nButtons, nCenterWid, nStart, lVoid, x

    *-------------------------------------------
    *-- Split up the message text into two lines
    *-------------------------------------------
    cMsgText = poMsgBox.Message
    nSemiColon = AT( ";", cMsgText )
    IF nSemiColon > 0
        Err_Msg1 = LEFT( cMsgText, nSemiColon - 1 )
        Err_Msg2 = SUBSTR( cMsgText, nSemiColon + 1 )
    ELSE
        IF LEN( cMsgText ) > 55
            cLine1 = LEFT( cMsgText, 55 )
            nLastSpace = RAT( " ", cLine1 )
            IF nLastSpace = 0
                Err_Msg1 = LEFT( cMsgText, 55 )
                Err_Msg2 = SUBSTR( cMsgText, 56 )
            ELSE
                Err_Msg1 = TRIM( LEFT( cLine1, nLastSpace - 1 ) )
                Err_Msg2 = SUBSTR( cLine1, nLastSpace + 1 ) + ;
                       SUBSTR( cMsgText, 56 )
            ENDIF
        ELSE
            Err_Msg1 = cMsgText
            Err_Msg2 = ""
        ENDIF
    ENDIF
    Err_Msg1 = HelpCTit( TRIM( Err_Msg1 ), 55 )
    IF .NOT. ISBLANK( Err_Msg2 )
        Err_Msg2 = HelpCTit( TRIM( Err_Msg2 ), 55 )
    ENDIF

    *-----------------------------------------
    *-- Define the objects for the message box
    *-----------------------------------------
    DEFINE FORM dB5___EM ;
        PROPERTY ;
            TOP     5, ;
            LEFT    9, ;
            HEIGHT  9, ;
            WIDTH   61,;
            TEXT    poMsgBox.BoxTitle ;
        CUSTOM ;
            Action  .F.

    *----------------------------------------------------------
    *-- Draw the rectangle first so the text shows on top of it
    *----------------------------------------------------------
    IF poMsgBox.DrawBox
        DEFINE RECTANGLE r OF dB5___EM FROM 0,1 TO 3, 57
    ENDIF

    DEFINE TEXT m1 OF dB5___EM ;
        PROPERTY ;
            TOP     1, ;
            LEFT    2, ;
            TEXT    Err_Msg1

    dB5___EM.m1.label = .F.

    DEFINE TEXT m2 OF dB5___EM ;
        PROPERTY ;
            TOP     2, ;
            LEFT    2, ;
            TEXT    Err_Msg2

    dB5___EM.m2.label = .F.

    *---------------------------------------------------
    *-- Add the pushbuttons based on the input structure
    *---------------------------------------------------
    nMaxBtn = 10                        && Minimum button width
    nButtons = 0
    IF poMsgBox.OkBtn
        DEFINE PUSHBUTTON pbOk OF dB5___EM ;
            PROPERTY ;
                TOP         5, ;
                LEFT        24, ;
                TEXT        poMsgBox.OkText, ;
                ONCLICK     OKHand, ;
                PROCFILE    "OKHand.prg," + HOME() + "FormRun.dbo"
        IF poMsgBox.OkText <> [~O~k]
            dB5___EM.pbOk.Width = LEN( poMsgBox.OkText ) + 2
        ELSE
            dB5___EM.pbOk.Width = 10
        ENDIF

        nMaxBtn = MAX( nMaxBtn, dB5___EM.pbOk.Width )
        nButtons = nButtons + 1
    ENDIF

    IF poMsgBox.CancelBtn
        DEFINE PUSHBUTTON pbCancel OF dB5___EM ;
            PROPERTY ;
                TOP         5, ;
                LEFT        24, ;
                TEXT        poMsgBox.CancelText, ;
                ONCLICK     CanHand, ;
                PROCFILE    "CanHand.prg," + HOME() + "FormRun.dbo"
        IF poMsgBox.CancelText <> [Cancel]
            dB5___EM.pbCancel.Width = LEN( poMsgBox.CancelText ) + 2
        ELSE
            dB5___EM.pbCancel.Width = 10
        ENDIF

        nMaxBtn = MAX( nMaxBtn, dB5___EM.pbCancel.Width )
        nButtons = nButtons + 1
    ENDIF

    IF poMsgBox.HelpBtn
        DEFINE PUSHBUTTON pbHelp OF dB5___EM ;
            PROPERTY ;
                TOP         5, ;
                LEFT        24, ;
                TEXT        poMsgBox.HelpText
        nMaxBtn = MAX( nMaxBtn, dB5___EM.pbHelp.Width )
        nButtons = nButtons + 1
    ENDIF

    *------------------------------------------------------
    *-- Adjust the pushbutton widths based on the max value
    *------------------------------------------------------
#define BtnSpace 3

    IF nButtons > 0
        nCenterWid = ( nMaxBtn + BtnSpace ) * nButtons - BtnSpace
        nStart = INT( (dB5___EM.Width - 2) / 2 - nCenterWid / 2 )

        IF poMsgBox.OkBtn
            dB5___EM.pbOk.Width     = nMaxBtn
            dB5___EM.pbOk.Left      = nStart
            nStart = nStart + nMaxBtn + BtnSpace
        ENDIF

        IF poMsgBox.CancelBtn
            dB5___EM.pbCancel.Width = nMaxBtn
            dB5___EM.pbCancel.Left  = nStart
            nStart = nStart + nMaxBtn + BtnSpace
        ENDIF

        IF poMsgBox.HelpBtn
            dB5___EM.pbHelp.Width       = nMaxBtn
            dB5___EM.pbHelp.Left        = nStart
            dB5___EM.pbHelp.HelpId      = poMsgBox.HelpId
            dB5___EM.pbHelp.HelpFile    = poMsgBox.HelpFile
            dB5___EM.pbHelp.OnClick     = poMsgBox.HelpClick
            dB5___EM.pbHelp.ProcFile    = poMsgBox.HelpProc
        ENDIF
    ENDIF

    *------------------------------------
    *-- Give the desired pushbutton focus
    *------------------------------------
    IF poMsgBox.OkFocus
        lVoid = dB5___EM.pbOk.SetFocus()
    ENDIF
    IF poMsgBox.CancelFoc
        lVoid = dB5___EM.pbCancel.SetFocus()
    ENDIF
    IF poMsgBox.HelpFocus
        lVoid = dB5___EM.pbHelp.SetFocus()
    ENDIF

    x = dB5___EM.READMODAL()

    *----------------------------------------------
    *-- Set the OK chosen value based on the Action
    *----------------------------------------------
    poMsgBox.OkChosen = dB5___EM.Action

    lVoid = dB5___EM.Release()
    RELEASE dB5___EM

RETURN
*-- EOP: ErrMsg WITH <cMsgText>              


FUNCTION HelpCTit
PARAMETERS pcMsg, pnWidth, plBar
*----------------------------------------------------------------------------
* NAME
*   HelpCTit() - 
*
* SYNOPSIS
*   HelpCTit( pcMsg, pnWidth )
*
* DESCRIPTION
*
* PARAMETERS
*   pcMsg      = 
*   pnWidth    = 
*   plBar      = .f., use space padding; .t., use bar padding
*
* EXAMPLE
*
* LIMITATIONS
*
* DEPENDENCIES
*
* SEE ALSO
*
*----------------------------------------------------------------------------
    PRIVATE cBar, cOpen, cClose, cMsg, nMsgLen, cResult, nHalfWid, ;
            nHalfMsg, nPosMsg, nPosOpen, nBars, nPad, cSpaces
    IF plBar
        cBar    = CHR( 205 )
        cOpen   = "["           && CHR( 181 )
        cClose  = "]"           && CHR( 198 )
    ELSE
        cBar    = " " && CHR( 205 )
        cOpen   = " " && CHR( 181 )
        cClose  = " " && CHR( 198 )
    ENDIF

    cMsg    = TRIM( pcMsg )
    nMsgLen = LEN( cMsg )
    IF MOD( nMsgLen, 2 ) = 0
        cMsg = cMsg + " "
        nMsgLen = nMsgLen + 1
    ENDIF

    cResult = ""
    nHalfWid = INT( pnWidth / 2 )
    nHalfMsg = INT( nMsgLen / 2 )
    nPosMsg  = nHalfWid - nHalfMsg + 1
    nPosOpen = nPosMsg - 3
    nBars    = nPosOpen - 1

    IF nBars > 0
        cResult = REPLICATE( cBar, nBars )
    ENDIF

    IF nPosOpen > 0
        cResult = cResult + cOpen
    ENDIF

    IF nPosMsg < 3
        nPad = nPosMsg - 1
        IF nPad > 0
            cSpaces = SPACE( nPad )
        ELSE
            cSpaces = ""
        ENDIF
    ELSE
        cSpaces = SPACE( 2 )
    ENDIF

    cResult = cResult + cSpaces + cMsg + cSpaces

    IF nPosOpen > 0
        cResult = cResult + cClose
    ENDIF

    IF nBars > 0
        cResult = cResult + REPLICATE( cBar, nBars )
    ENDIF

    cResult = LEFT( cResult + SPACE( pnWidth ), pnWidth )

RETURN( cResult )
*-- EOF: HelpCTit( pcMsg, pnWidth )

