* dBASE 5.0 DFM DRIVER - Do not remove this line
PROCEDURE EMPLOYEE     && Main program
*-----------------------------------------------------------------
* NAME
*   EMPLOYEE.PRG - Main program for form.
*
*-----------------------------------------------------------------
    PRIVATE lTalk, lVoid, cOldProc, cFormRun, cDispMode, cNewMode
    IF SET( 'TALK' ) = 'ON'
        SET TALK OFF
        lTalk = .T.
    ELSE
        lTalk = .F.
    ENDIF
    *--------------------------------------------
    *-- Make sure that FormRun.dbo file is active
    *--------------------------------------------
    cOldProc = SET( 'PROCEDURE' )
    cFormRun = HOME() + 'FORMRUN.DBO'
    SET PROCEDURE TO &cFormRun
    #include "EMPLOYEE.DFM"
    IF TYPE("EMPLOYEE.SetDisp") = "L" .AND. TYPE("EMPLOYEE.DispMode") = "C"
        IF EMPLOYEE.SetDisp
            cDispMode = SET('DISPLAY')
            cNewMode = EMPLOYEE.DispMode
            SET DISPLAY TO &cNewMode
        ENDIF
    ENDIF
    *-------------------------------------------
    *-- If ModalForm is missing from .DFM set it
    *-------------------------------------------
    IF TYPE( 'EMPLOYEE.ModalForm' ) # 'L'
        EMPLOYEE.ModalForm = .T.        && Assume modal form if not set
    ENDIF
    *-----------------------------------
    *-- Open the form based on ModalForm
    *-----------------------------------
    IF EMPLOYEE.ModalForm
        *-----------------------------------
        *-- Use Readmodal() to open the form
        *-----------------------------------
        EMPLOYEE.Action = .F.        && Set .T. by OKHAND before closing
        lVoid = EMPLOYEE.ReadModal()
        IF EMPLOYEE.Action
            *-------------------------------------------
            *-- Place code here to process OK pushbutton
            *-------------------------------------------
        ENDIF
        IF TYPE("EMPLOYEE.SetDisp") = "L"
            IF EMPLOYEE.SetDisp
                SET DISPLAY TO &cDispMode
            ENDIF
        ENDIF
        RELEASE EMPLOYEE        && Release the form and object ref.
    ELSE
        *------------------------------
        *-- Use Open() to open the form
        *------------------------------
        _CmdWindow.oBForm = m->Employee
        lVoid = EMPLOYEE.Open()
        *-------------------------------------------
        *-- Make the form release itself when closed
        *-- Comment out the RELEASE command to keep
        *-- the form defined when closed.
        *-------------------------------------------
        RELEASE EMPLOYEE
    ENDIF
    IF .NOT. ISBLANK( m->cOldProc )
        SET PROCEDURE TO &cOldProc
    ENDIF
    IF lTalk
        SET TALK ON
    ENDIF
RETURN
*-- EOP: C:\DBASE\NEW\EMPLOYEE.PRG

PROCEDURE CloseMe     && PBNAME18.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME18
*
*-----------------------------------------------------------------
    Form.Action = .F.
    lVoid = Form.Close()
RETURN

PROCEDURE DelIt     && PBNAME15.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME15
*
*-----------------------------------------------------------------
    IF DELETED()
      Form.TxName23.Text = ""
      RECALL
    ELSE
      Form.TxName23.Text = "DELETED"
      DELETE
    ENDIF
RETURN

PROCEDURE Add_new     && PBNAME16.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME16
*
*-----------------------------------------------------------------
    NewRecord = .T.
    *Write data to disk
    lvoid = Form.submit()
    * Append a record
    APPEND BLANK
    *Refresh Screen Data
    lvoid = Form.refresh()
RETURN

PROCEDURE PrintMe     && PBNAME17.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME17
*
*-----------------------------------------------------------------
DEFINE FORM Prt FROM 5,25 TO 16,50 ;
    PROPERTY ;
        TEXT "Print Form"
DEFINE TEXT t1 OF Prt AT 1,1 ;
    PROPERTY ;
        Text "Type :",;
        COLORNORMAL "R/W"
DEFINE RADIOBUTTON Rep OF Prt AT 2,1 ;
    PROPERTY ;
        Text "Report",;
        Group .T.,;
        COLORNORMAL "N/W",;
        WIDTH 15
DEFINE RADIOBUTTON Lab OF Prt AT 3,1 ;
    PROPERTY ;
        Text "Labels",;
        Group .F.,;
        COLORNORMAL "N/W",;
        WIDTH 15
DEFINE TEXT T3 OF Prt AT 9,5 ;
    PROPERTY ;
        TEXT "PRINTING ..." ,;
        VISIBLE .F.,;
        WIDTH 15
DEFINE PUSHBUTTON P1 OF Prt AT 8,12 ;
    PROPERTY ;
        TEXT "&Ok",;
        ONCLICK "RunRep",;
        Width 10
DEFINE PUSHBUTTON P2 OF Prt AT 8,2 ;
    PROPERTY ;
        TEXT "&Cancel",;
        ONCLICK "CloseMe",;
        Width 10
lVoid = Prt.Open()

******************
PROCEDURE Runrep
* Check for Labels or Reports
    SET CONSOLE OFF
    DO CASE
        CASE Form.Rep.Value
             * display to user something is happening
             Form.T3.Visible = .t.
             REPORT FORM Employee TO PRINTER
        CASE Form.Lab.Value
             * display to user something is happening
             Form.T3.Visible = .t.
             LABEL FORM Employee TO PRINTER
    ENDCASE
    SET CONSOLE ON
    SKIP -1
    lVoid = Form.Close()
    lVoid = Form.Release()
RETURN

PROCEDURE CloseEmp     && EMPLOYEE.ONCLOSE
*-----------------------------------------------------------------
* NAME
*   ONCLOSE - Event handler for EMPLOYEE
*
*-----------------------------------------------------------------
    IF This.Action
        lVoid = This.Submit()
    ELSE
           IF This.Modified()
            DO ErrorMsg WITH "Exit Employee Form ..."
           ENDIF
    ENDIF
    IF .NOT. This.lOpen     &&   If file wasn't already open on startup
        USE IN EMPLOYEE     &&   shut it down
    ENDIF
    lVoid = This.Release()
    mFormOpen=.F.
    DEFINE FORM mTemp PROPERTY VISIBLE .F.
    lVoid = mTemp.OPEN()
    mDesk = mTemp.PARENT
    lVoid = mTemp.CLOSE()
    mFormName=SPACE(8)
    mActive=mDesk.ActiveControl()
    IF TYPE("mActive.ClassName")="C"
        mClass=mActive.ClassName
        IF mClass="FORM"
            mFormName=mActive.Name
            mFormOpen=.T.
        ENDIF
    ENDIF
    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.T.
        Main.S.Srch.Enabled=.F.
        Main.S.Tp.Enabled=.F.
        Main.S.Btm.Enabled=.F.
        Main.S.Pck.Enabled=.T.
        Main.S.Indx.Enabled=.T.
        Main.E.Undo.Enabled=.F.
        Main.E.Save.Enabled=.F.
        Main.F1.Bac.Enabled=.T.
        Main.App.Inv.Enabled=.T.
    ENDIF
    Main.App.Emp.Enabled=.T.
    RELEASE Employee
    * , _CmdWindow.oBForm
RETURN

PROCEDURE OpenEmp     && EMPLOYEE.ONOPEN
*-----------------------------------------------------------------
* NAME
*   ONOPEN - Event handler for EMPLOYEE
*
*-----------------------------------------------------------------
    PRIVATE lOpen
    PUBLIC NewRecord
    lOpen = .F.        && is .DBF already open (assume .F.)?
    NewRecord = .F.
    mFormOpen = .F.
    IF SUBSTR(DBF(),3)<>"EMPLOYEE.DBF"
        lOpen = .F.     &&   .DBF was NOT already open
    ENDIF
    * Routine to check for existence of the key field index
    * If it doesn't exist, create it.  The reason for this
    * is that the CUA_SAMP business app uses a copy of tables
    * found in the SAMPLES directory and the lastname tag does
    * not exist in EMPLOYEE.DBF in the SAMPLES directory.
    * NOTE that if you intend to use this code in a network
    *      environment you should manually create the LASTNAME tag.
    NoTag=.T.
    FOR i = 1 TO TAGCOUNT()
      IF TAG(i)="LASTNAME"
         NoTag=.F.
         EXIT
      ENDIF
    ENDFOR
    IF NoTag
       USE EMPLOYEE EXCL
       INDEX ON Lastname TAG Lastname
       USE EMPLOYEE
    ENDIF
    RELEASE NoTag
    SET ORDER TO LASTNAME
    GO TOP
    This.lOpen = lOpen   &&   save lOpen to form
    lVoid = This.Refresh()
    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.F.
        Main.S.Srch.Enabled=.T.
        Main.S.Tp.Enabled=.T.
        Main.S.Btm.Enabled=.T.
        Main.S.Pck.Enabled=.F.
        Main.S.Indx.Enabled=.F.
        Main.E.Undo.Enabled=.T.
        Main.E.Save.Enabled=.T.
        Main.F1.Bac.Enabled=.F.
        Main.App.Inv.Enabled=.F.
    ENDIF
    Main.App.Emp.Enabled=.F.
RETURN

PROCEDURE Repaint     && EMPLOYEE.ONGOTFOCUS
*-----------------------------------------------------------------
* NAME
*   ONGOTFOCUS - Event handler for EMPLOYEE
*
*-----------------------------------------------------------------
    SELE Employee
    lVoid =This.Refresh()
RETURN

FUNCTION UniqKey
*-----------------------------------------------------------
* NAME
*   UniqKey
*
* DESCRIPTION
*   Calls routine to check for unique primary key
*
*-----------------------------------------------------------
    PRIVATE lRet
    lRet = ChkUniq(This, Form)
RETURN m->lRet
