* dBASE 5.0 DFM DRIVER - Do not remove this line
PROCEDURE CUST     && Main program
*-----------------------------------------------------------------
* NAME
*   CUST.PRG - Main program for form.
*
*-----------------------------------------------------------------
    PRIVATE lTalk, lVoid, cOldProc, cFormRun, cDispMode, cNewMode
    IF SET( 'TALK' ) = 'ON'
        SET TALK OFF
        lTalk = .T.
    ELSE
        lTalk = .F.
    ENDIF
    *--------------------------------------------
    *-- Make sure that FormRun.dbo file is active
    *--------------------------------------------
    cOldProc = SET( 'PROCEDURE' )
    cFormRun = HOME() + 'FORMRUN.DBO'
    SET PROCEDURE TO &cFormRun
    #include "CUST.DFM"
    IF TYPE("CUST.SetDisp") = "L" .AND. TYPE("CUST.DispMode") = "C"
        IF CUST.SetDisp
            cDispMode = SET('DISPLAY')
            cNewMode = CUST.DispMode
            SET DISPLAY TO &cNewMode
        ENDIF
    ENDIF
    *-------------------------------------------
    *-- If ModalForm is missing from .DFM set it
    *-------------------------------------------
    IF TYPE( 'CUST.ModalForm' ) # 'L'
        CUST.ModalForm = .T.            && Assume modal form if not set
    ENDIF
    *-----------------------------------
    *-- Open the form based on ModalForm
    *-----------------------------------
    IF CUST.ModalForm
        *-----------------------------------
        *-- Use Readmodal() to open the form
        *-----------------------------------
        CUST.Action = .F.               && Set .T. by OKHAND before closing
        lVoid = CUST.ReadModal()
        IF CUST.Action
            *-------------------------------------------
            *-- Place code here to process OK pushbutton
            *-------------------------------------------
        ENDIF
        IF TYPE("CUST.SetDisp") = "L"
            IF CUST.SetDisp
                SET DISPLAY TO &cDispMode
            ENDIF
        ENDIF
        RELEASE CUST            && Release the form and object ref.
    ELSE
        *------------------------------
        *-- Use Open() to open the form
        *------------------------------
        _CmdWindow.oBForm = m->Cust
        lVoid = CUST.Open()
        *-------------------------------------------
        *-- Make the form release itself when closed
        *-- Comment out the RELEASE command to keep
        *-- the form defined when closed.
        *-------------------------------------------
        RELEASE CUST
    ENDIF
    IF .NOT. ISBLANK( m->cOldProc )
        SET PROCEDURE TO &cOldProc
    ENDIF
    IF lTalk
        SET TALK ON
    ENDIF
RETURN
*-- EOP: C:\DBASE\NEW\CUST.PRG

PROCEDURE CloseMe     && PBNAME6.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME6
*
*-----------------------------------------------------------------
    Form.Action = .F.
    lVoid = Form.Close()
RETURN

PROCEDURE DelIt     && PBNAME7.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME7
*
*-----------------------------------------------------------------
    IF DELETED()
      Form.TxName20.Text = ""
      RECALL
    ELSE
      Form.TxName20.Text = "DELETED"
      DELETE
    ENDIF
RETURN

PROCEDURE Add_new     && PBNAME8.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME8
*
*-----------------------------------------------------------------
    *Write data to disk
    lvoid = Form.submit()
    NewRecord=.T.
    * Append a record
    APPEND BLANK
    *Refresh Screen Data
    lvoid = Form.refresh()
    Form.TxName20.Text=""
RETURN

PROCEDURE CloseCust     && CUST.ONCLOSE
*-----------------------------------------------------------------
* NAME
*   ONCLOSE - Event handler for CUST
*
*-----------------------------------------------------------------
    IF This.Action
        lVoid = This.Submit()
    ELSE
        IF This.Modified()
            DO ErrorMsg WITH "Exit Cust without saving ..."
        ENDIF
    ENDIF
    IF .NOT. This.lOpen     &&   if file wasn't already open on startup
        USE IN Cust         &&   shut down file
    ENDIF
    LVoid = This.Release()
    mFormOpen=.F.
    DEFINE FORM mTemp PROPERTY VISIBLE .F.
    lVoid = mTemp.OPEN()
    mDesk = mTemp.PARENT
    lVoid = mTemp.CLOSE()
    mFormName=SPACE(8)
    mActive=mDesk.ActiveControl()
    IF TYPE("mActive.ClassName")="C"
        mClass=mActive.ClassName
        IF mClass="FORM"
            mFormName=mActive.Name
            mFormOpen=.T.
        ENDIF
    ENDIF
    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.T.
        Main.S.Srch.Enabled=.F.
        Main.S.Tp.Enabled=.F.
        Main.S.Btm.Enabled=.F.
        Main.S.Pck.Enabled=.T.
        Main.S.Indx.Enabled=.T.
        Main.E.Undo.Enabled=.F.
        Main.E.Save.Enabled=.F.
        Main.App.Ord.Enabled=.T.
        Main.App.Acc.Enabled=.T.
        Main.F1.Bac.Enabled=.T.
        Main.App.Inv.Enabled=.T.
    ENDIF
    Main.App.Cust.Enabled=.T.
    RELEASE Cust, _CmdWindow.oBForm
RETURN

PROCEDURE OpenCust     && CUST.ONOPEN
*-----------------------------------------------------------------
* NAME
*   ONOPEN - Event handler for CUST
*
*-----------------------------------------------------------------
    PRIVATE lOpen
    PUBLIC NewRecord
    lOpen = .F.         && was file already open? (assume .T.)
    mFormOpen = .F.
    NewRecord = .F.
    This.TxName20.Text = ""
    IF SUBSTR(DBF(),3)<>"CUST.DBF"
         lOpen = .F.
    ENDIF
    SET ORDER TO CUST_ID
    This.lOPen = lOpen &&   save lOpen in form
    lVoid = This.Refresh()
    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.F.
        Main.S.Srch.Enabled=.T.
        Main.S.Tp.Enabled=.T.
        Main.S.Btm.Enabled=.T.
        Main.S.Pck.Enabled=.F.
        Main.S.Indx.Enabled=.F.
        Main.E.Undo.Enabled=.T.
        Main.E.Save.Enabled=.T.
        Main.App.Ord.Enabled=.F.
        Main.App.Acc.Enabled=.F.
        Main.F1.Bac.Enabled=.F.
        Main.App.Inv.Enabled=.F.
    ENDIF
    Main.App.Cust.Enabled=.F.
RETURN

PROCEDURE Repaint     && CUST.ONGOTFOCUS
*-----------------------------------------------------------------
* NAME
*   ONGOTFOCUS - Event handler for CUST
*
*-----------------------------------------------------------------
   SELECT Cust
   lVoid = This.Refresh()
RETURN

PROCEDURE PrintForm     && PBNAME5.ONCLICK
*-----------------------------------------------------------------
* NAME
*   ONCLICK - Event handler for PBNAME5
*
*-----------------------------------------------------------------
DEFINE FORM Prt FROM 5,25 TO 16,50 ;
    PROPERTY ;
        TEXT "Print Form"
DEFINE TEXT t1 OF Prt AT 1,1 ;
    PROPERTY ;
        Text "Type :",;
        COLORNORMAL "R/W"
DEFINE RADIOBUTTON Rep OF Prt AT 2,1 ;
    PROPERTY ;
        Text "Report",;
        Group .T.,;
        COLORNORMAL "N/W",;
        WIDTH 15
DEFINE RADIOBUTTON Lab OF Prt AT 3,1 ;
    PROPERTY ;
        Text "Labels",;
        Group .F.,;
        COLORNORMAL "N/W",;
        WIDTH 15
DEFINE TEXT T3 OF Prt AT 9,5 ;
    PROPERTY ;
        TEXT "PRINTING ..." ,;
        VISIBLE .F.,;
        WIDTH 15
DEFINE PUSHBUTTON P1 OF Prt AT 8,12 ;
    PROPERTY ;
        TEXT "&Ok",;
        ONCLICK "RunRep",;
        Width 10
DEFINE PUSHBUTTON P2 OF Prt AT 8,2 ;
    PROPERTY ;
        TEXT "&Cancel",;
        ONCLICK "CloseMe",;
        Width 10
lVoid = Prt.Open()

******************
PROCEDURE Runrep
* Check for Labels or Reports
SET CONSOLE OFF
DO CASE
    CASE Form.Rep.Value
         * display to user something is happening
         Form.T3.Visible = .t.
         REPORT FORM Cust TO PRINTER
    CASE Form.Lab.Value
         * display to user something is happening
         Form.T3.Visible = .t.
         LABEL FORM Cust TO PRINTER
ENDCASE
SET CONSOLE ON
SKIP -1
lVoid = Form.Close()
lVoid = Form.Release()
RETURN

FUNCTION UniqKey
*-----------------------------------------------------------
* NAME
*   UniqKey
*
* DESCRIPTION
*   Calls routine to check for unique primary key
*
*-----------------------------------------------------------
    PRIVATE lRet
    lRet = ChkUniq(This, Form)
RETURN m->lRet
