
FUNCTION ChkUniq
PARAMETERS pThis, pForm
*----------------------------------------------------------------------------
* NAME
*   ChkUniq() - Check field value for uniqueness
*
*----------------------------------------------------------------------------
#include "talkoff.hdb"
    PRIVATE lAppend, cMaster, nRecno, cOrder, entryKey, cKeyTag
    PRIVATE lKeyViol, cKey, lDelete, nSeekRec, lGoTo
    PRIVATE cIntlMess, cIntlTitle, cIntlYes, cIntlNo

    cIntlMess  = [Primary key violation.  Do you want to go to the existing record?]
    cIntlTitle = [Information]
    cIntlYes   = [~Y~es]
    cIntlNo    = [~N~o]

    *--------------------------------------------------------------
    *-- Select the Form master and set order to the master key tag.
    *--------------------------------------------------------------
    cMaster = pForm.CurrMast
    SELECT ( m->cMaster )
    IF EOF()
        lAppend = .T.
    ELSE
        lAppend = .F.
    ENDIF
    nSeekRec = 0
    nRecno = RECNO()
    cOrder = ORDER()
    cKeyTag = pThis.KeyTag
    entryKey = pThis.Value
    IF m->cOrder <> m->cKeyTag
        SET ORDER TO ( m->cKeyTag )
    ENDIF

    lDelete = SET( "DELETE" ) = "ON"
    SET DELETE OFF

    lKeyViol = .F.                      && Assume no key violation

    IF SEEK( m->entryKey )
        nSeekRec = RECNO()
        IF .NOT. m->lAppend
            IF m->nSeekRec <> m->nRecno
                lKeyViol = .T.          && Key violation here
            ELSE
                SKIP
                cKey = KEY()
                IF entryKey = EVAL( m->cKey )
                    lKeyViol = .T.      && Key violation here
                ENDIF
            ENDIF
        ELSE
            lKeyViol = .T.              && Key violation here
        ENDIF
    ENDIF

    IF lDelete
        SET DELETE ON
    ENDIF

    *--------------------------------------------------
    *-- Display the key violation error if it occurred.
    *--------------------------------------------------
    lGoTo = .F.
    IF lKeyViol
        #include "errmsg.hdb"
        dB5___EMsg.Message = m->cIntlMess
        dB5___EMsg.BoxTitle = m->cIntlTitle
        dB5___EMsg.OkText = m->cIntlYes
        dB5___EMsg.CancelBtn = .T.
        dB5___EMsg.CancelText = m->cIntlNo
        DO ErrMsg WITH dB5___EMsg
        lGoTo = dB5___EMsg.OkChosen
        lVoid = dB5___EMsg.Release()
        RELEASE dB5___EMsg

        IF lGoTo
            lKeyViol = .F.              && Reset value for proper exit
            GO nSeekRec
            lVoid = pForm.Refresh()      && Display the new values
            pForm.AddingRec = .F.
            SELECT ( pForm.CurrMast )

            *-----------------------------------------
            *-- If there are no lookups, bail out now.
            *-----------------------------------------
            IF TYPE( "pForm.Scan4Look" ) # "N"
                #include "talkon.hdb"
                RETURN .T.
            ENDIF

            *-----------------------------------------------------------
            *-- For Each field that has a lookup, call LookRef to update
            *-- the value of the look fields.
            *-----------------------------------------------------------
            oF = pForm.First
            oC = m->oF
            DO WHILE .T.
                IF oC.ClassName = "ENTRYFIELD"
                    IF TYPE( "oC.LookTag" ) = "C"
                        SELECT (oC.LookAlias)
                        cKey = oc.DataLink
                        SEEK EVAL( m->cKey )
                        DO LookRef WITH oC.LookAlias, m->oC
                    ENDIF
                ENDIF
                oC = oC.After
                IF oC = m->oF
                    EXIT
                ENDIF
            ENDDO

            IF TYPE( "pForm.DetExist" ) = "L" .AND. pForm.DetExist
                DO UpDetail WITH pForm
            ENDIF
        ENDIF    
    ENDIF

    IF .NOT. m->lGoTo
        IF m->cOrder <> m->cKeyTag
            SET ORDER TO ( m->cOrder )
        ENDIF
        IF m->lAppend
            GO BOTTOM
            IF .NOT. EOF()
                SKIP
            ENDIF
        ELSE
            GO m->nRecno
        ENDIF
    ENDIF

#include "talkon.hdb"
RETURN  .NOT. m->lKeyViol
*-- EOF: ChkUniq()




