
PROCEDURE BldDirs
PARAMETERS poListBox
*----------------------------------------------------------------------------
* NAME
*   BldDirs - Build a list of directories then set the DataSource.  This
*             routine can be used whenever a listbox of directories from
*             the current directory is needed.
*
* PARAMETERS
*   poListBox  = Object ref to list box or combo box.
*
*----------------------------------------------------------------------------
    PRIVATE cPath, n, i, nDirs, nMod, nOk, dB5___Dir, dB5___Ofls, nCurSel

    cPath = SET( "DIRECTORY" )
    IF RIGHT( m->cPath, 1 ) <> "\"
        cPath = m->cPath + "\"
    ENDIF

    *--------------------------------
    *-- Build the list of directories
    *--------------------------------
    poListBox.DataSource = "DIRECTORY " + m->cPath + "*.*"
    lAddRoot = .T.
    IF poListBox.Value == "."
        poListBox.Value = "\"
        lAddRoot = .F.
    ELSE
        IF ISBLANK( poListBox.Value )
            lAddRoot = .F.
        ENDIF
    ENDIF

    *-------------------------------------------------------------------
    *-- Not we have a list of directories, the next step is to pull them
    *-- out of the listbox into an array to sort.
    *-------------------------------------------------------------------
    cItem = ""
    nItems = 0
    DECLARE dB5___Dir[255]
    IF m->lAddRoot
        dB5___Dir[1] = "\"
        dB5___Dir[2] = ".."
        nItems = 2
    ENDIF
    
    nCurSel = 1
    poListBox.CurSel = m->nCurSel
    
    DO WHILE m->cItem # poListBox.Value .AND. nItems < 255
        cItem = poListBox.Value
        nItems = m->nItems + 1
        dB5___Dir[ m->nItems ] = poListBox.Value
        nCurSel = m->nCurSel + 1
        poListBox.CurSel =  m->nCurSel
    ENDDO

    IF m->nItems = 0
        dB5___Dir[1] = "\"
        dB5___Dir[2] = ".."
        nItems = 2
    ENDIF

    nVoid = ARESIZE( dB5___Dir, m->nItems )

    IF m->nItems > 2 .AND. dB5___Dir[2] == ".."
        nStart = 3
    ELSE
        nStart = 1
    ENDIF

    IF m->nItems > 2
        nVoid = ASORT( dB5___Dir, m->nStart )
    ENDIF

    poListBox.DataSource = "ARRAY dB5___Dir"

RETURN
*-- EOP: BldDirs


