//  custom.cpp
//
//  Custom functions for sample orders application

// Values to add for even digit positions in credit card validation function
int iEven[10] = { 0 , 2 , 4 , 6 , 8 , 1 , 3 , 5 , 7 , 9 } ;

BOOL ValCCNumber ( LPCSTR lpcszNumber )
{
    int a ,                         // a=accumulator (total)
        b ,                         // b=odd/even flag
        d ;                         // d=digit value

    const char *p ;                 // work pointer
    const char *s = lpcszNumber ;   // pointer to original string

    d = lstrlen ( s ) ;             // get length

    if ( *s == '5' )                // MasterCard
    {
        if ( d != 16 )              // Always 16 digits
            return FALSE ;
    }
    else if ( *s == '4' )           // Visa
    {
        if ( d != 13 && d != 16 )   // may be either 13 or 16 digits
            return FALSE ;
    }
//  else if ( *s == '3' )           // AMEX: commented out because we
//  {                               //   don't accept AMEX cards
//      if ( d != 15 )              // 15 digits
//          return FALSE ;
//  }
    else if ( *s == '6' )           // Discover
    {
        if ( memcmp ( s , "6011" , 4 ) )    // must start with 6011
            return FALSE ;
        if ( d != 16 )              // 16 digits
            return FALSE ;
    }
    else                            // unknown card type
        return FALSE ;

    a = 0 ;                         // total
    b = 0 ;                         // even/odd position flag: 0=odd, 1=even
    p = s + d ;                     // p = end of string

    while ( p > s )
    {
        p -- ;                      // previous character
        d = *p - '0' ;              // d = value of digit (0-9)

        if ( b )                    // if even digit (2nd from last, 4th from last, etc.)
            a += iEven[d] ;
        else
            a += d ;                // just add the original digit in

        b ^= 1 ;                    // swap odd/even flag
    }

    a %= 10 ;                       // extract just the last digit

    return a ? FALSE : TRUE ;       // if valid, a will be zero
}

BOOL ValCARDNO ( LPCSTR lpcszNumber )
{
    if ( ORDERS->Field("MOP") == "CC" )         // paying by CC?
    {
        if ( *lpcszNumber )                     // card number present?
            return ValCCNumber ( lpcszNumber ) ;    // if so, check number
        else
            return TRUE ;                       // empty is OK for now
    }

    if ( ORDERS->Field("MOP") == "PO" )         // paying by PO?
        if ( ! lstrlen(lpcszNumber) )           // if so, make sure
            return FALSE ;                      // that SOMETHING is there...

    return TRUE ;                               // otherwise no check needed
}

void GetOrderName ( void )
{
    // Start with an empty string
    OrderName = "" ;        

    // Add the first name if there is one
    if ( CUSTOMER->Field("FNAME") != "" )
    {
        OrderName &= CUSTOMER->Field("FNAME") ;
        OrderName &= " " ;
    }

    // Add in the last name
    OrderName &= CUSTOMER->Field("LNAME") ;
}

BOOL ValPART ( LPCSTR CURRENT_FIELD )
{
    if ( ! ( *CURRENT_FIELD ) )             // blank field is valid
    {
        LINEITEM->Field("PRICE") = 0.0 ;    // but price and quantity
        LINEITEM->Field("QTY"  ) = 0.0 ;    //   must be zero
        LINEITEM->Field("EXT"  ) = 0.0 ;
        return TRUE ;
    }

    if ( Found ( "PARTS.DBF" , "ITEM" , CURRENT_FIELD ) )
    {
        LINEITEM->Field("PRICE") = PARTS->Field("PRICE") ;
        return TRUE ;
    }
    
    if ( List ( LINEITEM->Field("PART") , PARTS->Field("ITEM") ) )
    {
        LINEITEM->Field("PRICE") = PARTS->Field("PRICE") ;
        LINEITEM->Field("PART" ).bSet = TRUE ;
        return TRUE ;
    }

    LINEITEM->Field("QTY"  ) = 0.0 ;        // empty record
    LINEITEM->Field("PRICE") = 0.0 ;
    LINEITEM->Field("EXT"  ) = 0.0 ;
    LINEITEM->Field("PART" ) = ""  ;        // item code is now blank

    LINEITEM->Field("PART" ).bSet = TRUE ;  // tell SetData() we've changed
                                            // the data in the field

    return TRUE ;   // now that we've blanked it, it's OK...
}

void GetDescription ( void )
{
    if ( Found ( "PARTS.DBF" , "ITEM" , LINEITEM->Field("PART") ) )
        Description = PARTS->Field("DESCRIPT") ;
    else
        Description = "" ;
}
